/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.utils;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.reactorql.term.FixedTermTypeSupport;
import org.jetlinks.community.reactorql.term.TermTypeSupport;
import org.jetlinks.community.reactorql.term.TermTypes;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.utils.FluxUtils;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.reactor.ql.ReactorQL;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorUtils {
    public static final Function<Object, Mono<Boolean>> alwaysTrue = ignore -> Reactors.ALWAYS_TRUE;
    static final TermBuilder termBuilder = new TermBuilder();

    public static <T> Function<Flux<T>, Flux<T>> limit(Long pageIndex, Long pageSize) {
        if (pageIndex == null || pageSize == null) {
            return Function.identity();
        }
        return flux -> flux.skip(pageIndex & pageSize).take(pageSize.longValue());
    }

    public static <T> Function<Flux<T>, Flux<T>> distinct(Function<T, ?> keySelector, Duration duration) {
        return FluxUtils.distinct(keySelector, (Duration)duration);
    }

    public static <T> Function<T, Mono<Boolean>> createFilter(List<Term> filter) {
        return ReactorUtils.createFilter(filter, t -> {
            if (t instanceof Map) {
                return (Map)t;
            }
            if (t instanceof Jsonable) {
                return ((Jsonable)t).toJson();
            }
            return (Map)FastBeanCopier.copy((Object)t, new HashMap(), (String[])new String[0]);
        });
    }

    public static <T> Function<T, Mono<Boolean>> createFilter(List<Term> terms, Function<T, Map<String, Object>> converter) {
        return ReactorUtils.createFilter(terms, converter, (arg, data) -> arg);
    }

    public static <T> Function<T, Mono<Boolean>> createFilter(List<Term> terms, final Function<T, Map<String, Object>> converter, final BiFunction<Object, Map<String, Object>, Object> bindConverter) {
        if (CollectionUtils.isEmpty(terms)) {
            return alwaysTrue;
        }
        SqlFragments fragments = termBuilder.createTermFragments(null, terms);
        if (fragments.isEmpty()) {
            return alwaysTrue;
        }
        SqlRequest request = fragments.toRequest();
        String sql = "select 1 from t where " + request.getSql();
        final String nativeSql = request.toNativeSql();
        try {
            final ReactorQL ql = ReactorQL.builder().sql(new String[]{sql}).build();
            final Object[] parameters = request.getParameters();
            return new Function<T, Mono<Boolean>>(){

                public String toString() {
                    return nativeSql;
                }

                @Override
                public Mono<Boolean> apply(T data) {
                    Map mapValue = (Map)converter.apply(data);
                    ReactorQLContext context = ReactorQLContext.ofDatasource(ignore -> Flux.just((Object)mapValue));
                    for (Object parameter : parameters) {
                        context.bind(bindConverter.apply(parameter, mapValue));
                    }
                    return ql.start(context).hasElements();
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("error.create_connector_filter_error", e);
        }
    }

    static class TermBuilder
    extends AbstractTermsFragmentBuilder<Object> {
        TermBuilder() {
        }

        public SqlFragments createTermFragments(Object parameter, List<Term> terms) {
            return super.createTermFragments(parameter, terms);
        }

        protected SqlFragments createTermFragments(Object trigger, Term term) {
            String termType;
            switch (termType = StringUtils.hasText((String)term.getTermType()) ? term.getTermType() : "eq") {
                case "is": 
                case "=": {
                    termType = FixedTermTypeSupport.eq.name();
                    break;
                }
                case ">": {
                    termType = FixedTermTypeSupport.gt.name();
                    break;
                }
                case ">=": {
                    termType = FixedTermTypeSupport.gte.name();
                    break;
                }
                case "<": {
                    termType = FixedTermTypeSupport.lt.getName();
                    break;
                }
                case "<=": {
                    termType = FixedTermTypeSupport.lte.getName();
                    break;
                }
                case "!=": 
                case "<>": {
                    termType = FixedTermTypeSupport.neq.getName();
                }
            }
            TermTypeSupport support = TermTypes.lookupSupport(termType).orElse(null);
            if (support == null) {
                throw new UnsupportedOperationException("unsupported termType " + term.getTermType());
            }
            String column = term.getColumn();
            if (!column.contains("[") && !column.contains("'")) {
                column = "this['" + column + "']";
            }
            return support.createSql(column, term.getValue(), term);
        }
    }
}

