/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.utils;

import org.hswebframework.web.exception.NotFoundException;
import reactor.core.publisher.Mono;

public class ErrorUtils {
    public static <T> Mono<T> notFound(String message) {
        return Mono.error(() -> new NotFoundException(message, new Object[0]));
    }

    @SafeVarargs
    public static boolean hasException(Throwable e, Class<? extends Throwable> ... target) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            for (Class<? extends Throwable> aClass : target) {
                if (!aClass.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }
}

