/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetlinks.community.micrometer.MeterRegistrySupplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MeterRegistryManager {
    private Map<String, MeterRegistry> meterRegistryMap = new ConcurrentHashMap<String, MeterRegistry>();
    @Autowired
    private List<MeterRegistrySupplier> suppliers;

    private MeterRegistry createMeterRegistry(String metric, String ... tagKeys) {
        return new CompositeMeterRegistry(Clock.SYSTEM, (Iterable)this.suppliers.stream().map(supplier -> supplier.getMeterRegistry(metric, tagKeys)).collect(Collectors.toList()));
    }

    public MeterRegistry getMeterRegister(String metric, String ... tagKeys) {
        return this.meterRegistryMap.computeIfAbsent(metric, _metric -> this.createMeterRegistry((String)_metric, tagKeys));
    }

    public void setMeterRegistryMap(Map<String, MeterRegistry> meterRegistryMap) {
        this.meterRegistryMap = meterRegistryMap;
    }

    public void setSuppliers(List<MeterRegistrySupplier> suppliers) {
        this.suppliers = suppliers;
    }
}

