/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetlinks.community.PropertyMetric;
import org.jetlinks.community.utils.ConverterUtils;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.reactor.ql.utils.CastUtils;

public interface PropertyMetadataConstants {

    public static interface Metrics {
        public static final String id = "metrics";

        public static Map<String, Object> metricsToExpands(List<PropertyMetric> metrics) {
            return Collections.singletonMap(id, metrics);
        }

        public static List<PropertyMetric> getMetrics(PropertyMetadata metadata) {
            return metadata.getExpand(id).map(obj -> ConverterUtils.convertToList(obj, PropertyMetric::of)).orElseGet(Collections::emptyList);
        }

        public static Optional<PropertyMetric> getMetric(PropertyMetadata metadata, String metric) {
            return metadata.getExpand(id).map(obj -> {
                for (PropertyMetric propertyMetric : ConverterUtils.convertToList(obj, PropertyMetric::of)) {
                    if (!Objects.equals(metric, propertyMetric.getId())) continue;
                    return propertyMetric;
                }
                return null;
            });
        }
    }

    public static interface AccessMode {
        public static final String id = "accessMode";
        public static final String read = "r";
        public static final String write = "w";
        public static final String report = "u";

        public static boolean isRead(PropertyMetadata property) {
            return property.getExpand(id).map(val -> val.toString().contains(read)).orElse(true);
        }

        public static boolean isWrite(PropertyMetadata property) {
            return property.getExpand(id).map(val -> val.toString().contains(write)).orElseGet(() -> property.getExpand("readOnly").map(readOnly -> !CastUtils.castBoolean((Object)readOnly)).orElse(true));
        }

        public static boolean isReport(PropertyMetadata property) {
            return property.getExpand(id).map(val -> val.toString().contains(report)).orElse(true);
        }
    }

    public static interface Source {
        public static final String id = "source";
        public static final HeaderKey<String> headerKey = HeaderKey.of((String)"source", null);
        public static final String manual = "manual";
        public static final String rule = "rule";

        public static boolean isManual(DeviceMessage message) {
            return message.getHeader(headerKey).map(manual::equals).orElse(false);
        }

        public static void setManual(DeviceMessage message) {
            message.addHeader(headerKey, (Object)manual);
        }

        public static boolean isManual(PropertyMetadata metadata) {
            return metadata.getExpand(id).map(manual::equals).orElse(false);
        }
    }
}

