/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.specialproject.vo.BizEngineeringProjectVo;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyListVO;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyVO;
import com.artfess.yhxt.specialproject.vo.ProjectReportVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectMoneyVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizEngineeringProject/v1/"})
@Api(tags={"\u5de5\u7a0b\u9879\u76ee\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class BizEngineeringProjectController
extends BaseController<BizEngineeringProjectManager, BizEngineeringProject> {
    @Resource
    BizEngineeringProjectManager bizEngineeringProjectManager;
    @Resource
    private BaseContext baseContext;
    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value={"projectMoneyReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e13\u9879\u8ba1\u91cf\u7edf\u8ba1\u62a5\u8868", httpMethod="GET", notes="\u83b7\u53d6\u4e13\u9879\u8ba1\u91cf\u7edf\u8ba1\u62a5\u8868")
    public List<ProjectMoneyVO> projectMoneyReport(String year, String orgId) throws Exception {
        return ((BizEngineeringProjectManager)this.baseService).getMoneyReport(year, orgId);
    }

    @RequestMapping(value={"moneyListReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e13\u9879\u8ba1\u91cf\u5217\u8868\u62a5\u8868", httpMethod="GET", notes="\u83b7\u53d6\u4e13\u9879\u8ba1\u91cf\u5217\u8868\u62a5\u8868")
    public List<ProjectMoneyListVO> moneyListReport(String year, String orgId) throws Exception {
        return ((BizEngineeringProjectManager)this.baseService).getMoneyListReport(year, orgId);
    }

    @RequestMapping(value={"projectReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e13\u9879\u62a5\u8868", httpMethod="GET", notes="\u83b7\u53d6\u4e13\u9879\u62a5\u8868")
    public List<ProjectReportVO> projectReport(String year, String orgId) throws Exception {
        return ((BizEngineeringProjectManager)this.baseService).getReport(year, orgId);
    }

    @RequestMapping(value={"getProjectMoneyVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u91d1\u989d\u7edf\u8ba1", httpMethod="POST", notes="\u83b7\u53d6\u9879\u76ee\u91d1\u989d\u7edf\u8ba1")
    public List<Org4ProjectMoneyVO> getProjectMoneyVo(String year) throws Exception {
        return ((BizEngineeringProjectManager)this.baseService).getProjectMoneyCount(year);
    }

    @RequestMapping(value={"getProjectCountVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5de5\u7a0b\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5de5\u7a0b\u6570\u91cf")
    public List<Org4ProjectVO> getProjectCountVo(String year) throws Exception {
        return ((BizEngineeringProjectManager)this.baseService).getProjectCount(year);
    }

    @RequestMapping(value={"/saveEngineeringProject"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name="bizEngineeringProject", value="\u5de5\u7a0b\u9879\u76ee\u4e13\u9879\u68c0\u67e5\u5bf9\u8c61") @RequestBody BizEngineeringProject bizEngineeringProject) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtils.isEmpty((String)bizEngineeringProject.getId())) {
            bizEngineeringProject.setIsDele("0");
            ((BizEngineeringProjectManager)this.baseService).create((Model)bizEngineeringProject);
        } else {
            ((BizEngineeringProjectManager)this.baseService).update((Model)bizEngineeringProject);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"/saveVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u5de5\u7a0b\u9879\u76ee\u3001\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveVo(@ApiParam(name="bizEngineeringProjectVo", value="\u5de5\u7a0b\u9879\u76ee\u4e13\u9879\u68c0\u67e5\u5bf9\u8c61") @RequestBody BizEngineeringProjectVo bizEngineeringProjectVo) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        BizEngineeringProject bizEngineeringProject = bizEngineeringProjectVo.getBizEngineeringProject();
        if (StringUtils.isEmpty((String)bizEngineeringProject.getId())) {
            bizEngineeringProject.setIsDele("0");
            ((BizEngineeringProjectManager)this.baseService).saveVo(bizEngineeringProjectVo);
        } else {
            ((BizEngineeringProjectManager)this.baseService).updateVo(bizEngineeringProjectVo);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f", httpMethod="POST")
    public PageList<BizEngineeringProject> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizEngineeringProject> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        PageList<BizEngineeringProject> pageList = ((BizEngineeringProjectManager)this.baseService).queryBizEngineeringProject(queryFilter);
        return pageList;
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f")
    public BizEngineeringProject get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return ((BizEngineeringProjectManager)this.baseService).getBizEngineeringProjectById(id);
    }

    @GetMapping(value={"getVo/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f")
    public BizEngineeringProjectVo getVo(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return ((BizEngineeringProjectManager)this.baseService).getVo(id);
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f")
    public CommonResult<String> removes(String ... ids) throws Exception {
        ((BizEngineeringProjectManager)this.baseService).removeByIds(Arrays.asList(ids));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/updateEngineeringProject"}, method={RequestMethod.DELETE}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f", httpMethod="DELETE", notes="\u903b\u8f91\u5220\u9664\u5de5\u7a0b\u9879\u76ee\u4fe1\u606f")
    public CommonResult<String> updateEngineeringProject(@ApiParam(name="ids", value="ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((String)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            ((BizEngineeringProjectManager)this.baseService).update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2\u9879\u76ee\u540d\u79f0\u4fe1\u606f", httpMethod="POST")
    public PageList<BizEngineeringProject> getList(@ApiParam(name="queryFilter", value="\u4e0d\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizEngineeringProject> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        this.permissionUtils.addPermission(queryFilter);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizEngineeringProject> bizEngineeringProject = ((BizEngineeringProjectManager)this.baseService).queryBizEngineeringProject(queryFilter);
        return bizEngineeringProject;
    }

    @RequestMapping(value={"updateFlag"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u542f\u7528\u7981\u7528\u72b6\u6001", httpMethod="POST", notes="\u6279\u91cf\u4fee\u6539\u542f\u7528\u7981\u7528\u72b6\u6001")
    public CommonResult<String> updateFlag(@ApiParam(name="ids", value="Id\u96c6\u5408\uff0c\u4ee5,\u9694\u5f00") @RequestParam String ids, @ApiParam(name="validFlag", value="\u6709\u6548\u6807\u5fd7\uff080\uff1a\u65e0\u6548  1\uff1a\u6709\u6548\uff09") @RequestParam Integer flag) throws Exception {
        this.bizEngineeringProjectManager.updateFlag(ids, flag);
        return new CommonResult(true, "\u72b6\u6001\u4fee\u6539\u6210\u529f");
    }
}

