/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.check.regular.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.uc.exception.BaseException;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.check.detail.manager.BridgeOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.manager.CulvertOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.manager.SideSlopeOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.manager.TunnelOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.model.BridgeOftenCheckDetail;
import com.artfess.yhxt.check.detail.model.CulvertOftenCheckDetail;
import com.artfess.yhxt.check.detail.model.SideSlopeOftenCheckDetail;
import com.artfess.yhxt.check.detail.model.TunnelOftenCheckDetail;
import com.artfess.yhxt.check.regular.manager.BridgeOftenCheckManager;
import com.artfess.yhxt.check.regular.manager.CheckExportOftenManager;
import com.artfess.yhxt.check.regular.manager.CulvertOftenCheckManager;
import com.artfess.yhxt.check.regular.manager.SideSlopeOftenCheckManager;
import com.artfess.yhxt.check.regular.manager.TunnelOftenCheckManager;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.artfess.yhxt.util.StreamUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.jsonwebtoken.lang.Assert;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.stereotype.Service;

@Service
public class CheckExportOftenManagerImpl
implements CheckExportOftenManager {
    @Resource
    private BridgeInformationManager bridgeInformationManager;
    @Resource
    private BridgeOftenCheckManager bridgeOftenCheckManager;
    @Resource
    private BridgeOftenCheckDetailManager bridgeOftenCheckDetailManager;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private TunnelOftenCheckManager tunnelOftenCheckManager;
    @Resource
    private TunnelOftenCheckDetailManager tunnelOftenCheckDetailManager;
    @Resource
    private BizCulvertInformationManager culvertInformationManager;
    @Resource
    private CulvertOftenCheckManager culvertOftenCheckManager;
    @Resource
    private CulvertOftenCheckDetailManager culvertOftenCheckDetailManager;
    @Resource
    private SideSlopeInformationManager sideSlopeInformationManager;
    @Resource
    private SideSlopeOftenCheckManager sideSlopeOftenCheckManager;
    @Resource
    private SideSlopeOftenCheckDetailManager sideSlopeOftenCheckDetailManager;
    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private RoadManager roadManager;
    private static final String FX = "fx";

    @Override
    public void exportBridgeOften(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "\u6865\u6881\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            Map qljcmxb = this.sysDictionaryManager.queryDictItemsByCode("qljcmxb");
            Map qljcmxblsq = this.sysDictionaryManager.queryDictItemsByCode("qljcmxblsq");
            List<String> strings = Arrays.asList(ids.split(","));
            strings.forEach(s -> {
                BridgeInformation bridge = this.bridgeInformationManager.getBridgeById((String)s);
                Road road = (Road)((Object)((Object)this.roadManager.getById((Serializable)((Object)bridge.getRoadSegmentId()))));
                QueryWrapper queryWrapper = new QueryWrapper();
                BridgeOftenCheck bridgeOftenCheck = (BridgeOftenCheck)((Object)((Object)this.bridgeOftenCheckManager.getBaseMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"BRIGE_ID_", s)).orderByDesc((Object)"CHECK_DATE_")).orderByDesc((Object)"CREATE_TIME_")).last("limit 0,1"))));
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                this.setExcelStyle(cellStyle, workbook);
                HSSFSheet sheet = workbook.createSheet(" \u6865\u6881\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                sheet.getPrintSetup().setPaperSize((short)9);
                if (bridgeOftenCheck != null) {
                    if (bridge.getBriShape() == null || bridge.getBriShape() == 1) {
                        this.exportBeamBridgeData(file, bridge, road, bridgeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);
                    }
                    if (bridge.getBriShape() != null && bridge.getBriShape() == 10) {
                        this.exportBriCableStayedData(file, bridge, road, bridgeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);
                    }
                } else {
                    if (bridge.getBriShape() == null || bridge.getBriShape() == 1) {
                        this.exportBeamBridge(file, qljcmxblsq, bridge, road, workbook, cellStyle, cellStyleTitle, sheet);
                    }
                    if (bridge.getBriShape() != null && bridge.getBriShape() == 10) {
                        this.exportBriCableStayed(file, qljcmxb, bridge, road, workbook, cellStyle, cellStyleTitle, sheet);
                    }
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    private void exportBeamBridgeData(File file, BridgeInformation bridge, Road road, BridgeOftenCheck bridgeOftenCheck, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5120);
        sheet.setColumnWidth(1, 2560);
        sheet.setColumnWidth(2, 2048);
        sheet.setColumnWidth(3, 3840);
        sheet.setColumnWidth(4, 2816);
        sheet.setColumnWidth(5, 2560);
        sheet.setColumnWidth(6, 2560);
        List list = this.bridgeOftenCheckDetailManager.list((Wrapper)new QueryWrapper().lambda().eq(BridgeOftenCheckDetail::getBridgeOftenCheckId, (Object)bridgeOftenCheck.getId()));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 6));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 2, 3));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 5, 6));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue(" \u6865\u6881\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
        cell0.setCellStyle(cellStyleTitle);
        this.setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row1 = sheet.createRow(1);
        HSSFCell cell = row1.createCell(0);
        HSSFCell cell1 = row1.createCell(1);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u7ba1\u7406\u5355\u4f4d");
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(this.getCompany(bridge.getOfficeName()));
        row1.createCell(2).setCellStyle(cellStyle);
        row1.createCell(3).setCellStyle(cellStyle);
        row1.createCell(4).setCellStyle(cellStyle);
        row1.createCell(5).setCellStyle(cellStyle);
        row1.createCell(6).setCellStyle(cellStyle);
        HSSFRow row2 = sheet.createRow(2);
        HSSFCell cell2 = row2.createCell(0);
        cell2.setCellValue("\u8def\u7ebf\u7f16\u7801");
        cell2.setCellStyle(cellStyle);
        HSSFCell cell3 = row2.createCell(1);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getCode());
        HSSFCell cell4 = row2.createCell(3);
        cell4.setCellValue("\u8def\u7ebf\u540d\u79f0");
        cell4.setCellStyle(cellStyle);
        HSSFCell cell5 = row2.createCell(4);
        cell5.setCellValue(road.getName());
        cell5.setCellStyle(cellStyle);
        HSSFCell cell6 = row2.createCell(5);
        cell6.setCellValue("\u6865\u4f4d\u6869\u53f7");
        cell6.setCellStyle(cellStyle);
        HSSFCell cell7 = row2.createCell(6);
        cell7.setCellValue((double)bridge.getCentPeg().floatValue());
        cell7.setCellStyle(cellStyle);
        row2.createCell(2).setCellStyle(cellStyle);
        HSSFRow row3 = sheet.createRow(3);
        HSSFCell cell8 = row3.createCell(0);
        cell8.setCellValue("\u6865\u6881\u7f16\u7801");
        cell8.setCellStyle(cellStyle);
        HSSFCell cell9 = row3.createCell(1);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue(bridge.getNumber());
        HSSFCell cell10 = row3.createCell(3);
        cell10.setCellValue("\u6865\u6881\u540d\u79f0");
        cell10.setCellStyle(cellStyle);
        HSSFCell cell11 = row3.createCell(4);
        cell11.setCellValue(bridge.getName() + "(" + bridge.getDirectionValue() + ")");
        cell11.setCellStyle(cellStyle);
        HSSFCell cell12 = row3.createCell(5);
        cell12.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
        cell12.setCellStyle(cellStyle);
        HSSFCell cell13 = row3.createCell(6);
        cell13.setCellValue(bridgeOftenCheck.getEvaluateValue());
        cell13.setCellStyle(cellStyle);
        row3.createCell(2).setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(4);
        HSSFCell cell14 = row4.createCell(0);
        cell14.setCellValue("\u90e8\u4ef6\u540d\u79f0");
        cell14.setCellStyle(cellStyle);
        HSSFCell cell15 = row4.createCell(1);
        cell15.setCellValue("\u7f3a\u635f\u7c7b\u578b");
        cell15.setCellStyle(cellStyle);
        HSSFCell cell16 = row4.createCell(2);
        cell16.setCellValue("\u7f3a\u635f\u8303\u56f4");
        cell16.setCellStyle(cellStyle);
        HSSFCell cell17 = row4.createCell(4);
        cell17.setCellValue("\u4fdd\u517b\u63aa\u65bd\u610f\u89c1");
        cell17.setCellStyle(cellStyle);
        HSSFCell cell18 = row4.createCell(5);
        cell18.setCellValue("\u5904\u7406\u63aa\u65bd");
        cell18.setCellStyle(cellStyle);
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(6).setCellStyle(cellStyle);
        row0.setHeight((short)640);
        row1.setHeight((short)580);
        row2.setHeight((short)580);
        row3.setHeight((short)580);
        row4.setHeight((short)580);
        for (int i = 0; i < list.size(); ++i) {
            HSSFRow row5 = sheet.createRow(5 + i);
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 2, 3));
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 5, 6));
            BridgeOftenCheckDetail bridgeOftenCheckDetail = (BridgeOftenCheckDetail)((Object)list.get(i));
            row5.setHeight((short)500);
            HSSFCell cell19 = row5.createCell(0);
            cell19.setCellValue(bridgeOftenCheckDetail.getName());
            cell19.setCellStyle(cellStyle);
            HSSFCell cell20 = row5.createCell(1);
            cell20.setCellValue(bridgeOftenCheckDetail.getDefectType());
            cell20.setCellStyle(cellStyle);
            HSSFCell cell21 = row5.createCell(2);
            cell21.setCellValue(bridgeOftenCheckDetail.getDefectScope());
            cell21.setCellStyle(cellStyle);
            HSSFCell cell22 = row5.createCell(4);
            cell22.setCellValue(bridgeOftenCheckDetail.getMaintainAdvice());
            cell22.setCellStyle(cellStyle);
            HSSFCell cell23 = row5.createCell(5);
            cell23.setCellValue(bridgeOftenCheckDetail.getProcessMode());
            cell23.setCellStyle(cellStyle);
            row5.createCell(3).setCellStyle(cellStyle);
            row5.createCell(6).setCellStyle(cellStyle);
        }
        HSSFRow row5 = sheet.createRow(5 + list.size());
        sheet.addMergedRegion(new CellRangeAddress(5 + list.size(), 5 + list.size(), 1, 2));
        HSSFCell cell24 = row5.createCell(0);
        cell24.setCellStyle(cellStyle);
        cell24.setCellValue("\u8d1f\u8d23\u4eba");
        HSSFCell cell25 = row5.createCell(1);
        cell25.setCellStyle(cellStyle);
        cell25.setCellValue(bridgeOftenCheck.getRummager());
        HSSFCell cell26 = row5.createCell(3);
        cell26.setCellStyle(cellStyle);
        cell26.setCellValue("\u8bb0\u5f55\u4eba");
        HSSFCell cell27 = row5.createCell(4);
        cell27.setCellStyle(cellStyle);
        cell27.setCellValue(bridgeOftenCheck.getNoteTaker());
        HSSFCell cell28 = row5.createCell(5);
        cell28.setCellStyle(cellStyle);
        cell28.setCellValue("\u68c0\u67e5\u65e5\u671f");
        HSSFCell cell29 = row5.createCell(6);
        cell29.setCellStyle(cellStyle);
        String dateStr = new SimpleDateFormat("yyyy/MM/dd").format(bridgeOftenCheck.getCheckDate());
        cell29.setCellValue(dateStr);
        row5.createCell(2).setCellStyle(cellStyle);
        try {
            FileOutputStream os = new FileOutputStream(file + "/" + bridge.getName() + "-" + bridge.getNumber() + "-" + bridge.getDirectionValue() + "-" + new SimpleDateFormat("yyyy-MM-dd").format(bridgeOftenCheck.getCheckDate()) + ".xls");
            workbook.write((OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportBeamBridge(File file, Map<String, List<SysDictionaryDetail>> qljcmxblsq, BridgeInformation bridge, Road road, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5120);
        sheet.setColumnWidth(1, 2560);
        sheet.setColumnWidth(2, 2048);
        sheet.setColumnWidth(3, 3840);
        sheet.setColumnWidth(4, 2816);
        sheet.setColumnWidth(5, 2560);
        sheet.setColumnWidth(6, 2560);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 6));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 2, 3));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 5, 6));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue(" \u6865\u6881\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
        cell0.setCellStyle(cellStyleTitle);
        this.setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row1 = sheet.createRow(1);
        HSSFCell cell = row1.createCell(0);
        HSSFCell cell1 = row1.createCell(1);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u7ba1\u7406\u5355\u4f4d");
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(this.getCompany(bridge.getOfficeName()));
        row1.createCell(2).setCellStyle(cellStyle);
        row1.createCell(3).setCellStyle(cellStyle);
        row1.createCell(4).setCellStyle(cellStyle);
        row1.createCell(5).setCellStyle(cellStyle);
        row1.createCell(6).setCellStyle(cellStyle);
        HSSFRow row2 = sheet.createRow(2);
        HSSFCell cell2 = row2.createCell(0);
        cell2.setCellValue("\u8def\u7ebf\u7f16\u7801");
        cell2.setCellStyle(cellStyle);
        HSSFCell cell3 = row2.createCell(1);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getCode());
        HSSFCell cell4 = row2.createCell(3);
        cell4.setCellValue("\u8def\u7ebf\u540d\u79f0");
        cell4.setCellStyle(cellStyle);
        HSSFCell cell5 = row2.createCell(4);
        cell5.setCellValue(road.getName());
        cell5.setCellStyle(cellStyle);
        HSSFCell cell6 = row2.createCell(5);
        cell6.setCellValue("\u6865\u4f4d\u6869\u53f7");
        cell6.setCellStyle(cellStyle);
        HSSFCell cell7 = row2.createCell(6);
        cell7.setCellValue((double)bridge.getCentPeg().floatValue());
        cell7.setCellStyle(cellStyle);
        row2.createCell(2).setCellStyle(cellStyle);
        HSSFRow row3 = sheet.createRow(3);
        HSSFCell cell8 = row3.createCell(0);
        cell8.setCellValue("\u6865\u6881\u7f16\u7801");
        cell8.setCellStyle(cellStyle);
        HSSFCell cell9 = row3.createCell(1);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue(bridge.getNumber());
        HSSFCell cell10 = row3.createCell(3);
        cell10.setCellValue("\u6865\u6881\u540d\u79f0");
        cell10.setCellStyle(cellStyle);
        HSSFCell cell11 = row3.createCell(4);
        cell11.setCellValue(bridge.getName() + "(" + bridge.getDirectionValue() + ")");
        cell11.setCellStyle(cellStyle);
        HSSFCell cell12 = row3.createCell(5);
        cell12.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
        cell12.setCellStyle(cellStyle);
        HSSFCell cell13 = row3.createCell(6);
        cell13.setCellStyle(cellStyle);
        row3.createCell(2).setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(4);
        HSSFCell cell14 = row4.createCell(0);
        cell14.setCellValue("\u90e8\u4ef6\u540d\u79f0");
        cell14.setCellStyle(cellStyle);
        HSSFCell cell15 = row4.createCell(1);
        cell15.setCellValue("\u7f3a\u635f\u7c7b\u578b");
        cell15.setCellStyle(cellStyle);
        HSSFCell cell16 = row4.createCell(2);
        cell16.setCellValue("\u7f3a\u635f\u8303\u56f4");
        cell16.setCellStyle(cellStyle);
        HSSFCell cell17 = row4.createCell(4);
        cell17.setCellValue("\u4fdd\u517b\u63aa\u65bd\u610f\u89c1");
        cell17.setCellStyle(cellStyle);
        HSSFCell cell18 = row4.createCell(5);
        cell18.setCellValue("\u5904\u7406\u63aa\u65bd");
        cell18.setCellStyle(cellStyle);
        List<SysDictionaryDetail> list = qljcmxblsq.get("qljcmxblsq");
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(6).setCellStyle(cellStyle);
        row0.setHeight((short)640);
        row1.setHeight((short)580);
        row2.setHeight((short)580);
        row3.setHeight((short)580);
        row4.setHeight((short)580);
        for (int i = 0; i < list.size(); ++i) {
            HSSFRow row5 = sheet.createRow(5 + i);
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 2, 3));
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 5, 6));
            SysDictionaryDetail detail = null;
            try {
                Map map = (Map)list.get(i);
                detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
            }
            catch (Exception e) {
                detail = list.get(i);
            }
            row5.setHeight((short)500);
            HSSFCell cell19 = row5.createCell(0);
            cell19.setCellValue(detail.getName());
            cell19.setCellStyle(cellStyle);
            HSSFCell cell20 = row5.createCell(1);
            cell20.setCellStyle(cellStyle);
            HSSFCell cell21 = row5.createCell(2);
            cell21.setCellStyle(cellStyle);
            HSSFCell cell22 = row5.createCell(4);
            cell22.setCellStyle(cellStyle);
            HSSFCell cell23 = row5.createCell(5);
            cell23.setCellStyle(cellStyle);
            row5.createCell(3).setCellStyle(cellStyle);
            row5.createCell(6).setCellStyle(cellStyle);
        }
        HSSFRow row5 = sheet.createRow(5 + list.size());
        sheet.addMergedRegion(new CellRangeAddress(5 + list.size(), 5 + list.size(), 1, 2));
        HSSFCell cell24 = row5.createCell(0);
        cell24.setCellStyle(cellStyle);
        cell24.setCellValue("\u8d1f\u8d23\u4eba");
        HSSFCell cell25 = row5.createCell(1);
        cell25.setCellStyle(cellStyle);
        HSSFCell cell26 = row5.createCell(3);
        cell26.setCellStyle(cellStyle);
        cell26.setCellValue("\u8bb0\u5f55\u4eba");
        HSSFCell cell27 = row5.createCell(4);
        cell27.setCellStyle(cellStyle);
        HSSFCell cell28 = row5.createCell(5);
        cell28.setCellStyle(cellStyle);
        cell28.setCellValue("\u68c0\u67e5\u65e5\u671f");
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(6).setCellStyle(cellStyle);
        try {
            FileOutputStream os = new FileOutputStream(file + "/" + bridge.getName() + "-" + bridge.getNumber() + "-" + bridge.getDirectionValue() + System.currentTimeMillis() + ".xls");
            workbook.write((OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    private void exportBriCableStayed(File file, Map<String, List<SysDictionaryDetail>> qljcmxb, BridgeInformation bridge, Road road, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5120);
        sheet.setColumnWidth(1, 2560);
        sheet.setColumnWidth(2, 2560);
        sheet.setColumnWidth(3, 6400);
        sheet.setColumnWidth(4, 2304);
        sheet.setColumnWidth(5, 2560);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 5));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell21 = row0.createCell(0);
        cell21.setCellValue(" \u6865\u6881\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
        cell21.setCellStyle(cellStyleTitle);
        this.setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(cellStyle);
        HSSFCell cell20 = row.createCell(1);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue(this.getCompany(bridge.getOfficeName()));
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(3).setCellStyle(cellStyle);
        row.createCell(4).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        cell.setCellValue("\u7ba1\u7406\u5355\u4f4d");
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell1 = row1.createCell(0);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue("\u8def\u7ebf\u7f16\u53f7");
        HSSFCell cell2 = row1.createCell(1);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue(road.getCode());
        HSSFCell cell3 = row1.createCell(2);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue("\u8def\u7ebf\u540d\u79f0");
        HSSFCell cell4 = row1.createCell(3);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue(road.getName());
        HSSFCell cell5 = row1.createCell(4);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue("\u6865\u4f4d\u6869\u53f7");
        HSSFCell cell6 = row1.createCell(5);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue((double)bridge.getCentPeg().floatValue());
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell7 = row2.createCell(0);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue("\u6865\u6881\u7f16\u53f7");
        HSSFCell cell8 = row2.createCell(1);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue(bridge.getNumber());
        HSSFCell cell9 = row2.createCell(2);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue("\u6865\u6881\u540d\u79f0");
        HSSFCell cell10 = row2.createCell(3);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue(bridge.getName());
        HSSFCell cell11 = row2.createCell(4);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue("\u517b\u62a4\u5355\u4f4d");
        HSSFCell cell12 = row2.createCell(5);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue(bridge.getOfficeName());
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell13 = row3.createCell(0);
        cell13.setCellStyle(cellStyle);
        cell13.setCellValue("\u68c0\u67e5\u9879\u76ee");
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 4, 5));
        HSSFCell cell14 = row3.createCell(1);
        cell14.setCellStyle(cellStyle);
        cell14.setCellValue("\u7f3a\u635f\u7c7b\u578b");
        row3.createCell(2).setCellStyle(cellStyle);
        HSSFCell cell15 = row3.createCell(3);
        cell15.setCellStyle(cellStyle);
        cell15.setCellValue("\u7f3a\u635f\u8303\u56f4");
        HSSFCell cell16 = row3.createCell(4);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("\u5904\u6cbb\u5efa\u8bae");
        row3.createCell(5).setCellStyle(cellStyle);
        row0.setHeight((short)640);
        row.setHeight((short)500);
        row1.setHeight((short)500);
        row2.setHeight((short)500);
        row3.setHeight((short)500);
        List<SysDictionaryDetail> list = qljcmxb.get("qljcmxb");
        for (int i = 0; i < list.size(); ++i) {
            HSSFRow row4 = sheet.createRow(5 + i);
            SysDictionaryDetail detail = null;
            try {
                Map map = (Map)list.get(i);
                detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
            }
            catch (Exception e) {
                detail = list.get(i);
            }
            HSSFCell cell17 = row4.createCell(0);
            row4.setHeight((short)420);
            cell17.setCellStyle(cellStyle);
            cell17.setCellValue(detail.getName());
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 1, 2));
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 4, 5));
            row4.createCell(1).setCellStyle(cellStyle);
            row4.createCell(2).setCellStyle(cellStyle);
            row4.createCell(3).setCellStyle(cellStyle);
            row4.createCell(4).setCellStyle(cellStyle);
            row4.createCell(5).setCellStyle(cellStyle);
        }
        HSSFRow row4 = sheet.createRow(5 + list.size());
        HSSFCell cell17 = row4.createCell(0);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue("\u8d1f\u8d23\u4eba");
        HSSFCell cell18 = row4.createCell(2);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("\u8bb0\u5f55\u4eba");
        HSSFCell cell19 = row4.createCell(4);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue("\u68c0\u67e5\u65e5\u671f");
        row4.createCell(1).setCellStyle(cellStyle);
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(5).setCellStyle(cellStyle);
        try {
            FileOutputStream os = new FileOutputStream(file + "/" + bridge.getName() + "-" + bridge.getNumber() + "-" + bridge.getDirectionValue() + System.currentTimeMillis() + ".xls");
            workbook.write((OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    private void exportBriCableStayedData(File file, BridgeInformation bridge, Road road, BridgeOftenCheck bridgeOftenCheck, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5120);
        sheet.setColumnWidth(1, 2560);
        sheet.setColumnWidth(2, 2560);
        sheet.setColumnWidth(3, 6400);
        sheet.setColumnWidth(4, 2304);
        sheet.setColumnWidth(5, 2560);
        List list = this.bridgeOftenCheckDetailManager.list((Wrapper)new QueryWrapper().lambda().eq(BridgeOftenCheckDetail::getBridgeOftenCheckId, (Object)bridgeOftenCheck.getId()));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 5));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell24 = row0.createCell(0);
        cell24.setCellValue(" \u6865\u6881\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
        cell24.setCellStyle(cellStyleTitle);
        this.setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(cellStyle);
        HSSFCell cell23 = row.createCell(1);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue(this.getCompany(bridge.getOfficeName()));
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(3).setCellStyle(cellStyle);
        row.createCell(4).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        cell.setCellValue("\u7ba1\u7406\u5355\u4f4d");
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell1 = row1.createCell(0);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue("\u8def\u7ebf\u7f16\u53f7");
        HSSFCell cell2 = row1.createCell(1);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue(road.getCode());
        HSSFCell cell3 = row1.createCell(2);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue("\u8def\u7ebf\u540d\u79f0");
        HSSFCell cell4 = row1.createCell(3);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue(road.getName());
        HSSFCell cell5 = row1.createCell(4);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue("\u6865\u4f4d\u6869\u53f7");
        HSSFCell cell6 = row1.createCell(5);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue((double)bridge.getCentPeg().floatValue());
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell7 = row2.createCell(0);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue("\u6865\u6881\u7f16\u53f7");
        HSSFCell cell8 = row2.createCell(1);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue(bridge.getNumber());
        HSSFCell cell9 = row2.createCell(2);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue("\u6865\u6881\u540d\u79f0");
        HSSFCell cell10 = row2.createCell(3);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue(bridge.getName());
        HSSFCell cell11 = row2.createCell(4);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue("\u517b\u62a4\u5355\u4f4d");
        HSSFCell cell12 = row2.createCell(5);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue(bridge.getOfficeName());
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell13 = row3.createCell(0);
        cell13.setCellStyle(cellStyle);
        cell13.setCellValue("\u68c0\u67e5\u9879\u76ee");
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 4, 5));
        HSSFCell cell14 = row3.createCell(1);
        cell14.setCellStyle(cellStyle);
        cell14.setCellValue("\u7f3a\u635f\u7c7b\u578b");
        row3.createCell(2).setCellStyle(cellStyle);
        HSSFCell cell15 = row3.createCell(3);
        cell15.setCellStyle(cellStyle);
        cell15.setCellValue("\u7f3a\u635f\u8303\u56f4");
        HSSFCell cell16 = row3.createCell(4);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("\u5904\u6cbb\u5efa\u8bae");
        row3.createCell(5).setCellStyle(cellStyle);
        row0.setHeight((short)640);
        row.setHeight((short)500);
        row1.setHeight((short)500);
        row2.setHeight((short)500);
        row3.setHeight((short)500);
        for (int i = 0; i < list.size(); ++i) {
            HSSFRow row4 = sheet.createRow(5 + i);
            row4.setHeight((short)420);
            BridgeOftenCheckDetail bridgeOftenCheckDetail = (BridgeOftenCheckDetail)((Object)list.get(i));
            HSSFCell cell17 = row4.createCell(0);
            cell17.setCellStyle(cellStyle);
            cell17.setCellValue(bridgeOftenCheckDetail.getName());
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 1, 2));
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 4, 5));
            HSSFCell cell18 = row4.createCell(1);
            cell18.setCellStyle(cellStyle);
            cell18.setCellValue(bridgeOftenCheckDetail.getDefectType());
            HSSFCell cell19 = row4.createCell(3);
            cell19.setCellStyle(cellStyle);
            cell19.setCellValue(bridgeOftenCheckDetail.getDefectScope());
            HSSFCell cell20 = row4.createCell(4);
            cell20.setCellStyle(cellStyle);
            cell20.setCellValue(bridgeOftenCheckDetail.getProcessMode());
            row4.createCell(2).setCellStyle(cellStyle);
            row4.createCell(5).setCellStyle(cellStyle);
        }
        HSSFRow row4 = sheet.createRow(5 + list.size());
        HSSFCell cell17 = row4.createCell(0);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue("\u8d1f\u8d23\u4eba");
        HSSFCell cell18 = row4.createCell(1);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue(bridgeOftenCheck.getRummager());
        HSSFCell cell22 = row4.createCell(2);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("\u8bb0\u5f55\u4eba");
        HSSFCell cell19 = row4.createCell(3);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue(bridgeOftenCheck.getNoteTaker());
        HSSFCell cell20 = row4.createCell(4);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue("\u68c0\u67e5\u65e5\u671f");
        HSSFCell cell21 = row4.createCell(5);
        cell21.setCellStyle(cellStyle);
        String dateStr = new SimpleDateFormat("yyyy/MM/dd").format(bridgeOftenCheck.getCheckDate());
        cell21.setCellValue(dateStr);
        try {
            FileOutputStream os = new FileOutputStream(file + "/" + bridge.getName() + "-" + bridge.getNumber() + "-" + bridge.getDirectionValue() + "-" + new SimpleDateFormat("yyyy-MM-dd").format(bridgeOftenCheck.getCheckDate()) + ".xls");
            workbook.write((OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportTunnelOften(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            List<String> strings = Arrays.asList(ids.split(","));
            Map qljcmxb = this.sysDictionaryManager.queryDictItemsByCode("sdsdjcjc");
            strings.forEach(s -> {
                TunnelInformation tunnel = this.tunnelInformationManager.getTunnelById((String)s);
                Road road = (Road)((Object)((Object)this.roadManager.getById((Serializable)((Object)tunnel.getRoadSegmentId()))));
                QueryWrapper queryWrapper = new QueryWrapper();
                TunnelOftenCheck tunnelOftenCheck = (TunnelOftenCheck)((Object)((Object)this.tunnelOftenCheckManager.getBaseMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"TUNNEL_ID_", s)).orderByDesc((Object)"CHECK_DATE_")).orderByDesc((Object)"CREATE_TIME_")).last("limit 0,1"))));
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                this.setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                HSSFSheet sheet = workbook.createSheet("\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                sheet.getPrintSetup().setPaperSize((short)9);
                sheet.setColumnWidth(0, 2560);
                sheet.setColumnWidth(1, 2560);
                sheet.setColumnWidth(2, 7680);
                sheet.setColumnWidth(3, 2048);
                sheet.setColumnWidth(4, 1536);
                sheet.setColumnWidth(5, 1280);
                sheet.setColumnWidth(6, 1280);
                sheet.setColumnWidth(7, 1280);
                if (tunnelOftenCheck != null) {
                    this.exportTunnelData(tunnel, road, tunnelOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);
                } else {
                    this.exportTunnel(qljcmxb, tunnel, road, workbook, cellStyle, cellStyleTitle, sheet);
                }
                try {
                    FileOutputStream os = new FileOutputStream(file + "/" + tunnel.getName() + "-" + tunnel.getNumber() + "-" + tunnel.getDirectionValue() + System.currentTimeMillis() + ".xls");
                    workbook.write((OutputStream)os);
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    private void exportTunnel(Map<String, List<SysDictionaryDetail>> qljcmxb, TunnelInformation tunnel, Road road, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue("\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
        cell0.setCellStyle(cellStyleTitle);
        this.setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u96a7\u9053\u540d\u79f0");
        cell.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 2));
        HSSFCell cell1 = row.createCell(1);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(tunnel.getName() + "(" + tunnel.getDirectionValue() + ")");
        HSSFCell cell2 = row.createCell(3);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue("\u8def\u7ebf\u540d\u79f0");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 7));
        HSSFCell cell3 = row.createCell(4);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getName());
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        row.createCell(6).setCellStyle(cellStyle);
        row.createCell(7).setCellStyle(cellStyle);
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell4 = row1.createCell(0);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue("\u96a7\u9053\u7f16\u7801");
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        HSSFCell cell5 = row1.createCell(1);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue(tunnel.getNumber());
        HSSFCell cell6 = row1.createCell(3);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue("\u8def\u7ebf\u7f16\u7801");
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 7));
        HSSFCell cell7 = row1.createCell(4);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue(road.getCode());
        row1.createCell(2).setCellStyle(cellStyle);
        row1.createCell(5).setCellStyle(cellStyle);
        row1.createCell(6).setCellStyle(cellStyle);
        row1.createCell(7).setCellStyle(cellStyle);
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell8 = row2.createCell(0);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue("\u517b\u62a4\u673a\u6784");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        HSSFCell cell9 = row2.createCell(1);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue(tunnel.getOfficeName());
        HSSFCell cell10 = row2.createCell(3);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue("\u68c0\u67e5\u65e5\u671f");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 5));
        HSSFCell cell11 = row2.createCell(4);
        cell11.setCellStyle(cellStyle);
        HSSFCell cell12 = row2.createCell(6);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue("\u5929\u6c14");
        HSSFCell cell13 = row2.createCell(7);
        cell13.setCellStyle(cellStyle);
        row2.createCell(2).setCellStyle(cellStyle);
        row2.createCell(5).setCellStyle(cellStyle);
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell14 = row3.createCell(0);
        cell14.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
        cell14.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 7));
        HSSFCell cell15 = row3.createCell(2);
        cell15.setCellStyle(cellStyle);
        row3.createCell(1).setCellStyle(cellStyle);
        row3.createCell(3).setCellStyle(cellStyle);
        row3.createCell(4).setCellStyle(cellStyle);
        row3.createCell(5).setCellStyle(cellStyle);
        row3.createCell(6).setCellStyle(cellStyle);
        row3.createCell(7).setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(5);
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 0, 0));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 1, 1));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 2, 2));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(5, 5, 5, 7));
        HSSFCell cell16 = row4.createCell(0);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("\u91cc\u7a0b\u6869\u53f7/\u5f02\u5e38\u4f4d\u7f6e");
        HSSFCell cell17 = row4.createCell(1);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue("\u7ed3\u6784\u540d\u79f0");
        HSSFCell cell18 = row4.createCell(2);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("\u68c0\u67e5\u5185\u5bb9");
        HSSFCell cell19 = row4.createCell(3);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue("\u5f02\u5e38\u63cf\u8ff0(\u6027\u8d28\u3001\u8303\u56f4\u3001\u7a0b\u5ea6\u7b49)");
        HSSFCell cell20 = row4.createCell(5);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue("\u5224\u65ad");
        row4.createCell(6).setCellStyle(cellStyle);
        row4.createCell(7).setCellStyle(cellStyle);
        HSSFRow row5 = sheet.createRow(6);
        HSSFCell cell21 = row5.createCell(5);
        cell21.setCellStyle(cellStyle);
        cell21.setCellValue("\u60c5\u51b5\u6b63\u5e38");
        HSSFCell cell22 = row5.createCell(6);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("\u4e00\u822c\u5f02\u5e38");
        HSSFCell cell23 = row5.createCell(7);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue("\u4e25\u91cd\u5f02\u5e38");
        row5.createCell(0).setCellStyle(cellStyle);
        row5.createCell(1).setCellStyle(cellStyle);
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(3).setCellStyle(cellStyle);
        row5.createCell(4).setCellStyle(cellStyle);
        row0.setHeight((short)640);
        row.setHeight((short)580);
        row1.setHeight((short)580);
        row2.setHeight((short)580);
        row3.setHeight((short)580);
        row4.setHeight((short)580);
        row5.setHeight((short)580);
        List<SysDictionaryDetail> list = qljcmxb.get("sdsdjcjc");
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
            HSSFRow row6 = sheet.createRow(7 + i);
            HSSFCell cell24 = row6.createCell(0);
            cell24.setCellStyle(cellStyle);
            HSSFCell cell25 = row6.createCell(1);
            cell25.setCellStyle(cellStyle);
            cell25.setCellValue(detail.getName());
            HSSFCell cell26 = row6.createCell(2);
            cell26.setCellStyle(cellStyle);
            cell26.setCellValue(detail.getValue());
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 3, 4));
            HSSFCell cell27 = row6.createCell(3);
            cell27.setCellStyle(cellStyle);
            row6.setHeight((short)1200);
            row6.createCell(4).setCellStyle(cellStyle);
            row6.createCell(5).setCellStyle(cellStyle);
            row6.createCell(6).setCellStyle(cellStyle);
            row6.createCell(7).setCellStyle(cellStyle);
        }
        HSSFRow row7 = sheet.createRow(7 + list.size());
        HSSFCell hssfCell = row7.createCell(0);
        hssfCell.setCellStyle(cellStyle);
        hssfCell.setCellValue("\u8d1f\u8d23\u4eba");
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 4, 7));
        HSSFCell hssfCell2 = row7.createCell(1);
        hssfCell2.setCellStyle(cellStyle);
        HSSFCell hssfCell3 = row7.createCell(3);
        hssfCell3.setCellStyle(cellStyle);
        hssfCell3.setCellValue("\u8bb0\u5f55\u4eba");
        HSSFCell hssfCell4 = row7.createCell(4);
        hssfCell4.setCellStyle(cellStyle);
        row7.setHeight((short)440);
        row7.createCell(2).setCellStyle(cellStyle);
        row7.createCell(5).setCellStyle(cellStyle);
        row7.createCell(6).setCellStyle(cellStyle);
        row7.createCell(7).setCellStyle(cellStyle);
    }

    private void exportTunnelData(TunnelInformation tunnel, Road road, TunnelOftenCheck tunnelOftenCheck, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        List list = this.tunnelOftenCheckDetailManager.list((Wrapper)new QueryWrapper().lambda().eq(TunnelOftenCheckDetail::getTunnelOftenCheckId, (Object)tunnelOftenCheck.getId()));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue("\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
        cell0.setCellStyle(cellStyleTitle);
        this.setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u96a7\u9053\u540d\u79f0");
        cell.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 2));
        HSSFCell cell1 = row.createCell(1);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(tunnel.getName() + "(" + tunnel.getDirectionValue() + ")");
        HSSFCell cell2 = row.createCell(3);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue("\u8def\u7ebf\u540d\u79f0");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 7));
        HSSFCell cell3 = row.createCell(4);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getName());
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        row.createCell(6).setCellStyle(cellStyle);
        row.createCell(7).setCellStyle(cellStyle);
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell4 = row1.createCell(0);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue("\u96a7\u9053\u7f16\u7801");
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        HSSFCell cell5 = row1.createCell(1);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue(tunnel.getNumber());
        HSSFCell cell6 = row1.createCell(3);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue("\u8def\u7ebf\u7f16\u7801");
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 7));
        HSSFCell cell7 = row1.createCell(4);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue(road.getCode());
        row1.createCell(2).setCellStyle(cellStyle);
        row1.createCell(5).setCellStyle(cellStyle);
        row1.createCell(6).setCellStyle(cellStyle);
        row1.createCell(7).setCellStyle(cellStyle);
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell8 = row2.createCell(0);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue("\u517b\u62a4\u673a\u6784");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        HSSFCell cell9 = row2.createCell(1);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue(tunnel.getOfficeName());
        HSSFCell cell10 = row2.createCell(3);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue("\u68c0\u67e5\u65e5\u671f");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 5));
        HSSFCell cell11 = row2.createCell(4);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue(new SimpleDateFormat("yyyy/MM/dd").format(tunnelOftenCheck.getCheckDate()));
        HSSFCell cell12 = row2.createCell(6);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue("\u5929\u6c14");
        HSSFCell cell13 = row2.createCell(7);
        cell13.setCellStyle(cellStyle);
        cell13.setCellValue(tunnelOftenCheck.getWeatherValue());
        row2.createCell(2).setCellStyle(cellStyle);
        row2.createCell(5).setCellStyle(cellStyle);
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell14 = row3.createCell(0);
        cell14.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
        cell14.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 7));
        HSSFCell cell15 = row3.createCell(1);
        cell15.setCellStyle(cellStyle);
        cell15.setCellValue(tunnelOftenCheck.getEvaluateValue());
        row3.createCell(2).setCellStyle(cellStyle);
        row3.createCell(3).setCellStyle(cellStyle);
        row3.createCell(4).setCellStyle(cellStyle);
        row3.createCell(5).setCellStyle(cellStyle);
        row3.createCell(6).setCellStyle(cellStyle);
        row3.createCell(7).setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(5);
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 0, 0));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 1, 1));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 2, 2));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(5, 5, 5, 7));
        HSSFCell cell16 = row4.createCell(0);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("\u91cc\u7a0b\u6869\u53f7/\u5f02\u5e38\u4f4d\u7f6e");
        HSSFCell cell17 = row4.createCell(1);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue("\u7ed3\u6784\u540d\u79f0");
        HSSFCell cell18 = row4.createCell(2);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("\u68c0\u67e5\u5185\u5bb9");
        HSSFCell cell19 = row4.createCell(3);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue("\u5f02\u5e38\u63cf\u8ff0(\u6027\u8d28\u3001\u8303\u56f4\u3001\u7a0b\u5ea6\u7b49)");
        HSSFCell cell20 = row4.createCell(5);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue("\u5224\u65ad");
        row4.createCell(6).setCellStyle(cellStyle);
        row4.createCell(7).setCellStyle(cellStyle);
        HSSFRow row5 = sheet.createRow(6);
        HSSFCell cell21 = row5.createCell(5);
        cell21.setCellStyle(cellStyle);
        cell21.setCellValue("\u60c5\u51b5\u6b63\u5e38");
        HSSFCell cell22 = row5.createCell(6);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("\u4e00\u822c\u5f02\u5e38");
        HSSFCell cell23 = row5.createCell(7);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue("\u4e25\u91cd\u5f02\u5e38");
        row5.createCell(0).setCellStyle(cellStyle);
        row5.createCell(1).setCellStyle(cellStyle);
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(3).setCellStyle(cellStyle);
        row5.createCell(4).setCellStyle(cellStyle);
        row0.setHeight((short)640);
        row.setHeight((short)580);
        row1.setHeight((short)580);
        row2.setHeight((short)580);
        row3.setHeight((short)580);
        row4.setHeight((short)580);
        row5.setHeight((short)580);
        for (int i = 0; i < list.size(); ++i) {
            HSSFCell cell28;
            HSSFRow row6 = sheet.createRow(7 + i);
            row6.setHeight((short)1200);
            HSSFCell cell24 = row6.createCell(0);
            TunnelOftenCheckDetail tunnelOftenCheckDetail = (TunnelOftenCheckDetail)((Object)list.get(i));
            cell24.setCellValue(tunnelOftenCheckDetail.getMileagePilenum());
            cell24.setCellStyle(cellStyle);
            HSSFCell cell25 = row6.createCell(1);
            cell25.setCellStyle(cellStyle);
            cell25.setCellValue(tunnelOftenCheckDetail.getUnitName());
            HSSFCell cell26 = row6.createCell(2);
            cell26.setCellStyle(cellStyle);
            cell26.setCellValue(tunnelOftenCheckDetail.getCheckContent());
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 3, 4));
            HSSFCell cell27 = row6.createCell(3);
            cell27.setCellStyle(cellStyle);
            cell27.setCellValue(tunnelOftenCheckDetail.getStatusDesc());
            if ("\u60c5\u51b5\u6b63\u5e38".equals(tunnelOftenCheckDetail.getFlag()) || "1".equals(tunnelOftenCheckDetail.getFlag())) {
                cell28 = row6.createCell(5);
                cell28.setCellValue("\u221a");
                cell28.setCellStyle(cellStyle);
                row6.createCell(6).setCellStyle(cellStyle);
                row6.createCell(7).setCellStyle(cellStyle);
            } else if ("\u4e00\u822c\u5f02\u5e38".equals(tunnelOftenCheckDetail.getFlag()) || "2".equals(tunnelOftenCheckDetail.getFlag())) {
                cell28 = row6.createCell(6);
                cell28.setCellValue("\u221a");
                cell28.setCellStyle(cellStyle);
                row6.createCell(5).setCellStyle(cellStyle);
                row6.createCell(7).setCellStyle(cellStyle);
            } else if ("\u4e25\u91cd\u5f02\u5e38".equals(tunnelOftenCheckDetail.getFlag()) || "3".equals(tunnelOftenCheckDetail.getFlag())) {
                cell28 = row6.createCell(7);
                cell28.setCellValue("\u221a");
                cell28.setCellStyle(cellStyle);
                row6.createCell(5).setCellStyle(cellStyle);
                row6.createCell(6).setCellStyle(cellStyle);
            } else {
                cell28 = row6.createCell(5);
                cell28.setCellStyle(cellStyle);
                row6.createCell(6).setCellStyle(cellStyle);
                row6.createCell(7).setCellStyle(cellStyle);
            }
            row6.createCell(4).setCellStyle(cellStyle);
        }
        HSSFRow row7 = sheet.createRow(7 + list.size());
        HSSFCell hssfCell = row7.createCell(0);
        hssfCell.setCellStyle(cellStyle);
        hssfCell.setCellValue("\u8d1f\u8d23\u4eba");
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 4, 7));
        HSSFCell hssfCell2 = row7.createCell(1);
        hssfCell2.setCellStyle(cellStyle);
        hssfCell2.setCellValue(tunnelOftenCheck.getRummager());
        HSSFCell hssfCell3 = row7.createCell(3);
        hssfCell3.setCellStyle(cellStyle);
        hssfCell3.setCellValue("\u8bb0\u5f55\u4eba");
        HSSFCell hssfCell4 = row7.createCell(4);
        hssfCell4.setCellStyle(cellStyle);
        hssfCell4.setCellValue(tunnelOftenCheck.getNoteTaker());
        row7.createCell(2).setCellStyle(cellStyle);
        row7.createCell(5).setCellStyle(cellStyle);
        row7.createCell(6).setCellStyle(cellStyle);
        row7.createCell(7).setCellStyle(cellStyle);
        row7.setHeight((short)440);
    }

    @Override
    public void exportCulvertOften(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            Map hdjcjcmx = this.sysDictionaryManager.queryDictItemsByCode("hdjcjcmx");
            List<String> strings = Arrays.asList(ids.split(","));
            List collect = IntStream.range(0, (strings.size() + 3 - 1) / 3).map(pageNum -> pageNum * 3).parallel().mapToObj(i -> strings.stream().skip(i).limit(3L).collect(Collectors.toList())).collect(Collectors.toList());
            for (List stringList : collect) {
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                this.setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                this.setExcelStyle(cellStyle, workbook);
                HSSFSheet sheet = workbook.createSheet("\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                sheet.getPrintSetup().setPaperSize((short)9);
                sheet.setColumnWidth(0, 2560);
                sheet.setColumnWidth(1, 2560);
                sheet.setColumnWidth(2, 2560);
                sheet.setColumnWidth(3, 2048);
                sheet.setColumnWidth(4, 1536);
                sheet.setColumnWidth(5, 1024);
                sheet.setColumnWidth(6, 2048);
                sheet.setColumnWidth(7, 2048);
                sheet.setColumnWidth(8, 2048);
                sheet.setColumnWidth(9, 2048);
                int rowIndex = 1;
                for (String s : stringList) {
                    HSSFRow row4;
                    int i2;
                    BizCulvertInformation culvert = (BizCulvertInformation)((Object)this.culvertInformationManager.getById((Serializable)((Object)s)));
                    Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)culvert.getRoadSegmentId())));
                    HSSFRow row0 = sheet.createRow(0);
                    HSSFCell cell24 = row0.createCell(0);
                    cell24.setCellValue("\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                    cell24.setCellStyle(cellStyleTitle);
                    this.setExcelStyleTitle(cellStyleTitle, workbook);
                    HSSFRow row1 = sheet.createRow(1);
                    HSSFCell cell = row1.createCell(0);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue("\u8def\u7ebf\u540d\u79f0:");
                    HSSFCell cell1 = row1.createCell(1);
                    cell1.setCellStyle(cellStyle);
                    cell1.setCellValue(road.getName());
                    HSSFCell cell2 = row1.createCell(6);
                    cell2.setCellStyle(cellStyle);
                    cell2.setCellValue("\u8def\u7ebf\u7f16\u7801:");
                    HSSFCell cell3 = row1.createCell(7);
                    row1.createCell(2).setCellStyle(cellStyle);
                    row1.createCell(3).setCellStyle(cellStyle);
                    row1.createCell(4).setCellStyle(cellStyle);
                    row1.createCell(5).setCellStyle(cellStyle);
                    row1.createCell(8).setCellStyle(cellStyle);
                    row1.createCell(9).setCellStyle(cellStyle);
                    cell3.setCellStyle(cellStyle);
                    cell3.setCellValue(road.getCode());
                    if (rowIndex == 1) {
                        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 4));
                        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
                        sheet.addMergedRegion(new CellRangeAddress(1, 1, 7, 9));
                    }
                    QueryWrapper queryWrapper = new QueryWrapper();
                    CulvertOftenCheck culvertOftenCheck = (CulvertOftenCheck)((Object)this.culvertOftenCheckManager.getBaseMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"CULVERT_ID_", (Object)s)).orderByDesc((Object)"CHECK_DATE_")).orderByDesc((Object)"CREATE_TIME_")).last("limit 0,1")));
                    if (culvertOftenCheck != null) {
                        List list = this.culvertOftenCheckDetailManager.list((Wrapper)new QueryWrapper().lambda().eq(CulvertOftenCheckDetail::getCulvertOftenCheckId, (Object)culvertOftenCheck.getId()));
                        HSSFRow row2 = sheet.createRow(++rowIndex);
                        HSSFCell cell4 = row2.createCell(0);
                        cell4.setCellStyle(cellStyle);
                        cell4.setCellValue("\u6db5\u6d1e\u6869\u53f7");
                        HSSFCell cell5 = row2.createCell(1);
                        cell5.setCellStyle(cellStyle);
                        cell5.setCellValue("\u6db5\u6d1e\u7c7b\u578b");
                        HSSFCell cell6 = row2.createCell(2);
                        cell6.setCellStyle(cellStyle);
                        cell6.setCellValue("\u68c0\u67e5\u65e5\u671f");
                        HSSFCell cell7 = row2.createCell(3);
                        cell7.setCellStyle(cellStyle);
                        cell7.setCellValue("\u68c0\u67e5\u4eba");
                        HSSFCell cell8 = row2.createCell(4);
                        cell8.setCellStyle(cellStyle);
                        cell8.setCellValue("\u8bb0\u5f55\u4eba");
                        HSSFCell cell9 = row2.createCell(5);
                        cell9.setCellStyle(cellStyle);
                        cell9.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
                        HSSFCell cell10 = row2.createCell(6);
                        cell10.setCellStyle(cellStyle);
                        cell10.setCellValue("\u68c0\u67e5\u5185\u5bb9");
                        HSSFCell cell11 = row2.createCell(7);
                        cell11.setCellStyle(cellStyle);
                        cell11.setCellValue("\u72b6\u6001\u63cf\u8ff0");
                        HSSFCell cell12 = row2.createCell(8);
                        cell12.setCellStyle(cellStyle);
                        cell12.setCellValue("\u5224\u65ad\u7ed3\u8bba");
                        HSSFCell cell13 = row2.createCell(9);
                        cell13.setCellStyle(cellStyle);
                        cell13.setCellValue("\u5904\u7406\u63aa\u65bd");
                        row0.setHeight((short)500);
                        row1.setHeight((short)400);
                        row2.setHeight((short)400);
                        Integer rowIndexFor = rowIndex + 1;
                        for (i2 = 0; i2 < list.size(); ++i2) {
                            row4 = sheet.createRow(rowIndexFor + i2);
                            CulvertOftenCheckDetail culvertOftenCheckDetail = (CulvertOftenCheckDetail)((Object)list.get(i2));
                            HSSFCell cell14 = row4.createCell(6);
                            cell14.setCellStyle(cellStyle);
                            cell14.setCellValue(culvertOftenCheckDetail.getCheckProject());
                            HSSFCell cell15 = row4.createCell(7);
                            cell15.setCellStyle(cellStyle);
                            cell15.setCellValue(culvertOftenCheckDetail.getStatusDesc());
                            HSSFCell cell16 = row4.createCell(8);
                            cell16.setCellStyle(cellStyle);
                            cell16.setCellValue(culvertOftenCheckDetail.getResult());
                            HSSFCell cell17 = row4.createCell(9);
                            cell17.setCellStyle(cellStyle);
                            cell17.setCellValue(culvertOftenCheckDetail.getProcess());
                            row4.setHeight((short)300);
                            if (i2 == 0) {
                                ++rowIndex;
                                HSSFCell cell18 = row4.createCell(0);
                                cell18.setCellValue(culvert.getCentPeg() + "(" + culvert.getDirectionValue() + ")");
                                cell18.setCellStyle(cellStyle);
                                HSSFCell cell19 = row4.createCell(1);
                                cell19.setCellValue(culvert.getTypeValue());
                                cell19.setCellStyle(cellStyle);
                                HSSFCell cell20 = row4.createCell(2);
                                cell20.setCellValue(new SimpleDateFormat("yyyy/MM/dd").format(culvertOftenCheck.getCheckDate()));
                                cell20.setCellStyle(cellStyle);
                                HSSFCell cell21 = row4.createCell(3);
                                cell21.setCellValue(culvertOftenCheck.getRummager());
                                cell21.setCellStyle(cellStyle);
                                HSSFCell cell22 = row4.createCell(4);
                                cell22.setCellValue(culvertOftenCheck.getNoteTaker());
                                cell22.setCellStyle(cellStyle);
                                HSSFCell cell23 = row4.createCell(5);
                                cell23.setCellValue(culvertOftenCheck.getEvaluateValue());
                                cell23.setCellStyle(cellStyle);
                                continue;
                            }
                            row4.createCell(0).setCellStyle(cellStyle);
                            row4.createCell(1).setCellStyle(cellStyle);
                            row4.createCell(2).setCellStyle(cellStyle);
                            row4.createCell(3).setCellStyle(cellStyle);
                            row4.createCell(4).setCellStyle(cellStyle);
                            row4.createCell(5).setCellStyle(cellStyle);
                            ++rowIndex;
                        }
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 0, 0));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 1, 1));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 2, 2));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 3, 3));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 4, 4));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 5, 5));
                        continue;
                    }
                    HSSFRow row2 = sheet.createRow(++rowIndex);
                    HSSFCell cell4 = row2.createCell(0);
                    cell4.setCellStyle(cellStyle);
                    cell4.setCellValue("\u6db5\u6d1e\u6869\u53f7");
                    HSSFCell cell5 = row2.createCell(1);
                    cell5.setCellStyle(cellStyle);
                    cell5.setCellValue("\u6db5\u6d1e\u7c7b\u578b");
                    HSSFCell cell6 = row2.createCell(2);
                    cell6.setCellStyle(cellStyle);
                    cell6.setCellValue("\u68c0\u67e5\u65e5\u671f");
                    HSSFCell cell7 = row2.createCell(3);
                    cell7.setCellStyle(cellStyle);
                    cell7.setCellValue("\u68c0\u67e5\u4eba");
                    HSSFCell cell8 = row2.createCell(4);
                    cell8.setCellStyle(cellStyle);
                    cell8.setCellValue("\u8bb0\u5f55\u4eba");
                    HSSFCell cell9 = row2.createCell(5);
                    cell9.setCellStyle(cellStyle);
                    cell9.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
                    HSSFCell cell10 = row2.createCell(6);
                    cell10.setCellStyle(cellStyle);
                    cell10.setCellValue("\u68c0\u67e5\u5185\u5bb9");
                    HSSFCell cell11 = row2.createCell(7);
                    cell11.setCellStyle(cellStyle);
                    cell11.setCellValue("\u72b6\u6001\u63cf\u8ff0");
                    HSSFCell cell12 = row2.createCell(8);
                    cell12.setCellStyle(cellStyle);
                    cell12.setCellValue("\u5224\u65ad\u7ed3\u8bba");
                    HSSFCell cell13 = row2.createCell(9);
                    cell13.setCellStyle(cellStyle);
                    cell13.setCellValue("\u5904\u7406\u63aa\u65bd");
                    row0.setHeight((short)500);
                    row1.setHeight((short)400);
                    row2.setHeight((short)400);
                    Integer rowIndexFor = rowIndex + 1;
                    List list = (List)hdjcjcmx.get("hdjcjcmx");
                    for (i2 = 0; i2 < list.size(); ++i2) {
                        row4 = sheet.createRow(rowIndexFor + i2);
                        Map map = (Map)list.get(i2);
                        SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                        HSSFCell cell14 = row4.createCell(6);
                        cell14.setCellStyle(cellStyle);
                        cell14.setCellValue(detail.getName());
                        HSSFCell cell15 = row4.createCell(7);
                        cell15.setCellStyle(cellStyle);
                        HSSFCell cell16 = row4.createCell(8);
                        cell16.setCellStyle(cellStyle);
                        row4.setHeight((short)300);
                        HSSFCell cell17 = row4.createCell(9);
                        cell17.setCellStyle(cellStyle);
                        if (i2 == 0) {
                            HSSFCell cell18 = row4.createCell(0);
                            cell18.setCellValue(culvert.getCentPeg() + "(" + culvert.getDirectionValue() + ")");
                            cell18.setCellStyle(cellStyle);
                            HSSFCell cell19 = row4.createCell(1);
                            cell19.setCellValue(culvert.getTypeValue());
                            cell19.setCellStyle(cellStyle);
                            HSSFCell cell20 = row4.createCell(2);
                            cell20.setCellStyle(cellStyle);
                            HSSFCell cell21 = row4.createCell(3);
                            cell21.setCellStyle(cellStyle);
                            HSSFCell cell22 = row4.createCell(4);
                            cell22.setCellStyle(cellStyle);
                            HSSFCell cell23 = row4.createCell(5);
                            cell23.setCellStyle(cellStyle);
                        } else {
                            row4.createCell(0).setCellStyle(cellStyle);
                            row4.createCell(1).setCellStyle(cellStyle);
                            row4.createCell(2).setCellStyle(cellStyle);
                            row4.createCell(3).setCellStyle(cellStyle);
                            row4.createCell(4).setCellStyle(cellStyle);
                            row4.createCell(5).setCellStyle(cellStyle);
                        }
                        ++rowIndex;
                    }
                    sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 0, 0));
                    sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 1, 1));
                    sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 2, 2));
                    sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 3, 3));
                    sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 4, 4));
                    sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 5, 5));
                }
                try {
                    FileOutputStream os = new FileOutputStream(file + "/" + "\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868" + System.currentTimeMillis() + ".xls");
                    workbook.write((OutputStream)os);
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    private void exportCulvert(File file, Map<String, List<SysDictionaryDetail>> hdjcjcmx, List<String> strings) {
        strings.forEach(s -> {
            BizCulvertInformation culvert = (BizCulvertInformation)((Object)((Object)this.culvertInformationManager.getById((Serializable)((Object)s))));
            Road road = (Road)((Object)((Object)this.roadManager.getById((Serializable)((Object)culvert.getRoadSegmentId()))));
            QueryWrapper queryWrapper = new QueryWrapper();
            CulvertOftenCheck culvertOftenCheck = (CulvertOftenCheck)((Object)((Object)this.culvertOftenCheckManager.getBaseMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"CULVERT_ID_", s)).orderByDesc((Object)"CHECK_DATE_")).orderByDesc((Object)"CREATE_TIME_")).last("limit 0,1"))));
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            this.setExcelStyle(cellStyle, workbook);
            HSSFSheet sheet = workbook.createSheet("\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
            sheet.setColumnWidth(0, 5000);
            sheet.setColumnWidth(1, 5000);
            sheet.setColumnWidth(2, 5000);
            sheet.setColumnWidth(3, 5000);
            sheet.setColumnWidth(4, 5000);
            sheet.setColumnWidth(5, 5000);
            sheet.setColumnWidth(6, 5000);
            if (culvertOftenCheck != null) {
                List list = this.culvertOftenCheckDetailManager.list((Wrapper)new QueryWrapper().lambda().eq(CulvertOftenCheckDetail::getCulvertOftenCheckId, (Object)culvertOftenCheck.getId()));
                HSSFRow row = sheet.createRow(0);
                HSSFCell rowCell0 = row.createCell(0);
                rowCell0.setCellStyle(cellStyle);
                rowCell0.setCellValue("\u8def\u7ebf\u7f16\u53f7");
                HSSFCell rowCell = row.createCell(1);
                rowCell.setCellStyle(cellStyle);
                rowCell.setCellValue(road.getCode());
                HSSFCell rowCell1 = row.createCell(2);
                rowCell1.setCellStyle(cellStyle);
                rowCell1.setCellValue("\u8def\u7ebf\u540d\u79f0");
                HSSFCell rowCell2 = row.createCell(3);
                rowCell2.setCellStyle(cellStyle);
                rowCell2.setCellValue(road.getName());
                HSSFCell rowCell3 = row.createCell(4);
                rowCell3.setCellStyle(cellStyle);
                rowCell3.setCellValue("\u884c\u653f\u533a\u5212");
                HSSFCell rowCell4 = row.createCell(5);
                rowCell4.setCellStyle(cellStyle);
                HSSFRow row1 = sheet.createRow(1);
                HSSFCell cell1 = row1.createCell(0);
                cell1.setCellStyle(cellStyle);
                cell1.setCellValue("\u4e2d\u5fc3\u6869\u53f7");
                HSSFCell cell2 = row1.createCell(1);
                cell2.setCellStyle(cellStyle);
                cell2.setCellValue(culvert.getCentPeg());
                HSSFCell cell3 = row1.createCell(2);
                cell3.setCellStyle(cellStyle);
                cell3.setCellValue("\u6db5\u6d1e\u7c7b\u578b");
                HSSFCell cell4 = row1.createCell(3);
                cell4.setCellStyle(cellStyle);
                cell4.setCellValue(culvert.getTypeValue());
                HSSFCell cell5 = row1.createCell(4);
                cell5.setCellStyle(cellStyle);
                cell5.setCellValue("\u517b\u62a4\u5355\u4f4d");
                HSSFCell cell6 = row1.createCell(5);
                cell6.setCellStyle(cellStyle);
                cell6.setCellValue(culvert.getOfficeName());
                HSSFRow row3 = sheet.createRow(2);
                HSSFCell cell13 = row3.createCell(0);
                cell13.setCellStyle(cellStyle);
                cell13.setCellValue("\u90e8\u4ef6\u7f16\u53f7");
                sheet.addMergedRegion(new CellRangeAddress(2, 2, 2, 3));
                sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 5));
                HSSFCell cell14 = row3.createCell(1);
                cell14.setCellStyle(cellStyle);
                cell14.setCellValue("\u7f3a\u635f\u7c7b\u578b");
                row3.createCell(2).setCellStyle(cellStyle);
                HSSFCell cell15 = row3.createCell(3);
                cell15.setCellStyle(cellStyle);
                cell15.setCellValue("\u7f3a\u635f\u8303\u56f4");
                HSSFCell cell16 = row3.createCell(4);
                cell16.setCellStyle(cellStyle);
                cell16.setCellValue("\u4fdd\u517b\u63aa\u65bd\u610f\u89c1");
                row3.createCell(5).setCellStyle(cellStyle);
                for (int i = 0; i < list.size(); ++i) {
                    HSSFRow row4 = sheet.createRow(3 + i);
                    CulvertOftenCheckDetail culvertOftenCheckDetail = (CulvertOftenCheckDetail)((Object)((Object)list.get(i)));
                    HSSFCell cell17 = row4.createCell(0);
                    cell17.setCellStyle(cellStyle);
                    cell17.setCellValue(culvertOftenCheckDetail.getCheckProject());
                    sheet.addMergedRegion(new CellRangeAddress(3 + i, 3 + i, 2, 3));
                    sheet.addMergedRegion(new CellRangeAddress(3 + i, 3 + i, 4, 5));
                    HSSFCell cell18 = row4.createCell(1);
                    cell18.setCellStyle(cellStyle);
                    cell18.setCellValue(culvertOftenCheckDetail.getStatusDesc());
                    HSSFCell cell19 = row4.createCell(3);
                    cell19.setCellStyle(cellStyle);
                    cell19.setCellValue(culvertOftenCheckDetail.getResult());
                    HSSFCell cell20 = row4.createCell(4);
                    cell20.setCellStyle(cellStyle);
                    cell20.setCellValue(culvertOftenCheckDetail.getProcess());
                    row4.createCell(2).setCellStyle(cellStyle);
                    row4.createCell(5).setCellStyle(cellStyle);
                }
                HSSFRow row4 = sheet.createRow(3 + list.size());
                HSSFCell cell = row4.createCell(0);
                sheet.addMergedRegion(new CellRangeAddress(3 + list.size(), 3 + list.size(), 1, 5));
                cell.setCellStyle(cellStyle);
                cell.setCellValue("\u5907\u6ce8");
                HSSFCell cell7 = row4.createCell(1);
                cell7.setCellStyle(cellStyle);
                cell7.setCellValue(culvertOftenCheck.getRemarks());
                row4.createCell(2).setCellStyle(cellStyle);
                row4.createCell(3).setCellStyle(cellStyle);
                row4.createCell(4).setCellStyle(cellStyle);
                row4.createCell(5).setCellStyle(cellStyle);
                try {
                    FileOutputStream os = new FileOutputStream(file + "/" + culvert.getRoadSegmentName() + "-" + culvert.getNumber() + "-" + culvert.getDirectionValue() + "-" + System.currentTimeMillis() + ".xls");
                    workbook.write((OutputStream)os);
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                HSSFRow row = sheet.createRow(0);
                HSSFCell rowCell0 = row.createCell(0);
                rowCell0.setCellStyle(cellStyle);
                rowCell0.setCellValue("\u8def\u7ebf\u7f16\u53f7");
                HSSFCell rowCell = row.createCell(1);
                rowCell.setCellStyle(cellStyle);
                rowCell.setCellValue(road.getCode());
                HSSFCell rowCell1 = row.createCell(2);
                rowCell1.setCellStyle(cellStyle);
                rowCell1.setCellValue("\u8def\u7ebf\u540d\u79f0");
                HSSFCell rowCell2 = row.createCell(3);
                rowCell2.setCellStyle(cellStyle);
                rowCell2.setCellValue(road.getName());
                HSSFCell rowCell3 = row.createCell(4);
                rowCell3.setCellStyle(cellStyle);
                rowCell3.setCellValue("\u884c\u653f\u533a\u5212");
                HSSFCell rowCell4 = row.createCell(5);
                rowCell4.setCellStyle(cellStyle);
                HSSFRow row1 = sheet.createRow(1);
                HSSFCell cell1 = row1.createCell(0);
                cell1.setCellStyle(cellStyle);
                cell1.setCellValue("\u4e2d\u5fc3\u6869\u53f7");
                HSSFCell cell2 = row1.createCell(1);
                cell2.setCellStyle(cellStyle);
                cell2.setCellValue(culvert.getCentPeg());
                HSSFCell cell3 = row1.createCell(2);
                cell3.setCellStyle(cellStyle);
                cell3.setCellValue("\u6db5\u6d1e\u7c7b\u578b");
                HSSFCell cell4 = row1.createCell(3);
                cell4.setCellStyle(cellStyle);
                cell4.setCellValue(culvert.getTypeValue());
                HSSFCell cell5 = row1.createCell(4);
                cell5.setCellStyle(cellStyle);
                cell5.setCellValue("\u517b\u62a4\u5355\u4f4d");
                HSSFCell cell6 = row1.createCell(5);
                cell6.setCellStyle(cellStyle);
                cell6.setCellValue(culvert.getOfficeName());
                HSSFRow row3 = sheet.createRow(2);
                HSSFCell cell13 = row3.createCell(0);
                cell13.setCellStyle(cellStyle);
                cell13.setCellValue("\u90e8\u4ef6\u7f16\u53f7");
                sheet.addMergedRegion(new CellRangeAddress(2, 2, 2, 3));
                sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 5));
                HSSFCell cell14 = row3.createCell(1);
                cell14.setCellStyle(cellStyle);
                cell14.setCellValue("\u7f3a\u635f\u7c7b\u578b");
                row3.createCell(2).setCellStyle(cellStyle);
                HSSFCell cell15 = row3.createCell(3);
                cell15.setCellStyle(cellStyle);
                cell15.setCellValue("\u7f3a\u635f\u8303\u56f4");
                HSSFCell cell16 = row3.createCell(4);
                cell16.setCellStyle(cellStyle);
                cell16.setCellValue("\u4fdd\u517b\u63aa\u65bd\u610f\u89c1");
                row3.createCell(5).setCellStyle(cellStyle);
                List list = (List)hdjcjcmx.get("hdjcjcmx");
                for (int i = 0; i < list.size(); ++i) {
                    HSSFRow row4 = sheet.createRow(3 + i);
                    Map map = (Map)list.get(i);
                    SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                    HSSFCell cell17 = row4.createCell(0);
                    cell17.setCellStyle(cellStyle);
                    cell17.setCellValue(detail.getName());
                    sheet.addMergedRegion(new CellRangeAddress(3 + i, 3 + i, 2, 3));
                    sheet.addMergedRegion(new CellRangeAddress(3 + i, 3 + i, 4, 5));
                    HSSFCell cell18 = row4.createCell(1);
                    cell18.setCellStyle(cellStyle);
                    HSSFCell cell19 = row4.createCell(3);
                    cell19.setCellStyle(cellStyle);
                    HSSFCell cell20 = row4.createCell(4);
                    cell20.setCellStyle(cellStyle);
                    row4.createCell(2).setCellStyle(cellStyle);
                    row4.createCell(5).setCellStyle(cellStyle);
                }
                HSSFRow row4 = sheet.createRow(3 + list.size());
                HSSFCell cell = row4.createCell(0);
                sheet.addMergedRegion(new CellRangeAddress(3 + list.size(), 3 + list.size(), 1, 5));
                cell.setCellStyle(cellStyle);
                cell.setCellValue("\u5907\u6ce8");
                row4.createCell(1).setCellStyle(cellStyle);
                row4.createCell(2).setCellStyle(cellStyle);
                row4.createCell(3).setCellStyle(cellStyle);
                row4.createCell(4).setCellStyle(cellStyle);
                row4.createCell(5).setCellStyle(cellStyle);
                try {
                    FileOutputStream os = new FileOutputStream(file + "/" + culvert.getRoadSegmentName() + "-" + culvert.getNumber() + "-" + culvert.getDirectionValue() + "-" + System.currentTimeMillis() + ".xls");
                    workbook.write((OutputStream)os);
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void exportSideSlopeOften(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            Map bpjcjcmx = this.sysDictionaryManager.queryDictItemsByCode("bpjcjcmx");
            Map fx = this.sysDictionaryManager.queryDictItemsByCode(FX);
            List<String> strings = Arrays.asList(ids.split(","));
            strings.forEach(s -> {
                SideSlopeInformation sideSlope = (SideSlopeInformation)((Object)((Object)this.sideSlopeInformationManager.getById((Serializable)((Object)s))));
                Road road = (Road)((Object)((Object)this.roadManager.getById((Serializable)((Object)sideSlope.getRoadSegmentId()))));
                QueryWrapper queryWrapper = new QueryWrapper();
                SideSlopeOftenCheck sideSlopeOftenCheck = (SideSlopeOftenCheck)((Object)((Object)this.sideSlopeOftenCheckManager.getBaseMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"SIDE_SLOPE_ID_", s)).orderByDesc((Object)"CHECK_DATE_")).orderByDesc((Object)"CREATE_TIME_")).last("limit 0,1"))));
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                this.setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                HSSFSheet sheet = workbook.createSheet("\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                sheet.getPrintSetup().setPaperSize((short)9);
                sheet.setColumnWidth(0, 5120);
                sheet.setColumnWidth(1, 2560);
                sheet.setColumnWidth(2, 2560);
                sheet.setColumnWidth(3, 3840);
                sheet.setColumnWidth(4, 2304);
                sheet.setColumnWidth(5, 5120);
                if (sideSlopeOftenCheck != null) {
                    this.exportSideSlopData(file, sideSlope, road, sideSlopeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet, fx);
                } else {
                    this.exportSideSlop(file, bpjcjcmx, sideSlope, road, workbook, cellStyle, cellStyleTitle, sheet, fx);
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    private void exportSideSlop(File file, Map<String, List<SysDictionaryDetail>> bpjcjcmx, SideSlopeInformation sideSlope, Road road, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet, Map<String, List<SysDictionaryDetail>> fx) {
        List<SysDictionaryDetail> details;
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue("\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5");
        cell0.setCellStyle(cellStyleTitle);
        this.setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u7ba1\u7406\u5355\u4f4d");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 5));
        HSSFCell cell1 = row.createCell(1);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(this.getCompany(sideSlope.getOfficeName()));
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(3).setCellStyle(cellStyle);
        row.createCell(4).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell2 = row1.createCell(0);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue("\u8def\u7ebf\u7f16\u7801");
        HSSFCell cell3 = row1.createCell(1);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getCode());
        HSSFCell cell4 = row1.createCell(2);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue("\u8def\u7ebf\u540d\u79f0");
        HSSFCell cell5 = row1.createCell(3);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue(road.getName());
        HSSFCell cell6 = row1.createCell(4);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue("\u6869\u53f7");
        HSSFCell cell7 = row1.createCell(5);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue(sideSlope.getStartPeg() + "-" + sideSlope.getEndPeg());
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell8 = row2.createCell(0);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue("\u8def\u7ebf\u65b9\u5411");
        HSSFCell cell9 = row2.createCell(1);
        cell9.setCellStyle(cellStyle);
        if (null != fx && null != (details = fx.get(FX))) {
            for (int i = 0; i < details.size(); ++i) {
                Map map = (Map)details.get(i);
                SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                if (null == detail.getValue() || !detail.getValue().equals(sideSlope.getDirection())) continue;
                cell9.setCellValue(detail.getName());
            }
        }
        HSSFCell cell10 = row2.createCell(2);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue("\u9632\u62a4\u79cd\u7c7b");
        HSSFCell cell11 = row2.createCell(3);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue(sideSlope.getProtectMaterial());
        HSSFCell cell12 = row2.createCell(4);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue("\u8fb9\u5761\u9ad8\u5ea6\uff08m\uff09");
        HSSFCell cell13 = row2.createCell(5);
        cell13.setCellStyle(cellStyle);
        cell13.setCellValue((double)sideSlope.getHeight().floatValue());
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell14 = row3.createCell(0);
        cell14.setCellStyle(cellStyle);
        cell14.setCellValue("\u68c0\u67e5\u65e5\u671f");
        HSSFCell cell15 = row3.createCell(1);
        cell15.setCellStyle(cellStyle);
        HSSFCell cell16 = row3.createCell(2);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("\u5929\u6c14");
        HSSFCell cell17 = row3.createCell(3);
        cell17.setCellStyle(cellStyle);
        HSSFCell cell18 = row3.createCell(4);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
        HSSFCell cell19 = row3.createCell(5);
        cell19.setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(5);
        HSSFCell cell29 = row4.createCell(0);
        cell29.setCellStyle(cellStyle);
        cell29.setCellValue("\u5907\u6ce8");
        sheet.addMergedRegion(new CellRangeAddress(5, 5, 1, 5));
        HSSFCell cell20 = row4.createCell(1);
        cell20.setCellStyle(cellStyle);
        row4.createCell(2).setCellStyle(cellStyle);
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(4).setCellStyle(cellStyle);
        row4.createCell(5).setCellStyle(cellStyle);
        HSSFRow row5 = sheet.createRow(6);
        sheet.addMergedRegion(new CellRangeAddress(6, 6, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(6, 6, 3, 4));
        HSSFCell cell21 = row5.createCell(0);
        cell21.setCellStyle(cellStyle);
        cell21.setCellValue("\u68c0\u67e5\u9879\u76ee");
        HSSFCell cell22 = row5.createCell(1);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("\u72b6\u6001\u63cf\u8ff0");
        HSSFCell cell23 = row5.createCell(3);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue("\u5224\u65ad\u7ed3\u8bba");
        HSSFCell cell24 = row5.createCell(5);
        cell24.setCellStyle(cellStyle);
        cell24.setCellValue("\u5904\u7406\u63aa\u65bd");
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(4).setCellStyle(cellStyle);
        row0.setHeight((short)640);
        row.setHeight((short)580);
        row1.setHeight((short)580);
        row2.setHeight((short)580);
        row3.setHeight((short)580);
        row4.setHeight((short)2500);
        row5.setHeight((short)580);
        List<SysDictionaryDetail> list = bpjcjcmx.get("bpjcjcmx");
        for (int i = 0; i < list.size(); ++i) {
            HSSFRow row6 = sheet.createRow(7 + i);
            Map map = (Map)list.get(i);
            SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
            HSSFCell cell25 = row6.createCell(0);
            cell25.setCellStyle(cellStyle);
            cell25.setCellValue(detail.getName());
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 1, 2));
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 3, 4));
            HSSFCell cell26 = row6.createCell(1);
            cell26.setCellStyle(cellStyle);
            HSSFCell cell27 = row6.createCell(3);
            cell27.setCellStyle(cellStyle);
            HSSFCell cell28 = row6.createCell(5);
            cell28.setCellStyle(cellStyle);
            row6.createCell(2).setCellStyle(cellStyle);
            row6.createCell(4).setCellStyle(cellStyle);
            row6.setHeight((short)1040);
        }
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 4, 5));
        HSSFRow row6 = sheet.createRow(7 + list.size());
        HSSFCell cell25 = row6.createCell(0);
        cell25.setCellStyle(cellStyle);
        cell25.setCellValue("\u68c0\u67e5\u4eba");
        HSSFCell cell26 = row6.createCell(1);
        cell26.setCellStyle(cellStyle);
        HSSFCell cell27 = row6.createCell(3);
        cell27.setCellStyle(cellStyle);
        cell27.setCellValue("\u8bb0\u5f55\u4eba");
        HSSFCell cell28 = row6.createCell(4);
        cell28.setCellStyle(cellStyle);
        row6.createCell(2).setCellStyle(cellStyle);
        row6.createCell(5).setCellStyle(cellStyle);
        row6.setHeight((short)440);
        try {
            FileOutputStream os = new FileOutputStream(file + "/\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5" + road.getName() + "-" + sideSlope.getStartPeg() + "-" + sideSlope.getDirectionValue() + "-" + System.currentTimeMillis() + ".xls");
            workbook.write((OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportSideSlopData(File file, SideSlopeInformation sideSlope, Road road, SideSlopeOftenCheck sideSlopeOftenCheck, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet, Map<String, List<SysDictionaryDetail>> fx) {
        List<SysDictionaryDetail> details;
        List list = this.sideSlopeOftenCheckDetailManager.list((Wrapper)new QueryWrapper().lambda().eq(SideSlopeOftenCheckDetail::getSideSlopeOftenCheckId, (Object)sideSlopeOftenCheck.getId()));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue("\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5");
        cell0.setCellStyle(cellStyleTitle);
        this.setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u7ba1\u7406\u5355\u4f4d");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 5));
        HSSFCell cell1 = row.createCell(1);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(this.getCompany(sideSlope.getOfficeName()));
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(3).setCellStyle(cellStyle);
        row.createCell(4).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell2 = row1.createCell(0);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue("\u8def\u7ebf\u7f16\u7801");
        HSSFCell cell3 = row1.createCell(1);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getCode());
        HSSFCell cell4 = row1.createCell(2);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue("\u8def\u7ebf\u540d\u79f0");
        HSSFCell cell5 = row1.createCell(3);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue(road.getName());
        HSSFCell cell6 = row1.createCell(4);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue("\u6869\u53f7");
        HSSFCell cell7 = row1.createCell(5);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue(sideSlope.getStartPeg() + "-" + sideSlope.getEndPeg());
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell8 = row2.createCell(0);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue("\u8def\u7ebf\u65b9\u5411");
        HSSFCell cell9 = row2.createCell(1);
        cell9.setCellStyle(cellStyle);
        if (null != fx && null != (details = fx.get(FX))) {
            for (int i = 0; i < details.size(); ++i) {
                Map map = (Map)details.get(i);
                SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                if (null == detail.getValue() || !detail.getValue().equals(sideSlope.getDirection())) continue;
                cell9.setCellValue(detail.getName());
            }
        }
        HSSFCell cell10 = row2.createCell(2);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue("\u9632\u62a4\u79cd\u7c7b");
        HSSFCell cell11 = row2.createCell(3);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue(sideSlope.getProtectMaterial());
        HSSFCell cell12 = row2.createCell(4);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue("\u8fb9\u5761\u9ad8\u5ea6\uff08m\uff09");
        HSSFCell cell13 = row2.createCell(5);
        cell13.setCellStyle(cellStyle);
        if (ObjectUtils.isNotEmpty((Object)sideSlope.getHeight())) {
            cell13.setCellValue((double)sideSlope.getHeight().floatValue());
        }
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell14 = row3.createCell(0);
        cell14.setCellStyle(cellStyle);
        cell14.setCellValue("\u68c0\u67e5\u65e5\u671f");
        HSSFCell cell15 = row3.createCell(1);
        cell15.setCellStyle(cellStyle);
        Date checkDate = sideSlopeOftenCheck.getCheckDate();
        String dateStr = new SimpleDateFormat("yyyy/MM/dd").format(checkDate);
        cell15.setCellValue(dateStr);
        HSSFCell cell16 = row3.createCell(2);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("\u5929\u6c14");
        HSSFCell cell17 = row3.createCell(3);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue(sideSlopeOftenCheck.getWeatherValue());
        HSSFCell cell18 = row3.createCell(4);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
        HSSFCell cell19 = row3.createCell(5);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue(sideSlopeOftenCheck.getEvaluateValue());
        HSSFRow row4 = sheet.createRow(5);
        HSSFCell cell29 = row4.createCell(0);
        cell29.setCellStyle(cellStyle);
        cell29.setCellValue("\u5907\u6ce8");
        sheet.addMergedRegion(new CellRangeAddress(5, 5, 1, 5));
        HSSFCell cell20 = row4.createCell(1);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue(sideSlopeOftenCheck.getRemarks());
        row4.createCell(2).setCellStyle(cellStyle);
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(4).setCellStyle(cellStyle);
        row4.createCell(5).setCellStyle(cellStyle);
        HSSFRow row5 = sheet.createRow(6);
        sheet.addMergedRegion(new CellRangeAddress(6, 6, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(6, 6, 3, 4));
        HSSFCell cell21 = row5.createCell(0);
        cell21.setCellStyle(cellStyle);
        cell21.setCellValue("\u68c0\u67e5\u9879\u76ee");
        HSSFCell cell22 = row5.createCell(1);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("\u72b6\u6001\u63cf\u8ff0");
        HSSFCell cell23 = row5.createCell(3);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue("\u5224\u65ad\u7ed3\u8bba");
        HSSFCell cell24 = row5.createCell(5);
        cell24.setCellStyle(cellStyle);
        cell24.setCellValue("\u5904\u7406\u63aa\u65bd");
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(4).setCellStyle(cellStyle);
        row0.setHeight((short)640);
        row.setHeight((short)580);
        row1.setHeight((short)580);
        row2.setHeight((short)580);
        row3.setHeight((short)580);
        row4.setHeight((short)2500);
        row5.setHeight((short)580);
        for (int i = 0; i < list.size(); ++i) {
            HSSFRow row6 = sheet.createRow(7 + i);
            SideSlopeOftenCheckDetail sideSlopeOftenCheckDetail = (SideSlopeOftenCheckDetail)((Object)list.get(i));
            HSSFCell cell25 = row6.createCell(0);
            cell25.setCellStyle(cellStyle);
            cell25.setCellValue(sideSlopeOftenCheckDetail.getCheckProject());
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 1, 2));
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 3, 4));
            HSSFCell cell26 = row6.createCell(1);
            cell26.setCellStyle(cellStyle);
            cell26.setCellValue(sideSlopeOftenCheckDetail.getStatusDesc());
            HSSFCell cell27 = row6.createCell(3);
            cell27.setCellValue(sideSlopeOftenCheckDetail.getResult());
            cell27.setCellStyle(cellStyle);
            HSSFCell cell28 = row6.createCell(5);
            cell28.setCellStyle(cellStyle);
            cell28.setCellValue(sideSlopeOftenCheckDetail.getProcess());
            row6.createCell(2).setCellStyle(cellStyle);
            row6.createCell(4).setCellStyle(cellStyle);
            row6.setHeight((short)1040);
        }
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 4, 5));
        HSSFRow row6 = sheet.createRow(7 + list.size());
        HSSFCell cell25 = row6.createCell(0);
        cell25.setCellStyle(cellStyle);
        cell25.setCellValue("\u68c0\u67e5\u4eba");
        HSSFCell cell26 = row6.createCell(1);
        cell26.setCellStyle(cellStyle);
        cell26.setCellValue(sideSlopeOftenCheck.getRummager());
        HSSFCell cell27 = row6.createCell(3);
        cell27.setCellStyle(cellStyle);
        cell27.setCellValue("\u8bb0\u5f55\u4eba");
        HSSFCell cell28 = row6.createCell(4);
        cell28.setCellStyle(cellStyle);
        cell28.setCellValue(sideSlopeOftenCheck.getNoteTaker());
        row6.createCell(2).setCellStyle(cellStyle);
        row6.createCell(5).setCellStyle(cellStyle);
        row6.setHeight((short)440);
        try {
            String direction = sideSlope.getDirection();
            String directionValue = "";
            if (direction.equals("1")) {
                directionValue = "\u4e0a\u884c\u65b9\u5411";
            }
            if (direction.equals("2")) {
                directionValue = "\u4e0b\u884c\u65b9\u5411";
            }
            FileOutputStream os = new FileOutputStream(file + "/\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5" + road.getName() + "-" + sideSlope.getStartPeg() + "-" + directionValue + "-" + new SimpleDateFormat("yyyy-MM-dd").format(checkDate) + "-" + sideSlope.getId() + ".xls");
            workbook.write((OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportBridgeOftenHistory(String id, String ids, Date timeGrateThan, Date timeLessThan, HttpServletResponse response) {
        List bridgeOftenChecks;
        long time = System.currentTimeMillis();
        String fileName = " \u6865\u6881\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868" + time;
        File file = new File(fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new RuntimeException("\u6865\u6881id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        List<String> bridgeIds = Arrays.asList(id.split(","));
        queryWrapper.in((Object)"BRIGE_ID_", bridgeIds);
        if (null != ids && !ids.equals("")) {
            List<String> strings = Arrays.asList(ids.split(","));
            queryWrapper.in((Object)"ID_", strings);
        }
        if (null != timeGrateThan && null != timeLessThan) {
            queryWrapper.between((Object)"CHECK_DATE_", (Object)timeGrateThan, (Object)timeLessThan);
        }
        if (null == (bridgeOftenChecks = this.bridgeOftenCheckManager.list((Wrapper)queryWrapper)) || bridgeOftenChecks.size() == 0) {
            throw new RuntimeException("\u8be5\u6865\u6881\u6682\u65e0\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55");
        }
        try {
            Map qljcmxb = this.sysDictionaryManager.queryDictItemsByCode("qljcmxb");
            Map qljcmxblsq = this.sysDictionaryManager.queryDictItemsByCode("qljcmxblsq");
            bridgeOftenChecks.forEach(bridgeOftenCheck -> {
                BridgeInformation bridge = this.bridgeInformationManager.getBridgeById(bridgeOftenCheck.getBrigeId());
                Road road = (Road)((Object)((Object)this.roadManager.getById((Serializable)((Object)bridge.getRoadSegmentId()))));
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                this.setExcelStyle(cellStyle, workbook);
                HSSFSheet sheet = workbook.createSheet("\u6865\u6881\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                sheet.getPrintSetup().setPaperSize((short)9);
                if (bridgeOftenCheck != null) {
                    if (bridge.getBriShape() == null || bridge.getBriShape() == 1) {
                        this.exportBeamBridgeData(file, bridge, road, (BridgeOftenCheck)((Object)bridgeOftenCheck), workbook, cellStyle, cellStyleTitle, sheet);
                    }
                    if (bridge.getBriShape() != null && bridge.getBriShape() == 10) {
                        this.exportBriCableStayedData(file, bridge, road, (BridgeOftenCheck)((Object)bridgeOftenCheck), workbook, cellStyle, cellStyleTitle, sheet);
                    }
                } else {
                    if (bridge.getBriShape() == null || bridge.getBriShape() == 1) {
                        this.exportBeamBridge(file, qljcmxblsq, bridge, road, workbook, cellStyle, cellStyleTitle, sheet);
                    }
                    if (bridge.getBriShape() != null && bridge.getBriShape() == 10) {
                        this.exportBriCableStayed(file, qljcmxb, bridge, road, workbook, cellStyle, cellStyleTitle, sheet);
                    }
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    @Override
    public void exportTunnelOftenHistory(String id, String ids, Date timeGrateThan, Date timeLessThan, HttpServletResponse response) {
        try {
            List list;
            long time = System.currentTimeMillis();
            String fileName = "\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new RuntimeException("\u96a7\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Map qljcmxb = this.sysDictionaryManager.queryDictItemsByCode("sdsdjcjc");
            QueryWrapper queryWrapper = new QueryWrapper();
            List<String> tunnelIds = Arrays.asList(id.split(","));
            queryWrapper.in((Object)"TUNNEL_ID_", tunnelIds);
            if (null != ids && !ids.equals("")) {
                List<String> strings = Arrays.asList(ids.split(","));
                queryWrapper.in((Object)"ID_", strings);
            }
            if (null != timeGrateThan && null != timeLessThan) {
                queryWrapper.between((Object)"CHECK_DATE_", (Object)timeGrateThan, (Object)timeLessThan);
            }
            if (null == (list = this.tunnelOftenCheckManager.list((Wrapper)queryWrapper)) || list.size() == 0) {
                throw new RuntimeException("\u8be5\u96a7\u9053\u6682\u65e0\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55");
            }
            list.forEach(tunnelOftenCheck -> {
                TunnelInformation tunnel = this.tunnelInformationManager.getTunnelById(tunnelOftenCheck.getTunnelId());
                Road road = (Road)((Object)((Object)this.roadManager.getById((Serializable)((Object)tunnel.getRoadSegmentId()))));
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                this.setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                HSSFSheet sheet = workbook.createSheet("\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                sheet.getPrintSetup().setPaperSize((short)9);
                sheet.setColumnWidth(0, 2560);
                sheet.setColumnWidth(1, 2560);
                sheet.setColumnWidth(2, 7680);
                sheet.setColumnWidth(3, 2048);
                sheet.setColumnWidth(4, 1536);
                sheet.setColumnWidth(5, 1280);
                sheet.setColumnWidth(6, 1280);
                sheet.setColumnWidth(7, 1280);
                if (tunnelOftenCheck != null) {
                    this.exportTunnelData(tunnel, road, (TunnelOftenCheck)((Object)tunnelOftenCheck), workbook, cellStyle, cellStyleTitle, sheet);
                    try {
                        FileOutputStream os = new FileOutputStream(file + "/" + tunnel.getName() + "-" + tunnel.getNumber() + "-" + tunnel.getDirectionValue() + "-" + new SimpleDateFormat("yyyy-MM-dd").format(tunnelOftenCheck.getCheckDate()) + ".xls");
                        workbook.write((OutputStream)os);
                        os.flush();
                        ((OutputStream)os).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
                    }
                }
                this.exportTunnel(qljcmxb, tunnel, road, workbook, cellStyle, cellStyleTitle, sheet);
                try {
                    FileOutputStream os = new FileOutputStream(file + "/" + tunnel.getName() + "-" + tunnel.getNumber() + "-" + tunnel.getDirectionValue() + System.currentTimeMillis() + ".xls");
                    workbook.write((OutputStream)os);
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    @Override
    public void exportCulvertOftenHistory(String id, String ids, Date timeGrateThan, Date timeLessThan, HttpServletResponse response) {
        try {
            List culvertOftenCheckList;
            long time = System.currentTimeMillis();
            String fileName = "\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new RuntimeException("\u6db5\u6d1eid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Map hdjcjcmx = this.sysDictionaryManager.queryDictItemsByCode("hdjcjcmx");
            QueryWrapper queryWrapper = new QueryWrapper();
            List<String> culvertIds = Arrays.asList(id.split(","));
            queryWrapper.in((Object)"CULVERT_ID_", culvertIds);
            if (null != ids && !ids.equals("")) {
                List<String> strings = Arrays.asList(ids.split(","));
                queryWrapper.in((Object)"ID_", strings);
            }
            if (null != timeGrateThan && null != timeLessThan) {
                queryWrapper.between((Object)"CHECK_DATE_", (Object)timeGrateThan, (Object)timeLessThan);
            }
            if (null == (culvertOftenCheckList = this.culvertOftenCheckManager.list((Wrapper)queryWrapper)) || culvertOftenCheckList.size() == 0) {
                throw new RuntimeException("\u8be5\u6db5\u6d1e\u6682\u65e0\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55");
            }
            Map<String, CulvertOftenCheck> checkMap = StreamUtil.toMap(culvertOftenCheckList, CulvertOftenCheck::getId);
            Map<String, List<CulvertOftenCheck>> detailMap = culvertOftenCheckList.stream().collect(Collectors.groupingBy(CulvertOftenCheck::getCulvertId));
            for (Map.Entry<String, List<CulvertOftenCheck>> entry : detailMap.entrySet()) {
                List<CulvertOftenCheck> checks = entry.getValue();
                List stringIds = checks.stream().sorted(Comparator.comparing(CulvertOftenCheck::getCulvertId)).map(CulvertOftenCheck::getId).collect(Collectors.toList());
                List collect = IntStream.range(0, (stringIds.size() + 3 - 1) / 3).map(pageNum -> pageNum * 3).parallel().mapToObj(i -> stringIds.stream().skip(i).limit(3L).collect(Collectors.toList())).collect(Collectors.toList());
                for (List stringList : collect) {
                    HSSFWorkbook workbook = new HSSFWorkbook();
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    this.setExcelStyle(cellStyle, workbook);
                    HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                    this.setExcelStyle(cellStyle, workbook);
                    HSSFSheet sheet = workbook.createSheet("\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                    sheet.getPrintSetup().setPaperSize((short)9);
                    sheet.setColumnWidth(0, 2560);
                    sheet.setColumnWidth(1, 2560);
                    sheet.setColumnWidth(2, 2560);
                    sheet.setColumnWidth(3, 2048);
                    sheet.setColumnWidth(4, 1536);
                    sheet.setColumnWidth(5, 1024);
                    sheet.setColumnWidth(6, 2048);
                    sheet.setColumnWidth(7, 2048);
                    sheet.setColumnWidth(8, 2048);
                    sheet.setColumnWidth(9, 2048);
                    int rowIndex = 0;
                    String numberCode = "\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868";
                    String dateStr = "";
                    for (String s : stringList) {
                        CulvertOftenCheck culvertOftenCheck = checkMap.get(s);
                        if (culvertOftenCheck != null) {
                            BizCulvertInformation culvert = (BizCulvertInformation)((Object)this.culvertInformationManager.getById((Serializable)((Object)culvertOftenCheck.getCulvertId())));
                            Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)culvert.getRoadSegmentId())));
                            List list = this.culvertOftenCheckDetailManager.list((Wrapper)new QueryWrapper().lambda().eq(CulvertOftenCheckDetail::getCulvertOftenCheckId, (Object)culvertOftenCheck.getId()));
                            HSSFRow row0 = sheet.createRow(rowIndex);
                            HSSFCell cell24 = row0.createCell(0);
                            cell24.setCellValue("\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                            cell24.setCellStyle(cellStyleTitle);
                            this.setExcelStyleTitle(cellStyleTitle, workbook);
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, 9));
                            HSSFRow row1 = sheet.createRow(++rowIndex);
                            HSSFCell cell = row1.createCell(0);
                            cell.setCellStyle(cellStyle);
                            cell.setCellValue("\u8def\u7ebf\u540d\u79f0:");
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 1, 4));
                            HSSFCell cell1 = row1.createCell(1);
                            cell1.setCellStyle(cellStyle);
                            cell1.setCellValue(road.getName());
                            HSSFCell cell2 = row1.createCell(6);
                            cell2.setCellStyle(cellStyle);
                            cell2.setCellValue("\u8def\u7ebf\u7f16\u7801:");
                            HSSFCell cell3 = row1.createCell(7);
                            row1.createCell(2).setCellStyle(cellStyle);
                            row1.createCell(3).setCellStyle(cellStyle);
                            row1.createCell(4).setCellStyle(cellStyle);
                            row1.createCell(5).setCellStyle(cellStyle);
                            row1.createCell(8).setCellStyle(cellStyle);
                            row1.createCell(9).setCellStyle(cellStyle);
                            cell3.setCellStyle(cellStyle);
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 7, 9));
                            cell3.setCellValue(road.getCode());
                            HSSFRow row2 = sheet.createRow(++rowIndex);
                            HSSFCell cell4 = row2.createCell(0);
                            cell4.setCellStyle(cellStyle);
                            cell4.setCellValue("\u6db5\u6d1e\u6869\u53f7");
                            HSSFCell cell5 = row2.createCell(1);
                            cell5.setCellStyle(cellStyle);
                            cell5.setCellValue("\u6db5\u6d1e\u7c7b\u578b");
                            HSSFCell cell6 = row2.createCell(2);
                            cell6.setCellStyle(cellStyle);
                            cell6.setCellValue("\u68c0\u67e5\u65e5\u671f");
                            HSSFCell cell7 = row2.createCell(3);
                            cell7.setCellStyle(cellStyle);
                            cell7.setCellValue("\u68c0\u67e5\u4eba");
                            HSSFCell cell8 = row2.createCell(4);
                            cell8.setCellStyle(cellStyle);
                            cell8.setCellValue("\u8bb0\u5f55\u4eba");
                            HSSFCell cell9 = row2.createCell(5);
                            cell9.setCellStyle(cellStyle);
                            cell9.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
                            HSSFCell cell10 = row2.createCell(6);
                            cell10.setCellStyle(cellStyle);
                            cell10.setCellValue("\u68c0\u67e5\u5185\u5bb9");
                            HSSFCell cell11 = row2.createCell(7);
                            cell11.setCellStyle(cellStyle);
                            cell11.setCellValue("\u72b6\u6001\u63cf\u8ff0");
                            HSSFCell cell12 = row2.createCell(8);
                            cell12.setCellStyle(cellStyle);
                            cell12.setCellValue("\u5224\u65ad\u7ed3\u8bba");
                            HSSFCell cell13 = row2.createCell(9);
                            cell13.setCellStyle(cellStyle);
                            cell13.setCellValue("\u5904\u7406\u63aa\u65bd");
                            row0.setHeight((short)500);
                            row1.setHeight((short)400);
                            row2.setHeight((short)400);
                            Integer rowIndexFor = rowIndex + 1;
                            if (list.size() > 0) {
                                for (int i2 = 0; i2 < list.size(); ++i2) {
                                    HSSFRow row4 = sheet.createRow(rowIndexFor + i2);
                                    CulvertOftenCheckDetail culvertOftenCheckDetail = (CulvertOftenCheckDetail)((Object)list.get(i2));
                                    HSSFCell cell14 = row4.createCell(6);
                                    cell14.setCellStyle(cellStyle);
                                    cell14.setCellValue(culvertOftenCheckDetail.getCheckProject());
                                    HSSFCell cell15 = row4.createCell(7);
                                    cell15.setCellStyle(cellStyle);
                                    cell15.setCellValue(culvertOftenCheckDetail.getStatusDesc());
                                    HSSFCell cell16 = row4.createCell(8);
                                    cell16.setCellStyle(cellStyle);
                                    cell16.setCellValue(culvertOftenCheckDetail.getResult());
                                    HSSFCell cell17 = row4.createCell(9);
                                    cell17.setCellStyle(cellStyle);
                                    cell17.setCellValue(culvertOftenCheckDetail.getProcess());
                                    row4.setHeight((short)300);
                                    if (i2 == 0) {
                                        ++rowIndex;
                                        HSSFCell cell18 = row4.createCell(0);
                                        cell18.setCellValue(culvert.getCentPeg());
                                        cell18.setCellStyle(cellStyle);
                                        HSSFCell cell19 = row4.createCell(1);
                                        cell19.setCellValue(culvert.getTypeValue());
                                        cell19.setCellStyle(cellStyle);
                                        HSSFCell cell20 = row4.createCell(2);
                                        cell20.setCellValue(new SimpleDateFormat("yyyy/MM/dd").format(culvertOftenCheck.getCheckDate()));
                                        cell20.setCellStyle(cellStyle);
                                        HSSFCell cell21 = row4.createCell(3);
                                        cell21.setCellValue(culvertOftenCheck.getRummager());
                                        cell21.setCellStyle(cellStyle);
                                        HSSFCell cell22 = row4.createCell(4);
                                        cell22.setCellValue(culvertOftenCheck.getNoteTaker());
                                        cell22.setCellStyle(cellStyle);
                                        HSSFCell cell23 = row4.createCell(5);
                                        cell23.setCellValue(culvertOftenCheck.getEvaluateValue());
                                        cell23.setCellStyle(cellStyle);
                                        continue;
                                    }
                                    row4.createCell(0).setCellStyle(cellStyle);
                                    row4.createCell(1).setCellStyle(cellStyle);
                                    row4.createCell(2).setCellStyle(cellStyle);
                                    row4.createCell(3).setCellStyle(cellStyle);
                                    row4.createCell(4).setCellStyle(cellStyle);
                                    row4.createCell(5).setCellStyle(cellStyle);
                                    ++rowIndex;
                                }
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 0, 0));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 1, 1));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 2, 2));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 3, 3));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 4, 4));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 5, 5));
                                ++rowIndex;
                            } else {
                                List listDict = (List)hdjcjcmx.get("hdjcjcmx");
                                for (int i3 = 0; i3 < listDict.size(); ++i3) {
                                    HSSFRow row4 = sheet.createRow(rowIndexFor + i3);
                                    Map map = (Map)listDict.get(i3);
                                    SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                                    HSSFCell cell14 = row4.createCell(6);
                                    cell14.setCellStyle(cellStyle);
                                    cell14.setCellValue(detail.getName());
                                    HSSFCell cell15 = row4.createCell(7);
                                    cell15.setCellStyle(cellStyle);
                                    HSSFCell cell16 = row4.createCell(8);
                                    cell16.setCellStyle(cellStyle);
                                    row4.setHeight((short)300);
                                    HSSFCell cell17 = row4.createCell(9);
                                    cell17.setCellStyle(cellStyle);
                                    if (i3 == 0) {
                                        HSSFCell cell18 = row4.createCell(0);
                                        cell18.setCellValue(culvert.getCentPeg());
                                        cell18.setCellStyle(cellStyle);
                                        HSSFCell cell19 = row4.createCell(1);
                                        cell19.setCellValue(culvert.getTypeValue());
                                        cell19.setCellStyle(cellStyle);
                                        HSSFCell cell20 = row4.createCell(2);
                                        cell20.setCellStyle(cellStyle);
                                        HSSFCell cell21 = row4.createCell(3);
                                        cell21.setCellStyle(cellStyle);
                                        HSSFCell cell22 = row4.createCell(4);
                                        cell22.setCellStyle(cellStyle);
                                        HSSFCell cell23 = row4.createCell(5);
                                        cell23.setCellStyle(cellStyle);
                                    } else {
                                        row4.createCell(0).setCellStyle(cellStyle);
                                        row4.createCell(1).setCellStyle(cellStyle);
                                        row4.createCell(2).setCellStyle(cellStyle);
                                        row4.createCell(3).setCellStyle(cellStyle);
                                        row4.createCell(4).setCellStyle(cellStyle);
                                        row4.createCell(5).setCellStyle(cellStyle);
                                    }
                                    ++rowIndex;
                                }
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 0, 0));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 1, 1));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 2, 2));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 3, 3));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 4, 4));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 5, 5));
                                ++rowIndex;
                            }
                            dateStr = new SimpleDateFormat("yyyy-MM-dd").format(culvertOftenCheck.getCheckDate());
                            numberCode = culvert.getCentPeg();
                            continue;
                        }
                        HSSFRow row0 = sheet.createRow(rowIndex);
                        HSSFCell cell24 = row0.createCell(0);
                        cell24.setCellValue("\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                        cell24.setCellStyle(cellStyleTitle);
                        this.setExcelStyleTitle(cellStyleTitle, workbook);
                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, 9));
                        HSSFRow row1 = sheet.createRow(++rowIndex);
                        HSSFCell cell = row1.createCell(0);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue("\u8def\u7ebf\u540d\u79f0:");
                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 1, 4));
                        HSSFCell cell1 = row1.createCell(1);
                        cell1.setCellStyle(cellStyle);
                        HSSFCell cell2 = row1.createCell(6);
                        cell2.setCellStyle(cellStyle);
                        cell2.setCellValue("\u8def\u7ebf\u7f16\u7801:");
                        HSSFCell cell3 = row1.createCell(7);
                        row1.createCell(2).setCellStyle(cellStyle);
                        row1.createCell(3).setCellStyle(cellStyle);
                        row1.createCell(4).setCellStyle(cellStyle);
                        row1.createCell(5).setCellStyle(cellStyle);
                        row1.createCell(8).setCellStyle(cellStyle);
                        row1.createCell(9).setCellStyle(cellStyle);
                        cell3.setCellStyle(cellStyle);
                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 7, 9));
                        HSSFRow row2 = sheet.createRow(++rowIndex);
                        HSSFCell cell4 = row2.createCell(0);
                        cell4.setCellStyle(cellStyle);
                        cell4.setCellValue("\u6db5\u6d1e\u6869\u53f7");
                        HSSFCell cell5 = row2.createCell(1);
                        cell5.setCellStyle(cellStyle);
                        cell5.setCellValue("\u6db5\u6d1e\u7c7b\u578b");
                        HSSFCell cell6 = row2.createCell(2);
                        cell6.setCellStyle(cellStyle);
                        cell6.setCellValue("\u68c0\u67e5\u65e5\u671f");
                        HSSFCell cell7 = row2.createCell(3);
                        cell7.setCellStyle(cellStyle);
                        cell7.setCellValue("\u68c0\u67e5\u4eba");
                        HSSFCell cell8 = row2.createCell(4);
                        cell8.setCellStyle(cellStyle);
                        cell8.setCellValue("\u8bb0\u5f55\u4eba");
                        HSSFCell cell9 = row2.createCell(5);
                        cell9.setCellStyle(cellStyle);
                        cell9.setCellValue("\u603b\u4f53\u8bc4\u4ef7");
                        HSSFCell cell10 = row2.createCell(6);
                        cell10.setCellStyle(cellStyle);
                        cell10.setCellValue("\u68c0\u67e5\u5185\u5bb9");
                        HSSFCell cell11 = row2.createCell(7);
                        cell11.setCellStyle(cellStyle);
                        cell11.setCellValue("\u72b6\u6001\u63cf\u8ff0");
                        HSSFCell cell12 = row2.createCell(8);
                        cell12.setCellStyle(cellStyle);
                        cell12.setCellValue("\u5224\u65ad\u7ed3\u8bba");
                        HSSFCell cell13 = row2.createCell(9);
                        cell13.setCellStyle(cellStyle);
                        cell13.setCellValue("\u5904\u7406\u63aa\u65bd");
                        row0.setHeight((short)500);
                        row1.setHeight((short)400);
                        row2.setHeight((short)400);
                        Integer rowIndexFor = rowIndex + 1;
                        List list = (List)hdjcjcmx.get("hdjcjcmx");
                        for (int i4 = 0; i4 < list.size(); ++i4) {
                            HSSFRow row4 = sheet.createRow(rowIndexFor + i4);
                            Map map = (Map)list.get(i4);
                            SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                            HSSFCell cell14 = row4.createCell(6);
                            cell14.setCellStyle(cellStyle);
                            cell14.setCellValue(detail.getName());
                            HSSFCell cell15 = row4.createCell(7);
                            cell15.setCellStyle(cellStyle);
                            HSSFCell cell16 = row4.createCell(8);
                            cell16.setCellStyle(cellStyle);
                            row4.setHeight((short)300);
                            HSSFCell cell17 = row4.createCell(9);
                            cell17.setCellStyle(cellStyle);
                            if (i4 == 0) {
                                HSSFCell cell18 = row4.createCell(0);
                                cell18.setCellStyle(cellStyle);
                                HSSFCell cell19 = row4.createCell(1);
                                cell19.setCellStyle(cellStyle);
                                HSSFCell cell20 = row4.createCell(2);
                                cell20.setCellStyle(cellStyle);
                                HSSFCell cell21 = row4.createCell(3);
                                cell21.setCellStyle(cellStyle);
                                HSSFCell cell22 = row4.createCell(4);
                                cell22.setCellStyle(cellStyle);
                                HSSFCell cell23 = row4.createCell(5);
                                cell23.setCellStyle(cellStyle);
                            } else {
                                row4.createCell(0).setCellStyle(cellStyle);
                                row4.createCell(1).setCellStyle(cellStyle);
                                row4.createCell(2).setCellStyle(cellStyle);
                                row4.createCell(3).setCellStyle(cellStyle);
                                row4.createCell(4).setCellStyle(cellStyle);
                                row4.createCell(5).setCellStyle(cellStyle);
                            }
                            ++rowIndex;
                        }
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 0, 0));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 1, 1));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 2, 2));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 3, 3));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 4, 4));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor.intValue(), rowIndex, 5, 5));
                        ++rowIndex;
                    }
                    try {
                        FileOutputStream os = new FileOutputStream(file + "/" + "\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868" + numberCode + "-" + dateStr + ".xls");
                        workbook.write((OutputStream)os);
                        os.flush();
                        ((OutputStream)os).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    @Override
    public void exportSideSlopeOftenHistory(String id, String ids, Date timeGrateThan, Date timeLessThan, HttpServletResponse response) {
        try {
            List SideSlopeOftenCheckList;
            long time = System.currentTimeMillis();
            String fileName = "\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            Map bpjcjcmx = this.sysDictionaryManager.queryDictItemsByCode("bpjcjcmx");
            Map fx = this.sysDictionaryManager.queryDictItemsByCode(FX);
            QueryWrapper queryWrapper = new QueryWrapper();
            List<String> sideIds = Arrays.asList(id.split(","));
            queryWrapper.in((Object)"SIDE_SLOPE_ID_", sideIds);
            if (null != ids && !ids.equals("")) {
                List<String> strings = Arrays.asList(id.split(","));
                queryWrapper.in((Object)"ID_", strings);
            }
            if (null != timeGrateThan && null != timeLessThan) {
                queryWrapper.between((Object)"CHECK_DATE_", (Object)timeGrateThan, (Object)timeLessThan);
            }
            if (null == (SideSlopeOftenCheckList = this.sideSlopeOftenCheckManager.list((Wrapper)queryWrapper)) || SideSlopeOftenCheckList.size() == 0) {
                throw new BaseException("\u8be5\u8fb9\u5761\u6682\u65e0\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55");
            }
            SideSlopeOftenCheckList.forEach(sideSlopeOftenCheck -> {
                SideSlopeInformation sideSlope = (SideSlopeInformation)((Object)((Object)this.sideSlopeInformationManager.getById((Serializable)((Object)sideSlopeOftenCheck.getSideSlopeId()))));
                Road road = (Road)((Object)((Object)this.roadManager.getById((Serializable)((Object)sideSlope.getRoadSegmentId()))));
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                this.setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                HSSFSheet sheet = workbook.createSheet("\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5\u8bb0\u5f55\u8868");
                sheet.getPrintSetup().setPaperSize((short)9);
                sheet.setColumnWidth(0, 5120);
                sheet.setColumnWidth(1, 2560);
                sheet.setColumnWidth(2, 2560);
                sheet.setColumnWidth(3, 3840);
                sheet.setColumnWidth(4, 2304);
                sheet.setColumnWidth(5, 5120);
                if (sideSlopeOftenCheck != null) {
                    this.exportSideSlopData(file, sideSlope, road, (SideSlopeOftenCheck)((Object)sideSlopeOftenCheck), workbook, cellStyle, cellStyleTitle, sheet, fx);
                } else {
                    this.exportSideSlop(file, bpjcjcmx, sideSlope, road, workbook, cellStyle, cellStyleTitle, sheet, fx);
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zip, (String)zip);
            FileUtil.deleteFile((String)zip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    private void setExcelStyle(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)8);
        cellStyle.setFont(font);
    }

    private void setExcelStyleTitle(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)18);
        cellStyle.setFont(font);
    }

    private void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            File file = new File(path);
            Assert.isTrue((boolean)file.exists(), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            ArrayList list = new ArrayList();
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir((File)file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getCompany(String officeName) {
        return officeName;
    }
}

