/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialcheck.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.poi.Excel;
import com.artfess.poi.editor.IFontEditor;
import com.artfess.poi.style.Align;
import com.artfess.poi.style.BorderStyle;
import com.artfess.poi.style.Color;
import com.artfess.poi.style.font.BoldWeight;
import com.artfess.poi.style.font.Font;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.yhxt.specialcheck.dao.BizMqiCheckDetailDao;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDetailManager;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckDetail;
import com.artfess.yhxt.specialcheck.vo.MqiCheckDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizMqiCheckDetailManagerImpl
extends BaseManagerImpl<BizMqiCheckDetailDao, BizMqiCheckDetail>
implements BizMqiCheckDetailManager {
    @Resource
    private SysDictionaryManager sysDictionaryManager;

    @Override
    public List<BizMqiCheckDetail> selectListByMqiDataId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MQI_DATA_ID_", (Object)id);
        return ((BizMqiCheckDetailDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public CommonResult<String> importData(String mqiId, MultipartFile file) {
        try {
            ArrayList bizMqiCheckDetailArrayList = new ArrayList();
            List mqiCheckDetailVos = ExcelUtil.readExcel(MqiCheckDetailVo.class, (MultipartFile)file);
            Map fx = this.sysDictionaryManager.queryDictItemsByCode("qlfx");
            Map pddj = this.sysDictionaryManager.queryDictItemsByCode("MQI-pddj");
            mqiCheckDetailVos.forEach(s -> {
                BizMqiCheckDetail bizMqiCheckDetail = s.getBizMqiCheckDetail((MqiCheckDetailVo)s);
                List fxDetails = (List)fx.get("qlfx");
                for (int i = 0; i < fxDetails.size(); ++i) {
                    Map map = (Map)fxDetails.get(i);
                    SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                    if (!detail.getName().equals(bizMqiCheckDetail.getDirectionValue())) continue;
                    bizMqiCheckDetail.setDirection(detail.getValue());
                }
                List pddjDetails = (List)pddj.get("MQI-pddj");
                for (int i = 0; i < pddjDetails.size(); ++i) {
                    Map map = (Map)pddjDetails.get(i);
                    SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                    if (!detail.getName().equals(bizMqiCheckDetail.getRatingValue())) continue;
                    bizMqiCheckDetail.setRating(Integer.parseInt(detail.getValue()));
                }
                bizMqiCheckDetailArrayList.add(bizMqiCheckDetail);
            });
            this.saveBatch(bizMqiCheckDetailArrayList);
            return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u5165\u5931\u8d25");
        }
    }

    @Override
    public CommonResult<List<BizMqiCheckDetail>> getimportData(MultipartFile file) {
        try {
            ArrayList bizMqiCheckDetailArrayList = new ArrayList();
            List mqiCheckDetailVos = ExcelUtil.readExcel(MqiCheckDetailVo.class, (MultipartFile)file);
            Map fx = this.sysDictionaryManager.queryDictItemsByCode("qlfx");
            Map pddj = this.sysDictionaryManager.queryDictItemsByCode("MQI-pddj");
            mqiCheckDetailVos.forEach(s -> {
                BizMqiCheckDetail bizMqiCheckDetail = s.getBizMqiCheckDetail((MqiCheckDetailVo)s);
                List fxDetails = (List)fx.get("qlfx");
                for (int i = 0; i < fxDetails.size(); ++i) {
                    Map map = (Map)fxDetails.get(i);
                    SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                    if (!detail.getName().equals(bizMqiCheckDetail.getDirectionValue())) continue;
                    bizMqiCheckDetail.setDirection(detail.getValue());
                }
                List pddjDetails = (List)pddj.get("MQI-pddj");
                for (int i = 0; i < pddjDetails.size(); ++i) {
                    Map map = (Map)pddjDetails.get(i);
                    SysDictionaryDetail detail = (SysDictionaryDetail)BeanUtil.toBean((Object)map, SysDictionaryDetail.class);
                    if (!detail.getName().equals(bizMqiCheckDetail.getRatingValue())) continue;
                    bizMqiCheckDetail.setRating(Integer.parseInt(detail.getValue()));
                }
                bizMqiCheckDetailArrayList.add(bizMqiCheckDetail);
            });
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", bizMqiCheckDetailArrayList);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public void exportMqiDetail(String id, HttpServletResponse response) {
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new RuntimeException("id \u4e0d\u80fd\u4e3a\u7a7a");
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)id), (Object)"MQI_DATA_ID_", (Object)id);
            List list = this.list((Wrapper)queryWrapper);
            LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
            exportMap.put("directionValue", "\u65b9\u5411");
            exportMap.put("startPeg", "\u8d77\u70b9\u6869\u53f7");
            exportMap.put("endPeg", "\u7ed3\u675f\u6869\u53f7");
            exportMap.put("length", "\u957f\u5ea6(m)");
            exportMap.put("mqiAvg", "MQI");
            exportMap.put("sciAvg", "\u8def\u57faSCI");
            exportMap.put("pqiAvg", "\u8def\u9762PQI");
            exportMap.put("pciAvg", "\u8def\u9762\u635f\u574fPCI");
            exportMap.put("rqiAvg", "\u884c\u9a76\u8d28\u91cfRQI");
            exportMap.put("rdiAvg", "\u8f66\u8f99\u6df1\u5ea6RDI");
            exportMap.put("pbiAvg", "\u8df3\u8f66PBI");
            exportMap.put("pwiAvg", "\u78e8\u8017PWI");
            exportMap.put("pssiAvg", "\u7ed3\u6784\u5f3a\u5ea6PSSI");
            exportMap.put("bciAvg", "\u6865\u96a7\u6784\u9020\u7269BCI");
            exportMap.put("tciAvg", "\u6cbf\u7ebf\u8bbe\u65bdTCI");
            exportMap.put("ratingValue", "\u8bc4\u5b9a\u7b49\u7ea7");
            List collect = list.stream().map(s -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("directionValue", s.getDirectionValue());
                map.put("startPeg", s.getStartPeg());
                map.put("endPeg", s.getEndPeg());
                map.put("length", s.getLength());
                map.put("mqiAvg", s.getMqiAvg());
                map.put("sciAvg", s.getSciAvg());
                map.put("pqiAvg", s.getPqiAvg());
                map.put("pciAvg", s.getPciAvg());
                map.put("rqiAvg", s.getRqiAvg());
                map.put("rdiAvg", s.getRdiAvg());
                map.put("pbiAvg", s.getPbiAvg());
                map.put("pwiAvg", s.getPwiAvg());
                map.put("pssiAvg", s.getPssiAvg());
                map.put("bciAvg", s.getBciAvg());
                map.put("tciAvg", s.getTciAvg());
                map.put("ratingValue", s.getRatingValue());
                return map;
            }).collect(Collectors.toList());
            HSSFWorkbook hssfWorkbook = this.exportExcel("MQI\u6570\u636e\u8be6\u60c5", 10, exportMap, collect, 0);
            ExcelUtil.downloadExcel((HSSFWorkbook)hssfWorkbook, (String)("MQI\u6570\u636e\u8be6\u60c5" + System.currentTimeMillis()), (HttpServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HSSFWorkbook exportExcel(String title, int rowHeight, Map<String, String> fieldMap, List data, int headerRowIndex) throws Exception {
        int size = fieldMap.size();
        Excel excel = new Excel();
        int titleCols = size;
        if (titleCols == 0) {
            throw new Exception("\u8bf7\u8bbe\u7f6e\u5217\uff01");
        }
        excel.sheet().sheetName(title);
        int i = 0;
        for (String name : fieldMap.values()) {
            excel.cell(headerRowIndex, i).value((Object)"").border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(10).warpText(true).align(Align.LEFT);
            excel.cell(headerRowIndex, i).value((Object)name).align(Align.CENTER).bgColor(Color.GREY_25_PERCENT).fontHeightInPoint(10).width(2560).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

                public void updateFont(Font font) {
                    font.boldweight(BoldWeight.BOLD);
                    font.color(Color.BLACK);
                }
            });
            ++i;
        }
        int rows = headerRowIndex + 1;
        for (Object obj : data) {
            Map rowObj = (Map)obj;
            int col = 0;
            for (String key : fieldMap.keySet()) {
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(rows, col).value((Object)val).border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(10).warpText(true).align(Align.CENTER);
                ++col;
            }
            ++rows;
        }
        return excel.getWorkBook();
    }
}

