export declare type KV<K extends string | number | symbol, V> = {
    [k in K]: V;
};
export declare const Anchors: readonly ["top-left", "top-center", "top-right", "middle-left", "center", "middle-right", "bottom-left", "bottom-center", "bottom-right"];
export declare type AnchorType = typeof Anchors[number];
export declare const LabelDirections: readonly ["top", "right", "bottom", "left", "center"];
export declare type LabelDirectionType = typeof LabelDirections[number];
export interface LabelOption {
    content: string;
    offset?: number[] | AMap.Pixel;
    direction?: LabelDirectionType;
}
export declare const LineJoins: readonly ["miter", "round", "bevel"];
export declare type LineJoinType = typeof LineJoins[number];
export declare const LineCaps: readonly ["butt", "round", "square"];
export declare type LineCapType = typeof LineCaps[number];
export declare const StrokeStyles: readonly ["solid", "dashed"];
export declare type StrokeStyleType = typeof StrokeStyles[number];
