/// <reference path="amap.d.ts" />

declare type Opt<T> = T | undefined | null;

declare type AMapGlobal = AMap.NameSpace;

declare type AMapControl = AMap.Control;

type AMapLayer =
  | AMap.BuildingLayer
  | AMap.CanvasLayer
  | AMap.CustomLayer
  | AMap.DistrictLayer
  | AMap.ImageLayer
  | AMap.LabelsLayer
  | AMap.NebulaLayer
  | AMap.TileLayer;

type AMapGeometry =
  | AMap.BezierCurve
  | AMap.Circle
  | AMap.Polygon
  | AMap.Polyline
  | AMap.Rectangle
  | AMap.Ellipse;

type AMapMarker =
  | AMap.Marker
  | AMap.Text
  | AMap.LabelMarker
  | AMap.CircleMarker;

declare type AMapComponent =
  | AMapControl
  | AMapLayer
  | AMapGeometry
  | AMapMarker
  | AMap.ContextMenu
  | AMap.InfoWindow;
//   | AMap.MassMarks;

declare type PathLike = number[][] | number[][][];
declare type PathLikeStrict = [number, number][] | [number, number][][];

declare type AMapEditor = AMapComponent & {
  open(): void;
  close(): void;
};
