/// <reference path="amap.d.ts" />
/// <reference path="global.d.ts" />
/// <reference path="utils.d.ts" />

import { Vue } from 'vue/types/vue';

declare interface ElementWithAMap extends Element {
  $amap?: AMap.Map;
}

declare type AMapTarget = AMap.Map | AMapComponent;

declare interface AMapContext<T extends AMapTarget> {
  AMap: AMapGlobal;
  target: T;
  ready: Promise<T>;
  vm: Vue;
  destroyed: boolean;
}

declare interface MapContext extends AMapContext<AMap.Map> {
  wrapper: Element;
}

declare interface ComponentContext<T extends AMapComponent = AMapComponent>
  extends AMapContext<T> {
  // map: MapContext;
}

declare interface AMapMeta<T extends AMapComponent = AMapComponent> {
  prepare?: () => Promise<any>;
  initComponent?: (this: Vue, AMap: AMapGlobal, defaults: any) => Promise<T>;
  events?: string[];
  slot?: boolean;
  add?: (this: Vue, container: MapContext, target: T) => void;
  remove?: (this: Vue, container: MapContext, target: T) => void;
}

declare interface AMapLogger {
  warn(...args: any[]): void;
  debug(...args: any[]): void;
}

declare module 'vue/types/options' {
  export interface ComponentOptions<V extends Vue> {
    amapMeta?: AMapMeta;
  }
}

declare module 'vue/types/vue' {
  export interface Vue {
    $amapMap: MapContext;
    $amap: {
      events: { [key: string]: Function[] };
      ready: Defer<AMapTarget>;
      context: AMapContext<AMapTarget>;
      logger: AMapLogger;
    };
  }
}

declare global {
  interface Window {
    readonly AMap: AMapGlobal;
  }
}
