package com.artfess.uc.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 8张报表关联的愉快政用户信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-06-30
 */
@TableName("BIZ_UC_USER")
@ApiModel(value="BizUcUser对象", description="8张报表关联的愉快政用户信息")
public class BizUcUser extends BaseModel<BizUcUser> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "本系统用户ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "愉快政用户名称")
    @TableField("ACCOUNT_NAME_")
    private String accountName;

    @ApiModelProperty(value = "愉快政用户ID")
    @TableField("ACCOUNT_ID_")
    private String accountId;

    @ApiModelProperty(value = "愉快政用户编码")
    @TableField("EMPLOYEE_CODE_")
    private String employeeCode;

    @ApiModelProperty(value = "8张报表权限（市级，区县）")
    @TableField("ACCOUNT_ROLE_")
    private String accountRole;

    @ApiModelProperty(value = "账号所属组织")
    @TableField("ACCOUNT_ORG_")
    private String accountOrg;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getAccountRole() {
        return accountRole;
    }

    public void setAccountRole(String accountRole) {
        this.accountRole = accountRole;
    }

    public String getAccountOrg() {
        return accountOrg;
    }

    public void setAccountOrg(String accountOrg) {
        this.accountOrg = accountOrg;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizUcUser{" +
            "id=" + id +
            ", userId=" + userId +
            ", accountName=" + accountName +
            ", accountId=" + accountId +
            ", employeeCode=" + employeeCode +
            ", accountRole=" + accountRole +
            ", accountOrg=" + accountOrg +
        "}";
    }
}
