package com.artfess.ljzc.stock.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.stock.dao.AssetStockInfoDao;
import com.artfess.ljzc.stock.manager.AssetStockInfoManager;
import com.artfess.ljzc.stock.manager.AssetStockStructureManager;
import com.artfess.ljzc.stock.model.AssetStockInfo;
import com.artfess.ljzc.stock.model.AssetStockStructure;
import com.artfess.ljzc.stock.vo.AssetStockInfoVo;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.apache.bcel.generic.NEW;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 股权资产信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-11-27
 */
@Service
public class AssetStockInfoManagerImpl extends BaseManagerImpl<AssetStockInfoDao, AssetStockInfo> implements AssetStockInfoManager {

    @Autowired
    private  AssetStockStructureManager  stockStructureManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String insertStockInfo(AssetStockInfoVo stockInfoVo) throws Exception {
        if(BeanUtils.isNotEmpty(stockInfoVo)){
            if(StringUtil.isEmpty(stockInfoVo.getAssetAudit())){
                stockInfoVo.setAssetAudit("0");
            }

            if(StringUtil.isEmpty(stockInfoVo.getBelongsOrgId())){
                stockInfoVo.setBelongsOrgId(ContextUtil.getCurrentOrgId());
                stockInfoVo.setBelongsOrgName(ContextUtil.getCurrentOrgName());
                stockInfoVo.setBelongsOrgFullId(ContextUtil.getCurrentOrgFullId());
            }
            this.baseMapper.insert(stockInfoVo);
            List<AssetStockStructure> list = stockInfoVo.getStructureList();
            if(!CollectionUtils.isEmpty(list)){
                list.forEach(s -> {
                    s.setStockId(stockInfoVo.getId());
                });
                stockStructureManager.saveBatch(list);
            }
            return stockInfoVo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateStockInfo(AssetStockInfoVo stockInfoVo) throws Exception {
        if(BeanUtils.isNotEmpty(stockInfoVo)){
            this.saveOrUpdate(stockInfoVo);
            List<AssetStockStructure> list = stockInfoVo.getStructureList();
            QueryWrapper<AssetStockStructure> delWrapper = new QueryWrapper<>();
            delWrapper.eq("stock_id_", stockInfoVo.getId());
            this.stockStructureManager.getBaseMapper().delete(delWrapper);
            if(!CollectionUtils.isEmpty(list)){
                list.forEach(s -> {
                    s.setStockId(stockInfoVo.getId());
                });
                stockStructureManager.saveOrUpdateBatch(list);
            }
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteStockInfo(String id) {
        Assert.hasText(id, "请选择要删除的资产！");
        boolean flag = this.removeById(id);
        if(flag){
            QueryWrapper<AssetStockStructure> delWrapper = new QueryWrapper<>();
            delWrapper.eq("stock_id_", id);
            this.stockStructureManager.getBaseMapper().delete(delWrapper);
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteBachStockInfo(List<String> ids) {
        Assert.noNullElements(ids, "请选择要删除的资产！");
        boolean flag = this.removeByIds(ids);
        if(flag){
            QueryWrapper<AssetStockStructure> delWrapper = new QueryWrapper<>();
            delWrapper.in("stock_id_", ids);
            this.stockStructureManager.getBaseMapper().delete(delWrapper);
        }
        return flag;
    }

    @Override
    public AssetStockInfoVo findStockInfoVo(String id) {
        Assert.hasText(id, "请选择要查询的资产！");
        AssetStockInfo assetStockInfo = this.getById(id);
        if(BeanUtils.isNotEmpty(assetStockInfo)){
            AssetStockInfoVo assetStockInfoVo =new AssetStockInfoVo();
            try {
                BeanUtils.copyNotNullProperties(assetStockInfoVo,assetStockInfo);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            QueryWrapper<AssetStockStructure> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("stock_id_", id);
            List<AssetStockStructure> list = stockStructureManager.list(queryWrapper);
            assetStockInfoVo.setStructureList(list);
            return assetStockInfoVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean auditStock(String status, String msg,List<String> idList) {
        Assert.hasText(status, "状态不能为空！");
        Assert.notNull(idList, "请选择要审核的资产");
        Integer result = null;
        UpdateWrapper<AssetStockInfo> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("asset_audit_", status);
        updateWrapper.set("audit_msg_", msg);
        updateWrapper.in("id_",idList);
        result =  this.baseMapper.update(null,updateWrapper);
        return null != result && result >= 1;
    }

    @Override
    public Map<String,Object> queryStockStructures(String orgId,String orgName) {
        if(StringUtil.isEmpty(orgId)){
           orgId = ContextUtil.getCurrentOrgId();
           orgName = ContextUtil.getCurrentOrgName();
        }
        QueryWrapper<AssetStockInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("belongs_org_id_", orgId);
        List<AssetStockInfo> stockInfoList = this.baseMapper.selectList(queryWrapper);
        Map<String,Object> map = new HashMap<>();
        map.put("id",orgId);
        map.put("name",orgName);
        map.put("level", 1);
        List<Map<String,Object>> level2List =null;
        if(!CollectionUtils.isEmpty(stockInfoList)){
            level2List = new ArrayList<>();
            for (AssetStockInfo assetStockInfo:stockInfoList){
                QueryWrapper<AssetStockStructure> queryStructureWrapper = new QueryWrapper<>();
                queryStructureWrapper.eq("stock_id_", assetStockInfo.getId());
                List<AssetStockStructure> structureList = stockStructureManager.list(queryStructureWrapper);
                List<Map<String,Object>> level3List =null;
                Map<String,Object> level2Map = new HashMap<>();
                level2Map.put("id",assetStockInfo.getId());
                level2Map.put("name",assetStockInfo.getName());
                level2Map.put("level", 2);
                level2Map.put("type", 2);
                level2Map.put("equityRatio",assetStockInfo.getEquityRatio());

                if(!CollectionUtils.isEmpty(structureList)){
                    level3List = new ArrayList<>();
                    for(AssetStockStructure structure:structureList){
                        if(structure.getStockName().equals(orgName)){
                            continue;
                        }
                        Map<String,Object> level3Map = new HashMap<>();
                        level3Map.put("id",structure.getId());
                        level3Map.put("name",structure.getStockName());
                        level3Map.put("level", 3);
                        level3Map.put("type", 1);
                        level3Map.put("equityRatio",structure.getEquityRatio());
                        level3List.add(level3Map);
                    }
                }
                level2Map.put("list",level3List);
                level2List.add(level2Map);
            }
        }
        map.put("list",level2List);
        return map;
    }

    @Override
    public List<JSONObject> stockStatistics(String fullId) {
        return this.baseMapper.stockStatistics(fullId);
    }

}
