package com.artfess.ljzc.land.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.ljzc.land.model.BizAssetLandInfo;

import java.util.List;

/**
 * 土地资产的基础信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
public interface BizAssetLandInfoManager extends BaseManager<BizAssetLandInfo> {

    boolean audit(List<String> asList, String status, String assetMsg);

    boolean removeInfo(List<String> ids);

    boolean updateInfo(BizAssetLandInfo t);

    BizAssetLandInfo findById(String id);

    boolean createInfo(BizAssetLandInfo t);

    PageList<BizAssetLandInfo> findByPage(QueryFilter<BizAssetLandInfo> queryFilter);

    JSONObject landStatistics(String fullId);
}
