package com.artfess.ljzc.land.dao;

import com.alibaba.fastjson.JSONObject;
import com.artfess.ljzc.land.model.BizAssetLandInfo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 土地资产的基础信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
public interface BizAssetLandInfoDao extends BaseMapper<BizAssetLandInfo> {

    IPage<BizAssetLandInfo> findByPage(IPage<BizAssetLandInfo> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizAssetLandInfo> convert2Wrapper);

    BigDecimal bookValue(@Param("fullId") String fullId);

    JSONObject landStatistics(@Param("fullId") String fullId);

    List<JSONObject> yearUseArea(@Param("fullId") String fullId, @Param("yearList") List<Integer> yearList);

    List<JSONObject> assetStatusList(@Param("fullId") String fullId);
}
