package com.artfess.ljzc.fixed.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 固定资产信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetFixedInfo对象", description="固定资产信息")
public class BizAssetFixedInfo extends BizDelModel<BizAssetFixedInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资产类型ID")
    @TableField("type_id_")
    private String typeId;

    @ApiModelProperty(value = "资产名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "资产编码")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "资产型号")
    @TableField("model_")
    private String model;

    @ApiModelProperty(value = "生产厂商")
    @TableField("manufacturer_")
    private String manufacturer;

    @ApiModelProperty(value = "最低库存")
    @TableField("min_number_")
    private Integer minNumber;

    @ApiModelProperty(value = "计量单位（字典）")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "参考单价(元)")
    @TableField("price_")
    private BigDecimal price;

    @ApiModelProperty(value = "归属单位ID")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "归属单位")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "归属单位fullid")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "库存信息")
    @TableField(exist = false)
    private BizAssetFixedInventory assetFixedInventory;

    @ApiModelProperty(value = "资产类型ID")
    @TableField(exist = false)
    private String typeName;

}
