package com.artfess.ljzc.fixed.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.ljzc.fixed.dao.BizAssetFixedTypeDao;
import com.artfess.ljzc.fixed.manager.BizAssetFixedTypeManager;
import com.artfess.ljzc.fixed.model.BizAssetFixedType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 固定资产类型信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Service
public class BizAssetFixedTypeManagerImpl extends BaseManagerImpl<BizAssetFixedTypeDao, BizAssetFixedType> implements BizAssetFixedTypeManager {

    @Override
    public List<BizAssetFixedType> getTree(BizAssetFixedType entity) {
        QueryWrapper<BizAssetFixedType> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        List<BizAssetFixedType> list = this.baseMapper.selectList(queryWrapper);
        List<BizAssetFixedType> tree = BeanUtils.listToTree(list);
        return tree;
    }
}
