package com.artfess.ljzc.welfare.vo;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.ljzc.welfare.model.AssetPublicUse;
import com.artfess.ljzc.welfare.model.AssetPublicWarrents;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 公益资产信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="AssetPubilcInfoVo对象", description="公益资产信息")
public class AssetPubilcInfoVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "资产名称")
    private String name;

    @ApiModelProperty(value = "资产编号")
    private String code;

    @ApiModelProperty(value = "资产详细地址")
    private String address;

    @ApiModelProperty(value = "项目所在行政区划代码")
    private String addvcd;

    @ApiModelProperty(value = "项目所在行政区划名称")
    private String addvcdName;

    @ApiModelProperty(value = "资产经度")
    private String longitude;

    @ApiModelProperty(value = "资产经度")
    private String latitude;

    @ApiModelProperty(value = "资产地图范围")
    private String map;

    @ApiModelProperty(value = "资产类型（字典：具备经营价值，不具备经营价值）")
    private String assetType;

    @ApiModelProperty(value = "资产业态（字典：公园，公共文体设施（场馆、展览馆等），安置房，停车场，划线车位，交通基础设施，市政基础设施，教育设施，行政设施，医疗设施，水利基础设施）")
    private String assetBusiness;

    @ApiModelProperty(value = "资产来源（字典：自建，购买，划拨，置换，出让）")
    private String assetSrc;

    @ApiModelProperty(value = "所属单位ID")
    private String belongsOrgId;

    @ApiModelProperty(value = "所属单位")
    private String belongsOrgName;

    @ApiModelProperty(value = "所属单位fullid")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "是否移交(0：未移交1：已移交)")
    private String isMove;

    @ApiModelProperty(value = "未移交原因")
    private String moveReason;

    @ApiModelProperty(value = "资产管理单位名称")
    private String managementUnit;

    @ApiModelProperty(value = "资产规模（已确定的数量）")
    private BigDecimal confirmSize;

    @ApiModelProperty(value = "未确权规模")
    private BigDecimal unconfirmSize;

    @ApiModelProperty(value = "规模数量单位（字典：）")
    private BigDecimal unit;

    @ApiModelProperty(value = "规划总投资（万元）")
    private BigDecimal investPlan;

    @ApiModelProperty(value = "完成投资（万元）")
    private BigDecimal investOver;

    @ApiModelProperty(value = "是否代建（字典：0：否，1：是）")
    private String isDeputy;

    @ApiModelProperty(value = "套数（针对：安置房）")
    private Integer houseNum;

    @ApiModelProperty(value = "账面价值（元）")
    private BigDecimal bookValue;

    @ApiModelProperty(value = "资产审核状态（0：未审核，1：已审核）")
    private String assetAudit;

    @ApiModelProperty(value = "是否获取权属信息(0：未获取1：已获取)")
    private String isGetWarrents;

    @ApiModelProperty(value = "未获取原因")
    private String warrentsReason;

    @ApiModelProperty(value = "权证号")
    private String warrentsNo;

    @ApiModelProperty(value = "权属单位ID")
    private String warrentsOrgId;

    @ApiModelProperty(value = "权属单位")
    private String warrentsOrgName;

    @ApiModelProperty(value = "填报年")
    private Integer fillYear;

    @ApiModelProperty(value = "已建成规模")
    private BigDecimal completedSize;

    @ApiModelProperty(value = "投入使用规模")
    private BigDecimal usedSize;

    @ApiModelProperty(value = "未使用规模")
    private BigDecimal unusedSize;

    @ApiModelProperty(value = "在建规模")
    private BigDecimal buildingSize;

    @ApiModelProperty(value = "未来规划规模")
    private BigDecimal planSize;

    @ApiModelProperty(value = "规模数量单位")
    private String planUnit;

}
