package com.artfess.ljzc.loan.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.ljzc.loan.model.AssetLoanInfo;
import com.artfess.ljzc.loan.vo.MonthVo;
import com.artfess.ljzc.stock.model.AssetStockInfo;
import com.artfess.ljzc.stock.vo.AssetStockInfoVo;

import java.util.List;

/**
 * 债权资产信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
public interface AssetLoanInfoManager extends BaseManager<AssetLoanInfo> {
    /**
     * 保存债权资产信息
     * @param loanInfo
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    String insertLoanInfo(AssetLoanInfo loanInfo) throws Exception;

    /**
     * 修改债权资产信息
     * @param loanInfo
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean updateLoanInfo(AssetLoanInfo loanInfo) throws Exception;

    /**
     * 删除债权资产信息
     * @param id
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean deleteLoanInfo(String id);

    /**
     * 删除债权资产信息
     * @param ids 债权id集合
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean deleteBachLoanInfo(List<String> ids);

    /**
     * 根据ID查询债权资产信息
     * @param id
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    AssetLoanInfo findLoanInfo(String id);

    /**
     * 审核债权资产信息入库
     * @param status 入库审核状态（0：未审核，1：已审核）
     * @param idList 资产ID集合
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean auditLoan(String status,String msg,List<String> idList);

    List<MonthVo> loanStatistics(String fullId);
}
