package com.artfess.ljzc.business.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;

/**
 * 经营资产使用信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetBusinessUse对象", description="经营资产使用信息	")
public class BizAssetBusinessUse extends BizDelModel<BizAssetBusinessUse> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择项目", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目ID")
    @TableField("project_id_")
    private String projectId;

    @NotBlank(message = "请选择楼栋", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "楼栋ID")
    @TableField("building_id_")
    private String buildingId;

    @NotBlank(message = "请选择资产", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "资产ID")
    @TableField("asset_id_")
    private String assetId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "自用面积（㎡）")
    @TableField("use_area_")
    private BigDecimal useArea;

    @ApiModelProperty(value = "出租面积（㎡）")
    @TableField("hire_area_")
    private BigDecimal hireArea;

    @ApiModelProperty(value = "被占用面积（㎡）")
    @TableField("occupy_area_")
    private BigDecimal occupyArea;

    @ApiModelProperty(value = "出借面积（㎡）")
    @TableField("lend_area_")
    private BigDecimal lendArea;

    @ApiModelProperty(value = "其他面积（㎡）")
    @TableField("other_area_")
    private BigDecimal otherArea;

    @ApiModelProperty(value = "闲置面积（㎡）")
    @TableField("unused_area_")
    private BigDecimal unusedArea;

    @ApiModelProperty(value = "闲置原因")
    @TableField("unused_reason_")
    private String unusedReason;

    @ApiModelProperty(value = "出租率（%）（出租面积/建筑面积）")
    @TableField("hire_rate_")
    private BigDecimal hireRate;

    @ApiModelProperty(value = "年收益（万元）")
    @TableField("year_earnings_")
    private BigDecimal yearEarnings;

    @ApiModelProperty(value = "年收益率（%）（年收益/账面净值）")
    @TableField("year_earnings_rate_")
    private BigDecimal yearEarningsRate;

    @ApiModelProperty(value = "运营分级（A,B,C,D）不需填报，标准A级：①租赁收益率≥7%；②租赁收益率≥5%，出租率≥80%（满足其一)；B级：①租赁收益率≥5%，出租率<80%，②4%≤租赁收益率<5%（满足其一）；C级：2%≤租赁收益率<4%；D级：租赁收益率<2%   ")
    @TableField("operation_level_")
    private String operationLevel;

    @ApiModelProperty(value = "盘活计划")
    @TableField("vitalize_plan_")
    private String vitalizePlan;

    @ApiModelProperty(value = "盘活措施")
    @TableField("vitalize_measure_")
    private String vitalizeMeasure;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

}
