package com.artfess.ljzc.business.controller;


import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.easyExcel.util.excel.ExcelUtil;
import com.artfess.easyExcel.util.excel.XExcelUtil;
import com.artfess.easyExcel.vo.UserVo;
import com.artfess.ljzc.business.manager.BizAssetBusinessInfoManager;
import com.artfess.ljzc.business.model.BizAssetBusinessInfo;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

/**
 * 经营性资产的资产信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Slf4j
@Api(tags = "经营性资产-资产信息")
@RestController
@RequestMapping("/biz/assetBusinessInfo/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizAssetBusinessInfoController extends BaseController<BizAssetBusinessInfoManager, BizAssetBusinessInfo> {


    @GetMapping("/audit")
    @ApiOperation("批量审核")
    public CommonResult<String> auditAsset(@ApiParam(name = "status", value = "审核状态")  @RequestParam String status,
                                           @ApiParam(name = "assetMsg", value = "审核意见")  @RequestParam String assetMsg,
                                           @ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.audit(Arrays.asList(ids), status, assetMsg);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizAssetBusinessInfo> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizAssetBusinessInfo> queryFilter) {
        String fullId = ContextUtil.getCurrentOrgFullId();
        queryFilter.addFilter("belongs_org_full_id_", fullId, QueryOP.RIGHT_LIKE);
        return baseService.findByPage(queryFilter);
    }

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizAssetBusinessInfo t) {
        boolean result = baseService.createInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success(t, null);
    }

    @Override
    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public BizAssetBusinessInfo getById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        return baseService.findById(id);
    }


    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @Validated({UpdateGroup.class}) @RequestBody BizAssetBusinessInfo t) {
        boolean result = baseService.updateInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return CommonResult.success(t, null);
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.removeInfo(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/gatherStatistics")
    @ApiOperation("统计-资产汇总")
    public CommonResult<String> gatherStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        JSONObject result = baseService.gatherStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/belongStatistics")
    @ApiOperation("统计-资产归属分布")
    public CommonResult<String> belongStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = baseService.belongStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/natureStatistics")
    @ApiOperation("统计-资产属性分布")
    public CommonResult<String> natureStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = baseService.natureStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/typeStatistics")
    @ApiOperation("统计-资产类型分布")
    public CommonResult<String> typeStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = baseService.typeStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/sourceStatistics")
    @ApiOperation("统计-资产来源情况")
    public CommonResult<String> sourceStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = baseService.sourceStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/statusStatistics")
    @ApiOperation("统计-资产状态情况")
    public CommonResult<String> statusStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = baseService.statusStatistics(fullId);
        return CommonResult.success(result, "");
    }

    @PostMapping("/operationStatistics")
    @ApiOperation("统计-资产业态情况")
    public CommonResult<String> operationStatistics() {
        String fullId = ContextUtil.getCurrentOrgFullId();
        List<JSONObject> result = baseService.operationStatistics(fullId);
        return CommonResult.success(result, "");
    }

}

