/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.fixed.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.ljzc.fixed.dao.BizAssetFixedInfoDao;
import com.artfess.ljzc.fixed.manager.BizAssetFixedInfoManager;
import com.artfess.ljzc.fixed.manager.BizAssetFixedInventoryManager;
import com.artfess.ljzc.fixed.manager.BizAssetFixedTypeManager;
import com.artfess.ljzc.fixed.model.BizAssetFixedInfo;
import com.artfess.ljzc.fixed.model.BizAssetFixedInventory;
import com.artfess.ljzc.fixed.model.BizAssetFixedType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizAssetFixedInfoManagerImpl
extends BaseManagerImpl<BizAssetFixedInfoDao, BizAssetFixedInfo>
implements BizAssetFixedInfoManager {
    @Autowired
    private BizAssetFixedInventoryManager fixedInventoryManager;
    @Autowired
    private BizAssetFixedTypeManager assetFixedTypeManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(BizAssetFixedInfo t) {
        boolean save = this.save((Object)t);
        if (save) {
            this.processInfo(t);
        }
        return save;
    }

    private void processInfo(BizAssetFixedInfo t) {
        BizAssetFixedInventory assetFixedInventory = t.getAssetFixedInventory();
        assetFixedInventory.setFixedId(t.getId());
        assetFixedInventory.setTypeId(t.getTypeId());
        this.fixedInventoryManager.saveOrUpdate((Object)assetFixedInventory);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizAssetFixedInfo t) {
        boolean b = this.updateById((Object)t);
        if (b) {
            this.processInfo(t);
        }
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeInfo(List<String> ids) {
        boolean b = this.removeByIds(ids);
        if (b) {
            QueryWrapper warrentsQueryWrapper = new QueryWrapper();
            warrentsQueryWrapper.in((Object)"fixed_id_", ids);
            this.fixedInventoryManager.remove((Wrapper)warrentsQueryWrapper);
        }
        return b;
    }

    @Override
    public PageList<BizAssetFixedInfo> findByPage(QueryFilter<BizAssetFixedInfo> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)DelStatusEnum.N.getType(), QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<BizAssetFixedInfo> result = ((BizAssetFixedInfoDao)this.baseMapper).findByPage((IPage<BizAssetFixedInfo>)this.convert2IPage(pageBean), (Wrapper<BizAssetFixedInfo>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }

    @Override
    public List<JSONObject> fixedStatistics(String fullId) {
        return ((BizAssetFixedInfoDao)this.baseMapper).fixedStatistics(fullId);
    }

    @Override
    public BizAssetFixedInfo findById(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u8d44\u4ea7");
        BizAssetFixedInfo businessInfo = (BizAssetFixedInfo)this.get((Serializable)((Object)id));
        QueryWrapper warrentsQueryWrapper = new QueryWrapper();
        warrentsQueryWrapper.eq((Object)"fixed_id_", (Object)id);
        BizAssetFixedInventory fixedInventory = (BizAssetFixedInventory)((Object)this.fixedInventoryManager.getOne((Wrapper)warrentsQueryWrapper));
        businessInfo.setAssetFixedInventory(fixedInventory);
        BizAssetFixedType bizAssetFixedType = (BizAssetFixedType)this.assetFixedTypeManager.get((Serializable)((Object)businessInfo.getTypeId()));
        if (null != bizAssetFixedType) {
            businessInfo.setTypeName(bizAssetFixedType.getName());
        }
        return businessInfo;
    }
}

