import request from '@/requset/axios'

// 登录
export const login = (data: object) => {
    return new Promise((resolve, reject) => {
        request
            .post('/auth', data)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 登出
export const loginOut = () => {
    return new Promise((resolve, reject) => {
        request
            .get('/signout')
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}
// 获取用户菜单
export const getCurrentUserMenu = (params: object) => {
    return new Promise((resolve, reject) => {
        request
            .get('/sys/sysMenu/v1/getCurrentUserMenu', params)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 获取用户信息详情
export const getCurrentUserDetail = (account: string) => {
    return new Promise((resolve, reject) => {
        request
            .get('/api/user/v1/user/getDetailByAccountOrId?account=' + account)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 修改用户信息
export const updateUserInfo = (data: object) => {
    return new Promise((resolve, reject) => {
        request
            .post('/api/user/v1/user/updateUser', data)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

//获取用户头像
export const getUserImg = (fileId: string) => {
    return new Promise((resolve, reject) => {
        request
            .download('/file/v1/preview?fileId=' + fileId, 'get', undefined, 'blob')
            .then((res) => {
                if (res?.data?.size > 0) {
                    const blob = res.data
                    const reader = new FileReader()
                    reader.readAsDataURL(blob)
                    reader.onload = function (e) {
                        resolve(e.target.result)
                    }
                } else {
                    resolve('')
                }
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 修改密码
export const updatePassword = (data: object) => {
    return new Promise((resolve, reject) => {
        request
            .post('/api/user/v1/user/modifiUserPsd', data)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

//获取密码策略
export const getDefaultPwdStrategy = () => {
    return new Promise((resolve, reject) => {
        request
            .get('/api/pwdStrategy/v1/getDefault')
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 获取按钮权限
export const getBtnAuth = () => {
    return new Promise((resolve, reject) => {
        request
            .get('/sys/sysMenu/v1/getCurrentUserMethodAuth')
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 获取当前组织用户列表
export const getOrgUserList = (data: object) => {
    return new Promise((resolve, reject) => {
        request
            .post('/api/user/v1/users/getOrgUserQuery', data)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}