/**
 * 选择优先显示的部门
 * 优先级: 当前部门 > 主部门 > 第一个部门
 */
export const selectPriorityOrg = (orgList) => {
    const currentOrg = orgList.find((org) => org.isCurrent === 1)
    if (currentOrg) return currentOrg

    const masterOrg = orgList.find((org) => org.isMaster === 1)
    if (masterOrg) return masterOrg

    return orgList[0]
}

/**
 * 格式化部门名称
 */
export const formatOrgName = (org) => {
    if (!org) return ''
    const { orgName, deptName } = org
    return [orgName, deptName].filter(Boolean).join(' - ') || ''
}
