"use strict";const utils=require("@typescript-eslint/utils"),n$3=require("typescript"),node_path=require("node:path"),node_module=require("node:module"),scopeManager=require("@typescript-eslint/scope-manager");var _documentCurrentScript=typeof document<"u"?document.currentScript:null;function _interopDefaultCompat(q){return q&&typeof q=="object"&&"default"in q?q.default:q}const n__default=_interopDefaultCompat(n$3),version="1.3.8",createEslintRule=utils.ESLintUtils.RuleCreator(q=>`https://github.com/vitest-dev/eslint-plugin-vitest/blob/main/docs/rules/${q}.md`),joinNames=(q,$)=>q&&$?`${q}.${$}`:null,isFunction=q=>q.type===utils.AST_NODE_TYPES.FunctionExpression||q.type===utils.AST_NODE_TYPES.ArrowFunctionExpression;function getNodeName(q){if(isSupportedAccessor(q))return getAccessorValue(q);switch(q.type){case utils.AST_NODE_TYPES.TaggedTemplateExpression:return getNodeName(q.tag);case utils.AST_NODE_TYPES.MemberExpression:return joinNames(getNodeName(q.object),getNodeName(q.property));case utils.AST_NODE_TYPES.NewExpression:case utils.AST_NODE_TYPES.CallExpression:return getNodeName(q.callee)}return null}const isSupportedAccessor=(q,$)=>isIdentifier(q,$)||isStringNode(q,$),isIdentifier=(q,$)=>q.type===utils.AST_NODE_TYPES.Identifier&&($===void 0||q.name===$),S$4=(q,$)=>q.type===utils.AST_NODE_TYPES.TemplateLiteral&&q.quasis.length===1&&($===void 0||q.quasis[0].value.raw===$),g$3=(q,$)=>q.type===utils.AST_NODE_TYPES.Literal&&typeof q.value=="string"&&($===void 0||q.value===$),isStringNode=(q,$)=>g$3(q,$)||S$4(q,$),getAccessorValue=q=>q.type===utils.AST_NODE_TYPES.Identifier?q.name:getStringValue(q),getStringValue=q=>q?.type===utils.AST_NODE_TYPES.TemplateLiteral?q.quasis[0].value.raw:q?.value,replaceAccessorFixer=(q,$,Y)=>q.replaceText($,$.type===utils.AST_NODE_TYPES.Identifier?Y:`'${Y}'`),removeExtraArgumentsFixer=(q,$,Y,B)=>{const F=Y.arguments[B],W=Y.arguments[Y.arguments.length-1],{sourceCode:H}=$;let V=H.getTokenAfter(W);return V.value===","&&(V=H.getTokenAfter(V)),q.removeRange([F.range[0],V.range[0]])},isParsedInstanceOfMatcherCall=(q,$)=>getAccessorValue(q.matcher)==="toBeInstanceOf"&&q.args.length===1&&isSupportedAccessor(q.args[0],$);var UtilName=(q=>(q.vi="vi",q.vitest="vitest",q))(UtilName||{}),DescribeAlias=(q=>(q.describe="describe",q.fdescribe="fdescribe",q.xdescribe="xdescribe",q))(DescribeAlias||{}),TestCaseName=(q=>(q.fit="fit",q.it="it",q.test="test",q.xit="xit",q.xtest="xtest",q.bench="bench",q))(TestCaseName||{}),HookName=(q=>(q.beforeAll="beforeAll",q.beforeEach="beforeEach",q.afterAll="afterAll",q.afterEach="afterEach",q))(HookName||{}),ModifierName=(q=>(q.to="to",q.have="have",q.not="not",q.rejects="rejects",q.resolves="resolves",q.returns="returns",q.branded="branded",q.asserts="asserts",q.constructorParameters="constructorParameters",q.parameters="parameters",q.thisParameter="thisParameter",q.guards="guards",q.instance="instance",q.items="items",q))(ModifierName||{}),EqualityMatcher=(q=>(q.toBe="toBe",q.toEqual="toEqual",q.toStrictEqual="toStrictEqual",q))(EqualityMatcher||{});function isClassOrFunctionType(q){return q.getCallSignatures().length>0?!0:q.getSymbol()?.getDeclarations()?.some($=>n__default.isArrowFunction($)||n__default.isClassDeclaration($)||n__default.isClassExpression($)||n__default.isFunctionDeclaration($)||n__default.isFunctionExpression($)||n__default.isMethodDeclaration($)||n__default.isFunctionTypeNode($))??!1}const ValidVitestFnCallChains=new Set(["beforeEach","beforeAll","afterEach","afterAll","it","it.skip","it.only","it.concurrent","it.sequential","it.todo","it.fails","it.extend","it.skipIf","it.runIf","it.each","it.skip.only","it.skip.concurrent","it.skip.sequential","it.skip.todo","it.skip.fails","it.only.skip","it.only.concurrent","it.only.sequential","it.only.todo","it.only.fails","it.concurrent.skip","it.concurrent.only","it.concurrent.sequential","it.concurrent.todo","it.concurrent.fails","it.sequential.skip","it.sequential.only","it.sequential.concurrent","it.sequential.todo","it.sequential.fails","it.todo.skip","it.todo.only","it.todo.concurrent","it.todo.sequential","it.todo.fails","it.fails.skip","it.fails.only","it.fails.concurrent","it.fails.sequential","it.fails.todo","it.extend.skip","it.extend.only","it.extend.concurrent","it.extend.sequential","it.extend.todo","it.extend.fails","it.skipIf.skip","it.skipIf.only","it.skipIf.concurrent","it.skipIf.sequential","it.skipIf.todo","it.skipIf.fails","it.runIf.skip","it.runIf.only","it.runIf.concurrent","it.runIf.sequential","it.runIf.todo","it.runIf.fails","it.skip.each","it.only.each","it.concurrent.each","it.sequential.each","it.todo.each","it.fails.each","it.extend.skipIf","it.extend.runIf","it.extend.each","it.skipIf.each","it.runIf.each","it.skip.only.concurrent","it.skip.only.sequential","it.skip.only.todo","it.skip.only.fails","it.skip.concurrent.only","it.skip.concurrent.sequential","it.skip.concurrent.todo","it.skip.concurrent.fails","it.skip.sequential.only","it.skip.sequential.concurrent","it.skip.sequential.todo","it.skip.sequential.fails","it.skip.todo.only","it.skip.todo.concurrent","it.skip.todo.sequential","it.skip.todo.fails","it.skip.fails.only","it.skip.fails.concurrent","it.skip.fails.sequential","it.skip.fails.todo","it.only.skip.concurrent","it.only.skip.sequential","it.only.skip.todo","it.only.skip.fails","it.only.concurrent.skip","it.only.concurrent.sequential","it.only.concurrent.todo","it.only.concurrent.fails","it.only.sequential.skip","it.only.sequential.concurrent","it.only.sequential.todo","it.only.sequential.fails","it.only.todo.skip","it.only.todo.concurrent","it.only.todo.sequential","it.only.todo.fails","it.only.fails.skip","it.only.fails.concurrent","it.only.fails.sequential","it.only.fails.todo","it.concurrent.skip.only","it.concurrent.skip.sequential","it.concurrent.skip.todo","it.concurrent.skip.fails","it.concurrent.only.skip","it.concurrent.only.sequential","it.concurrent.only.todo","it.concurrent.only.fails","it.concurrent.sequential.skip","it.concurrent.sequential.only","it.concurrent.sequential.todo","it.concurrent.sequential.fails","it.concurrent.todo.skip","it.concurrent.todo.only","it.concurrent.todo.sequential","it.concurrent.todo.fails","it.concurrent.fails.skip","it.concurrent.fails.only","it.concurrent.fails.sequential","it.concurrent.fails.todo","it.sequential.skip.only","it.sequential.skip.concurrent","it.sequential.skip.todo","it.sequential.skip.fails","it.sequential.only.skip","it.sequential.only.concurrent","it.sequential.only.todo","it.sequential.only.fails","it.sequential.concurrent.skip","it.sequential.concurrent.only","it.sequential.concurrent.todo","it.sequential.concurrent.fails","it.sequential.todo.skip","it.sequential.todo.only","it.sequential.todo.concurrent","it.sequential.todo.fails","it.sequential.fails.skip","it.sequential.fails.only","it.sequential.fails.concurrent","it.sequential.fails.todo","it.todo.skip.only","it.todo.skip.concurrent","it.todo.skip.sequential","it.todo.skip.fails","it.todo.only.skip","it.todo.only.concurrent","it.todo.only.sequential","it.todo.only.fails","it.todo.concurrent.skip","it.todo.concurrent.only","it.todo.concurrent.sequential","it.todo.concurrent.fails","it.todo.sequential.skip","it.todo.sequential.only","it.todo.sequential.concurrent","it.todo.sequential.fails","it.todo.fails.skip","it.todo.fails.only","it.todo.fails.concurrent","it.todo.fails.sequential","it.fails.skip.only","it.fails.skip.concurrent","it.fails.skip.sequential","it.fails.skip.todo","it.fails.only.skip","it.fails.only.concurrent","it.fails.only.sequential","it.fails.only.todo","it.fails.concurrent.skip","it.fails.concurrent.only","it.fails.concurrent.sequential","it.fails.concurrent.todo","it.fails.sequential.skip","it.fails.sequential.only","it.fails.sequential.concurrent","it.fails.sequential.todo","it.fails.todo.skip","it.fails.todo.only","it.fails.todo.concurrent","it.fails.todo.sequential","it.extend.skip.only","it.extend.skip.concurrent","it.extend.skip.sequential","it.extend.skip.todo","it.extend.skip.fails","it.extend.only.skip","it.extend.only.concurrent","it.extend.only.sequential","it.extend.only.todo","it.extend.only.fails","it.extend.concurrent.skip","it.extend.concurrent.only","it.extend.concurrent.sequential","it.extend.concurrent.todo","it.extend.concurrent.fails","it.extend.sequential.skip","it.extend.sequential.only","it.extend.sequential.concurrent","it.extend.sequential.todo","it.extend.sequential.fails","it.extend.todo.skip","it.extend.todo.only","it.extend.todo.concurrent","it.extend.todo.sequential","it.extend.todo.fails","it.extend.fails.skip","it.extend.fails.only","it.extend.fails.concurrent","it.extend.fails.sequential","it.extend.fails.todo","it.skipIf.skip.only","it.skipIf.skip.concurrent","it.skipIf.skip.sequential","it.skipIf.skip.todo","it.skipIf.skip.fails","it.skipIf.only.skip","it.skipIf.only.concurrent","it.skipIf.only.sequential","it.skipIf.only.todo","it.skipIf.only.fails","it.skipIf.concurrent.skip","it.skipIf.concurrent.only","it.skipIf.concurrent.sequential","it.skipIf.concurrent.todo","it.skipIf.concurrent.fails","it.skipIf.sequential.skip","it.skipIf.sequential.only","it.skipIf.sequential.concurrent","it.skipIf.sequential.todo","it.skipIf.sequential.fails","it.skipIf.todo.skip","it.skipIf.todo.only","it.skipIf.todo.concurrent","it.skipIf.todo.sequential","it.skipIf.todo.fails","it.skipIf.fails.skip","it.skipIf.fails.only","it.skipIf.fails.concurrent","it.skipIf.fails.sequential","it.skipIf.fails.todo","it.runIf.skip.only","it.runIf.skip.concurrent","it.runIf.skip.sequential","it.runIf.skip.todo","it.runIf.skip.fails","it.runIf.only.skip","it.runIf.only.concurrent","it.runIf.only.sequential","it.runIf.only.todo","it.runIf.only.fails","it.runIf.concurrent.skip","it.runIf.concurrent.only","it.runIf.concurrent.sequential","it.runIf.concurrent.todo","it.runIf.concurrent.fails","it.runIf.sequential.skip","it.runIf.sequential.only","it.runIf.sequential.concurrent","it.runIf.sequential.todo","it.runIf.sequential.fails","it.runIf.todo.skip","it.runIf.todo.only","it.runIf.todo.concurrent","it.runIf.todo.sequential","it.runIf.todo.fails","it.runIf.fails.skip","it.runIf.fails.only","it.runIf.fails.concurrent","it.runIf.fails.sequential","it.runIf.fails.todo","it.skip.only.each","it.skip.concurrent.each","it.skip.sequential.each","it.skip.todo.each","it.skip.fails.each","it.only.skip.each","it.only.concurrent.each","it.only.sequential.each","it.only.todo.each","it.only.fails.each","it.concurrent.skip.each","it.concurrent.only.each","it.concurrent.sequential.each","it.concurrent.todo.each","it.concurrent.fails.each","it.sequential.skip.each","it.sequential.only.each","it.sequential.concurrent.each","it.sequential.todo.each","it.sequential.fails.each","it.todo.skip.each","it.todo.only.each","it.todo.concurrent.each","it.todo.sequential.each","it.todo.fails.each","it.fails.skip.each","it.fails.only.each","it.fails.concurrent.each","it.fails.sequential.each","it.fails.todo.each","it.extend.skipIf.skip","it.extend.skipIf.only","it.extend.skipIf.concurrent","it.extend.skipIf.sequential","it.extend.skipIf.todo","it.extend.skipIf.fails","it.extend.runIf.skip","it.extend.runIf.only","it.extend.runIf.concurrent","it.extend.runIf.sequential","it.extend.runIf.todo","it.extend.runIf.fails","it.extend.skip.each","it.extend.only.each","it.extend.concurrent.each","it.extend.sequential.each","it.extend.todo.each","it.extend.fails.each","it.skipIf.skip.each","it.skipIf.only.each","it.skipIf.concurrent.each","it.skipIf.sequential.each","it.skipIf.todo.each","it.skipIf.fails.each","it.runIf.skip.each","it.runIf.only.each","it.runIf.concurrent.each","it.runIf.sequential.each","it.runIf.todo.each","it.runIf.fails.each","it.extend.skipIf.each","it.extend.runIf.each","test","test.skip","test.only","test.concurrent","test.sequential","test.todo","test.fails","test.extend","test.skipIf","test.runIf","test.each","test.skip.only","test.skip.concurrent","test.skip.sequential","test.skip.todo","test.skip.fails","test.only.skip","test.only.concurrent","test.only.sequential","test.only.todo","test.only.fails","test.concurrent.skip","test.concurrent.only","test.concurrent.sequential","test.concurrent.todo","test.concurrent.fails","test.sequential.skip","test.sequential.only","test.sequential.concurrent","test.sequential.todo","test.sequential.fails","test.todo.skip","test.todo.only","test.todo.concurrent","test.todo.sequential","test.todo.fails","test.fails.skip","test.fails.only","test.fails.concurrent","test.fails.sequential","test.fails.todo","test.extend.skip","test.extend.only","test.extend.concurrent","test.extend.sequential","test.extend.todo","test.extend.fails","test.skipIf.skip","test.skipIf.only","test.skipIf.concurrent","test.skipIf.sequential","test.skipIf.todo","test.skipIf.fails","test.runIf.skip","test.runIf.only","test.runIf.concurrent","test.runIf.sequential","test.runIf.todo","test.runIf.fails","test.skip.each","test.only.each","test.concurrent.each","test.sequential.each","test.todo.each","test.fails.each","test.extend.skipIf","test.extend.runIf","test.extend.each","test.skipIf.each","test.runIf.each","test.skip.only.concurrent","test.skip.only.sequential","test.skip.only.todo","test.skip.only.fails","test.skip.concurrent.only","test.skip.concurrent.sequential","test.skip.concurrent.todo","test.skip.concurrent.fails","test.skip.sequential.only","test.skip.sequential.concurrent","test.skip.sequential.todo","test.skip.sequential.fails","test.skip.todo.only","test.skip.todo.concurrent","test.skip.todo.sequential","test.skip.todo.fails","test.skip.fails.only","test.skip.fails.concurrent","test.skip.fails.sequential","test.skip.fails.todo","test.only.skip.concurrent","test.only.skip.sequential","test.only.skip.todo","test.only.skip.fails","test.only.concurrent.skip","test.only.concurrent.sequential","test.only.concurrent.todo","test.only.concurrent.fails","test.only.sequential.skip","test.only.sequential.concurrent","test.only.sequential.todo","test.only.sequential.fails","test.only.todo.skip","test.only.todo.concurrent","test.only.todo.sequential","test.only.todo.fails","test.only.fails.skip","test.only.fails.concurrent","test.only.fails.sequential","test.only.fails.todo","test.concurrent.skip.only","test.concurrent.skip.sequential","test.concurrent.skip.todo","test.concurrent.skip.fails","test.concurrent.only.skip","test.concurrent.only.sequential","test.concurrent.only.todo","test.concurrent.only.fails","test.concurrent.sequential.skip","test.concurrent.sequential.only","test.concurrent.sequential.todo","test.concurrent.sequential.fails","test.concurrent.todo.skip","test.concurrent.todo.only","test.concurrent.todo.sequential","test.concurrent.todo.fails","test.concurrent.fails.skip","test.concurrent.fails.only","test.concurrent.fails.sequential","test.concurrent.fails.todo","test.sequential.skip.only","test.sequential.skip.concurrent","test.sequential.skip.todo","test.sequential.skip.fails","test.sequential.only.skip","test.sequential.only.concurrent","test.sequential.only.todo","test.sequential.only.fails","test.sequential.concurrent.skip","test.sequential.concurrent.only","test.sequential.concurrent.todo","test.sequential.concurrent.fails","test.sequential.todo.skip","test.sequential.todo.only","test.sequential.todo.concurrent","test.sequential.todo.fails","test.sequential.fails.skip","test.sequential.fails.only","test.sequential.fails.concurrent","test.sequential.fails.todo","test.todo.skip.only","test.todo.skip.concurrent","test.todo.skip.sequential","test.todo.skip.fails","test.todo.only.skip","test.todo.only.concurrent","test.todo.only.sequential","test.todo.only.fails","test.todo.concurrent.skip","test.todo.concurrent.only","test.todo.concurrent.sequential","test.todo.concurrent.fails","test.todo.sequential.skip","test.todo.sequential.only","test.todo.sequential.concurrent","test.todo.sequential.fails","test.todo.fails.skip","test.todo.fails.only","test.todo.fails.concurrent","test.todo.fails.sequential","test.fails.skip.only","test.fails.skip.concurrent","test.fails.skip.sequential","test.fails.skip.todo","test.fails.only.skip","test.fails.only.concurrent","test.fails.only.sequential","test.fails.only.todo","test.fails.concurrent.skip","test.fails.concurrent.only","test.fails.concurrent.sequential","test.fails.concurrent.todo","test.fails.sequential.skip","test.fails.sequential.only","test.fails.sequential.concurrent","test.fails.sequential.todo","test.fails.todo.skip","test.fails.todo.only","test.fails.todo.concurrent","test.fails.todo.sequential","test.extend.skip.only","test.extend.skip.concurrent","test.extend.skip.sequential","test.extend.skip.todo","test.extend.skip.fails","test.extend.only.skip","test.extend.only.concurrent","test.extend.only.sequential","test.extend.only.todo","test.extend.only.fails","test.extend.concurrent.skip","test.extend.concurrent.only","test.extend.concurrent.sequential","test.extend.concurrent.todo","test.extend.concurrent.fails","test.extend.sequential.skip","test.extend.sequential.only","test.extend.sequential.concurrent","test.extend.sequential.todo","test.extend.sequential.fails","test.extend.todo.skip","test.extend.todo.only","test.extend.todo.concurrent","test.extend.todo.sequential","test.extend.todo.fails","test.extend.fails.skip","test.extend.fails.only","test.extend.fails.concurrent","test.extend.fails.sequential","test.extend.fails.todo","test.skipIf.skip.only","test.skipIf.skip.concurrent","test.skipIf.skip.sequential","test.skipIf.skip.todo","test.skipIf.skip.fails","test.skipIf.only.skip","test.skipIf.only.concurrent","test.skipIf.only.sequential","test.skipIf.only.todo","test.skipIf.only.fails","test.skipIf.concurrent.skip","test.skipIf.concurrent.only","test.skipIf.concurrent.sequential","test.skipIf.concurrent.todo","test.skipIf.concurrent.fails","test.skipIf.sequential.skip","test.skipIf.sequential.only","test.skipIf.sequential.concurrent","test.skipIf.sequential.todo","test.skipIf.sequential.fails","test.skipIf.todo.skip","test.skipIf.todo.only","test.skipIf.todo.concurrent","test.skipIf.todo.sequential","test.skipIf.todo.fails","test.skipIf.fails.skip","test.skipIf.fails.only","test.skipIf.fails.concurrent","test.skipIf.fails.sequential","test.skipIf.fails.todo","test.runIf.skip.only","test.runIf.skip.concurrent","test.runIf.skip.sequential","test.runIf.skip.todo","test.runIf.skip.fails","test.runIf.only.skip","test.runIf.only.concurrent","test.runIf.only.sequential","test.runIf.only.todo","test.runIf.only.fails","test.runIf.concurrent.skip","test.runIf.concurrent.only","test.runIf.concurrent.sequential","test.runIf.concurrent.todo","test.runIf.concurrent.fails","test.runIf.sequential.skip","test.runIf.sequential.only","test.runIf.sequential.concurrent","test.runIf.sequential.todo","test.runIf.sequential.fails","test.runIf.todo.skip","test.runIf.todo.only","test.runIf.todo.concurrent","test.runIf.todo.sequential","test.runIf.todo.fails","test.runIf.fails.skip","test.runIf.fails.only","test.runIf.fails.concurrent","test.runIf.fails.sequential","test.runIf.fails.todo","test.skip.only.each","test.skip.concurrent.each","test.skip.sequential.each","test.skip.todo.each","test.skip.fails.each","test.only.skip.each","test.only.concurrent.each","test.only.sequential.each","test.only.todo.each","test.only.fails.each","test.concurrent.skip.each","test.concurrent.only.each","test.concurrent.sequential.each","test.concurrent.todo.each","test.concurrent.fails.each","test.sequential.skip.each","test.sequential.only.each","test.sequential.concurrent.each","test.sequential.todo.each","test.sequential.fails.each","test.todo.skip.each","test.todo.only.each","test.todo.concurrent.each","test.todo.sequential.each","test.todo.fails.each","test.fails.skip.each","test.fails.only.each","test.fails.concurrent.each","test.fails.sequential.each","test.fails.todo.each","test.extend.skipIf.skip","test.extend.skipIf.only","test.extend.skipIf.concurrent","test.extend.skipIf.sequential","test.extend.skipIf.todo","test.extend.skipIf.fails","test.extend.runIf.skip","test.extend.runIf.only","test.extend.runIf.concurrent","test.extend.runIf.sequential","test.extend.runIf.todo","test.extend.runIf.fails","test.extend.skip.each","test.extend.only.each","test.extend.concurrent.each","test.extend.sequential.each","test.extend.todo.each","test.extend.fails.each","test.skipIf.skip.each","test.skipIf.only.each","test.skipIf.concurrent.each","test.skipIf.sequential.each","test.skipIf.todo.each","test.skipIf.fails.each","test.runIf.skip.each","test.runIf.only.each","test.runIf.concurrent.each","test.runIf.sequential.each","test.runIf.todo.each","test.runIf.fails.each","test.extend.skipIf.each","test.extend.runIf.each","bench","bench.skip","bench.only","bench.todo","bench.skipIf","bench.runIf","bench.skip.only","bench.skip.todo","bench.only.skip","bench.only.todo","bench.todo.skip","bench.todo.only","bench.skipIf.skip","bench.skipIf.only","bench.skipIf.todo","bench.runIf.skip","bench.runIf.only","bench.runIf.todo","bench.skip.only.todo","bench.skip.todo.only","bench.only.skip.todo","bench.only.todo.skip","bench.todo.skip.only","bench.todo.only.skip","bench.skipIf.skip.only","bench.skipIf.skip.todo","bench.skipIf.only.skip","bench.skipIf.only.todo","bench.skipIf.todo.skip","bench.skipIf.todo.only","bench.runIf.skip.only","bench.runIf.skip.todo","bench.runIf.only.skip","bench.runIf.only.todo","bench.runIf.todo.skip","bench.runIf.todo.only","describe","describe.skip","describe.only","describe.concurrent","describe.sequential","describe.shuffle","describe.todo","describe.skipIf","describe.runIf","describe.each","describe.skip.only","describe.skip.concurrent","describe.skip.sequential","describe.skip.shuffle","describe.skip.todo","describe.only.skip","describe.only.concurrent","describe.only.sequential","describe.only.shuffle","describe.only.todo","describe.concurrent.skip","describe.concurrent.only","describe.concurrent.sequential","describe.concurrent.shuffle","describe.concurrent.todo","describe.sequential.skip","describe.sequential.only","describe.sequential.concurrent","describe.sequential.shuffle","describe.sequential.todo","describe.shuffle.skip","describe.shuffle.only","describe.shuffle.concurrent","describe.shuffle.sequential","describe.shuffle.todo","describe.todo.skip","describe.todo.only","describe.todo.concurrent","describe.todo.sequential","describe.todo.shuffle","describe.skipIf.skip","describe.skipIf.only","describe.skipIf.concurrent","describe.skipIf.sequential","describe.skipIf.shuffle","describe.skipIf.todo","describe.runIf.skip","describe.runIf.only","describe.runIf.concurrent","describe.runIf.sequential","describe.runIf.shuffle","describe.runIf.todo","describe.skip.each","describe.only.each","describe.concurrent.each","describe.sequential.each","describe.shuffle.each","describe.todo.each","describe.skipIf.each","describe.runIf.each","describe.skip.only.concurrent","describe.skip.only.sequential","describe.skip.only.shuffle","describe.skip.only.todo","describe.skip.concurrent.only","describe.skip.concurrent.sequential","describe.skip.concurrent.shuffle","describe.skip.concurrent.todo","describe.skip.sequential.only","describe.skip.sequential.concurrent","describe.skip.sequential.shuffle","describe.skip.sequential.todo","describe.skip.shuffle.only","describe.skip.shuffle.concurrent","describe.skip.shuffle.sequential","describe.skip.shuffle.todo","describe.skip.todo.only","describe.skip.todo.concurrent","describe.skip.todo.sequential","describe.skip.todo.shuffle","describe.only.skip.concurrent","describe.only.skip.sequential","describe.only.skip.shuffle","describe.only.skip.todo","describe.only.concurrent.skip","describe.only.concurrent.sequential","describe.only.concurrent.shuffle","describe.only.concurrent.todo","describe.only.sequential.skip","describe.only.sequential.concurrent","describe.only.sequential.shuffle","describe.only.sequential.todo","describe.only.shuffle.skip","describe.only.shuffle.concurrent","describe.only.shuffle.sequential","describe.only.shuffle.todo","describe.only.todo.skip","describe.only.todo.concurrent","describe.only.todo.sequential","describe.only.todo.shuffle","describe.concurrent.skip.only","describe.concurrent.skip.sequential","describe.concurrent.skip.shuffle","describe.concurrent.skip.todo","describe.concurrent.only.skip","describe.concurrent.only.sequential","describe.concurrent.only.shuffle","describe.concurrent.only.todo","describe.concurrent.sequential.skip","describe.concurrent.sequential.only","describe.concurrent.sequential.shuffle","describe.concurrent.sequential.todo","describe.concurrent.shuffle.skip","describe.concurrent.shuffle.only","describe.concurrent.shuffle.sequential","describe.concurrent.shuffle.todo","describe.concurrent.todo.skip","describe.concurrent.todo.only","describe.concurrent.todo.sequential","describe.concurrent.todo.shuffle","describe.sequential.skip.only","describe.sequential.skip.concurrent","describe.sequential.skip.shuffle","describe.sequential.skip.todo","describe.sequential.only.skip","describe.sequential.only.concurrent","describe.sequential.only.shuffle","describe.sequential.only.todo","describe.sequential.concurrent.skip","describe.sequential.concurrent.only","describe.sequential.concurrent.shuffle","describe.sequential.concurrent.todo","describe.sequential.shuffle.skip","describe.sequential.shuffle.only","describe.sequential.shuffle.concurrent","describe.sequential.shuffle.todo","describe.sequential.todo.skip","describe.sequential.todo.only","describe.sequential.todo.concurrent","describe.sequential.todo.shuffle","describe.shuffle.skip.only","describe.shuffle.skip.concurrent","describe.shuffle.skip.sequential","describe.shuffle.skip.todo","describe.shuffle.only.skip","describe.shuffle.only.concurrent","describe.shuffle.only.sequential","describe.shuffle.only.todo","describe.shuffle.concurrent.skip","describe.shuffle.concurrent.only","describe.shuffle.concurrent.sequential","describe.shuffle.concurrent.todo","describe.shuffle.sequential.skip","describe.shuffle.sequential.only","describe.shuffle.sequential.concurrent","describe.shuffle.sequential.todo","describe.shuffle.todo.skip","describe.shuffle.todo.only","describe.shuffle.todo.concurrent","describe.shuffle.todo.sequential","describe.todo.skip.only","describe.todo.skip.concurrent","describe.todo.skip.sequential","describe.todo.skip.shuffle","describe.todo.only.skip","describe.todo.only.concurrent","describe.todo.only.sequential","describe.todo.only.shuffle","describe.todo.concurrent.skip","describe.todo.concurrent.only","describe.todo.concurrent.sequential","describe.todo.concurrent.shuffle","describe.todo.sequential.skip","describe.todo.sequential.only","describe.todo.sequential.concurrent","describe.todo.sequential.shuffle","describe.todo.shuffle.skip","describe.todo.shuffle.only","describe.todo.shuffle.concurrent","describe.todo.shuffle.sequential","describe.skipIf.skip.only","describe.skipIf.skip.concurrent","describe.skipIf.skip.sequential","describe.skipIf.skip.shuffle","describe.skipIf.skip.todo","describe.skipIf.only.skip","describe.skipIf.only.concurrent","describe.skipIf.only.sequential","describe.skipIf.only.shuffle","describe.skipIf.only.todo","describe.skipIf.concurrent.skip","describe.skipIf.concurrent.only","describe.skipIf.concurrent.sequential","describe.skipIf.concurrent.shuffle","describe.skipIf.concurrent.todo","describe.skipIf.sequential.skip","describe.skipIf.sequential.only","describe.skipIf.sequential.concurrent","describe.skipIf.sequential.shuffle","describe.skipIf.sequential.todo","describe.skipIf.shuffle.skip","describe.skipIf.shuffle.only","describe.skipIf.shuffle.concurrent","describe.skipIf.shuffle.sequential","describe.skipIf.shuffle.todo","describe.skipIf.todo.skip","describe.skipIf.todo.only","describe.skipIf.todo.concurrent","describe.skipIf.todo.sequential","describe.skipIf.todo.shuffle","describe.runIf.skip.only","describe.runIf.skip.concurrent","describe.runIf.skip.sequential","describe.runIf.skip.shuffle","describe.runIf.skip.todo","describe.runIf.only.skip","describe.runIf.only.concurrent","describe.runIf.only.sequential","describe.runIf.only.shuffle","describe.runIf.only.todo","describe.runIf.concurrent.skip","describe.runIf.concurrent.only","describe.runIf.concurrent.sequential","describe.runIf.concurrent.shuffle","describe.runIf.concurrent.todo","describe.runIf.sequential.skip","describe.runIf.sequential.only","describe.runIf.sequential.concurrent","describe.runIf.sequential.shuffle","describe.runIf.sequential.todo","describe.runIf.shuffle.skip","describe.runIf.shuffle.only","describe.runIf.shuffle.concurrent","describe.runIf.shuffle.sequential","describe.runIf.shuffle.todo","describe.runIf.todo.skip","describe.runIf.todo.only","describe.runIf.todo.concurrent","describe.runIf.todo.sequential","describe.runIf.todo.shuffle","describe.skip.only.each","describe.skip.concurrent.each","describe.skip.sequential.each","describe.skip.shuffle.each","describe.skip.todo.each","describe.only.skip.each","describe.only.concurrent.each","describe.only.sequential.each","describe.only.shuffle.each","describe.only.todo.each","describe.concurrent.skip.each","describe.concurrent.only.each","describe.concurrent.sequential.each","describe.concurrent.shuffle.each","describe.concurrent.todo.each","describe.sequential.skip.each","describe.sequential.only.each","describe.sequential.concurrent.each","describe.sequential.shuffle.each","describe.sequential.todo.each","describe.shuffle.skip.each","describe.shuffle.only.each","describe.shuffle.concurrent.each","describe.shuffle.sequential.each","describe.shuffle.todo.each","describe.todo.skip.each","describe.todo.only.each","describe.todo.concurrent.each","describe.todo.sequential.each","describe.todo.shuffle.each","describe.skipIf.skip.each","describe.skipIf.only.each","describe.skipIf.concurrent.each","describe.skipIf.sequential.each","describe.skipIf.shuffle.each","describe.skipIf.todo.each","describe.runIf.skip.each","describe.runIf.only.each","describe.runIf.concurrent.each","describe.runIf.sequential.each","describe.runIf.shuffle.each","describe.runIf.todo.each","suite","suite.skip","suite.only","suite.concurrent","suite.sequential","suite.shuffle","suite.todo","suite.skipIf","suite.runIf","suite.each","suite.skip.only","suite.skip.concurrent","suite.skip.sequential","suite.skip.shuffle","suite.skip.todo","suite.only.skip","suite.only.concurrent","suite.only.sequential","suite.only.shuffle","suite.only.todo","suite.concurrent.skip","suite.concurrent.only","suite.concurrent.sequential","suite.concurrent.shuffle","suite.concurrent.todo","suite.sequential.skip","suite.sequential.only","suite.sequential.concurrent","suite.sequential.shuffle","suite.sequential.todo","suite.shuffle.skip","suite.shuffle.only","suite.shuffle.concurrent","suite.shuffle.sequential","suite.shuffle.todo","suite.todo.skip","suite.todo.only","suite.todo.concurrent","suite.todo.sequential","suite.todo.shuffle","suite.skipIf.skip","suite.skipIf.only","suite.skipIf.concurrent","suite.skipIf.sequential","suite.skipIf.shuffle","suite.skipIf.todo","suite.runIf.skip","suite.runIf.only","suite.runIf.concurrent","suite.runIf.sequential","suite.runIf.shuffle","suite.runIf.todo","suite.skip.each","suite.only.each","suite.concurrent.each","suite.sequential.each","suite.shuffle.each","suite.todo.each","suite.skipIf.each","suite.runIf.each","suite.skip.only.concurrent","suite.skip.only.sequential","suite.skip.only.shuffle","suite.skip.only.todo","suite.skip.concurrent.only","suite.skip.concurrent.sequential","suite.skip.concurrent.shuffle","suite.skip.concurrent.todo","suite.skip.sequential.only","suite.skip.sequential.concurrent","suite.skip.sequential.shuffle","suite.skip.sequential.todo","suite.skip.shuffle.only","suite.skip.shuffle.concurrent","suite.skip.shuffle.sequential","suite.skip.shuffle.todo","suite.skip.todo.only","suite.skip.todo.concurrent","suite.skip.todo.sequential","suite.skip.todo.shuffle","suite.only.skip.concurrent","suite.only.skip.sequential","suite.only.skip.shuffle","suite.only.skip.todo","suite.only.concurrent.skip","suite.only.concurrent.sequential","suite.only.concurrent.shuffle","suite.only.concurrent.todo","suite.only.sequential.skip","suite.only.sequential.concurrent","suite.only.sequential.shuffle","suite.only.sequential.todo","suite.only.shuffle.skip","suite.only.shuffle.concurrent","suite.only.shuffle.sequential","suite.only.shuffle.todo","suite.only.todo.skip","suite.only.todo.concurrent","suite.only.todo.sequential","suite.only.todo.shuffle","suite.concurrent.skip.only","suite.concurrent.skip.sequential","suite.concurrent.skip.shuffle","suite.concurrent.skip.todo","suite.concurrent.only.skip","suite.concurrent.only.sequential","suite.concurrent.only.shuffle","suite.concurrent.only.todo","suite.concurrent.sequential.skip","suite.concurrent.sequential.only","suite.concurrent.sequential.shuffle","suite.concurrent.sequential.todo","suite.concurrent.shuffle.skip","suite.concurrent.shuffle.only","suite.concurrent.shuffle.sequential","suite.concurrent.shuffle.todo","suite.concurrent.todo.skip","suite.concurrent.todo.only","suite.concurrent.todo.sequential","suite.concurrent.todo.shuffle","suite.sequential.skip.only","suite.sequential.skip.concurrent","suite.sequential.skip.shuffle","suite.sequential.skip.todo","suite.sequential.only.skip","suite.sequential.only.concurrent","suite.sequential.only.shuffle","suite.sequential.only.todo","suite.sequential.concurrent.skip","suite.sequential.concurrent.only","suite.sequential.concurrent.shuffle","suite.sequential.concurrent.todo","suite.sequential.shuffle.skip","suite.sequential.shuffle.only","suite.sequential.shuffle.concurrent","suite.sequential.shuffle.todo","suite.sequential.todo.skip","suite.sequential.todo.only","suite.sequential.todo.concurrent","suite.sequential.todo.shuffle","suite.shuffle.skip.only","suite.shuffle.skip.concurrent","suite.shuffle.skip.sequential","suite.shuffle.skip.todo","suite.shuffle.only.skip","suite.shuffle.only.concurrent","suite.shuffle.only.sequential","suite.shuffle.only.todo","suite.shuffle.concurrent.skip","suite.shuffle.concurrent.only","suite.shuffle.concurrent.sequential","suite.shuffle.concurrent.todo","suite.shuffle.sequential.skip","suite.shuffle.sequential.only","suite.shuffle.sequential.concurrent","suite.shuffle.sequential.todo","suite.shuffle.todo.skip","suite.shuffle.todo.only","suite.shuffle.todo.concurrent","suite.shuffle.todo.sequential","suite.todo.skip.only","suite.todo.skip.concurrent","suite.todo.skip.sequential","suite.todo.skip.shuffle","suite.todo.only.skip","suite.todo.only.concurrent","suite.todo.only.sequential","suite.todo.only.shuffle","suite.todo.concurrent.skip","suite.todo.concurrent.only","suite.todo.concurrent.sequential","suite.todo.concurrent.shuffle","suite.todo.sequential.skip","suite.todo.sequential.only","suite.todo.sequential.concurrent","suite.todo.sequential.shuffle","suite.todo.shuffle.skip","suite.todo.shuffle.only","suite.todo.shuffle.concurrent","suite.todo.shuffle.sequential","suite.skipIf.skip.only","suite.skipIf.skip.concurrent","suite.skipIf.skip.sequential","suite.skipIf.skip.shuffle","suite.skipIf.skip.todo","suite.skipIf.only.skip","suite.skipIf.only.concurrent","suite.skipIf.only.sequential","suite.skipIf.only.shuffle","suite.skipIf.only.todo","suite.skipIf.concurrent.skip","suite.skipIf.concurrent.only","suite.skipIf.concurrent.sequential","suite.skipIf.concurrent.shuffle","suite.skipIf.concurrent.todo","suite.skipIf.sequential.skip","suite.skipIf.sequential.only","suite.skipIf.sequential.concurrent","suite.skipIf.sequential.shuffle","suite.skipIf.sequential.todo","suite.skipIf.shuffle.skip","suite.skipIf.shuffle.only","suite.skipIf.shuffle.concurrent","suite.skipIf.shuffle.sequential","suite.skipIf.shuffle.todo","suite.skipIf.todo.skip","suite.skipIf.todo.only","suite.skipIf.todo.concurrent","suite.skipIf.todo.sequential","suite.skipIf.todo.shuffle","suite.runIf.skip.only","suite.runIf.skip.concurrent","suite.runIf.skip.sequential","suite.runIf.skip.shuffle","suite.runIf.skip.todo","suite.runIf.only.skip","suite.runIf.only.concurrent","suite.runIf.only.sequential","suite.runIf.only.shuffle","suite.runIf.only.todo","suite.runIf.concurrent.skip","suite.runIf.concurrent.only","suite.runIf.concurrent.sequential","suite.runIf.concurrent.shuffle","suite.runIf.concurrent.todo","suite.runIf.sequential.skip","suite.runIf.sequential.only","suite.runIf.sequential.concurrent","suite.runIf.sequential.shuffle","suite.runIf.sequential.todo","suite.runIf.shuffle.skip","suite.runIf.shuffle.only","suite.runIf.shuffle.concurrent","suite.runIf.shuffle.sequential","suite.runIf.shuffle.todo","suite.runIf.todo.skip","suite.runIf.todo.only","suite.runIf.todo.concurrent","suite.runIf.todo.sequential","suite.runIf.todo.shuffle","suite.skip.only.each","suite.skip.concurrent.each","suite.skip.sequential.each","suite.skip.shuffle.each","suite.skip.todo.each","suite.only.skip.each","suite.only.concurrent.each","suite.only.sequential.each","suite.only.shuffle.each","suite.only.todo.each","suite.concurrent.skip.each","suite.concurrent.only.each","suite.concurrent.sequential.each","suite.concurrent.shuffle.each","suite.concurrent.todo.each","suite.sequential.skip.each","suite.sequential.only.each","suite.sequential.concurrent.each","suite.sequential.shuffle.each","suite.sequential.todo.each","suite.shuffle.skip.each","suite.shuffle.only.each","suite.shuffle.concurrent.each","suite.shuffle.sequential.each","suite.shuffle.todo.each","suite.todo.skip.each","suite.todo.only.each","suite.todo.concurrent.each","suite.todo.sequential.each","suite.todo.shuffle.each","suite.skipIf.skip.each","suite.skipIf.only.each","suite.skipIf.concurrent.each","suite.skipIf.sequential.each","suite.skipIf.shuffle.each","suite.skipIf.todo.each","suite.runIf.skip.each","suite.runIf.only.each","suite.runIf.concurrent.each","suite.runIf.sequential.each","suite.runIf.shuffle.each","suite.runIf.todo.each","xtest","xtest.each","xit","xit.each","fit","xdescribe","xdescribe.each","fdescribe"]);function getScope(q,$){return q.sourceCode.getScope?q.sourceCode.getScope($):q.getScope()}function getModuleScope(q,$){let Y=getScope(q,$);for(;Y;){if(Y.type==="module")return Y;Y=Y.upper}return Y}const isTypeOfVitestFnCall=(q,$,Y)=>{const B=parseVitestFnCall(q,$);return B!==null&&Y.includes(B.type)},parseVitestFnCall=(q,$)=>{const Y=parseVitestFnCallWithReason(q,$);return typeof Y=="string"?null:Y},y$4=new WeakMap,parseVitestFnCallWithReason=(q,$)=>{let Y=y$4.get(q);return Y||(Y=M$3(q,$),y$4.set(q,Y),Y)},A$3=q=>q==="expect"?"expect":q==="expectTypeOf"?"expectTypeOf":q==="vi"?"vi":q==="vitest"?"vitest":DescribeAlias.hasOwnProperty(q)?"describe":TestCaseName.hasOwnProperty(q)?"test":HookName.hasOwnProperty(q)?"hook":"unknown",w$2=q=>{const $=[];for(const Y of q){if(Y.parent?.type===utils.AST_NODE_TYPES.MemberExpression&&Y.parent.parent?.type===utils.AST_NODE_TYPES.CallExpression)return{matcher:Y,args:Y.parent.parent.arguments,modifiers:$};const B=getAccessorValue(Y);if($.length===0){if(!ModifierName.hasOwnProperty(B))return"modifier-unknown"}else if($.length===1){if(B!==ModifierName.not&&B!=ModifierName.have)return"modifier-unknown";const F=getAccessorValue($[0]);if(F!==ModifierName.resolves&&F!==ModifierName.rejects&&F!==ModifierName.to)return"modifier-unknown"}else return"modifier-unknown";$.push(Y)}return"matcher-not-found"},P$2=(q,$)=>{const Y=w$2(q.members);return typeof Y=="string"?Y:{...q,type:$,...Y}},findTopMostCallExpression=q=>{let $=q,{parent:Y}=q;for(;Y;){if(Y.type===utils.AST_NODE_TYPES.CallExpression){$=Y,Y=Y.parent;continue}if(Y.type!==utils.AST_NODE_TYPES.MemberExpression)break;Y=Y.parent}return $},M$3=(q,$)=>{const Y=getNodeChain(q);if(!Y?.length)return null;const[B,...F]=Y,W=getAccessorValue(Y[Y.length-1]);if(W==="each"&&q.callee.type!==utils.AST_NODE_TYPES.CallExpression&&q.callee.type!==utils.AST_NODE_TYPES.TaggedTemplateExpression||q.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression&&W!=="each")return null;const H=v($,q,getAccessorValue(B));if(!H)return null;const V=H.original??H.local,G=[V,...F.map(getAccessorValue)];if(H.type!=="testContext"&&V!=="vi"&&V!=="vitest"&&V!=="expect"&&V!=="expectTypeOf"&&!ValidVitestFnCallChains.has(G.join(".")))return null;const z={name:V,head:{...H,node:B},members:F},J=A$3(V);if(J==="expect"||J==="expectTypeOf"){const X=P$2(z,J);return typeof X=="string"&&findTopMostCallExpression(q)!==q?null:X==="matcher-not-found"&&q.parent?.type===utils.AST_NODE_TYPES.MemberExpression?"matcher-not-called":X}return Y.slice(0,Y.length-1).some(X=>X.parent?.type!==utils.AST_NODE_TYPES.MemberExpression)||q.parent?.type===utils.AST_NODE_TYPES.CallExpression||q.parent?.type===utils.AST_NODE_TYPES.MemberExpression?null:{...z,type:J}},k$1=(q,$)=>q&&$?[...q,...$]:null;function getNodeChain(q){if(isSupportedAccessor(q))return[q];switch(q.type){case utils.AST_NODE_TYPES.TaggedTemplateExpression:return getNodeChain(q.tag);case utils.AST_NODE_TYPES.MemberExpression:return k$1(getNodeChain(q.object),getNodeChain(q.property));case utils.AST_NODE_TYPES.CallExpression:return getNodeChain(q.callee)}return null}const v=(q,$,Y)=>{const B=getScope(q,$),F=resolveScope(B,Y);return F==="local"?null:F==="testContext"?{local:Y,original:null,type:"testContext"}:F?F.source==="vitest"?{original:F.imported,local:F.local,type:"import"}:null:{original:N$4(Y,q),local:Y,type:"global"}},N$4=(q,$)=>{const Y=$.settings.vitest?.globalAliases??{},B=Object.entries(Y).find(([F,W])=>W.includes(q));return B?B[0]:null},I$1=({parent:q})=>{if(q?.type===utils.AST_NODE_TYPES.CallExpression&&q.callee.type===utils.AST_NODE_TYPES.Identifier)return TestCaseName.hasOwnProperty(q.callee.name)},resolveScope=(q,$)=>{let Y=q;for(;Y!==null;){const B=Y.set.get($);if(B&&B.defs.length>0){const F=B.defs[B.defs.length-1],W=isFunction(F.node)?F.node.params.find(G=>G.type===utils.AST_NODE_TYPES.ObjectPattern):void 0;if(W){const G=W.properties.find(z=>z.type===utils.AST_NODE_TYPES.Property);if((G?.key.type===utils.AST_NODE_TYPES.Identifier?G.key:void 0)?.name===$)return"testContext"}const H=isFunction(F.node)?F.node.params.find(G=>G.type===utils.AST_NODE_TYPES.Identifier):void 0;if(H&&I$1(H.parent))return"testContext";const V=D$1(F);return V?.local===$?V:"local"}Y=Y.upper}return null},R=q=>q.type===utils.AST_NODE_TYPES.AwaitExpression?q.argument.type===utils.AST_NODE_TYPES.ImportExpression?q.argument.source:null:q.type===utils.AST_NODE_TYPES.CallExpression&&isIdentifier(q.callee,"require")?q.arguments[0]??null:null,O$2=q=>q.parent.type===utils.AST_NODE_TYPES.TSImportEqualsDeclaration||q.node.type!==utils.AST_NODE_TYPES.ImportSpecifier||q.node.imported.type!=utils.AST_NODE_TYPES.Identifier||q.parent.importKind==="type"?null:{source:q.parent.source.value,imported:q.node.imported.name,local:q.node.local.name},D$1=q=>q.type==="Variable"?L$1(q):q.type==="ImportBinding"?O$2(q):null,L$1=q=>{if(!q.node.init)return null;const $=R(q.node.init);return!$||!isStringNode($)||q.name.parent?.type!==utils.AST_NODE_TYPES.Property||!isSupportedAccessor(q.name.parent.key)?null:{source:getStringValue($),imported:getAccessorValue(q.name.parent.key),local:q.name.name}},getTestCallExpressionsFromDeclaredVariables=(q,$)=>q.reduce((Y,{references:B})=>Y.concat(B.map(({identifier:F})=>F.parent).filter(F=>F?.type===utils.AST_NODE_TYPES.CallExpression&&isTypeOfVitestFnCall(F,$,["test"]))),[]),getFirstMatcherArg=q=>{const[$]=q.args;return $.type===utils.AST_NODE_TYPES.SpreadElement?$:followTypeAssertionChain$1($)},K=q=>q.type===utils.AST_NODE_TYPES.TSAsExpression||q.type===utils.AST_NODE_TYPES.TSTypeAssertion,followTypeAssertionChain$1=q=>K(q)?followTypeAssertionChain$1(q.expression):q,RULE_NAME$18="prefer-lowercase-title",E$5=q=>q.arguments[0]&&isStringNode(q.arguments[0]),x$4=q=>{const $=[];return q.includes(DescribeAlias.describe)&&$.push(...Object.keys(DescribeAlias)),q.includes(TestCaseName.test)&&$.push(...Object.keys(TestCaseName).filter(Y=>Y.endsWith(TestCaseName.test))),q.includes(TestCaseName.it)&&$.push(...Object.keys(TestCaseName).filter(Y=>Y.endsWith(TestCaseName.it))),$},ge=createEslintRule({name:RULE_NAME$18,meta:{type:"problem",docs:{description:"enforce lowercase titles",recommended:!1},fixable:"code",messages:{lowerCaseTitle:"`{{ method }}`s should begin with lowercase",fullyLowerCaseTitle:"`{{ method }}`s should be lowercase"},schema:[{type:"object",properties:{ignore:{type:"array",items:{type:"string",enum:[DescribeAlias.describe,TestCaseName.test,TestCaseName.it]}},allowedPrefixes:{type:"array",items:{type:"string"},additionalItems:!1},ignoreTopLevelDescribe:{type:"boolean",default:!1},lowercaseFirstCharacterOnly:{type:"boolean",default:!0}},additionalProperties:!1}]},defaultOptions:[{ignore:[],allowedPrefixes:[],ignoreTopLevelDescribe:!1,lowercaseFirstCharacterOnly:!0}],create:(q,[{ignore:$=[],allowedPrefixes:Y=[],ignoreTopLevelDescribe:B=!1,lowercaseFirstCharacterOnly:F=!1}])=>{const W=x$4($);let H=0;return{CallExpression(V){const G=parseVitestFnCall(V,q);if(!G||!E$5)return;if(G?.type==="describe"){if(H++,B&&H===1)return}else if(G?.type!=="test")return;const[z]=V.arguments,J=getStringValue(z);if(typeof J!="string"||Y.some(ee=>J.startsWith(ee)))return;const X=J.charAt(0);W.includes(G.name)||F&&(!X||X===X.toLowerCase())||!F&&J===J.toLowerCase()||q.report({messageId:F?"lowerCaseTitle":"fullyLowerCaseTitle",node:V.arguments[0],data:{method:G.name},fix:ee=>{const Q=getStringValue(z),se=[z.range[0]+1,z.range[1]-1],Z=F?Q.substring(0,1).toLowerCase()+Q.substring(1):Q.toLowerCase();return[ee.replaceTextRange(se,Z)]}})},"CallExpression:exit"(V){isTypeOfVitestFnCall(V,q,["describe"])&&H--}}}}),RULE_NAME$17="max-nested-describe",ke=createEslintRule({name:RULE_NAME$17,meta:{type:"problem",docs:{description:"require describe block to be less than set max value or default value",recommended:!1},schema:[{type:"object",properties:{max:{type:"number"}},additionalProperties:!1}],messages:{maxNestedDescribe:"Nested describe block should be less than set max value"}},defaultOptions:[{max:5}],create(q,[{max:$}]){const Y=[];function B(W){W.parent?.type==="CallExpression"&&(W.parent.callee.type!=="Identifier"||W.parent.callee.name!=="describe"||(Y.push(0),Y.length>$&&q.report({node:W.parent,messageId:"maxNestedDescribe"})))}function F(W){W.parent?.type==="CallExpression"&&(W.parent.callee.type!=="Identifier"||W.parent.callee.name!=="describe"||Y.pop())}return{FunctionExpression:B,"FunctionExpression:exit":F,ArrowFunctionExpression:B,"ArrowFunctionExpression:exit":F}}}),RULE_NAME$16="no-identical-title",c$4=()=>({describeTitles:[],testTitles:[]}),xe=createEslintRule({name:RULE_NAME$16,meta:{type:"problem",docs:{description:"disallow identical titles",recommended:!1},fixable:"code",schema:[],messages:{multipleTestTitle:"Test is used multiple times in the same describe(suite) block",multipleDescribeTitle:"Describe is used multiple times in the same describe(suite) block"}},defaultOptions:[],create(q){const $=[c$4()];return{CallExpression(Y){const B=$[$.length-1],F=parseVitestFnCall(Y,q);if(!F||((F.name==="describe"||F.name==="suite")&&$.push(c$4()),F.members.find(V=>isSupportedAccessor(V,"each"))))return;const[W]=Y.arguments;if(!W||!isStringNode(W))return;const H=getStringValue(W);F.type==="test"&&(B?.testTitles.includes(H)&&q.report({node:Y,messageId:"multipleTestTitle"}),B?.testTitles.push(H)),F.type==="describe"&&(B?.describeTitles.includes(H)&&q.report({node:Y,messageId:"multipleDescribeTitle"}),B?.describeTitles.push(H))},"CallExpression:exit"(Y){isTypeOfVitestFnCall(Y,q,["describe"])&&$.pop()}}}}),RULE_NAME$15="no-focused-tests",n$2=q=>q.type==="Identifier"&&["it","test","describe"].includes(q.name),a$7=q=>q.type==="Identifier"&&q.name==="only",ve=createEslintRule({name:RULE_NAME$15,meta:{type:"problem",docs:{description:"disallow focused tests",recommended:!1},fixable:"code",schema:[{type:"object",properties:{fixable:{type:"boolean",default:!0}},additionalProperties:!1}],messages:{noFocusedTests:"Focused tests are not allowed"}},defaultOptions:[{fixable:!0}],create:q=>{const $=q.options[0]?.fixable;return{ExpressionStatement(Y){if(Y.expression.type==="CallExpression"){const{callee:B}=Y.expression;if(B.type==="MemberExpression"&&n$2(B.object)&&a$7(B.property)&&q.report({node:B.property,messageId:"noFocusedTests",fix:F=>$?F.removeRange([B.property.range[0]-1,B.property.range[1]]):null}),B.type==="TaggedTemplateExpression"){const F=B.tag.type==="MemberExpression"?B.tag.object:null;if(!F)return;F.type==="MemberExpression"&&n$2(F.object)&&a$7(F.property)&&q.report({node:F.property,messageId:"noFocusedTests",fix:W=>$?W.removeRange([F.property.range[0]-1,F.property.range[1]]):null})}}},CallExpression(Y){if(Y.callee.type==="CallExpression"){const{callee:B}=Y.callee;if(B.type==="MemberExpression"&&B.object.type==="MemberExpression"&&n$2(B.object.object)&&a$7(B.object.property)&&B.property.type==="Identifier"&&B.property.name==="each"){const F=B.object.property;q.report({node:B.object.property,messageId:"noFocusedTests",fix:W=>$?W.removeRange([F.range[0]-1,F.range[1]]):null})}}}}}}),RULE_NAME$14="no-conditional-tests",Ce=createEslintRule({name:RULE_NAME$14,meta:{type:"problem",docs:{description:"disallow conditional tests",recommended:!1},schema:[],messages:{noConditionalTests:"Avoid using if conditions in a test"}},defaultOptions:[],create(q){return{Identifier:function($){["test","it","describe"].includes($.name)&&$.parent?.parent?.parent?.parent?.type==="IfStatement"&&q.report({node:$,messageId:"noConditionalTests"})}}}}),i$2={typecheck:!1};function parsePluginSettings(q){const $=typeof q.vitest!="object"||q.vitest===null?{}:q.vitest;return{...i$2,...$}}const RULE_NAME$13="expect-expect",Be=createEslintRule({name:RULE_NAME$13,meta:{type:"suggestion",docs:{description:"enforce having expectation in test body",recommended:!1},schema:[{type:"object",properties:{assertFunctionNames:{type:"array",items:{type:"string"}},additionalTestBlockFunctions:{type:"array",items:{type:"string"}}},additionalProperties:!1}],messages:{noAssertions:"Test has no assertions"}},defaultOptions:[{assertFunctionNames:["expect","assert"],additionalTestBlockFunctions:[]}],create(q,[{assertFunctionNames:$=["expect"],additionalTestBlockFunctions:Y=[]}]){const B=[];parsePluginSettings(q.settings).typecheck&&$.push("expectTypeOf","assertType");const F=$.map(x$3);function W(H){for(const V of H){const G=V.type===utils.AST_NODE_TYPES.CallExpression?B.indexOf(V):-1;if(V.type===utils.AST_NODE_TYPES.FunctionDeclaration){const z=q.sourceCode.getDeclaredVariables(V),J=getTestCallExpressionsFromDeclaredVariables(z,q);W(J)}if(G!==-1){B.splice(G,1);break}}}return{CallExpression(H){if(H.callee.type===utils.AST_NODE_TYPES.Identifier&&H.callee.name==="bench"||H?.callee?.type===utils.AST_NODE_TYPES.MemberExpression&&H.callee.property.type===utils.AST_NODE_TYPES.Identifier&&H.callee.property.name==="extend"||H?.callee?.type===utils.AST_NODE_TYPES.MemberExpression&&H.callee.property.type===utils.AST_NODE_TYPES.Identifier&&H.callee.property.name==="skip")return;const V=getNodeName(H)??"";if(isTypeOfVitestFnCall(H,q,["test"])||Y.includes(V)){if(H.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(H.callee.property,"todo"))return;B.push(H)}else F.some(G=>G.test(V))&&W(q.sourceCode.getAncestors(H))},"Program:exit"(){B.forEach(H=>{q.report({node:H.callee,messageId:"noAssertions"})})}}}});function x$3(q){const $=q.split(".").map(Y=>Y==="**"?"[_a-z\\d\\.]*":Y.replace(/\*/gu,"[a-z\\d]*"));return new RegExp(`^${$.join("\\.")}(\\.|$)`,"ui")}const RULE_NAME$12="hoisted-apis-on-top",a$6=["mock","hoisted","unmock"],ye=createEslintRule({name:RULE_NAME$12,meta:{hasSuggestions:!0,type:"suggestion",docs:{description:"enforce hoisted APIs to be on top of the file"},messages:{hoistedApisOnTop:"Hoisted API is used in a runtime location in this file, but it is actually executed before this file is loaded.",suggestMoveHoistedApiToTop:"Move this hoisted API to the top of the file to better reflect its behavior.",suggestReplaceMockWithDoMock:"Replace 'vi.mock()' with 'vi.doMock()', which is not hoisted."},schema:[]},defaultOptions:[],create(q){let $=null;const Y=[];return{ImportDeclaration(B){B.parent.type==="Program"&&($=B.range[1])},CallExpression(B){if(!(B.parent.type==="ExpressionStatement"&&B.parent.parent.type==="Program")&&B.callee.type==="MemberExpression"){const{object:F,property:W}=B.callee;F.type==="Identifier"&&F.name==="vi"&&W.type==="Identifier"&&a$6.includes(W.name)&&Y.push(B)}},"Program:exit"(){for(const B of Y){const F=[];F.push({messageId:"suggestMoveHoistedApiToTop",*fix(H){B.parent.type==="ExpressionStatement"?yield H.remove(B):yield H.replaceText(B,"undefined"),$!=null?yield H.insertTextAfterRange([$,$],`
`+q.sourceCode.getText(B)+";"):yield H.insertTextAfterRange([0,0],q.sourceCode.getText(B)+`;
`)}});const W=B.callee.property;W.name==="mock"&&F.push({messageId:"suggestReplaceMockWithDoMock",fix(H){return H.replaceText(W,"doMock")}}),q.report({node:B,messageId:"hoistedApisOnTop",suggest:F})}}}}}),RULE_NAME$11="consistent-test-it",g$2=(q,$,Y)=>B=>[B.replaceText(q.type===utils.AST_NODE_TYPES.MemberExpression?q.object:q,E$4($,Y))];function E$4(q,$){return q===TestCaseName.fit?"test.only":q.startsWith("f")||q.startsWith("x")?q.charAt(0)+$:$}function u$4(q){return q===TestCaseName.test?TestCaseName.it:TestCaseName.test}const Ie=createEslintRule({name:RULE_NAME$11,meta:{type:"suggestion",fixable:"code",docs:{description:"enforce using test or it but not both",recommended:!1},messages:{consistentMethod:"Prefer using {{ testFnKeyWork }} instead of {{ oppositeTestKeyword }}",consistentMethodWithinDescribe:"Prefer using {{ testKeywordWithinDescribe }} instead of {{ oppositeTestKeyword }} within describe"},schema:[{type:"object",properties:{fn:{type:"string",enum:[TestCaseName.test,TestCaseName.it]},withinDescribe:{type:"string",enum:[TestCaseName.test,TestCaseName.it]}},additionalProperties:!1}]},defaultOptions:[{fn:TestCaseName.test,withinDescribe:TestCaseName.it}],create(q){const $=q.options[0]??{},Y=$.fn||TestCaseName.test,B=$?.withinDescribe||$?.fn||TestCaseName?.it,F=Y===B?Y:void 0;let W=0;return{ImportDeclaration(H){if(F==null||H.source.type!=="Literal"||H.source.value!=="vitest")return;const V=u$4(F);for(const G of H.specifiers)G.type==="ImportSpecifier"&&G.imported.type==="Identifier"&&G.local.name===G.imported.name&&G.local.name===V&&q.report({node:G,data:{testFnKeyWork:Y,oppositeTestKeyword:V},messageId:"consistentMethod",fix:z=>{const J=H.specifiers.filter(X=>X.local.name!==V);if(J.length>0){const X=J.map(Q=>Q.local.name).join(", "),ee=H.specifiers.at(-1)?.range;return ee?z.replaceTextRange([H.specifiers[0].range[0],ee[1]],X):null}return z.replaceText(G.local,F)}})},CallExpression(H){if(H.callee.type===utils.AST_NODE_TYPES.Identifier&&H.callee.name==="bench")return;const V=parseVitestFnCall(H,q);if(!V)return;if(V.type==="describe"){W++;return}const G=H.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression?H.callee.tag:H.callee.type===utils.AST_NODE_TYPES.CallExpression?H.callee.callee:H.callee;if(V.type==="test"&&W===0&&!V.name.endsWith(Y)){const z=u$4(Y);q.report({node:H.callee,data:{testFnKeyWork:Y,oppositeTestKeyword:z},messageId:"consistentMethod",fix:g$2(G,V.name,Y)})}else if(V.type==="test"&&W>0&&!V.name.endsWith(B)){const z=u$4(B);q.report({messageId:"consistentMethodWithinDescribe",node:H.callee,data:{testKeywordWithinDescribe:B,oppositeTestKeyword:z},fix:g$2(G,V.name,B)})}},"CallExpression:exit"(H){isTypeOfVitestFnCall(H,q,["describe"])&&W--}}}}),RULE_NAME$10="consistent-vitest-vi",d=q=>q===UtilName.vi?UtilName.vitest:UtilName.vi,Se=createEslintRule({name:RULE_NAME$10,meta:{type:"suggestion",fixable:"code",docs:{description:"enforce using vitest or vi but not both",recommended:!1},messages:{consistentUtil:"Prefer using {{ utilKeyword }} instead of {{ oppositeUtilKeyword }}"},schema:[{type:"object",properties:{fn:{type:"string",enum:[UtilName.vi,UtilName.vitest]}},additionalProperties:!1}]},defaultOptions:[{fn:UtilName.vi}],create(q){const $=(q.options[0]??{}).fn||UtilName.vi,Y=d($);return{ImportDeclaration(B){if(!(B.source.type!==utils.AST_NODE_TYPES.Literal||B.source.value!=="vitest"))for(const F of B.specifiers)F.type===utils.AST_NODE_TYPES.ImportSpecifier&&F.imported.type===utils.AST_NODE_TYPES.Identifier&&F.local.name===F.imported.name&&F.imported.name===Y&&q.report({node:F,messageId:"consistentUtil",data:{utilKeyword:$,oppositeUtilKeyword:Y},fix:W=>{const H=B.specifiers.filter(V=>V.local.name!==Y);if(H.length>0){const V=H.map(z=>z.local.name).join(", "),G=B.specifiers.at(-1)?.range;return G?W.replaceTextRange([B.specifiers[0].range[0],G[1]],V):null}return W.replaceText(F.local,$)}})},CallExpression(B){if(parseVitestFnCall(B,q)?.type!==Y)return;const F=B.callee.type===utils.AST_NODE_TYPES.MemberExpression?B.callee.object:B.callee;q.report({node:F,data:{utilKeyword:$,oppositeUtilKeyword:Y},messageId:"consistentUtil",fix:W=>W.replaceText(F,$)})}}}}),RULE_NAME$$="prefer-to-be",E$3=q=>q.type===utils.AST_NODE_TYPES.Literal&&q.value===null,N$3=q=>E$3(getFirstMatcherArg(q)),c$3=(q,$)=>isIdentifier(getFirstMatcherArg(q),$),h$2=q=>Math.floor(q)!==Math.ceil(q),y$3=q=>{let $=getFirstMatcherArg(q);return $.type===utils.AST_NODE_TYPES.Literal&&typeof $.value=="number"&&h$2($.value)?!1:($.type===utils.AST_NODE_TYPES.UnaryExpression&&$.operator==="-"&&($=$.argument),$.type===utils.AST_NODE_TYPES.Literal?!("regex"in $):$.type===utils.AST_NODE_TYPES.TemplateLiteral)},o$2=(q,$,Y,B,F)=>{q.report({messageId:`useToBe${$}`,fix(W){const H=[replaceAccessorFixer(W,Y.matcher,`toBe${$}`)];return Y.args?.length&&$!==""&&H.push(removeExtraArgumentsFixer(W,q,B,0)),F&&H.push(W.removeRange([F.range[0]-1,F.range[1]])),H},node:Y.matcher})},Oe=createEslintRule({name:RULE_NAME$$,meta:{type:"suggestion",docs:{description:"enforce using toBe()",recommended:!1},schema:[],fixable:"code",messages:{useToBe:"Use `toBe` instead",useToBeUndefined:"Use `toBeUndefined()` instead",useToBeDefined:"Use `toBeDefined()` instead",useToBeNull:"Use `toBeNull()` instead",useToBeNaN:"Use `toBeNaN()` instead"}},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect")return;const B=getAccessorValue(Y.matcher),F=Y.modifiers.find(W=>getAccessorValue(W)==="not");if(F&&["toBeUndefined","toBeDefined"].includes(B)){o$2(q,B==="toBeDefined"?"Undefined":"Defined",Y,$,F);return}if(!(!EqualityMatcher.hasOwnProperty(B)||Y.args.length===0)){if(N$3(Y)){o$2(q,"Null",Y,$);return}if(c$3(Y,"undefined")){o$2(q,F?"Defined":"Undefined",Y,$);return}if(c$3(Y,"NaN")){o$2(q,"NaN",Y,$);return}y$3(Y)&&B!==EqualityMatcher.toBe&&o$2(q,"",Y,$)}}}}}),RULE_NAME$_="no-hooks",De=createEslintRule({name:RULE_NAME$_,meta:{type:"suggestion",docs:{description:"disallow setup and teardown hooks",recommended:!1},schema:[{type:"object",properties:{allow:{type:"array",contains:["beforeAll","beforeEach","afterAll","afterEach"]}},additionalProperties:!1}],messages:{unexpectedHook:"Unexpected '{{ hookName }}' hook"}},defaultOptions:[{allow:[]}],create(q,[{allow:$=[]}]){return{CallExpression(Y){const B=parseVitestFnCall(Y,q);B?.type==="hook"&&!$.includes(B.name)&&q.report({node:Y,messageId:"unexpectedHook",data:{hookName:B.name}})}}}}),RULE_NAME$Z="no-restricted-vi-methods",He=createEslintRule({name:RULE_NAME$Z,meta:{type:"suggestion",docs:{description:"disallow specific `vi.` methods",recommended:!1},schema:[{type:"object",additionalProperties:{type:["string","null"]}}],messages:{restrictedViMethod:"Use of `{{ restriction }}` is disallowed",restrictedViMethodWithMessage:"{{ message }}"}},defaultOptions:[{}],create(q,[$]){return{CallExpression(Y){const B=parseVitestFnCall(Y,q);if(B?.type!=="vi"||B.members.length===0)return;const F=getAccessorValue(B.members[0]);if(F in $){const W=$[F];q.report({messageId:W?"restrictedViMethodWithMessage":"restrictedViMethod",data:{message:W,restriction:F},loc:{start:B.members[0].loc.start,end:B.members[B.members.length-1].loc.end}})}}}}}),RULE_NAME$Y="consistent-test-filename",o$1=/.*\.test\.[tj]sx?$/,e=/.*\.(test|spec)\.[tj]sx?$/,qe=createEslintRule({name:RULE_NAME$Y,meta:{type:"problem",docs:{recommended:!1,requiresTypeChecking:!1,description:"require .spec test file pattern"},messages:{consistentTestFilename:"Use test file name pattern {{ pattern }}"},schema:[{type:"object",additionalProperties:!1,properties:{pattern:{format:"regex",default:o$1.source},allTestPattern:{format:"regex",default:e.source}}}]},defaultOptions:[{pattern:e.source,allTestPattern:e.source}],create:q=>{const $=q.options[0]??{},{pattern:Y=o$1,allTestPattern:B=e}=$,F=typeof Y=="string"?new RegExp(Y):Y,W=typeof B=="string"?new RegExp(B):B,{filename:H}=q;return W.test(H)?{Program:V=>{F.test(H)||q.report({node:V,messageId:"consistentTestFilename",data:{pattern:F.source}})}}:{}}}),RULE_NAME$X="max-expects",Fe=createEslintRule({name:RULE_NAME$X,meta:{docs:{requiresTypeChecking:!1,recommended:!1,description:"enforce a maximum number of expect per test"},messages:{maxExpect:"Too many assertion calls ({{ count }}) - maximum allowed is {{ max }}"},type:"suggestion",schema:[{type:"object",properties:{max:{type:"number"}},additionalProperties:!1}]},defaultOptions:[{max:5}],create(q,[{max:$}]){let Y=0;const B=F=>{(F.parent?.type!==utils.AST_NODE_TYPES.CallExpression||isTypeOfVitestFnCall(F.parent,q,["test"]))&&(Y=0)};return{FunctionExpression:B,"FunctionExpression:exit":B,ArrowFunctionExpression:B,"ArrowFunctionExpression:exit":B,CallExpression(F){const W=parseVitestFnCall(F,q);W?.type!=="expect"||W.head.node.parent?.type===utils.AST_NODE_TYPES.MemberExpression||(Y+=1,Y>$&&q.report({node:F,messageId:"maxExpect",data:{count:Y,max:$}}))}}}}),RULE_NAME$W="no-alias-methods",Ve=createEslintRule({name:RULE_NAME$W,meta:{docs:{description:"disallow alias methods",requiresTypeChecking:!1,recommended:!1},messages:{noAliasMethods:"Replace {{ alias }}() with its canonical name {{ canonical }}()"},type:"suggestion",fixable:"code",schema:[]},defaultOptions:[],create(q){const $={toBeCalled:"toHaveBeenCalled",toBeCalledTimes:"toHaveBeenCalledTimes",toBeCalledWith:"toHaveBeenCalledWith",lastCalledWith:"toHaveBeenLastCalledWith",nthCalledWith:"toHaveBeenNthCalledWith",toReturn:"toHaveReturned",toReturnTimes:"toHaveReturnedTimes",toReturnWith:"toHaveReturnedWith",lastReturnedWith:"toHaveLastReturnedWith",nthReturnedWith:"toHaveNthReturnedWith",toThrowError:"toThrow"};return{CallExpression(Y){const B=parseVitestFnCall(Y,q);if(B?.type!=="expect")return;const{matcher:F}=B,W=getAccessorValue(F);if(W in $){const H=$[W];q.report({messageId:"noAliasMethods",data:{alias:W,canonical:H},node:F,fix:V=>[replaceAccessorFixer(V,F,H)]})}}}}}),RULE_NAME$V="no-commented-out-tests";function n$1(q){return/^\s*[xf]?(test|it|describe)(\.\w+|\[['"]\w+['"]\])?\s*\(/mu.test(q.value)}const Pe=createEslintRule({name:RULE_NAME$V,meta:{docs:{description:"disallow commented out tests",requiresTypeChecking:!1,recommended:!1},messages:{noCommentedOutTests:"Remove commented out tests - you may want to use `skip` or `only` instead"},schema:[],type:"suggestion"},defaultOptions:[],create(q){const{sourceCode:$}=q;function Y(B){n$1(B)&&q.report({messageId:"noCommentedOutTests",node:B})}return{Program(){$.getAllComments().forEach(Y)}}}}),RULE_NAME$U="no-conditional-expect",r=q=>q.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(q.callee.property,"catch"),Ge=createEslintRule({name:RULE_NAME$U,meta:{type:"problem",docs:{description:"disallow conditional expects",requiresTypeChecking:!1,recommended:!1},messages:{noConditionalExpect:"Avoid calling `expect` inside conditional statements"},schema:[]},defaultOptions:[],create(q){let $=0,Y=!1,B=!1;const F=()=>Y&&$++,W=()=>Y&&$--;return{FunctionDeclaration(H){const V=q.sourceCode.getDeclaredVariables(H);getTestCallExpressionsFromDeclaredVariables(V,q).length>0&&(Y=!0)},CallExpression(H){const{type:V}=parseVitestFnCall(H,q)??{};V==="test"&&(Y=!0),r(H)&&(B=!0),Y&&V==="expect"&&$>0&&q.report({messageId:"noConditionalExpect",node:H}),B&&V==="expect"&&q.report({messageId:"noConditionalExpect",node:H})},"CallExpression:exit"(H){isTypeOfVitestFnCall(H,q,["test"])&&(Y=!1),r(H)&&(B=!1)},CatchClause:F,"CatchClause:exit":W,IfStatement:F,"IfStatement:exit":W,SwitchStatement:F,"SwitchStatement:exit":W,ConditionalExpression:F,"ConditionalExpression:exit":W,LogicalExpression:F,"LogicalExpression:exit":W}}}),RULE_NAME$T="no-import-node-test",je=createEslintRule({name:RULE_NAME$T,meta:{docs:{description:"disallow importing `node:test`",recommended:!1},type:"suggestion",messages:{noImportNodeTest:"Import from `vitest` instead of `node:test`"},fixable:"code",schema:[]},defaultOptions:[],create(q){return{ImportDeclaration($){$.source.value==="node:test"&&q.report({messageId:"noImportNodeTest",node:$,fix:Y=>Y.replaceText($.source,$.source.raw.replace("node:test","vitest"))})}}}}),VITEST_GLOBALS=new Set(["suite","test","chai","describe","it","expectTypeOf","assertType","expect","assert","vitest","vi","beforeAll","afterAll","beforeEach","afterEach","onTestFailed","onTestFinished"]),isVitestImport=q=>q.source.value==="vitest",isVitestGlobalsImportSpecifier=q=>q.type===utils.AST_NODE_TYPES.ImportSpecifier&&q.imported.type===utils.AST_NODE_TYPES.Identifier&&VITEST_GLOBALS.has(q.imported.name),isVitestGlobalsProperty=q=>q.type===utils.AST_NODE_TYPES.Property&&q.key.type===utils.AST_NODE_TYPES.Identifier&&VITEST_GLOBALS.has(q.key.name),isVitestGlobalsFunction=q=>q.callee.type===utils.AST_NODE_TYPES.Identifier&&VITEST_GLOBALS.has(q.callee.name),isRequireVitestCall=q=>{if(q?.type!==utils.AST_NODE_TYPES.CallExpression||q.callee.type!==utils.AST_NODE_TYPES.Identifier||q.callee.name!=="require")return!1;const $=q.arguments;return $.length===1&&$[0].type===utils.AST_NODE_TYPES.Literal&&$[0].value==="vitest"},isObjectPattern=q=>q.type===utils.AST_NODE_TYPES.ObjectPattern,removeVariableDeclarator=(q,$)=>{const Y=$.parent,B=Y.declarations;if(B.length===1)return q.remove(Y);const F=B.findIndex(W=>W.range[0]===$.range[0]&&W.range[1]===$.range[1]);if(F===0){const W=B[1];return q.removeRange([$.range[0],W.range[0]])}else{const W=B[F-1];return q.removeRange([W.range[1],$.range[1]])}},removeNodeFromArray=(q,$,Y)=>{const B=$.indexOf(Y);if(B===-1)throw new Error("Target node not found in nodes array");if(B===0){const F=$[1];return q.removeRange([Y.range[0],F.range[0]])}else{const F=$[B-1];return q.removeRange([F.range[1],Y.range[1]])}},RULE_NAME$S="no-importing-vitest-globals",Ke=createEslintRule({name:RULE_NAME$S,meta:{type:"suggestion",docs:{description:"disallow importing Vitest globals",recommended:!1},messages:{noImportingVitestGlobals:"Do not import '{{name}}' from 'vitest'. Use globals configuration instead.",noRequiringVitestGlobals:"Do not require '{{name}}' from 'vitest'. Use globals configuration instead."},fixable:"code",schema:[]},defaultOptions:[],create(q){return{ImportDeclaration($){if(!isVitestImport($))return;const Y=$.specifiers;for(const B of Y)isVitestGlobalsImportSpecifier(B)&&q.report({node:B,messageId:"noImportingVitestGlobals",data:{name:B.imported.name},fix(F){return Y.every(W=>isVitestGlobalsImportSpecifier(W))?F.remove($):removeNodeFromArray(F,Y,B)}})},VariableDeclarator($){if(!isRequireVitestCall($.init)||!isObjectPattern($.id))return;const Y=$.id.properties;for(const B of Y)isVitestGlobalsProperty(B)&&q.report({node:B,messageId:"noRequiringVitestGlobals",data:{name:B.key.name},fix(F){return Y.every(W=>isVitestGlobalsProperty(W))?removeVariableDeclarator(F,$):removeNodeFromArray(F,Y,B)}})}}}}),RULE_NAME$R="prefer-importing-vitest-globals",$e=createEslintRule({name:RULE_NAME$R,meta:{type:"suggestion",docs:{description:"enforce importing Vitest globals",recommended:!1},messages:{preferImportingVitestGlobals:"Import '{{name}}' from 'vitest'"},schema:[],fixable:"code"},defaultOptions:[],create(q){const $=new Set;let Y,B;return{ImportDeclaration(F){if(!isVitestImport(F))return;const W=F.specifiers;for(const H of W)if(isVitestGlobalsImportSpecifier(H)){const V=H.imported.name;$.add(V)}Y=F.specifiers},VariableDeclarator(F){if(!isRequireVitestCall(F.init)||!isObjectPattern(F.id))return;const W=F.id.properties;for(const H of W)if(isVitestGlobalsProperty(H)){const V=H.key.name;$.add(V)}B=W},CallExpression(F){if(!isVitestGlobalsFunction(F))return;const W=F.callee.name;if($.has(W))return;const H=q.sourceCode.getScope(F).set.get(W);H&&H.defs.length>0&&H.defs.some(V=>!(V.type==="ImportBinding"||V.type==="Variable"&&V.node.init&&isRequireVitestCall(V.node.init)))||q.report({node:F.callee,messageId:"preferImportingVitestGlobals",data:{name:W},fix(V){const G=q.sourceCode.ast;if(!Y)if(B){const X=B[B.length-1];return V.insertTextAfter(X,`, ${W}`)}else return V.insertTextBefore(G.body[0],`import { ${W} } from 'vitest';
`);if(Y.find(X=>X.type==="ImportNamespaceSpecifier"))return V.insertTextBefore(G.body[0],`import { ${W} } from 'vitest';
`);const z=Y.find(X=>X.type==="ImportDefaultSpecifier");if(z)return V.insertTextAfter(z,`, { ${W} }`);const J=Y[Y.length-1];return V.insertTextAfter(J,`, ${W}`)}})}}}}),RULE_NAME$Q="no-conditional-in-test",We=createEslintRule({name:RULE_NAME$Q,meta:{docs:{description:"disallow conditional tests",requiresTypeChecking:!1,recommended:!1},messages:{noConditionalInTest:"Remove conditional tests"},schema:[],type:"problem"},defaultOptions:[],create(q){return{IfStatement($){$.parent?.parent?.parent?.type==="CallExpression"&&isTypeOfVitestFnCall($.parent?.parent?.parent,q,["test","it"])&&q.report({messageId:"noConditionalInTest",node:$})}}}}),RULE_NAME$P="no-disabled-tests",ze=createEslintRule({name:RULE_NAME$P,meta:{type:"suggestion",docs:{description:"disallow disabled tests",recommended:!1},messages:{missingFunction:"Test is missing function argument",pending:"Call to pending()",pendingSuite:"Call to pending() within test suite",pendingTest:"Call to pending() within test",disabledSuite:"Disabled test suite - if you want to skip a test suite temporarily, use .todo() instead",disabledTest:"Disabled test - if you want to skip a test temporarily, use .todo() instead"},schema:[]},defaultOptions:[],create(q){let $=0,Y=0;return{CallExpression(B){const F=parseVitestFnCall(B,q);if(!F)return;F.type==="describe"&&$++,F.type==="test"&&(Y++,B.arguments.length<2&&F.members.every(H=>getAccessorValue(H)==="skip")&&q.report({messageId:"missingFunction",node:B}));const W=F.members.find(H=>getAccessorValue(H)==="skip");(F.name.startsWith("x")||W!==void 0)&&q.report({messageId:F.type==="describe"?"disabledSuite":"disabledTest",node:W??F.head.node})},"CallExpression:exit"(B){const F=parseVitestFnCall(B,q);F&&(F.type==="describe"&&$--,F.type==="test"&&Y--)},'CallExpression[callee.name="pending"]'(B){const F=getScope(q,B);resolveScope(F,"pending")||(Y>0?q.report({messageId:"pendingTest",node:B}):$>0?q.report({messageId:"pendingSuite",node:B}):q.report({messageId:"pending",node:B}))}}}}),RULE_NAME$O="no-done-callback",P$1=(q,$,Y)=>{if($)return q.arguments[1];const B=parseVitestFnCall(q,Y);return B?.type==="hook"&&q.arguments.length>=1?q.arguments[0]:B?.type==="test"&&q.arguments.length>=2?q.arguments[1]:null},Je=createEslintRule({name:RULE_NAME$O,meta:{type:"suggestion",docs:{description:"disallow using a callback in asynchronous tests and hooks",recommended:!1},deprecated:!0,schema:[],messages:{noDoneCallback:"Return a promise instead of relying on callback parameter",suggestWrappingInPromise:"Wrap in `new Promise({{ callback }} => ...`",useAwaitInsteadOfCallback:"Use `await` instead of callback in async function"},hasSuggestions:!0},defaultOptions:[],create(q){return{CallExpression($){const Y=/\.each$|\.concurrent$/.test(getNodeName($.callee)??"");if(Y&&$.callee.type!==utils.AST_NODE_TYPES.TaggedTemplateExpression||q.sourceCode.getAncestors($).some(H=>H.type!==utils.AST_NODE_TYPES.CallExpression||!isTypeOfVitestFnCall(H,q,["describe","test"])?!1:H.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(H.callee.property,"concurrent")))return;const B=P$1($,Y,q),F=Number(Y);if(!B||!isFunction(B)||B.params.length!==1+F)return;const W=B.params[F];if(W.type!==utils.AST_NODE_TYPES.Identifier){q.report({node:W,messageId:"noDoneCallback"});return}if(B.async){q.report({node:W,messageId:"useAwaitInsteadOfCallback"});return}q.report({node:$,messageId:"noDoneCallback",suggest:[{messageId:"suggestWrappingInPromise",data:{callback:W.name},fix(H){const{body:V,params:G}=B,{sourceCode:z}=q,J=z.getFirstToken(V),X=z.getLastToken(V),[ee]=G,Q=G[G.length-1],se=z.getTokenBefore(ee);let Z=z.getTokenAfter(Q);if(Z?.value===","&&(Z=z.getTokenAfter(Z)),!J||!X||!se||!Z)throw new Error(`Unexpected null when attempting to fix ${q.filename} - please file an issue at https://github/veritem/eslint-plugin-vitest`);let te=H.replaceText(ee,"()");se.value==="("&&Z.value===")"&&(te=H.removeRange([se.range[1],Z.range[0]]));let re=`new Promise(${W.name} => `,oe=")",ne=!0;return V.type===utils.AST_NODE_TYPES.BlockStatement&&(re=`return ${re}{`,oe+="}",ne=!1),[te,ne?H.insertTextBefore(J,re):H.insertTextAfter(J,re),H.insertTextAfter(X,oe)]}}]})}}}}),RULE_NAME$N="no-duplicate-hooks",Qe=createEslintRule({name:RULE_NAME$N,meta:{docs:{recommended:!1,description:"disallow duplicate hooks and teardown hooks",requiresTypeChecking:!1},messages:{noDuplicateHooks:"Duplicate {{ hook }} in describe block"},schema:[],type:"suggestion"},defaultOptions:[],create(q){const $=[{}];return{CallExpression(Y){const B=parseVitestFnCall(Y,q);if(B?.type==="describe"&&$.push({}),B?.type!=="hook")return;const F=$[$.length-1];F[B.name]||=0,F[B.name]+=1,F[B.name]>1&&q.report({messageId:"noDuplicateHooks",data:{hook:B.name},node:Y})},"CallExpression:exit"(Y){isTypeOfVitestFnCall(Y,q,["describe"])&&$.pop()}}}}),RULE_NAME$M="no-large-snapshots",m$5=(q,$,{maxSize:Y=50,allowedSnapshots:B={}})=>{const F=$.loc.start.line,W=$.loc.end.line-F;if(!Object.keys(B).every(node_path.isAbsolute))throw new Error("All paths for allowedSnapshots must be absolute. You can use JS config and `path.resolve`");let H=!1;if($.type===utils.AST_NODE_TYPES.ExpressionStatement&&"left"in $.expression&&$.expression.left.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor($.expression.left.property)){const V=q.filename,G=B[V];if(G){const z=getAccessorValue($.expression.left.property);H=G.some(J=>J instanceof RegExp?J.test(z):z===J)}}!H&&W>Y&&q.report({node:$,messageId:Y===0?"noSnapShot":"tooLongSnapShot",data:{lineCount:W,lineLimit:Y}})},Xe=createEslintRule({name:RULE_NAME$M,meta:{docs:{description:"disallow large snapshots",recommended:!1},messages:{noSnapShot:"`{{ lineCount }}`s should begin with lowercase",tooLongSnapShot:"Expected vitest snapshot to be smaller than {{ lineLimit }} lines but was {{ lineCount }} lines long"},type:"suggestion",schema:[{type:"object",properties:{maxSize:{type:"number"},inlineMaxSize:{type:"number"},allowedSnapshots:{type:"object",additionalProperties:{type:"array"}}},additionalProperties:!1}]},defaultOptions:[{}],create(q,[$]){return q.filename.endsWith(".snap")?{ExpressionStatement(Y){m$5(q,Y,$)}}:{CallExpression(Y){const B=parseVitestFnCall(Y,q);B?.type==="expect"&&["toMatchInlineSnapshot","toThrowErrorMatchingInlineSnapshot"].includes(getAccessorValue(B.matcher))&&B.args.length&&m$5(q,B.args[0],{...$,maxSize:$.inlineMaxSize??$.maxSize})}}}}),RULE_NAME$L="no-interpolation-in-snapshots",Ye=createEslintRule({name:RULE_NAME$L,meta:{type:"problem",docs:{description:"disallow string interpolation in snapshots",recommended:!1},fixable:"code",schema:[],messages:{noInterpolationInSnapshots:"Do not use string interpolation in snapshots"}},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);Y?.type==="expect"&&["toMatchInlineSnapshot","toThrowErrorMatchingInlineSnapshot"].includes(getAccessorValue(Y.matcher))&&Y.args.forEach(B=>{B.type===utils.AST_NODE_TYPES.TemplateLiteral&&B.expressions.length>0&&q.report({messageId:"noInterpolationInSnapshots",node:B})})}}}}),t="__mocks__",p$2=q=>q.split(node_path.posix.sep).includes(t),s=q=>isStringNode(q)&&p$2(getStringValue(q)),RULE_NAME$K="no-mocks-import",Ze=createEslintRule({name:RULE_NAME$K,meta:{type:"problem",docs:{description:"disallow importing from __mocks__ directory",recommended:!1},messages:{noMocksImport:`Mocks should not be manually imported from a ${t} directory. Instead use \`vi.mock\` and import from the original module path`},schema:[]},defaultOptions:[],create(q){return{ImportDeclaration($){s($.source)&&q.report({node:$,messageId:"noMocksImport"})},'CallExpression[callee.name="require"]'($){const[Y]=$.arguments;Y&&s(Y)&&q.report({node:Y,messageId:"noMocksImport"})}}}}),RULE_NAME$J="no-restricted-matchers",l$2=(q,$)=>ModifierName.hasOwnProperty($)||$.endsWith(".not")?q.startsWith($):q===$,er=createEslintRule({name:RULE_NAME$J,meta:{docs:{description:"disallow the use of certain matchers",recommended:!1},type:"suggestion",schema:[{type:"object",additionalProperties:{type:["string","null"]}}],messages:{restrictedChain:"use of {{ restriction }} is disallowed",restrictedChainWithMessage:"{{ message }}"}},defaultOptions:[{}],create(q,[$]){return{CallExpression(Y){const B=parseVitestFnCall(Y,q);if(B?.type!=="expect")return;const F=B.members.map(W=>getAccessorValue(W)).join(".");for(const[W,H]of Object.entries($))if(l$2(F,W)){q.report({messageId:H?"restrictedChainWithMessage":"restrictedChain",data:{message:H,restriction:W},loc:{start:B.members[0].loc.start,end:B.members[B.members.length-1].loc.end}});break}}}}}),RULE_NAME$I="no-standalone-expect",a$5=(q,$)=>{const Y=q.parent;if(!Y)throw new Error("Unexpected block statement. If you feel like this is a bug report https://github.com/veritem/eslint-plugin-vitest/issues/new");if(Y.type===utils.AST_NODE_TYPES.FunctionDeclaration)return"function";if(isFunction(Y)&&Y.parent){const B=Y.parent;if(B.type===utils.AST_NODE_TYPES.VariableDeclarator)return"function";if(B.type===utils.AST_NODE_TYPES.CallExpression&&isTypeOfVitestFnCall(B,$,["describe"]))return"describe"}return null},rr=createEslintRule({name:RULE_NAME$I,meta:{docs:{description:"disallow using `expect` outside of `it` or `test` blocks",recommended:!1},type:"suggestion",messages:{noStandaloneExpect:"Expect must be called inside a test block"},schema:[{type:"object",properties:{additionalTestBlockFunctions:{type:"array",items:{type:"string"}}},additionalProperties:!1}]},defaultOptions:[{additionalTestBlockFunctions:[]}],create(q,[{additionalTestBlockFunctions:$=[]}]){const Y=[],B=F=>$.includes(getNodeName(F)||"");return{CallExpression(F){const W=parseVitestFnCall(F,q);if(W?.type==="expect"){if(W.head.node.parent?.type===utils.AST_NODE_TYPES.MemberExpression&&W.members.length===1&&!["assertions","hasAssertions"].includes(getAccessorValue(W.members[0])))return;const H=Y[Y.length-1];(!H||H===DescribeAlias.describe)&&q.report({node:F,messageId:"noStandaloneExpect"});return}(W?.type==="test"||B(F))&&Y.push("test"),F.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression&&Y.push("template")},"CallExpression:exit"(F){const W=Y[Y.length-1];(W==="test"&&(isTypeOfVitestFnCall(F,q,["test"])||B(F))&&F.callee.type!==utils.AST_NODE_TYPES.MemberExpression||W==="template"&&F.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression)&&Y.pop()},BlockStatement(F){const W=a$5(F,q);W&&Y.push(W)},"BlockStatement:exit"(F){a$5(F,q)&&Y.pop()},ArrowFunctionExpression(F){F.parent?.type!==utils.AST_NODE_TYPES.CallExpression&&Y.push("arrow")},"ArrowFunctionExpression:exit"(){Y[Y.length-1]==="arrow"&&Y.pop()}}}}),RULE_NAME$H="no-test-prefixes",or=createEslintRule({name:RULE_NAME$H,meta:{docs:{description:"disallow using the `f` and `x` prefixes in favour of `.only` and `.skip`",recommended:!1},type:"suggestion",messages:{usePreferredName:'Use "{{ preferredNodeName }}" instead'},fixable:"code",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="describe"&&Y?.type!=="test"||Y.name[0]!=="f"&&Y.name[0]!=="x")return;const B=[Y.name.slice(1),Y.name[0]==="f"?"only":"skip",...Y.members.map(W=>getAccessorValue(W))].join("."),F=$.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression?$.callee.tag:$.callee.type===utils.AST_NODE_TYPES.CallExpression?$.callee.callee:$.callee;q.report({messageId:"usePreferredName",node:$.callee,data:{preferredNodeName:B},fix:W=>[W.replaceText(F,B)]})}}}}),RULE_NAME$G="no-test-return-statement",u$3=q=>{const[,$]=q;return $&&isFunction($)&&$.body.type===utils.AST_NODE_TYPES.BlockStatement?$.body.body:[]},ar=createEslintRule({name:RULE_NAME$G,meta:{type:"problem",docs:{description:"disallow return statements in tests",recommended:!1},schema:[],messages:{noTestReturnStatement:"Return statements are not allowed in tests"}},defaultOptions:[],create(q){return{CallExpression($){if(!isTypeOfVitestFnCall($,q,["test"]))return;const Y=u$3($.arguments).find(B=>B.type===utils.AST_NODE_TYPES.ReturnStatement);Y&&q.report({messageId:"noTestReturnStatement",node:Y})},FunctionDeclaration($){const Y=q.sourceCode.getDeclaredVariables($);if(getTestCallExpressionsFromDeclaredVariables(Y,q).length===0)return;const B=$.body.body.find(F=>F.type===utils.AST_NODE_TYPES.ReturnStatement);B&&q.report({messageId:"noTestReturnStatement",node:B})}}}}),RULE_NAME$F="prefer-called-with",tr=createEslintRule({name:RULE_NAME$F,meta:{docs:{description:"enforce using `toBeCalledWith()` or `toHaveBeenCalledWith()`",recommended:!1},messages:{preferCalledWith:"Prefer {{ matcherName }}With(/* expected args */)"},type:"suggestion",fixable:"code",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect"||Y.modifiers.some(W=>getAccessorValue(W)==="not"))return;const{matcher:B}=Y,F=getAccessorValue(B);["toBeCalled","toHaveBeenCalled"].includes(F)&&q.report({data:{matcherName:F},messageId:"preferCalledWith",node:B,fix:W=>[W.replaceText(B,`${F}With`)]})}}}}),RULE_NAME$E="valid-title",_=q=>["f","x"].includes(q.charAt(0))?q.substring(1):q,T$2=q=>q.type===utils.AST_NODE_TYPES.TemplateLiteral?`\`${q.quasis[0].value.raw}\``:q.raw,A$2={type:"array",items:{type:"string"},minItems:1,maxItems:2,additionalItems:!1},p$1=q=>{const[$,Y]=Array.isArray(q)?q:[q];return[new RegExp($,"u"),Y]};function j(q){return!!(q.flags&n__default.TypeFlags.StringLike)}const b=q=>{if(typeof q=="string"||Array.isArray(q)){const $=p$1(q);return{describe:$,test:$,it:$}}return{describe:q.describe?p$1(q.describe):null,test:q.test?p$1(q.test):null,it:q.it?p$1(q.it):null}},E$2=q=>isStringNode(q.right)?!0:q.left.type===utils.AST_NODE_TYPES.BinaryExpression?E$2(q.left):isStringNode(q.left),sr=createEslintRule({name:RULE_NAME$E,meta:{docs:{description:"enforce valid titles",recommended:!1},messages:{titleMustBeString:"Test title must be a string, a function or class name",emptyTitle:"{{ functionName }} should not have an empty title",duplicatePrefix:"should not have duplicate prefix",accidentalSpace:"should not have leading or trailing spaces",disallowedWord:'"{{ word }}" is not allowed in test title',mustNotMatch:"{{ functionName }} should not match {{ pattern }}",mustMatch:"{{ functionName }} should match {{ pattern }}",mustNotMatchCustom:"{{ message }}",mustMatchCustom:"{{ message }}"},type:"suggestion",schema:[{type:"object",properties:{ignoreTypeOfDescribeName:{type:"boolean",default:!1},allowArguments:{type:"boolean",default:!1},disallowedWords:{type:"array",items:{type:"string"}}},patternProperties:{[/^must(?:Not)?Match$/u.source]:{oneOf:[{type:"string"},A$2,{type:"object",propertyNames:{type:"string",enum:["describe","test","it"]},additionalProperties:{oneOf:[{type:"string"},A$2]}}]}},additionalProperties:!1}],fixable:"code"},defaultOptions:[{ignoreTypeOfDescribeName:!1,allowArguments:!1,disallowedWords:[]}],create(q,[{ignoreTypeOfDescribeName:$,allowArguments:Y,disallowedWords:B=[],mustNotMatch:F,mustMatch:W}]){const H=new RegExp(`\\b(${B.join("|")})\\b`,"iu"),V=b(F??{}),G=b(W??{}),z=parsePluginSettings(q.settings);return{CallExpression(J){const X=parseVitestFnCall(J,q);if(X?.type!=="describe"&&X?.type!=="test"&&X?.type!=="it"||X.members&&X.members[0]&&X.members[0].type===utils.AST_NODE_TYPES.Identifier&&X.members[0].name==="extend")return;const ee=ae=>{q.report({messageId:"emptyTitle",data:{functionName:X.type==="describe"?DescribeAlias.describe:TestCaseName.test},node:ae})},[Q]=J.arguments;if(z.typecheck){const ae=utils.ESLintUtils.getParserServices(q).getTypeAtLocation(Q);if(isClassOrFunctionType(ae))return;if(j(ae)){isStringNode(Q)&&!getStringValue(Q)&&ee(J);return}}if(!Q||Y&&Q.type===utils.AST_NODE_TYPES.Identifier)return;if(!isStringNode(Q)){if(Q.type===utils.AST_NODE_TYPES.BinaryExpression&&E$2(Q))return;Q.type!==utils.AST_NODE_TYPES.TemplateLiteral&&!($&&X.type==="describe")&&q.report({messageId:"titleMustBeString",loc:Q.loc});return}const se=getStringValue(Q);if(!se){ee(J);return}if(B.length>0){const ae=H.exec(se);if(ae){q.report({messageId:"disallowedWord",data:{word:ae[1]},node:Q});return}}se.trim().length!==se.length&&q.report({messageId:"accidentalSpace",node:Q,fix:ae=>[ae.replaceTextRange(Q.range,T$2(Q).replace(/^([`'"]) +?/u,"$1").replace(/ +?([`'"])$/u,"$1"))]});const Z=_(X.name),[te]=se.split(" ");te.toLowerCase()===Z&&q.report({messageId:"duplicatePrefix",node:Q,fix:ae=>[ae.replaceTextRange(Q.range,T$2(Q).replace(/^([`'"]).+? /u,"$1"))]});const re=Z,[oe,ne]=V[re]??[];if(oe&&oe.test(se)){q.report({messageId:ne?"mustNotMatchCustom":"mustNotMatch",node:Q,data:{functionName:re,pattern:oe,message:ne}});return}const[ie,ce]=G[re]??[];ie&&(ie.test(se)||q.report({messageId:ce?"mustMatchCustom":"mustMatch",node:Q,data:{functionName:re,pattern:ie,message:ce}}))}}}}),RULE_NAME$D="valid-expect",h$1=["toReject","toResolve"],D=q=>(q.type===utils.AST_NODE_TYPES.ArrayExpression&&q.parent&&q.parent.type===utils.AST_NODE_TYPES.CallExpression&&(q=q.parent),q.type===utils.AST_NODE_TYPES.CallExpression&&q.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(q.callee.object,"Promise")&&q.parent?q:null),A$1=({start:q,end:$})=>`${q.line}:${q.column}-${$.line}:${$.column}`,O$1=q=>q.parent.type===utils.AST_NODE_TYPES.Property&&q.type===utils.AST_NODE_TYPES.FunctionExpression?q.parent:q;function M$2(q){const $=q.parent?.parent;return $&&$.type===utils.AST_NODE_TYPES.CallExpression&&$.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor($.callee.property)&&["then","catch"].includes(getAccessorValue($.callee.property))&&$.parent?M$2($):q}const U=q=>q.parent?.parent&&[utils.AST_NODE_TYPES.CallExpression,utils.AST_NODE_TYPES.ArrayExpression].includes(q.parent.type)?D(q.parent):null,N$2=({parent:q})=>q?isFunction(q)?q:N$2(q):null,w$1=(q,$)=>$&&q.type===utils.AST_NODE_TYPES.ReturnStatement?!0:q.type===utils.AST_NODE_TYPES.ConditionalExpression&&q.parent?w$1(q.parent,$):[utils.AST_NODE_TYPES.ArrowFunctionExpression,utils.AST_NODE_TYPES.AwaitExpression].includes(q.type),nr=createEslintRule({name:RULE_NAME$D,meta:{docs:{description:"enforce valid `expect()` usage",recommended:!1},messages:{tooManyArgs:"Expect takes at most {{ amount}} argument{{ s }}",notEnoughArgs:"Expect requires at least {{ amount }} argument{{ s }}",modifierUnknown:"Expect has an unknown modifier",matcherNotFound:"Expect must have a corresponding matcher call",matcherNotCalled:"Matchers must be called to assert",asyncMustBeAwaited:"Async assertions must be awaited{{ orReturned }}",promisesWithAsyncAssertionsMustBeAwaited:"Promises which return async assertions must be awaited{{ orReturned }}"},type:"suggestion",fixable:"code",schema:[{type:"object",properties:{alwaysAwait:{type:"boolean",default:!1},asyncMatchers:{type:"array",items:{type:"string"}},minArgs:{type:"number",minimum:1},maxArgs:{type:"number",minimum:1}},additionalProperties:!1}]},defaultOptions:[{alwaysAwait:!1,asyncMatchers:h$1,minArgs:1,maxArgs:1}],create:(q,[{alwaysAwait:$,asyncMatchers:Y=h$1,minArgs:B=1,maxArgs:F=1}])=>{const W=new Set,H=[],V=J=>W.add(A$1(J)),G=J=>W.has(A$1(J)),z=J=>{let X=J,{parent:ee}=J;for(;ee&&ee.type===utils.AST_NODE_TYPES.MemberExpression;)X=ee,ee=ee.parent;return X};return{CallExpression(J){const X=parseVitestFnCallWithReason(J,q),ee=parsePluginSettings(q.settings);if(typeof X=="string"){const ie=J.parent?.type===utils.AST_NODE_TYPES.MemberExpression?z(J.parent).property:J;if(X==="matcher-not-found"){q.report({messageId:"matcherNotFound",node:ie});return}if(X==="matcher-not-called"&&q.report({messageId:isSupportedAccessor(ie)&&ModifierName.hasOwnProperty(getAccessorValue(ie))?"matcherNotFound":"matcherNotCalled",node:ie}),X==="modifier-unknown"){q.report({messageId:"modifierUnknown",node:ie});return}return}else if(X?.type==="expectTypeOf"&&ee.typecheck||X?.type!=="expect"||X.modifiers.some(ie=>ie.type===utils.AST_NODE_TYPES.Identifier&&ie.name=="to"))return;const{parent:Q}=X.head.node;if(Q?.type!==utils.AST_NODE_TYPES.CallExpression)return;if(Q.arguments.length<B){const ie=getAccessorValue(X.head.node).length,ce={start:{column:Q.loc.start.column+ie,line:Q.loc.start.line},end:{column:Q.loc.start.column+ie+1,line:Q.loc.start.line}};q.report({messageId:"notEnoughArgs",data:{amount:B,s:B===1?"":"s"},node:Q,loc:ce})}if(Q.arguments.length>F){if(Q.arguments.length===2){const le=Q.arguments[1].type===utils.AST_NODE_TYPES.Literal&&typeof Q.arguments[1].value=="string",ue=Q.arguments[1].type===utils.AST_NODE_TYPES.TemplateLiteral;if(le||ue)return}const{start:ie}=Q.arguments[F].loc,{end:ce}=Q.arguments[Q.arguments.length-1].loc,ae={start:ie,end:{column:ce.column+1,line:ce.line}};q.report({messageId:"tooManyArgs",data:{amount:F,s:F===1?"":"s"},node:Q,loc:ae})}const{matcher:se}=X,Z=se.parent.parent,te=X.modifiers.some(ie=>getAccessorValue(ie)!=="not")||Y.includes(getAccessorValue(se));if(!Z?.parent||!te)return;const re=Z.parent.type===utils.AST_NODE_TYPES.ArrayExpression,oe=M$2(Z),ne=U(oe)||oe;ne.parent&&!w$1(ne.parent,!$)&&!G(ne.loc)&&(H.push({messageId:ne===oe?"asyncMustBeAwaited":"promisesWithAsyncAssertionsMustBeAwaited",node:ne}),re&&V(ne.loc))},"Program:exit"(){const J=[];H.forEach(({node:X,messageId:ee},Q)=>{const se=$?"":" or returned";q.report({loc:X.loc,data:{orReturned:se},messageId:ee,node:X,fix(Z){const te=N$2(X);if(!te)return null;const re=J.some(ne=>ne.text==="async ");if(!te.async&&!re){const ne=O$1(te);J.push(Z.insertTextBefore(ne,"async "))}const oe=X.parent?.type===utils.AST_NODE_TYPES.ReturnStatement?X.parent:null;if($&&oe){const ne=q.sourceCode.getText(oe).replace("return","await");J.push(Z.replaceText(oe,ne))}else J.push(Z.insertTextBefore(X,"await "));return Q===H.length-1?J:null}})})}}}}),isBooleanLiteral=q=>q.type===utils.AST_NODE_TYPES.Literal&&typeof q.value=="boolean",isBooleanEqualityMatcher=q=>{const $=getAccessorValue(q.matcher);if(["toBeTruthy","toBeFalsy"].includes($))return!0;if(q.args.length!==1)return!1;const Y=getFirstMatcherArg(q);return EqualityMatcher.hasOwnProperty($)&&isBooleanLiteral(Y)},isInstanceOfBinaryExpression=(q,$)=>q.type===utils.AST_NODE_TYPES.BinaryExpression&&q.operator==="instanceof"&&isSupportedAccessor(q.right,$),hasOnlyOneArgument=q=>q.arguments.length===1,RULE_NAME$C="prefer-to-be-object",ir=createEslintRule({name:RULE_NAME$C,meta:{type:"suggestion",docs:{description:"enforce using toBeObject()",recommended:!1},fixable:"code",messages:{preferToBeObject:"Prefer toBeObject() to test if a value is an object"},schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expectTypeOf")return;if(isParsedInstanceOfMatcherCall(Y,"Object")){q.report({node:Y.matcher,messageId:"preferToBeObject",fix:W=>[W.replaceTextRange([Y.matcher.range[0],Y.matcher.range[1]+8],"toBeObject()")]});return}const{parent:B}=Y.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const[F]=B.arguments;!F||!isBooleanEqualityMatcher(Y)||!isInstanceOfBinaryExpression(F,"Object")||q.report({node:Y.matcher,messageId:"preferToBeObject",fix(W){const H=[W.replaceText(Y.matcher,"toBeObject"),W.removeRange([F.left.range[1],F.range[1]])];let V=getAccessorValue(Y.matcher)==="toBeFalsy";if(Y.args.length){const[G]=Y.args;H.push(W.remove(G)),V=G.type===utils.AST_NODE_TYPES.Literal&&followTypeAssertionChain$1(G).value===!1}if(V){const G=Y.modifiers.find(z=>getAccessorValue(z)==="not");H.push(G?W.removeRange([G.range[0]-1,G.range[1]]):W.insertTextBefore(Y.matcher,"not."))}return H}})}}}}),RULE_NAME$B="prefer-to-be-truthy",n=q=>q.type===utils.AST_NODE_TYPES.Literal&&q.value===!0,mr=createEslintRule({name:RULE_NAME$B,meta:{type:"suggestion",docs:{description:"enforce using `toBeTruthy`",recommended:!1},messages:{preferToBeTruthy:"Prefer using `toBeTruthy` to test value is `true`"},fixable:"code",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);(Y?.type==="expect"||Y?.type==="expectTypeOf")&&Y.args.length===1&&n(getFirstMatcherArg(Y))&&EqualityMatcher.hasOwnProperty(getAccessorValue(Y.matcher))&&q.report({node:Y.matcher,messageId:"preferToBeTruthy",fix:B=>[B.replaceText(Y.matcher,"toBeTruthy"),B.remove(Y.args[0])]})}}}}),RULE_NAME$A="prefer-to-be-falsy",c$2=q=>q.type===utils.AST_NODE_TYPES.Literal&&q.value===!1,pr=createEslintRule({name:RULE_NAME$A,meta:{type:"suggestion",docs:{description:"enforce using toBeFalsy()",recommended:!1},fixable:"code",schema:[],messages:{preferToBeFalsy:"Prefer using toBeFalsy()"}},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);(Y?.type==="expect"||Y?.type==="expectTypeOf")&&Y.args.length===1&&c$2(getFirstMatcherArg(Y))&&EqualityMatcher.hasOwnProperty(getAccessorValue(Y.matcher))&&q.report({node:Y.matcher,messageId:"preferToBeFalsy",fix:B=>[B.replaceText(Y.matcher,"toBeFalsy"),B.remove(Y.args[0])]})}}}}),RULE_NAME$z="prefer-to-have-length",Er=createEslintRule({name:RULE_NAME$z,meta:{type:"suggestion",docs:{description:"enforce using toHaveLength()",recommended:!1},fixable:"code",messages:{preferToHaveLength:"Prefer toHaveLength()"},schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect")return;const{parent:B}=Y.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const[F]=B.arguments,{matcher:W}=Y;!EqualityMatcher.hasOwnProperty(getAccessorValue(W))||F?.type!==utils.AST_NODE_TYPES.MemberExpression||!isSupportedAccessor(F.property,"length")||q.report({node:W,messageId:"preferToHaveLength",fix(H){return[H.removeRange([F.property.range[0]-1,F.range[1]]),H.replaceTextRange([W.parent.object.range[1],W.parent.range[1]],".toHaveLength")]}})}}}}),RULE_NAME$y="prefer-equality-matcher",fr=createEslintRule({name:RULE_NAME$y,meta:{type:"suggestion",docs:{description:"enforce using the built-in quality matchers",recommended:!1},messages:{useEqualityMatcher:"Prefer using one of the equality matchers instead",suggestEqualityMatcher:"Use `{{ equalityMatcher }}`"},hasSuggestions:!0,schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect"||Y.args.length===0)return;const{parent:B}=Y.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const{arguments:[F],range:[,W]}=B,{matcher:H}=Y,V=getFirstMatcherArg(Y);if(F?.type!==utils.AST_NODE_TYPES.BinaryExpression||F.operator!=="==="&&F.operator!=="!=="||!EqualityMatcher.hasOwnProperty(getAccessorValue(H))||!isBooleanLiteral(V))return;const G=V.value,[z]=Y.modifiers,J=Y.modifiers.some(Q=>getAccessorValue(Q)==="not"),X=(F.operator==="!=="?!G:G)===J,ee=Q=>se=>{const{sourceCode:Z}=q;let te=z&&getAccessorValue(z)!=="not"?`.${getAccessorValue(z)}`:"";return X&&(te+=`.${ModifierName.not}`),[se.replaceText(F,Z.getText(F.left)),se.replaceTextRange([W,H.parent.range[1]],`${te}.${Q}`),se.replaceText(V,Z.getText(F.right))]};q.report({messageId:"useEqualityMatcher",suggest:["toBe","toEqual","toStrictEqual"].map(Q=>({messageId:"suggestEqualityMatcher",data:{equalityMatcher:Q},fix:ee(Q)})),node:H})}}}}),RULE_NAME$x="prefer-strict-equal",lr=createEslintRule({name:RULE_NAME$x,meta:{type:"suggestion",docs:{description:"enforce strict equal over equal",recommended:!1},messages:{useToStrictEqual:"Use `toStrictEqual()` instead",suggestReplaceWithStrictEqual:"Replace with `toStrictEqual()`"},schema:[],hasSuggestions:!0},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect")return;const{matcher:B}=Y;isSupportedAccessor(B,"toEqual")&&q.report({messageId:"useToStrictEqual",node:B,suggest:[{messageId:"suggestReplaceWithStrictEqual",fix:F=>[replaceAccessorFixer(F,B,EqualityMatcher.toStrictEqual)]}]})}}}}),RULE_NAME$w="prefer-expect-resolves",Nr=createEslintRule({name:RULE_NAME$w,meta:{type:"suggestion",docs:{description:"enforce using `expect().resolves` over `expect(await ...)` syntax",recommended:!1},fixable:"code",messages:{expectResolves:"Use `expect().resolves` instead"},schema:[]},defaultOptions:[],create:q=>({CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect")return;const{parent:B}=Y.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const[F]=B.arguments;F?.type===utils.AST_NODE_TYPES.AwaitExpression&&q.report({node:F,messageId:"expectResolves",fix(W){return[W.insertTextBefore(B,"await "),W.removeRange([F.range[0],F.argument.range[0]]),W.insertTextAfter(B,".resolves")]}})}})}),RULE_NAME$v="prefer-each",cr=createEslintRule({name:RULE_NAME$v,meta:{type:"suggestion",docs:{description:"enforce using `each` rather than manual loops",recommended:!1},schema:[],messages:{preferEach:"Prefer using `{{ fn }}.each` rather than a manual loop"}},defaultOptions:[],create(q){const $=[];let Y=!1;const B=()=>$.length===1&&$[0]==="test"?"it":"describe",F=()=>{$.length===0||Y||($.length=0)},W=H=>{$.length===0||Y||(q.report({node:H,messageId:"preferEach",data:{fn:B()}}),$.length=0)};return{ForStatement:F,"ForStatement:exit":W,ForInStatement:F,"ForInStatement:exit":W,ForOfStatement:F,"ForOfStatement:exit":W,CallExpression(H){const{type:V}=parseVitestFnCall(H,q)??{};(V==="hook"||V==="describe"||V==="test")&&$.push(V),V==="test"&&(Y=!0)},"CallExpression:exit"(H){const{type:V}=parseVitestFnCall(H,q)??{};V==="test"&&(Y=!1)}}}}),RULE_NAME$u="prefer-hooks-on-top",dr=createEslintRule({name:RULE_NAME$u,meta:{type:"suggestion",docs:{description:"enforce having hooks before any test cases",recommended:!1},messages:{noHookOnTop:"Hooks should come before test cases"},schema:[]},defaultOptions:[],create(q){const $=[!1];return{CallExpression(Y){isTypeOfVitestFnCall(Y,q,["test"])&&($[$.length-1]=!0),$[$.length-1]&&isTypeOfVitestFnCall(Y,q,["hook"])&&q.report({messageId:"noHookOnTop",node:Y}),$.push(!1)},"CallExpression:exit"(){$.pop()}}}}),RULE_NAME$t="prefer-hooks-in-order",a$4=["beforeAll","beforeEach","afterEach","afterAll"],Ar=createEslintRule({name:RULE_NAME$t,meta:{type:"suggestion",docs:{description:"enforce having hooks in consistent order",recommended:!1},messages:{reorderHooks:"`{{ currentHook }}` hooks should be before any `{{ previousHook }}` hooks"},schema:[]},defaultOptions:[],create(q){let $=-1,Y=!1;return{CallExpression(B){if(Y)return;const F=parseVitestFnCall(B,q);if(F?.type!=="hook"){$=-1;return}Y=!0;const W=F.name,H=a$4.indexOf(W);if(H<$){q.report({messageId:"reorderHooks",data:{previousHook:a$4[$],currentHook:W},node:B}),Y=!1;return}$=H},"CallExpression:exit"(B){if(isTypeOfVitestFnCall(B,q,["hook"])){Y=!1;return}Y||($=-1)}}}}),RULE_NAME$s="prefer-mock-promise-shorthand",l$1=(q,$)=>`${q}${$?"Once":""}`,f$1=q=>q.body.type!==utils.AST_NODE_TYPES.BlockStatement?q.body:q.body.body[0]?.type===utils.AST_NODE_TYPES.ReturnStatement?q.body.body[0].argument:null,Mr=createEslintRule({name:RULE_NAME$s,meta:{type:"suggestion",docs:{description:"enforce mock resolved/rejected shorthands for promises",recommended:!1},messages:{useMockShorthand:"Prefer {{ replacement }}"},schema:[],fixable:"code"},defaultOptions:[],create(q){const $=(Y,B,F,W=F)=>{if(W?.type!==utils.AST_NODE_TYPES.CallExpression)return;const H=getNodeName(W);if(H!=="Promise.resolve"&&H!=="Promise.reject")return;const V=l$1(H.endsWith("reject")?"mockRejectedValue":"mockResolvedValue",B);q.report({node:Y,messageId:"useMockShorthand",data:{replacement:V},fix(G){const{sourceCode:z}=q;return W.arguments.length>1?null:[G.replaceText(Y,V),G.replaceText(F,W.arguments.length===1?z.getText(W.arguments[0]):"undefined")]}})};return{CallExpression(Y){if(Y.callee.type!==utils.AST_NODE_TYPES.MemberExpression||!isSupportedAccessor(Y.callee.property)||Y.arguments.length===0)return;const B=getAccessorValue(Y.callee.property),F=B.endsWith("Once");if(B===l$1("mockReturnValue",F))$(Y.callee.property,F,Y.arguments[0]);else if(B===l$1("mockImplementation",F)){const[W]=Y.arguments;if(!isFunction(W)||W.params.length!==0)return;$(Y.callee.property,F,W,f$1(W))}}}}}),a$3=node_module.createRequire(typeof document>"u"?require("url").pathToFileURL(__filename).href:_documentCurrentScript&&_documentCurrentScript.tagName.toUpperCase()==="SCRIPT"&&_documentCurrentScript.src||new URL("index.cjs",document.baseURI).href),c$1=node_module.createRequire(a$3.resolve("eslint"));c$1.resolve("espree");const p=new Set([utils.AST_NODE_TYPES.Program,utils.AST_NODE_TYPES.BlockStatement,utils.AST_NODE_TYPES.SwitchCase,utils.AST_NODE_TYPES.SwitchStatement]),isValidParent=q=>p.has(q),isTokenASemicolon=q=>q.value===";"&&q.type===utils.AST_TOKEN_TYPES.Punctuator,getActualLastToken=(q,$)=>{const Y=q.getLastToken($),B=q.getTokenBefore(Y),F=q.getTokenAfter(Y);return B&&F&&B.range[0]>=$.range[0]&&isTokenASemicolon(Y)&&Y.loc.start.line!==B.loc.end.line&&Y.loc.end.line===F.loc.start.line?B:Y},getPaddingLineSequences=(q,$,Y)=>{const B=[];let F=getActualLastToken(Y,q);if($.loc.start.line-q.loc.end.line>=2)do{const W=Y.getTokenAfter(F,{includeComments:!0});W.loc.start.line-F.loc.end.line>=2&&B.push([F,W]),F=W}while(F.range[0]<$.range[0]);return B},areTokensOnSameLine=(q,$)=>q.loc.end.line===$.loc.start.line,E$1=q=>q.type===utils.AST_NODE_TYPES.TSAsExpression||q.type===utils.AST_NODE_TYPES.TSTypeAssertion,followTypeAssertionChain=q=>E$1(q)?followTypeAssertionChain(q.expression):q,RULE_NAME$r="prefer-vi-mocked",m$4=["Mock","MockedFunction","MockedClass","MockedObject"],wr=createEslintRule({name:RULE_NAME$r,meta:{type:"suggestion",docs:{description:"require `vi.mocked()` over `fn as Mock`",requiresTypeChecking:!0,recommended:!1},fixable:"code",messages:{useViMocked:"Prefer `vi.mocked()`"},schema:[]},defaultOptions:[],create(q){function $(Y){const{typeAnnotation:B}=Y;if(B.type!==utils.AST_NODE_TYPES.TSTypeReference)return;const{typeName:F}=B;if(F.type!==utils.AST_NODE_TYPES.Identifier||!m$4.includes(F.name))return;const W=q.sourceCode.text.slice(...followTypeAssertionChain(Y.expression).range);q.report({node:Y,messageId:"useViMocked",fix(H){return H.replaceText(Y,`vi.mocked(${W})`)}})}return{TSAsExpression(Y){Y.parent.type!==utils.AST_NODE_TYPES.TSAsExpression&&$(Y)},TSTypeAssertion(Y){$(Y)}}}}),RULE_NAME$q="prefer-snapshot-hint",E=["toMatchSnapshot","toThrowErrorMatchingSnapshot"],x$2=E,S$3=q=>{if(q.args.length===0)return!0;if(!isSupportedAccessor(q.matcher,"toMatchSnapshot"))return q.args.length!==1;if(q.args.length===2)return!1;const[$]=q.args;return!isStringNode($)},Rr=createEslintRule({name:RULE_NAME$q,meta:{type:"suggestion",docs:{description:"enforce including a hint with external snapshots",recommended:!1},messages:{missingHint:"You should provide a hint for this snapshot"},schema:[{type:"string",enum:["always","multi"]}]},defaultOptions:["multi"],create(q,[$]){const Y=[];let B=0;const F=[],W=()=>{for(const G of Y)S$3(G)&&q.report({messageId:"missingHint",node:G.matcher})},H=()=>{B++},V=()=>{B--,$==="always"&&(W(),Y.length=0),$==="multi"&&B===0&&(Y.length>1&&W(),Y.length=0)};return{"Program:exit"(){H(),V()},FunctionExpression:H,"FunctionExpression:exit":V,ArrowFunctionExpression:H,"ArrowFunctionExpression:exit":V,"CallExpression:exit"(G){isTypeOfVitestFnCall(G,q,["describe","test"])&&(B=F.pop()??0)},CallExpression(G){const z=parseVitestFnCall(G,q);if(z?.type!=="expect"){(z?.type==="describe"||z?.type==="test")&&(F.push(B),B=0);return}const J=getAccessorValue(z.matcher);x$2.includes(J)&&Y.push(z)}}}}),RULE_NAME$p="valid-describe-callback",o=q=>{const[$]=q,Y=q[q.length-1];return{start:$.loc.start,end:Y.loc.end}},i$1=(q,$)=>q.members.every(Y=>getAccessorValue(Y)!=="each")&&$.params.length,u$2=(q,$)=>{q.body.forEach(Y=>{Y.type===utils.AST_NODE_TYPES.ReturnStatement&&$.report({messageId:"unexpectedReturnInDescribe",node:Y})})},ur=createEslintRule({name:RULE_NAME$p,meta:{type:"problem",docs:{description:"enforce valid describe callback",recommended:!1},messages:{nameAndCallback:"Describe requires a name and callback arguments",secondArgumentMustBeFunction:"Second argument must be a function",unexpectedDescribeArgument:"Unexpected argument in describe callback",unexpectedReturnInDescribe:"Unexpected return statement in describe callback"},schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="describe"||Y?.members[0]?.type===utils.AST_NODE_TYPES.Identifier&&Y.members[0].name==="todo")return;if($.arguments.length<1)return q.report({messageId:"nameAndCallback",loc:$.loc});const[,B,F]=$.arguments;if(!B){q.report({messageId:"nameAndCallback",loc:o($.arguments)});return}if(!isFunction(B)){if(F&&isFunction(F)){i$1(Y,F)&&q.report({messageId:"unexpectedDescribeArgument",node:F}),F.body.type===utils.AST_NODE_TYPES.CallExpression&&q.report({messageId:"unexpectedReturnInDescribe",node:F}),F.body.type===utils.AST_NODE_TYPES.BlockStatement&&u$2(F.body,q);return}q.report({messageId:"secondArgumentMustBeFunction",loc:o($.arguments)});return}i$1(Y,B)&&q.report({messageId:"unexpectedDescribeArgument",node:B}),B.body.type===utils.AST_NODE_TYPES.CallExpression&&q.report({messageId:"unexpectedReturnInDescribe",node:B}),B.body.type===utils.AST_NODE_TYPES.BlockStatement&&u$2(B.body,q)}}}}),RULE_NAME$o="require-top-level-describe",Lr=createEslintRule({name:RULE_NAME$o,meta:{docs:{description:"enforce that all tests are in a top-level describe",recommended:!1},messages:{tooManyDescribes:"There should not be more than {{ max }} describe{{ s }} at the top level",unexpectedTestCase:"All test cases must be wrapped in a describe block",unexpectedHook:"All hooks must be wrapped in a describe block"},type:"suggestion",schema:[{type:"object",properties:{maxNumberOfTopLevelDescribes:{type:"number",minimum:1}},additionalProperties:!1}]},defaultOptions:[{}],create(q){const{maxNumberOfTopLevelDescribes:$=1/0}=q.options[0]??{};let Y=0,B=0;return{CallExpression(F){const W=parseVitestFnCall(F,q);if(W){if(W.type==="describe"){B++,B===1&&(Y++,Y>$&&q.report({node:F,messageId:"tooManyDescribes",data:{max:$,s:$===1?"":"s"}}));return}if(B===0){if(W.type==="test"){q.report({node:F,messageId:"unexpectedTestCase"});return}W.type==="hook"&&q.report({node:F,messageId:"unexpectedHook"})}}},"CallExpression:exit"(F){isTypeOfVitestFnCall(F,q,["describe"])&&B--}}}}),RULE_NAME$n="require-to-throw-message",Tr=createEslintRule({name:RULE_NAME$n,meta:{type:"suggestion",docs:{description:"require toThrow() to be called with an error message",recommended:!1},schema:[],messages:{addErrorMessage:"Add an error message to {{ matcherName }}()"}},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect")return;const{matcher:B}=Y,F=getAccessorValue(B);Y.args.length===0&&["toThrow","toThrowError"].includes(F)&&!Y.modifiers.some(W=>getAccessorValue(W)==="not")&&q.report({messageId:"addErrorMessage",data:{matcherName:F},node:B})}}}}),RULE_NAME$m="require-hook",S$2=(q,$)=>parseVitestFnCall(q,$)?!0:!!getNodeName(q)?.startsWith("vi"),m$3=q=>q.type===utils.AST_NODE_TYPES.Literal&&q.value===null||isIdentifier(q,"undefined"),a$2=(q,$,Y=[])=>{switch(q.type){case utils.AST_NODE_TYPES.ExpressionStatement:return a$2(q.expression,$,Y);case utils.AST_NODE_TYPES.CallExpression:return!(S$2(q,$)||Y.includes(getNodeName(q)));case utils.AST_NODE_TYPES.VariableDeclaration:return q.kind==="const"?!1:q.declarations.some(({init:B})=>B!==null&&!m$3(B));default:return!1}},Ur=createEslintRule({name:RULE_NAME$m,meta:{docs:{description:"require setup and teardown to be within a hook",recommended:!1},messages:{useHook:"This should be done within a hook"},type:"suggestion",schema:[{type:"object",properties:{allowedFunctionCalls:{type:"array",items:{type:"string"}}},additionalProperties:!1}]},defaultOptions:[{allowedFunctionCalls:[]}],create(q){const{allowedFunctionCalls:$}=q.options[0]??{},Y=B=>{for(const F of B)a$2(F,q,$)&&q.report({node:F,messageId:"useHook"})};return{Program(B){Y(B.body)},CallExpression(B){if(!isTypeOfVitestFnCall(B,q,["describe"])||B.arguments.length<2)return;const[,F]=B.arguments;!isFunction(F)||F.body.type!==utils.AST_NODE_TYPES.BlockStatement||Y(F.body.body)}}}}),RULE_NAME$l="require-local-test-context-for-concurrent-snapshots",_r=createEslintRule({name:RULE_NAME$l,meta:{docs:{description:"require local Test Context for concurrent snapshot tests",recommended:!1},messages:{requireLocalTestContext:"Use local Test Context instead"},type:"problem",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);Y===null||Y.type!=="expect"||Y.type==="expect"&&Y.head.type==="testContext"||!["toMatchSnapshot","toMatchInlineSnapshot","toMatchFileSnapshot","toThrowErrorMatchingSnapshot","toThrowErrorMatchingInlineSnapshot"].includes($.callee?.property.name)||!q.sourceCode.getAncestors($).some(B=>B.type!==utils.AST_NODE_TYPES.CallExpression||!isTypeOfVitestFnCall(B,q,["describe","test"])?!1:B.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(B.callee.property,"concurrent"))||q.report({node:$,messageId:"requireLocalTestContext"})}}}}),RULE_NAME$k="prefer-todo",S$1=q=>q.members.some($=>getAccessorValue($)!=="skip")||q.name.startsWith("x")?!1:!q.name.startsWith("f");function T$1(q){return isFunction(q)?q.body.type===utils.AST_NODE_TYPES.BlockStatement&&!q.body.body.length:!1}function a$1(q,$){return q.members.length?replaceAccessorFixer($,q.members[0],"todo"):$.replaceText(q.head.node,`${q.head.local}.todo`)}const br=createEslintRule({name:RULE_NAME$k,meta:{type:"layout",docs:{description:"enforce using `test.todo`",recommended:!1},messages:{emptyTest:"Prefer todo test case over empty test case",unimplementedTest:"Prefer todo test case over unimplemented test case"},fixable:"code",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const[Y,B]=$.arguments,F=parseVitestFnCall($,q);!Y||F?.type!=="test"||!S$1(F)||!isStringNode(Y)||(B&&T$1(B)&&q.report({messageId:"emptyTest",node:$,fix:W=>[W.removeRange([Y.range[1],B.range[1]]),a$1(F,W)]}),hasOnlyOneArgument($)&&q.report({messageId:"unimplementedTest",node:$,fix:W=>a$1(F,W)}))}}}}),RULE_NAME$j="prefer-spy-on",u$1=q=>"object"in q?q.object:q.callee.type===utils.AST_NODE_TYPES.MemberExpression?q.callee.object:null,a=q=>{if(q.type!==utils.AST_NODE_TYPES.CallExpression&&q.type!==utils.AST_NODE_TYPES.MemberExpression)return null;const $=u$1(q);return $?$.type===utils.AST_NODE_TYPES.Identifier?q.type===utils.AST_NODE_TYPES.CallExpression&&getNodeName(q.callee)==="vi.fn"?q:null:a($):null},S=(q,$)=>{if(q.parent?.type===utils.AST_NODE_TYPES.MemberExpression&&q.parent.property.type===utils.AST_NODE_TYPES.Identifier&&q.parent.property.name==="mockImplementation")return"";const[Y]=q.arguments,B=Y&&$.sourceCode.getText(Y);return B?`.mockImplementation(${B})`:".mockImplementation()"},hr=createEslintRule({name:RULE_NAME$j,meta:{type:"suggestion",docs:{description:"enforce using `vi.spyOn`",recommended:!1},messages:{useViSpayOn:"Use `vi.spyOn` instead"},fixable:"code",schema:[]},defaultOptions:[],create(q){return{AssignmentExpression($){const{left:Y,right:B}=$;if(Y.type!==utils.AST_NODE_TYPES.MemberExpression)return;const F=a(B);F&&q.report({node:$,messageId:"useViSpayOn",fix(W){const H=Y.property.type===utils.AST_NODE_TYPES.Identifier&&!Y.computed?"'":"",V=S(F,q);return[W.insertTextBefore(Y,"vi.spyOn("),W.replaceTextRange([Y.object.range[1],Y.property.range[0]],`, ${H}`),W.replaceTextRange([Y.property.range[1],F.range[1]],`${H})${V}`)]}})}}}}),RULE_NAME$i="prefer-comparison-matcher",g$1=q=>isStringNode(q)||q?.type===utils.AST_NODE_TYPES.TemplateLiteral,C=q=>g$1(q.left)||g$1(q.right),M$1=q=>{switch(q){case">":return"<=";case"<":return">=";case">=":return"<";case"<=":return">"}return null},O=(q,$)=>{switch($?M$1(q):q){case">":return"toBeGreaterThan";case"<":return"toBeLessThan";case">=":return"toBeGreaterThanOrEqual";case"<=":return"toBeLessThanOrEqual"}return null},gr=createEslintRule({name:RULE_NAME$i,meta:{type:"suggestion",docs:{description:"enforce using the built-in comparison matchers",recommended:!1},schema:[],fixable:"code",messages:{useToBeComparison:"Prefer using `{{ preferredMatcher }}` instead"}},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect"||Y.args.length===0)return;const{parent:B}=Y.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const{arguments:[F],range:[,W]}=B,{matcher:H}=Y,V=getFirstMatcherArg(Y);if(F?.type!==utils.AST_NODE_TYPES.BinaryExpression||C(F)||!EqualityMatcher.hasOwnProperty(getAccessorValue(H))||!isBooleanLiteral(V))return;const[G]=Y.modifiers,z=Y.modifiers.some(X=>getAccessorValue(X)==="not"),J=O(F.operator,V.value===z);J&&q.report({fix(X){const{sourceCode:ee}=q,Q=G&&getAccessorValue(G)!=="not"?`.${getAccessorValue(G)}`:"";return[X.replaceText(F,ee.getText(F.left)),X.replaceTextRange([W,H.parent.range[1]],`${Q}.${J}`),X.replaceText(V,ee.getText(F.right))]},messageId:"useToBeComparison",data:{preferredMatcher:J},node:H})}}}}),RULE_NAME$h="prefer-describe-function-title",kr=createEslintRule({name:RULE_NAME$h,meta:{type:"problem",docs:{description:"enforce using a function as a describe title over an equivalent string",recommended:!1},fixable:"code",schema:[],messages:{preferFunction:"Enforce using a function over an equivalent string"}},defaultOptions:[],create(q){return{CallExpression($){if($.arguments.length<2)return;const Y=getModuleScope(q,$),[B]=$.arguments;if(B.type===utils.AST_NODE_TYPES.MemberExpression&&B.object.type===utils.AST_NODE_TYPES.Identifier&&B.property.type===utils.AST_NODE_TYPES.Identifier){const H=B.object.name;if(Y?.set.get(H)?.defs[0]?.type!==scopeManager.DefinitionType.ImportBinding||B.property.name!=="name")return;q.report({node:B,messageId:"preferFunction",fix(V){return V.replaceText(B,H)}});return}if(B.type!==utils.AST_NODE_TYPES.Literal||typeof B.value!="string")return;const F=B.value;if(parseVitestFnCall($,q)?.type!=="describe")return;const W=Y?.set.get(F)?.defs[0];if(W?.type===scopeManager.DefinitionType.ImportBinding){if(parsePluginSettings(q.settings).typecheck){const H=utils.ESLintUtils.getParserServices(q).getTypeAtLocation(W.node);if(!isClassOrFunctionType(H))return}q.report({node:B,messageId:"preferFunction",fix(H){return H.replaceText(B,F)}})}}}}}),RULE_NAME$g="prefer-to-contain",T=q=>q.type===utils.AST_NODE_TYPES.CallExpression&&q.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(q.callee.property,"includes")&&hasOnlyOneArgument(q)&&q.arguments[0].type!==utils.AST_NODE_TYPES.SpreadElement,xr=createEslintRule({name:RULE_NAME$g,meta:{docs:{description:"enforce using toContain()",recommended:!1},messages:{useToContain:"Use toContain() instead"},fixable:"code",type:"suggestion",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect"||Y.args.length===0)return;const{parent:B}=Y.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const{arguments:[F],range:[,W]}=B,{matcher:H}=Y,V=getFirstMatcherArg(Y);if(!F||V.type===utils.AST_NODE_TYPES.SpreadElement||!EqualityMatcher.hasOwnProperty(getAccessorValue(H))||!isBooleanLiteral(V)||!T(F))return;const G=Y.modifiers.some(z=>getAccessorValue(z)==="not");q.report({fix(z){const{sourceCode:J}=q,X=V.value===G;return[z.removeRange([F.callee.property.range[0]-1,F.range[1]]),z.replaceTextRange([W,H.parent.range[1]],X?`.${ModifierName.not}.toContain`:".toContain"),z.replaceText(Y.args[0],J.getText(F.arguments[0]))]},messageId:"useToContain",node:H})}}}}),RULE_NAME$f="prefer-expect-assertions",L=q=>{let $=q;for(;$;){if($.parent?.type===utils.AST_NODE_TYPES.BlockStatement)return $.parent.body[0]===$;if($.parent?.type===utils.AST_NODE_TYPES.ArrowFunctionExpression)return!0;$=$.parent}throw new Error("Could not find parent block statement")},y$2=(q,$,Y)=>({messageId:"suggestRemovingExtraArguments",fix:B=>removeExtraArgumentsFixer(B,q,$,Y)}),vr=createEslintRule({name:"prefer-expect-assertions",meta:{docs:{description:"enforce using expect assertions instead of callbacks",recommended:!1},messages:{hasAssertionsTakesNoArguments:"`expect.hasAssertions` expects no arguments",assertionsRequiresOneArgument:"`expect.assertions` excepts a single argument of type number",assertionsRequiresNumberArgument:"This argument should be a number",haveExpectAssertions:"Every test should have either `expect.assertions(<number of assertions>)` or `expect.hasAssertions()` as its first expression",suggestAddingHasAssertions:"Add `expect.hasAssertions()`",suggestAddingAssertions:"Add `expect.assertions(<number of assertions>)`",suggestRemovingExtraArguments:"Remove extra arguments"},type:"suggestion",hasSuggestions:!0,schema:[{type:"object",properties:{onlyFunctionsWithAsyncKeyword:{type:"boolean"},onlyFunctionsWithExpectInLoop:{type:"boolean"},onlyFunctionsWithExpectInCallback:{type:"boolean"}},additionalProperties:!1}]},defaultOptions:[{onlyFunctionsWithAsyncKeyword:!1,onlyFunctionsWithExpectInCallback:!1,onlyFunctionsWithExpectInLoop:!1}],create(q,[$]){let Y=0,B=!1,F=!1,W=!1,H=null,V=!1,G=!1;const z=Z=>!!(!$.onlyFunctionsWithAsyncKeyword&&!$.onlyFunctionsWithExpectInCallback&&!$.onlyFunctionsWithExpectInLoop||$.onlyFunctionsWithAsyncKeyword&&Z.async||$.onlyFunctionsWithExpectInCallback&&B||$.onlyFunctionsWithExpectInLoop&&F);function J(Z,te){if(getAccessorValue(Z.members[0])==="hasAssertions"){Z.args.length&&q.report({messageId:"hasAssertionsTakesNoArguments",node:Z.matcher,suggest:[y$2(q,te,0)]});return}if(Z.args.length!==1){let{loc:oe}=Z.matcher;const ne=[];Z.args.length&&(oe=Z.args[1].loc,ne.push(y$2(q,te,1))),q.report({messageId:"assertionsRequiresOneArgument",suggest:ne,loc:oe});return}const[re]=Z.args;re.type===utils.AST_NODE_TYPES.Literal&&typeof re.value=="number"&&Number.isInteger(re.value)||q.report({messageId:"assertionsRequiresNumberArgument",node:re})}const X=()=>V&&Y++,ee=()=>V&&Y--,Q=()=>G=!0,se=()=>G=!1;return{FunctionExpression:X,"FunctionExpression:exit":ee,ArrowFunctionExpression:X,"ArrowFunctionExpression:exit":ee,ForStatement:Q,"ForStatement:exit":se,ForInStatement:Q,"ForInStatement:exit":se,ForOfStatement:Q,"ForOfStatement:exit":se,CallExpression(Z){const te=parseVitestFnCall(Z,q);if(te?.type==="test"){V=!0;return}te?.head.type==="testContext"&&te.members[0]&&te.members[0].type===utils.AST_NODE_TYPES.Identifier&&te.members[0].name==="expect"&&(H=`${te.head.local}`),te?.type==="expect"&&V&&(Y===1&&L(Z)&&te.head.node.parent?.type===utils.AST_NODE_TYPES.MemberExpression&&te.members.length===1&&["assertions","hasAssertions"].includes(getAccessorValue(te.members[0]))&&(J(te,Z),W=!0),G&&(F=!0),Y>1&&(B=!0))},"CallExpression:exit"(Z){if(!isTypeOfVitestFnCall(Z,q,["test"])||(V=!1,Z.arguments.length<2))return;const[,te]=Z.arguments;if(!isFunction(te)||!z(te))return;if(F=!1,B=!1,W){W=!1;return}const re=[];if(te.body.type===utils.AST_NODE_TYPES.BlockStatement){const oe=H?`${H}.`:"";re.push(["suggestAddingHasAssertions",`${oe}expect.hasAssertions();`],["suggestAddingAssertions",`${oe}expect.assertions();`])}q.report({messageId:"haveExpectAssertions",node:Z,suggest:re.map(([oe,ne])=>({messageId:oe,fix:ie=>ie.insertTextBeforeRange([te.body.range[0]+1,te.body.range[1]],ne)}))})}}}});var PaddingType=(q=>(q[q.Any=0]="Any",q[q.Always=1]="Always",q))(PaddingType||{}),StatementType=(q=>(q[q.Any=0]="Any",q[q.AfterAllToken=1]="AfterAllToken",q[q.AfterEachToken=2]="AfterEachToken",q[q.BeforeAllToken=3]="BeforeAllToken",q[q.BeforeEachToken=4]="BeforeEachToken",q[q.DescribeToken=5]="DescribeToken",q[q.ExpectToken=6]="ExpectToken",q[q.ExpectTypeOfToken=7]="ExpectTypeOfToken",q[q.FdescribeToken=8]="FdescribeToken",q[q.FitToken=9]="FitToken",q[q.ItToken=10]="ItToken",q[q.TestToken=11]="TestToken",q[q.XdescribeToken=12]="XdescribeToken",q[q.XitToken=13]="XitToken",q[q.XtestToken=14]="XtestToken",q))(StatementType||{});const x$1=(q,$,Y)=>{const{sourceCode:B,ruleContext:F}=Y;getPaddingLineSequences(q,$,B).length>0||F.report({node:$,messageId:"missingPadding",fix(W){let H=getActualLastToken(B,q);const V=B.getFirstTokenBetween(H,$,{includeComments:!0,filter(z){return areTokensOnSameLine(H,z)?(H=z,!1):!0}})||$,G=areTokensOnSameLine(H,V)?`

`:`
`;return W.insertTextAfter(H,G)}})},m$2={0:()=>!0,1:x$1},y$1=()=>{let q=null;return{get prevNode(){return q.prevNode},set prevNode($){q.prevNode=$},enter(){q={upper:q,prevNode:null}},exit(){q=q.upper}}},i=q=>($,Y)=>{let B=$;if(B.type===utils.AST_NODE_TYPES.ExpressionStatement){B.expression.type===utils.AST_NODE_TYPES.AwaitExpression&&(B=B.expression.argument);const F=Y.getFirstToken(B);return F?.type===utils.AST_TOKEN_TYPES.Identifier&&F.value===q}return!1},A={0:()=>!0,1:i("afterAll"),2:i("afterEach"),3:i("beforeAll"),4:i("beforeEach"),5:i("describe"),6:i("expect"),7:i("expectTypeOf"),8:i("fdescribe"),9:i("fit"),10:i("it"),11:i("test"),12:i("xdescribe"),13:i("xit"),14:i("xtest")},l=(q,$,Y)=>{let B=q;const{sourceCode:F}=Y;for(;B.type===utils.AST_NODE_TYPES.LabeledStatement;)B=B.body;return Array.isArray($)?$.some(W=>l(B,W,Y)):A[$](B,F)},N$1=(q,$,Y)=>{const{configs:B}=Y,F=W=>m$2[W](q,$,Y);for(let W=B.length-1;W>=0;--W){const{prevStatementType:H,nextStatementType:V,paddingType:G}=B[W];if(l(q,H,Y)&&l($,V,Y))return F(G)}return F(0)},u=(q,$)=>{const{scopeInfo:Y}=$;isValidParent(q?.parent.type)&&(Y.prevNode&&N$1(Y.prevNode,q,$),Y.prevNode=q)},createPaddingRule=(q,$,Y,B=!1)=>createEslintRule({name:q,meta:{docs:{description:$},fixable:"whitespace",deprecated:B,messages:{missingPadding:"expect blank line before this statement"},schema:[],type:"suggestion"},defaultOptions:[],create(F){const W={ruleContext:F,sourceCode:F.sourceCode??F.getSourceCode(),scopeInfo:y$1(),configs:Y},{scopeInfo:H}=W;return{Program:H.enter,"Program:exit":H.exit,BlockStatement:H.enter,"BlockStatement:exit":H.exit,SwitchStatement:H.enter,"SwitchStatement:exit":H.exit,":statement":V=>u(V,W),SwitchCase(V){u(V,W),H.enter()},"SwitchCase:exit":H.exit}}}),RULE_NAME$e="padding-around-after-all-blocks",config$6=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.AfterAllToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.AfterAllToken,nextStatementType:StatementType.Any}],Cr=createPaddingRule(RULE_NAME$e,"Enforce padding around `afterAll` blocks",config$6),RULE_NAME$d="padding-around-after-each-blocks",config$5=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.AfterEachToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.AfterEachToken,nextStatementType:StatementType.Any}],Br=createPaddingRule(RULE_NAME$d,"Enforce padding around `afterEach` blocks",config$5),RULE_NAME$c="padding-around-before-all-blocks",config$4=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.BeforeAllToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.BeforeAllToken,nextStatementType:StatementType.Any}],Ir=createPaddingRule(RULE_NAME$c,"Enforce padding around `beforeAll` blocks",config$4),RULE_NAME$b="padding-around-before-each-blocks",config$3=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.BeforeEachToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.BeforeEachToken,nextStatementType:StatementType.Any}],Sr=createPaddingRule(RULE_NAME$b,"Enforce padding around `beforeEach` blocks",config$3),RULE_NAME$a="padding-around-describe-blocks",config$2=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:[StatementType.DescribeToken,StatementType.FdescribeToken,StatementType.XdescribeToken]},{paddingType:PaddingType.Always,prevStatementType:[StatementType.DescribeToken,StatementType.FdescribeToken,StatementType.XdescribeToken],nextStatementType:StatementType.Any}],Or=createPaddingRule(RULE_NAME$a,"Enforce padding around `describe` blocks",config$2),RULE_NAME$9="padding-around-expect-groups",config$1=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.ExpectToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.ExpectToken,nextStatementType:StatementType.Any},{paddingType:PaddingType.Any,prevStatementType:StatementType.ExpectToken,nextStatementType:StatementType.ExpectToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.ExpectTypeOfToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.ExpectTypeOfToken,nextStatementType:StatementType.Any},{paddingType:PaddingType.Any,prevStatementType:StatementType.ExpectTypeOfToken,nextStatementType:StatementType.ExpectTypeOfToken}],Dr=createPaddingRule(RULE_NAME$9,"Enforce padding around `expect` groups",config$1),RULE_NAME$8="padding-around-test-blocks",config=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:[StatementType.TestToken,StatementType.ItToken,StatementType.FitToken,StatementType.XitToken,StatementType.XtestToken]},{paddingType:PaddingType.Always,prevStatementType:[StatementType.TestToken,StatementType.ItToken,StatementType.FitToken,StatementType.XitToken,StatementType.XtestToken],nextStatementType:StatementType.Any}],Hr=createPaddingRule(RULE_NAME$8,"Enforce padding around `test` blocks",config),RULE_NAME$7="padding-around-all",yr=createPaddingRule(RULE_NAME$7,"Enforce padding around vitest functions",[...config$6,...config$5,...config$4,...config$3,...config$2,...config$1,...config]),RULE_NAME$6="valid-expect-in-promise",w=["toRejectWith","toResolveWith"],c=q=>{if(q.type===utils.AST_NODE_TYPES.CallExpression&&q.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(q.callee.property)){if(q.arguments.length===0)return!1;switch(getAccessorValue(q.callee.property)){case"then":return q.arguments.length<3;case"catch":case"finally":return q.arguments.length<2}}return!1},k=(q,$)=>{const Y=parseVitestFnCall(q,$);if(Y?.type!=="test")return!1;const B=Y.members.some(H=>getAccessorValue(H)==="each");if(B&&q.callee.type!==utils.AST_NODE_TYPES.TaggedTemplateExpression)return!0;const[,F]=q.arguments,W=Number(B);return F&&isFunction(F)&&F.params.length===1+W},x=(q,$)=>{const{name:Y}=$;if(q.argument===null)return!1;if(q.argument.type===utils.AST_NODE_TYPES.CallExpression&&q.argument.arguments.length>0){const B=getNodeName(q.argument);if(["Promise.all","Promise.allSettled"].includes(B)){const[F]=q.argument.arguments;if(F.type===utils.AST_NODE_TYPES.ArrayExpression&&F.elements.some(W=>W&&isIdentifier(W,Y)))return!0}if(["Promise.resolve","Promise.reject"].includes(B)&&q.argument.arguments.length===1)return isIdentifier(q.argument.arguments[0],Y)}return isIdentifier(q.argument,Y)},h=(q,$)=>{for(const Y of $)if(Y?.type===utils.AST_NODE_TYPES.AwaitExpression&&isIdentifier(Y.argument,q)||Y?.type===utils.AST_NODE_TYPES.ArrayExpression&&h(q,Y.elements))return!0;return!1},M=(q,$)=>{let Y=$;for(;Y;){if(Y.type===utils.AST_NODE_TYPES.CallExpression){if(h(q,Y.arguments))return!0;Y=Y.callee}if(Y.type!==utils.AST_NODE_TYPES.MemberExpression)break;Y=Y.object}return!1},N=q=>{let $=q,Y=q;for(;Y&&(Y.type===utils.AST_NODE_TYPES.CallExpression&&($=Y,Y=Y.callee),Y.type===utils.AST_NODE_TYPES.MemberExpression);)Y=Y.object;return $},m$1=(q,$,Y)=>{const{name:B}=q;for(const F of $)if(!(F.range[0]<=q.range[0])){if(F.type===utils.AST_NODE_TYPES.ReturnStatement)return x(F,q);if(F.type===utils.AST_NODE_TYPES.ExpressionStatement){if(F.expression.type===utils.AST_NODE_TYPES.CallExpression){if(M(B,F.expression))return!0;const W=N(F.expression),H=parseVitestFnCall(F.expression,Y);if(H?.type==="expect"&&W.arguments.length>0&&isIdentifier(W.arguments[0],B)&&H.members.some(V=>{const G=getAccessorValue(V);return G===ModifierName.resolves||G===ModifierName.rejects}))return!0}if(F.expression.type===utils.AST_NODE_TYPES.AwaitExpression&&x(F.expression,q))return!0;if(F.expression.type===utils.AST_NODE_TYPES.AssignmentExpression){if(isIdentifier(F.expression.left,B)&&getNodeName(F.expression.right)?.startsWith(`${B}.`)&&c(F.expression.right))continue;break}}if(F.type===utils.AST_NODE_TYPES.BlockStatement&&m$1(q,F.body,Y))return!0}return!1},y=q=>{let $=q;for(;$;){if($.type===utils.AST_NODE_TYPES.BlockStatement)return $.body;$=$.parent}throw new Error("Could not find BlockStatement - please file a github issue at https://github.com/vitest-dev/eslint-plugin-vitest")},I=(q,$)=>{let Y=q;for(;Y;){if(isFunction(Y))return Y=Y.parent,Y?.type===utils.AST_NODE_TYPES.CallExpression&&isTypeOfVitestFnCall(Y,$,["test"]);Y=Y.parent}return!1},P=(q,$)=>{const Y=y(q);return isIdentifier(q.id)?m$1(q.id,Y,$):!0},qr=createEslintRule({name:RULE_NAME$6,meta:{docs:{description:"require promises that have expectations in their chain to be valid"},messages:{expectInFloatingPromise:"This promise should either be returned or awaited to ensure the expects in its chain are called"},type:"suggestion",schema:[]},defaultOptions:[{alwaysAwait:!1,asyncMatchers:w,minArgs:1,maxArgs:1}],create(q){let $=!1;const Y=[];return{CallExpression(B){if(k(B,q)){$=!0;return}if(c(B)){Y.unshift(!1);return}Y.length>0&&isTypeOfVitestFnCall(B,q,["expect"])&&(Y[0]=!0)},"CallExpression:exit"(B){if($){isTypeOfVitestFnCall(B,q,["test"])&&($=!1);return}if(!c(B)||!Y.shift())return;const{parent:F}=findTopMostCallExpression(B);if(!(!F||!I(F,q))){switch(F.type){case utils.AST_NODE_TYPES.VariableDeclarator:{if(P(F,q))return;break}case utils.AST_NODE_TYPES.AssignmentExpression:{if(F.left.type===utils.AST_NODE_TYPES.Identifier&&m$1(F.left,y(F),q))return;break}case utils.AST_NODE_TYPES.ExpressionStatement:break;case utils.AST_NODE_TYPES.ReturnStatement:case utils.AST_NODE_TYPES.AwaitExpression:default:return}q.report({messageId:"expectInFloatingPromise",node:F})}}}}}),RULE_NAME$5="prefer-strict-boolean-matchers",Fr=createEslintRule({name:RULE_NAME$5,meta:{type:"suggestion",docs:{description:"enforce using `toBe(true)` and `toBe(false)` over matchers that coerce types to boolean",recommended:!1},messages:{preferToBeTrue:"Prefer using `toBe(true)` to test value is `true`",preferToBeFalse:"Prefer using `toBe(false)` to test value is `false`"},fixable:"code",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(!(Y?.type==="expect"||Y?.type==="expectTypeOf"))return;const B=getAccessorValue(Y.matcher);B==="toBeFalsy"&&q.report({node:Y.matcher,messageId:"preferToBeFalse",fix:F=>[F.replaceText(Y.matcher,"toBe"),F.insertTextAfterRange([Y.matcher.range[0],Y.matcher.range[1]+1],"false")]}),B==="toBeTruthy"&&q.report({node:Y.matcher,messageId:"preferToBeTrue",fix:F=>[F.replaceText(Y.matcher,"toBe"),F.insertTextAfterRange([Y.matcher.range[0],Y.matcher.range[1]+1],"true")]})}}}}),RULE_NAME$4="require-mock-type-parameters",Vr=createEslintRule({name:RULE_NAME$4,meta:{type:"suggestion",docs:{description:"enforce using type parameters with vitest mock functions",recommended:!1},messages:{noTypeParameter:"Missing type parameters"},fixable:"code",schema:[{type:"object",properties:{checkImportFunctions:{type:"boolean"}},additionalProperties:!1}]},defaultOptions:[{checkImportFunctions:!1}],create(q,[$]){return{CallExpression(Y){const B=parseVitestFnCall(Y,q);if(B?.type==="vi")for(const F of B?.members)!("name"in F)||F.parent.parent.typeArguments!==void 0||(F.name==="fn"&&q.report({node:F,messageId:"noTypeParameter"}),$.checkImportFunctions&&["importActual","importMock"].includes(F.name)&&q.report({node:F,messageId:"noTypeParameter"}))}}}}),RULE_NAME$3="prefer-called-once",m=q=>q.type===utils.AST_NODE_TYPES.Literal&&q.value===1,Pr=createEslintRule({name:RULE_NAME$3,meta:{docs:{description:"enforce using `toBeCalledOnce()` or `toHaveBeenCalledOnce()`",recommended:!1},messages:{preferCalledOnce:"Prefer {{ replacedMatcherName }}()"},type:"suggestion",fixable:"code",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect")return;const{matcher:B}=Y,F=getAccessorValue(B);if(["toBeCalledTimes","toHaveBeenCalledTimes"].includes(F)&&Y.args.length===1&&m(getFirstMatcherArg(Y))){const W=F.replace("Times","Once");q.report({data:{replacedMatcherName:W},messageId:"preferCalledOnce",node:B,fix:H=>[H.replaceText(B,W),H.remove(Y.args[0])]})}}}}}),RULE_NAME$2="prefer-called-times",Gr=createEslintRule({name:RULE_NAME$2,meta:{docs:{description:"enforce using `toBeCalledTimes(1)` or `toHaveBeenCalledTimes(1)`",recommended:!1},messages:{preferCalledTimes:"Prefer {{ replacedMatcherName }}(1)"},type:"suggestion",fixable:"code",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect")return;const{matcher:B}=Y,F=getAccessorValue(B);if(["toBeCalledOnce","toHaveBeenCalledOnce"].includes(F)){const W=F.replace("Once","Times");q.report({data:{replacedMatcherName:W},messageId:"preferCalledTimes",node:B,fix:H=>[H.replaceText(B,W),H.insertTextAfterRange([Y.matcher.range[0],Y.matcher.range[1]+1],"1")]})}}}}}),RULE_NAME$1="prefer-expect-type-of",g={string:"toBeString",number:"toBeNumber",boolean:"toBeBoolean",object:"toBeObject",function:"toBeFunction",symbol:"toBeSymbol",bigint:"toBeBigInt",undefined:"toBeUndefined"},jr=createEslintRule({name:RULE_NAME$1,meta:{type:"suggestion",docs:{description:"enforce using `expectTypeOf` instead of `expect(typeof ...)`",recommended:!1},schema:[],fixable:"code",messages:{preferExpectTypeOf:'Use `expectTypeOf({{ value }}).{{ matcher }}()` instead of `expect(typeof {{ value }}).toBe("{{ type }}")`'}},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="expect"||Y.head.node.parent?.type!==utils.AST_NODE_TYPES.CallExpression)return;const B=Y.head.node.parent,[F]=B.arguments;if(!F||F.type!==utils.AST_NODE_TYPES.UnaryExpression||F.operator!=="typeof")return;const W=getAccessorValue(Y.matcher);if(W!=="toBe"&&W!=="toEqual")return;const[H]=Y.args;if(!H||H.type!==utils.AST_NODE_TYPES.Literal||typeof H.value!="string")return;const V=H.value,G=g[V];if(!G)return;const z=q.sourceCode.getText(F.argument),J=Y.modifiers.map(ee=>getAccessorValue(ee)).join("."),X=J?`.${J}`:"";q.report({node:$,messageId:"preferExpectTypeOf",data:{value:z,matcher:G,type:V},fix(ee){return ee.replaceText($,`expectTypeOf(${z})${X}.${G}()`)}})}}}}),RULE_NAME="warn-todo",Kr=createEslintRule({name:RULE_NAME,meta:{docs:{description:"disallow `.todo` usage",recommended:!1},messages:{warnTodo:"The use of `.todo` is not recommended."},type:"suggestion",schema:[]},defaultOptions:[],create(q){return{CallExpression($){const Y=parseVitestFnCall($,q);if(Y?.type!=="describe"&&Y?.type!=="test"&&Y?.type!=="it")return;const B=Y.members.find(F=>F.type==="Identifier"&&F.name==="todo");B&&q.report({messageId:"warnTodo",node:B})}}}}),Te=q=>Object.keys(q).reduce(($,Y)=>({...$,[`vitest/${Y}`]:q[Y]}),{}),Ue=q=>({plugins:["@vitest"],rules:Object.keys(q).reduce(($,Y)=>({...$,[`@vitest/${Y}`]:q[Y]}),{})}),_e={[RULE_NAME$18]:"warn",[RULE_NAME$17]:"warn",[RULE_NAME$15]:"warn",[RULE_NAME$14]:"warn",[RULE_NAME$11]:"warn",[RULE_NAME$10]:"warn",[RULE_NAME$_]:"warn",[RULE_NAME$Z]:"warn",[RULE_NAME$Y]:"warn",[RULE_NAME$X]:"warn",[RULE_NAME$W]:"warn",[RULE_NAME$U]:"warn",[RULE_NAME$Q]:"warn",[RULE_NAME$P]:"warn",[RULE_NAME$O]:"warn",[RULE_NAME$N]:"warn",[RULE_NAME$M]:"warn",[RULE_NAME$L]:"warn",[RULE_NAME$K]:"warn",[RULE_NAME$J]:"warn",[RULE_NAME$I]:"warn",[RULE_NAME$H]:"warn",[RULE_NAME$G]:"warn",[RULE_NAME$F]:"warn",[RULE_NAME$A]:"off",[RULE_NAME$C]:"warn",[RULE_NAME$B]:"off",[RULE_NAME$z]:"warn",[RULE_NAME$y]:"warn",[RULE_NAME$x]:"warn",[RULE_NAME$w]:"warn",[RULE_NAME$v]:"warn",[RULE_NAME$u]:"warn",[RULE_NAME$t]:"warn",[RULE_NAME$s]:"warn",[RULE_NAME$r]:"warn",[RULE_NAME$q]:"warn",[RULE_NAME$o]:"warn",[RULE_NAME$n]:"warn",[RULE_NAME$m]:"warn",[RULE_NAME$k]:"warn",[RULE_NAME$j]:"warn",[RULE_NAME$i]:"warn",[RULE_NAME$h]:"warn",[RULE_NAME$g]:"warn",[RULE_NAME$f]:"warn",[RULE_NAME$$]:"warn",[RULE_NAME$e]:"warn",[RULE_NAME$d]:"warn",[RULE_NAME$7]:"warn",[RULE_NAME$c]:"warn",[RULE_NAME$b]:"warn",[RULE_NAME$a]:"warn",[RULE_NAME$9]:"warn",[RULE_NAME$8]:"warn",[RULE_NAME$6]:"warn",[RULE_NAME$13]:"warn",[RULE_NAME$16]:"warn",[RULE_NAME$V]:"warn",[RULE_NAME$E]:"warn",[RULE_NAME$D]:"warn",[RULE_NAME$p]:"warn",[RULE_NAME$l]:"warn",[RULE_NAME$T]:"warn",[RULE_NAME$5]:"warn",[RULE_NAME$4]:"warn",[RULE_NAME$S]:"off",[RULE_NAME$R]:"warn",[RULE_NAME$3]:"off",[RULE_NAME$2]:"warn",[RULE_NAME$1]:"warn",[RULE_NAME$12]:"warn"},be={[RULE_NAME$13]:"error",[RULE_NAME$16]:"error",[RULE_NAME$V]:"error",[RULE_NAME$E]:"error",[RULE_NAME$D]:"error",[RULE_NAME$p]:"error",[RULE_NAME$l]:"error",[RULE_NAME$T]:"error"},Wr={[RULE_NAME$18]:ge,[RULE_NAME$17]:ke,[RULE_NAME$16]:xe,[RULE_NAME$15]:ve,[RULE_NAME$14]:Ce,[RULE_NAME$13]:Be,[RULE_NAME$12]:ye,[RULE_NAME$11]:Ie,[RULE_NAME$10]:Se,[RULE_NAME$$]:Oe,[RULE_NAME$_]:De,[RULE_NAME$Z]:He,[RULE_NAME$Y]:qe,[RULE_NAME$X]:Fe,[RULE_NAME$W]:Ve,[RULE_NAME$V]:Pe,[RULE_NAME$U]:Ge,[RULE_NAME$Q]:We,[RULE_NAME$P]:ze,[RULE_NAME$O]:Je,[RULE_NAME$N]:Qe,[RULE_NAME$M]:Xe,[RULE_NAME$L]:Ye,[RULE_NAME$K]:Ze,[RULE_NAME$J]:er,[RULE_NAME$I]:rr,[RULE_NAME$H]:or,[RULE_NAME$G]:ar,[RULE_NAME$T]:je,[RULE_NAME$F]:tr,[RULE_NAME$E]:sr,[RULE_NAME$D]:nr,[RULE_NAME$A]:pr,[RULE_NAME$C]:ir,[RULE_NAME$B]:mr,[RULE_NAME$z]:Er,[RULE_NAME$y]:fr,[RULE_NAME$x]:lr,[RULE_NAME$w]:Nr,[RULE_NAME$v]:cr,[RULE_NAME$u]:dr,[RULE_NAME$t]:Ar,[RULE_NAME$l]:_r,[RULE_NAME$s]:Mr,[RULE_NAME$r]:wr,[RULE_NAME$q]:Rr,[RULE_NAME$p]:ur,[RULE_NAME$o]:Lr,[RULE_NAME$n]:Tr,[RULE_NAME$m]:Ur,[RULE_NAME$k]:br,[RULE_NAME$j]:hr,[RULE_NAME$i]:gr,[RULE_NAME$h]:kr,[RULE_NAME$g]:xr,[RULE_NAME$f]:vr,[RULE_NAME$e]:Cr,[RULE_NAME$d]:Br,[RULE_NAME$7]:yr,[RULE_NAME$c]:Ir,[RULE_NAME$b]:Sr,[RULE_NAME$a]:Or,[RULE_NAME$9]:Dr,[RULE_NAME$8]:Hr,[RULE_NAME$6]:qr,[RULE_NAME$5]:Fr,[RULE_NAME$4]:Vr,[RULE_NAME$S]:Ke,[RULE_NAME$R]:$e,[RULE_NAME$3]:Pr,[RULE_NAME$2]:Gr,[RULE_NAME$1]:jr,[RULE_NAME]:Kr},f={meta:{name:"vitest",version},rules:Wr,environments:{env:{globals:{suite:!0,test:!0,describe:!0,it:!0,expectTypeOf:!0,assertType:!0,expect:!0,assert:!0,chai:!0,vitest:!0,vi:!0,beforeAll:!0,afterAll:!0,beforeEach:!0,afterEach:!0,onTestFailed:!0,onTestFinished:!0}}},configs:{"legacy-recommended":Ue(be),"legacy-all":Ue(_e),recommended:{name:"vitest/recommended",plugins:{get vitest(){return f}},rules:Te(be)},all:{name:"vitest/all",plugins:{get vitest(){return f}},rules:Te(_e)},env:{name:"vitest/env",languageOptions:{globals:{suite:"writable",test:"writable",describe:"writable",it:"writable",expectTypeOf:"writable",assertType:"writable",expect:"writable",assert:"writable",chai:"writable",vitest:"writable",vi:"writable",beforeAll:"writable",afterAll:"writable",beforeEach:"writable",afterEach:"writable",onTestFailed:"writable",onTestFinished:"writable"}}}}};module.exports=f;
