/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.easyExcel.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class LocalDateConverter
implements Converter<LocalDate> {
    public Class<LocalDate> supportJavaTypeKey() {
        return LocalDate.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalDate convertToJavaData(ReadConverterContext<?> context) {
        GregorianCalendar calendar = new GregorianCalendar(1900, 0, -1);
        Date gregorianDate = calendar.getTime();
        return LocalDate.parse(new SimpleDateFormat("yyyy-MM-dd").format(LocalDateConverter.addDay(gregorianDate, context.getReadCellData().getNumberValue().intValue())), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<LocalDate> context) {
        return new WriteCellData(((LocalDate)context.getValue()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
    }

    public static Date addDay(Date date, int day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, day);
        date = calendar.getTime();
        return date;
    }
}

