/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.persistence.dao.BpmExeStackExecutorDao;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.model.BpmExeStackExecutor;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmExeStackExecutorManager")
public class BpmExeStackExecutorManagerImpl
extends BaseManagerImpl<BpmExeStackExecutorDao, BpmExeStackExecutor>
implements BpmExeStackExecutorManager {
    @Override
    public BpmExeStackExecutor getByTaskId(String taskId) {
        return ((BpmExeStackExecutorDao)this.baseMapper).getByTaskId(taskId);
    }

    @Override
    public List<BpmExeStackExecutor> getByStackId(String exeStackId) {
        return ((BpmExeStackExecutorDao)this.baseMapper).getByStackId(exeStackId);
    }

    @Override
    @Transactional
    public void deleteByStackId(String stackId) {
        ((BpmExeStackExecutorDao)this.baseMapper).deleteByStackId(stackId);
    }

    @Override
    @Transactional
    public void deleteByStackPath(String stackPath) {
        String[] stackIds = stackPath.split("\\.");
        if (BeanUtils.isEmpty((Object)stackIds)) {
            return;
        }
        ((BpmExeStackExecutorDao)this.baseMapper).deleteByStackIds(stackIds);
    }

    @Override
    public List<BpmIdentity> getBpmIdentitysByStackId(String exeStackId) {
        List<BpmExeStackExecutor> executors = this.getByStackId(exeStackId);
        if (BeanUtils.isNotEmpty(executors)) {
            ArrayList<BpmIdentity> identitys = new ArrayList<BpmIdentity>();
            for (BpmExeStackExecutor executor : executors) {
                if (StringUtil.isZeroEmpty((String)executor.getAssigneeId())) continue;
                String assigneeId = executor.getAssigneeId();
                String assigneeName = "";
                IUserService userService = (IUserService)AppUtil.getBean(IUserService.class);
                IUser user = userService.getUserById(assigneeId);
                if (BeanUtils.isNotEmpty((Object)user)) {
                    assigneeName = user.getFullname();
                }
                DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity(assigneeId, assigneeName, "user");
                identitys.add(bpmIdentity);
            }
            return identitys;
        }
        return Collections.emptyList();
    }
}

