/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.ods.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableFieldManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableManager;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataResource.ods.dao.BizOdsTableDao;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsFieldManager;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsTableManager;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataResource.ods.vo.BizOdsTableExportVo;
import com.artfess.dataShare.dataResource.ods.vo.CatalogTableVo;
import com.artfess.dataShare.dataResource.ods.vo.OdsTableDetailVo;
import com.artfess.dataShare.factory.QueryDataTableFactory;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizOdsTableManagerImpl
extends BaseManagerImpl<BizOdsTableDao, BizOdsTable>
implements BizOdsTableManager {
    @Resource
    BizClusterTableManager clusterTableManager;
    @Resource
    BizClusterTableFieldManager clusterFieldManager;
    @Resource
    BizOdsTableManager odsTableManager;
    @Resource
    BizOdsFieldManager odsFieldManager;
    @Resource
    IdGenerator idGenerator;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTable(String catalogId, String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizClusterTable clusterTable = (BizClusterTable)((Object)this.clusterTableManager.getById((Serializable)((Object)tableId)));
        List<BizClusterTableField> clusterFieldList = this.clusterFieldManager.queryFieldByTableId(tableId);
        BizOdsTable odsTable = new BizOdsTable();
        ArrayList<BizOdsField> odsFieldList = new ArrayList<BizOdsField>();
        String tableName = "ods_" + clusterTable.getTableNameEn();
        BeanUtils.copyNotNullProperties((Object)((Object)odsTable), (Object)((Object)clusterTable));
        odsTable.setTableNameEn(tableName);
        odsTable.setId(this.idGenerator.getSuid());
        odsTable.setOdsCatalogsId(catalogId);
        odsTable.setTablePrefixCode(clusterTable.getTablePrefixCode());
        odsTable.setClusterTableId(clusterTable.getId());
        odsTable.setClusterId(clusterTable.getClusterId());
        odsTable.setDeployed(0);
        odsTable.setDeployedTime(null);
        odsTable.setIsCreateTable(0);
        odsTable.setTotalNum(clusterFieldList.size());
        odsTable.setDbSourceId("ods");
        odsTable.setCreateTableSql(null);
        boolean flag = this.cheackSameClusterTable(clusterTable.getId(), odsTable.getId());
        if (flag) {
            throw new ApplicationException("\u9009\u4e2d\u7684\u6c47\u805a\u5c42\u6570\u636e\u8d44\u6e90\u3010" + clusterTable.getName() + "\u3011\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u518d\u6b21\u4f7f\u7528\uff01");
        }
        for (BizClusterTableField clusterField : clusterFieldList) {
            BizOdsField odsField = new BizOdsField();
            BeanUtils.copyNotNullProperties((Object)((Object)odsField), (Object)((Object)clusterField));
            odsField.setId(this.idGenerator.getSuid());
            odsField.setTableId(odsTable.getId());
            if ("\u7ba1\u7406\u5b57\u6bb5".equals(odsField.getFieldType())) {
                odsField.setFieldType("1");
            } else if ("\u4e1a\u52a1\u5b57\u6bb5".equals(odsField.getFieldType())) {
                odsField.setFieldType("2");
            }
            if (BeanUtils.isEmpty((Object)odsField.getFieldValueType())) {
                odsField.setFieldValueType(1);
            }
            Integer attrLength = odsField.getAttrLength() == null ? 0 : odsField.getAttrLength();
            Integer decimalLen = odsField.getDecimalLen() == null ? 4 : odsField.getDecimalLen();
            String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + odsField.getFieldName() + "` " + FieldUtil.getColumnType(odsField.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + odsField.getDesc() + "' ";
            odsField.setFlSql(fieldSq);
            odsFieldList.add(odsField);
        }
        this.odsTableManager.save((Object)odsTable);
        this.odsFieldManager.saveBatch(odsFieldList);
    }

    @Override
    public boolean saveTableBatch(List<CatalogTableVo> list) throws Exception {
        for (CatalogTableVo entity : list) {
            this.saveTable(entity.getCatalogId(), entity.getTableId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void Deploy(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizOdsTable table = (BizOdsTable)((Object)this.getById((Serializable)((Object)tableId)));
        if ("1".equals(table.getDeployed())) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u5e03");
        }
        List<BizOdsField> fieldList = this.odsFieldManager.queryFieldByTableId(tableId);
        if (fieldList.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
        String tableDesc = table.getTableDesc() == null ? table.getTableNameCh() : table.getTableDesc();
        String createSql = DorisUtils.createTable(template, table.getTableNameEn(), tableDesc, fieldList);
        table.setCreateTableSql(createSql);
        this.update((Model)table);
    }

    @Override
    public OdsTableDetailVo queryTableVo(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        OdsTableDetailVo vo = new OdsTableDetailVo();
        BizOdsTable table = (BizOdsTable)((Object)this.getById((Serializable)((Object)tableId)));
        if (null == table) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u8868");
        }
        vo.setTable(table);
        vo.setFieldList(this.odsFieldManager.queryFieldByTableId(tableId));
        return vo;
    }

    @Override
    public void downloadMainTempFile(HttpServletResponse response, String tableId) throws IOException, Exception {
        BizOdsTable odsTable = (BizOdsTable)((Object)this.getById((Serializable)((Object)tableId)));
        List<BizOdsField> field = this.odsFieldManager.queryFieldByTableId(tableId);
        if (field.size() == 0) {
            throw new ApplicationException("\u8d44\u6e90\u8868\u672a\u8bbe\u7f6e\u5b57\u6bb5\u3002");
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        for (BizOdsField field1 : field) {
            exportMap.put(field1.getName(), field1.getDesc());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)odsTable.getName(), (int)12, exportMap, new ArrayList(), (int)0);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)(odsTable.getName() + "_\u5bfc\u5165\u6a21\u677f"), (HttpServletResponse)response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizOdsTable table = (BizOdsTable)((Object)this.getById((Serializable)((Object)tableId)));
        List<BizOdsField> fieldLists = this.odsFieldManager.queryFieldByTableId(tableId);
        HashMap<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizOdsField field : fieldLists) {
            nameFieldMap.put(field.getDesc(), field.getFieldName());
        }
        List rows = ExcelUtil.ImportDate((MultipartFile)file);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
        for (Map row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            fields.add(BizClusterTableField.PK_NAME);
            values.add("'" + UniqueIdUtil.getSuid() + "'");
            for (Map.Entry map : row.entrySet()) {
                String key;
                String field;
                if (!BeanUtils.isNotEmpty(map.getValue()) || "ID_".equalsIgnoreCase(field = this.getFieldName(key = (String)map.getKey(), fieldLists, (String)nameFieldMap.get(key)))) continue;
                fields.add(field);
                String dataType = this.getDataType(key, fieldLists, (String)nameFieldMap.get(key));
                if ("number".equals(dataType)) {
                    values.add((String)map.getValue());
                    continue;
                }
                values.add("'" + (String)map.getValue() + "'");
            }
            sql.append(table.getTableNameEn());
            sql.append("(" + String.join((CharSequence)",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + String.join((CharSequence)",", values) + ")");
            template.execute(sql.toString());
        }
    }

    private String getFieldName(String key, List<BizOdsField> columnList, String fieldName) {
        for (BizOdsField boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getFieldName();
        }
        return "";
    }

    private String getDataType(String key, List<BizOdsField> columnList, String fieldName) {
        for (BizOdsField boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getDataType();
        }
        return "";
    }

    @Override
    public List<BizOdsTable> queryDeployed() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"DEPLOYED_", (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public QueryResultData queryTableData(QueryParamVo queryParamVo) throws Exception {
        if (StringUtil.isEmpty((String)queryParamVo.getTableId()) && StringUtil.isEmpty((String)queryParamVo.getTableName())) {
            throw new ApplicationException("\u8868ID\u6216\u8005\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties((Object)queryParam, (Object)queryParamVo);
        BizOdsTable table = null;
        if (StringUtil.isNotEmpty((String)queryParam.getTableId())) {
            table = (BizOdsTable)((Object)this.getById((Serializable)((Object)queryParam.getTableId())));
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)queryParamVo.getTableName());
            table = (BizOdsTable)((Object)((BizOdsTableDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        }
        if (table == null) {
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizOdsField> fieldList = this.odsFieldManager.queryFieldByTableId(table.getId());
        Map<String, String> field = fieldList.stream().filter(p -> "2".equals(p.getFieldType())).collect(Collectors.toMap(BizOdsField::getFieldName, p -> p.getName()));
        queryParam.setField(field);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
        queryParam.setJdbcTemplate(template);
        queryParam.setDbType("mysql");
        return QueryDataTableFactory.getTableData(queryParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTable(String tableId) throws Exception {
        BizOdsTable table = (BizOdsTable)((Object)this.getById((Serializable)((Object)tableId)));
        boolean exists = this.checkPhysicsTableExists(table.getTableNameEn());
        if (exists && table.getDeployed() == 1) {
            String dropSql = "drop table " + table.getTableNameEn();
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
            template.execute(dropSql);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID_", (Object)tableId);
        this.removeById((Serializable)((Object)tableId));
        this.odsFieldManager.getBaseMapper().delete((Wrapper)queryWrapper);
    }

    private Boolean cheackSameClusterTable(String clusterTableId, String id) {
        Assert.hasText((String)clusterTableId, (String)"\u8bf7\u9009\u62e9\u5173\u8054\u7684\u6c47\u805a\u8d44\u6e90\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CLUSTER_TABLE_ID_", (Object)clusterTableId);
        queryWrapper.ne(StringUtil.isNotEmpty((String)id), (Object)"ID_", (Object)id);
        Integer num = ((BizOdsTableDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (num > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void export(MultipartFile file, String catalogId) throws Exception {
        ExcelTool util = new ExcelTool(BizOdsTableExportVo.class);
        List list = util.importExcel(file.getInputStream(), Integer.valueOf(3), Integer.valueOf(4));
        if ((list = list.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getTableNameEn())).collect(Collectors.toList())).size() == 0) {
            throw new BaseException("\u8868\u6ca1\u6709\u68c0\u6d4b\u5230\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\uff0c\u6ce8\u610f\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        for (BizOdsTableExportVo vo : list) {
            if (StringUtils.isBlank((CharSequence)vo.getTableNameCh())) continue;
            if (StringUtils.isBlank((CharSequence)vo.getTableNameCh())) {
                throw new BaseException("\u8868" + vo.getName() + "\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)vo.getTableNameEn())) {
                throw new BaseException("\u8868" + vo.getName() + "\u82f1\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.checkTable(vo.getTableNameEn())) {
                throw new BaseException("\u8868\u3010" + vo.getName() + "(" + vo.getCode() + ")\u3011\u5df2\u7ecf\u5b58\u5728");
            }
            if (!this.checkTableCode(vo.getCode())) continue;
            throw new BaseException("\u8868\u3010" + vo.getName() + "(" + vo.getCode() + ")\u3011\u5df2\u7ecf\u5b58\u5728");
        }
        for (BizOdsTableExportVo vo : list) {
            if (StringUtil.isEmpty((String)vo.getCode())) continue;
            BizOdsTable table = BizOdsTableExportVo.parseTable(vo);
            table.setDbSourceId("ods");
            table.setOdsCatalogsId(catalogId);
            table.setIsCreateTable(0);
            table.setDeployed(0);
            table.setSource("1");
            table.setTableType("1");
            table.setTableNameEn("ods_" + table.getTableNameEn());
            this.create((Model)table);
        }
    }

    public boolean checkTable(String tableName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)tableName);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    public boolean checkTableCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CODE_", (Object)code);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    @Transactional
    public void deployHaveTable(String tableId) throws Exception {
        BizOdsTable table = (BizOdsTable)this.get((Serializable)((Object)tableId));
        if (1 == table.getDeployed()) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        this.update((Model)table);
    }

    @Override
    @Transactional
    public void deployDotHaveTable(String tableId, String tableSql) throws Exception {
        BizOdsTable table = (BizOdsTable)this.get((Serializable)((Object)tableId));
        List<BizOdsField> odsFields = this.odsFieldManager.queryFieldByTableId(tableId);
        if (1 == table.getDeployed()) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (odsFields.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        table.setCreateTableSql(tableSql);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        template.execute(table.getCreateTableSql());
        this.update((Model)table);
    }

    @Override
    public boolean checkTableExists(String tableNameEn) throws Exception {
        String sql;
        tableNameEn = "ods_" + tableNameEn.replaceFirst("dw_", "");
        if (this.checkTable(tableNameEn)) {
            return true;
        }
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    public boolean checkPhysicsTableExists(String tableNameEn) throws Exception {
        String sql;
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateCatalog(String[] ids, String catalogId) {
        int count = ((BizOdsTableDao)this.baseMapper).updateCatalog(ids, catalogId);
        return count > 0;
    }
}

