/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.RelAuthManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRelManager;
import com.artfess.uc.model.RelAuth;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserRel;
import com.artfess.uc.params.common.OrgExportObject;
import com.artfess.uc.params.org.RelAuthVo;
import com.artfess.uc.util.OrgUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/relAuth/v1/"})
@Api(tags={"\u6c47\u62a5\u7ebf\u5206\u7ea7\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class RelAuthController
extends BaseController<RelAuthManager, RelAuth> {
    @Autowired
    RelAuthManager relAuthService;
    @Autowired
    UserRelManager userRelService;
    @Autowired
    UserManager userService;

    @RequestMapping(value={"relAuths/getRelAuthPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6c47\u62a5\u7ebf\u5206\u7ea7\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u6c47\u62a5\u7ebf\u5206\u7ea7\u5217\u8868")
    public PageList<RelAuth> getRelAuthPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter filter, @ApiParam(name="relCode", value="\u6c47\u62a5\u7ebf\u7f16\u7801", required=true) @RequestParam String relCode, @ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=false) String account) throws Exception {
        User user;
        UserRel rel = this.userRelService.getByAlias(relCode);
        if (BeanUtils.isEmpty((Object)rel)) {
            throw new RequiredException("\u6c47\u62a5\u7ebf\u7f16\u7801\u3010" + relCode + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        filter.addFilter("a.REL_ID_", (Object)rel.getId(), QueryOP.EQUAL, FieldRelation.AND);
        if (StringUtil.isNotEmpty((String)account) && BeanUtils.isEmpty((Object)(user = this.userService.getByAccount(account)))) {
            throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return this.relAuthService.queryRelAuth(filter);
    }

    @RequestMapping(value={"relAuth/addRelAuth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u6c47\u62a5\u7ebf\u5206\u7ea7", httpMethod="POST", notes="\u6dfb\u52a0\u6c47\u62a5\u7ebf\u5206\u7ea7")
    public CommonResult<String> addRelAuth(@ApiParam(name="relAuthVo", value="\u6c47\u62a5\u7ebf\u5206\u7ea7\u5bf9\u8c61", required=true) @RequestBody RelAuthVo relAuthVo) throws Exception {
        this.relAuthService.addRelAuth(relAuthVo);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"relAuths/addRelAuths"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u914d\u7ba1\u7406\u5458\uff08\u591a\u4e2a\uff09", httpMethod="POST", notes="\u5206\u914d\u7ba1\u7406\u5458\uff08\u591a\u4e2a\uff09")
    public CommonResult<String> addRelAuths(@ApiParam(name="code", value="\u6c47\u62a5\u7ebf\u8282\u70b9\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="accounts", value="\u7528\u6237\u8d26\u53f7\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String accounts) throws Exception {
        return this.relAuthService.addRelAuths(code, accounts);
    }

    @RequestMapping(value={"relAuth/updateRelAuth"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u6c47\u62a5\u7ebf\u5206\u7ea7", httpMethod="PUT", notes="\u4fee\u6539\u6c47\u62a5\u7ebf\u5206\u7ea7")
    public CommonResult<String> updateRelAuth(@ApiParam(name="relAuthVo", value="\u6c47\u62a5\u7ebf\u5206\u7ea7\u5bf9\u8c61", required=true) @RequestBody RelAuthVo relAuthVo) throws Exception {
        this.relAuthService.updateRelAuth(relAuthVo);
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"relAuth/delRelAuth"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6c47\u62a5\u7ebf\u5206\u7ea7", httpMethod="DELETE", notes="\u5220\u9664\u6c47\u62a5\u7ebf\u5206\u7ea7")
    public CommonResult<String> delRelAuth(@ApiParam(name="relCode", value="\u6c47\u62a5\u7ebf\u7f16\u7801", required=true) @RequestParam String relCode, @ApiParam(name="accounts", value="\u7528\u6237\u8d26\u53f7\uff08\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String accounts) throws Exception {
        return this.relAuthService.delRelAuth(relCode, accounts);
    }

    @RequestMapping(value={"relAuth/getRelAuth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6c47\u62a5\u7ebf\u5206\u7ea7", httpMethod="GET", notes="\u83b7\u53d6\u6c47\u62a5\u7ebf\u5206\u7ea7")
    public RelAuth getRelAuth(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="relCode", value="\u6c47\u62a5\u7ebf\u7f16\u7801", required=true) @RequestParam String relCode) throws Exception {
        return this.relAuthService.getRelAuth(account, relCode);
    }

    @RequestMapping(value={"relAuth/deleteRelAuthPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u5206\u7ea7\u6c47\u62a5\u7ebf\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u5206\u7ea7\u6c47\u62a5\u7ebf\u6570\u636e")
    public CommonResult<Integer> deleteRelAuthPhysical() throws Exception {
        Integer num = this.relAuthService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"relAuths/getRelAuthByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5206\u7ea7\u6c47\u62a5\u7ebf\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5206\u7ea7\u6c47\u62a5\u7ebf\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<RelAuth> getRelAuthByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        return this.relAuthService.getRelAuthByTime(exportObject);
    }
}

