/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.ReportTypeEnum;
import com.artfess.base.enums.SubjectTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.dao.QfFinanceCfMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinanceCfDManager;
import com.artfess.cqlt.manager.QfFinanceCfMManager;
import com.artfess.cqlt.manager.QfFinanceCfSManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.manager.QfReportLogManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceCfD;
import com.artfess.cqlt.model.QfFinanceCfM;
import com.artfess.cqlt.model.QfFinanceCfS;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.ReportVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceCfMManagerImpl
extends BaseManagerImpl<QfFinanceCfMDao, QfFinanceCfM>
implements QfFinanceCfMManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinanceCfMManagerImpl.class);
    @Autowired
    private QfFinanceCfDManager detailManager;
    @Autowired
    private QfFinanceCfSManager sumManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;
    @Autowired
    private QfFinancialStatisticalManager qfFinancialStatisticalManager;
    @Autowired
    private QfReportLogManager reportLogManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceCfM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinanceCfMS = ((QfFinanceCfMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceCfMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceCfMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceCfM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinanceCfMS = ((QfFinanceCfMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceCfMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceCfMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinanceCfM t) {
        QfFinanceCfM QfFinanceCfM2 = (QfFinanceCfM)((Object)((QfFinanceCfMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinanceCfM2) {
            return false;
        }
        QfFinanceCfM2.setStatus(QfFinanceCfM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceCfMDao)this.baseMapper).updateById((Object)QfFinanceCfM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        QfFinanceCfM mainInfo = (QfFinanceCfM)((Object)((QfFinanceCfMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)mainInfo), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(mainInfo.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        this.removeInfo(mainId);
        Map<String, List<QfFinanceCfD>> historyMap = this.historyList(mainInfo);
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("CF");
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        HashSet noexitSubjectCodes = Sets.newHashSet();
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> subjectCodes = detailMap.get(1);
        HashMap subjectCodeMap = Maps.newHashMap();
        for (HeaderNode headerNode : subjectCodes) {
            subjectCodeMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        HashSet subjectCodeList = Sets.newHashSet();
        int maxColumn = detailMap.size();
        ArrayList detailList = Lists.newArrayList();
        JSONObject totalInfo = new JSONObject();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            String enterpriseCode = (String)headerMap.get(column);
            List<Object> historyDetailList = Lists.newArrayList();
            if (historyMap.containsKey(enterpriseCode)) {
                historyDetailList = historyMap.get(enterpriseCode);
            }
            for (HeaderNode node : nodes) {
                if (0 == node.getRow()) continue;
                String subjectCode = (String)subjectCodeMap.get(node.getRow());
                subjectCodeList.add(subjectCode);
                if (node.getColumn() > 1 && node.getColumn() < maxColumn - 3 && !StringUtils.isEmpty((Object)node.getHeaderName())) {
                    this.createDetail(mainId, mainInfo, subjectMap, enterpriseInfoMap, noexitSubjectCodes, subjectCodeMap, detailList, enterpriseCode, historyDetailList, node);
                    continue;
                }
                if (node.getColumn() < maxColumn - 3 || StringUtils.isEmpty((Object)node.getHeaderName())) continue;
                if (node.getColumn() == maxColumn - 1) {
                    totalInfo.put(subjectCode + ":actualConsolidated", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() == maxColumn - 2) {
                    totalInfo.put(subjectCode + ":actualPosting", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() != maxColumn - 3) continue;
                totalInfo.put(subjectCode + ":actualTotal", (Object)node.getHeaderName());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)noexitSubjectCodes)) {
            throw new BaseException(((Object)noexitSubjectCodes).toString() + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        List<QfFinanceCfS> totalList = this.getQfFinanceCfS(mainInfo, subjectMap, new ArrayList<String>(subjectCodeList), totalInfo);
        this.sumManager.saveBatch(totalList);
        try {
            this.partitionSave(detailList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u4f8b\u5982\u62a5\u8868\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
        this.asyncReportInfo(mainInfo, detailList, totalList);
        return true;
    }

    private void asyncReportInfo(QfFinanceCfM mainInfo, List<QfFinanceCfD> list, List<QfFinanceCfS> totalList) {
        this.executorService.execute(() -> {
            String msg = null;
            String reportStatus = "0";
            try {
                this.saveFinancialVo(mainInfo, list, totalList);
                reportStatus = "1";
            }
            catch (Exception e) {
                msg = e.getMessage();
                log.error("\u8d22\u52a1\u5927\u5c4f\u62a5\u8868\u5b9e\u9645\u6570\u636e\u751f\u6210\u5931\u8d25:{}", (Object)e.getMessage());
            }
            this.reportLogManager.saveReportInfo(reportStatus, msg, ReportTypeEnum.CF_ACTUAL.getType(), mainInfo.getFillYear(), mainInfo.getFillMonth());
        });
    }

    private void partitionSave(List<QfFinanceCfD> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)(detailList.size() / 10));
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.detailManager.saveOrUpdateBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    private void saveFinancialVo(QfFinanceCfM mainInfo, List<QfFinanceCfD> detailList, List<QfFinanceCfS> totalList) {
        QfEnterpriseInfo group = this.enterpriseInfoManager.getGroup();
        Map<String, QfFinanceCfS> historyMap = this.historyTotalList(mainInfo);
        ArrayList financialVoList = Lists.newArrayList();
        DataInfoVo dataInfoVo = new DataInfoVo();
        dataInfoVo.setYear(mainInfo.getFillYear());
        dataInfoVo.setMonth(mainInfo.getFillMonth());
        dataInfoVo.setQuarter(mainInfo.getFillQuarter());
        detailList.forEach(detail -> {
            ReportVo financialVo = new ReportVo();
            financialVo.setEnterpriseCode(detail.getEnterpriseCode());
            financialVo.setActual(detail.getActual());
            financialVo.setActualYtd(detail.getActualYtd());
            financialVo.setSubjectCode(detail.getSubjectCode());
            financialVoList.add(financialVo);
        });
        totalList.forEach(detail -> {
            ReportVo financialVo = new ReportVo();
            financialVo.setEnterpriseCode(group.getCode());
            financialVo.setActualYtd(detail.getActualConsolidated());
            if (historyMap.containsKey(detail.getSubjectCode())) {
                QfFinanceCfS plS = (QfFinanceCfS)((Object)((Object)historyMap.get(detail.getSubjectCode())));
                if (null == financialVo.getActualYtd()) {
                    financialVo.setActualYtd(BigDecimal.ZERO);
                }
                if (null == plS || null == plS.getActualConsolidated()) {
                    financialVo.setActual(financialVo.getActualYtd());
                } else {
                    financialVo.setActual(financialVo.getActualYtd().subtract(((QfFinanceCfS)((Object)((Object)historyMap.get(detail.getSubjectCode())))).getActualConsolidated()));
                }
            } else {
                financialVo.setActual(financialVo.getActualYtd());
            }
            financialVo.setSubjectCode(detail.getSubjectCode());
            financialVoList.add(financialVo);
        });
        this.qfFinancialStatisticalManager.saveData(financialVoList, dataInfoVo, 1);
    }

    private List<QfFinanceCfS> getQfFinanceCfS(QfFinanceCfM mainInfo, Map<String, QfSubjectInternationalInfo> subjectMap, List<String> subjectCodeList, JSONObject totalInfo) {
        ArrayList totalList = Lists.newArrayList();
        subjectCodeList.forEach(subjectCode -> {
            QfFinanceCfS plS = new QfFinanceCfS();
            plS.setMainId(mainInfo.getId());
            QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(subjectCode)));
            if (null == subjectInternationalInfo) {
                return;
            }
            plS.setSubjectNameEn(subjectInternationalInfo.getNameEn());
            plS.setSubjectUnit(subjectInternationalInfo.getUnit());
            plS.setSubjectName(subjectInternationalInfo.getName());
            if (totalInfo.containsKey((Object)(subjectCode + ":actualConsolidated"))) {
                plS.setActualConsolidated(totalInfo.getBigDecimal(subjectCode + ":actualConsolidated"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":actualPosting"))) {
                plS.setActualPosting(totalInfo.getBigDecimal(subjectCode + ":actualPosting"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":actualTotal"))) {
                plS.setActualTotal(totalInfo.getBigDecimal(subjectCode + ":actualTotal"));
            }
            plS.setFillYear(mainInfo.getFillYear());
            plS.setFillMonth(mainInfo.getFillMonth());
            plS.setFillDate(mainInfo.getFillDate());
            plS.setFillQuarter(mainInfo.getFillQuarter());
            plS.setSubjectCode((String)subjectCode);
            totalList.add(plS);
        });
        return totalList;
    }

    private void createDetail(String mainId, QfFinanceCfM mainInfo, Map<String, QfSubjectInternationalInfo> subjectMap, Map<String, QfEnterpriseInfo> enterpriseInfoMap, Set<String> noexitSubjectCodes, Map<Integer, String> subjectCodeMap, List<QfFinanceCfD> detailList, String enterpriseCode, List<QfFinanceCfD> historyDetailList, HeaderNode node) {
        try {
            QfFinanceCfD financeCfD = new QfFinanceCfD();
            financeCfD.setMainId(mainId);
            financeCfD.setSn(node.getRow());
            financeCfD.setColumn(node.getColumn());
            financeCfD.setFillDate(mainInfo.getFillDate());
            financeCfD.setEnterpriseCode(enterpriseCode);
            financeCfD.setSubjectCode(subjectCodeMap.get(node.getRow()));
            if (!subjectMap.containsKey(financeCfD.getSubjectCode())) {
                noexitSubjectCodes.add(financeCfD.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = subjectMap.get(financeCfD.getSubjectCode());
                financeCfD.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                financeCfD.setSubjectUnit(subjectInternationalInfo.getUnit());
                financeCfD.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    financeCfD.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
                if (subjectInternationalInfo.getType().equals(SubjectTypeEnum.CBFY.getType())) {
                    financeCfD.setActualYtd(new BigDecimal(node.getHeaderName()).multiply(new BigDecimal(-1)));
                } else {
                    financeCfD.setActualYtd(new BigDecimal(node.getHeaderName()));
                }
            }
            Map<String, QfFinanceCfD> historyDetailMap = historyDetailList.stream().collect(Collectors.toMap(item -> item.getSubjectCode(), item -> item));
            if (historyDetailMap.containsKey(financeCfD.getSubjectCode())) {
                QfFinanceCfD historyDetail = historyDetailMap.get(financeCfD.getSubjectCode());
                financeCfD.setActual(financeCfD.getActualYtd().subtract(historyDetail.getActualYtd()));
            } else {
                financeCfD.setActual(financeCfD.getActualYtd());
            }
            if (enterpriseInfoMap.containsKey(financeCfD.getEnterpriseCode())) {
                QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(financeCfD.getEnterpriseCode());
                financeCfD.setEnterpriseName(qfEnterpriseInfo.getName());
                financeCfD.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
            }
            detailList.add(financeCfD);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeInfo(String mainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.detailManager.remove((Wrapper)queryWrapper);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_id_", (Object)mainId);
        this.sumManager.remove((Wrapper)query);
    }

    private Map<String, List<QfFinanceCfD>> historyList(QfFinanceCfM qfFinancePlM) {
        List<QfFinanceCfD> historyList = ((QfFinanceCfMDao)this.baseMapper).historyList(qfFinancePlM.getFillMonth() - 1, qfFinancePlM.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        return historyList.stream().collect(Collectors.groupingBy(QfFinanceCfD::getEnterpriseCode));
    }

    private Map<String, QfFinanceCfS> historyTotalList(QfFinanceCfM mainInfo) {
        List<QfFinanceCfS> historyList = ((QfFinanceCfMDao)this.baseMapper).historyTotalList(mainInfo.getFillMonth() - 1, mainInfo.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        return historyList.stream().collect(Collectors.toMap(item -> item.getSubjectCode(), item -> item));
    }
}

