/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.entity.CqltTreeModel;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.SubjectLevelEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QfSubjectInternationalInfoManagerImpl
extends BaseManagerImpl<QfSubjectInternationalInfoDao, QfSubjectInternationalInfo>
implements QfSubjectInternationalInfoManager {
    @Override
    public List<QfSubjectInternationalInfo> getTree(QfSubjectInternationalInfo entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)entity.getCode())) {
            queryWrapper.like((Object)"code_", (Object)entity.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
            queryWrapper.like((Object)"name_", (Object)entity.getName());
        }
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        queryWrapper.orderByAsc((Object)"sn_");
        List sysList = ((QfSubjectInternationalInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        List tree = BeanUtils.listToTree((List)sysList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfSubjectInternationalInfo> list) {
        list.forEach(subject -> {
            subject.setLevel(SubjectLevelEnum.getType((String)subject.getLevel()));
            if ("1".equals(subject.getLevel())) {
                subject.setParentId("0");
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"code_", (Object)subject.getParentSubjectCode());
            QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)((QfSubjectInternationalInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null != subjectInternationalInfo) {
                subject.setParentId(subjectInternationalInfo.getId());
            }
            subject.setName(subject.getSubjectName());
            subject.setCode(subject.getSubjectCode());
            subject.setSn(subject.getSnn().intValue());
            this.newInsertTree((CqltTreeModel)subject);
        });
        return true;
    }

    @Override
    public boolean batchUpdate() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"create_time_");
        List list = ((QfSubjectInternationalInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        list.forEach(subject -> {
            subject.setSn(this.getNextSequence(null));
            this.newUpdateTree((CqltTreeModel)subject, subject.getName());
        });
        return true;
    }

    @Override
    public Map<String, QfSubjectInternationalInfo> getSubjectCodeMap(String type) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        query.like((Object)"type_", (Object)type);
        List qfSubjectInternationalInfos = ((QfSubjectInternationalInfoDao)this.baseMapper).selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> subjectMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        return subjectMap;
    }

    @Override
    public List<QfSubjectInternationalInfo> findByType(String type) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        query.eq((Object)"type_", (Object)type);
        return ((QfSubjectInternationalInfoDao)this.baseMapper).selectList((Wrapper)query);
    }
}

