/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfReportAuthorityDao;
import com.artfess.cqlt.dao.QfReportInfoDao;
import com.artfess.cqlt.manager.QfReportAuthorityManager;
import com.artfess.cqlt.model.QfReportAuthority;
import com.artfess.cqlt.model.QfReportInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class QfReportAuthorityManagerImpl
extends BaseManagerImpl<QfReportAuthorityDao, QfReportAuthority>
implements QfReportAuthorityManager {
    @Resource
    private QfReportInfoDao reportInfoDao;

    @Override
    public CommonResult<PageList<QfReportAuthority>> selectList(Integer pageNum, Integer pageSize, String reportId) {
        PageBean pageBean = new PageBean();
        pageBean.setPage(pageNum.intValue());
        pageBean.setPageSize(pageSize.intValue());
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), (Object)new PageList(((QfReportAuthorityDao)this.baseMapper).selectByReportId((IPage<QfReportAuthority>)this.convert2IPage(pageBean), reportId)));
    }

    @Override
    public List<QfReportInfo> myAuthList(List<String> currentAndChildOrgIds, String currentUserId, Set<String> roleCodes, QfReportInfo t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtil.isEmpty((String)t.getBusiness())) {
            queryWrapper.eq((Object)"business_", (Object)t.getBusiness());
        }
        if (null != t.getTyep()) {
            queryWrapper.eq((Object)"tyep_", (Object)t.getTyep());
        }
        if (!StringUtil.isEmpty((String)t.getName())) {
            queryWrapper.eq((Object)"name", (Object)t.getName());
        }
        List allList = this.reportInfoDao.selectList((Wrapper)queryWrapper);
        List<String> roleIds = ((QfReportAuthorityDao)this.baseMapper).getRoleIds(roleCodes);
        List<QfReportInfo> qfReportInfos = ((QfReportAuthorityDao)this.baseMapper).myAuthList(currentAndChildOrgIds, currentUserId, roleIds, t);
        Map<String, QfReportInfo> reportInfoMap = qfReportInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        allList.forEach(qfReportInfo -> {
            QfReportInfo report = (QfReportInfo)((Object)((Object)reportInfoMap.get(qfReportInfo.getName())));
            if (null == report || StringUtil.isEmpty((String)report.getAuthority())) {
                qfReportInfo.setAuthority("qurey");
                return;
            }
            String authority = report.getAuthority();
            List<String> strings = Arrays.asList(authority.split(","));
            Long count = strings.stream().filter(x -> x.equals("qurey")).count();
            if (count < 1L) {
                authority = authority + ",qurey";
            }
            qfReportInfo.setAuthority(authority);
        });
        return allList;
    }
}

