/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationMacrMDao;
import com.artfess.cqlt.manager.QfOperationMacrDManager;
import com.artfess.cqlt.manager.QfOperationMacrMManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfOperationMacrD;
import com.artfess.cqlt.model.QfOperationMacrM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfOperationMacrMManagerImpl
extends BaseManagerImpl<QfOperationMacrMDao, QfOperationMacrM>
implements QfOperationMacrMManager {
    @Autowired
    private QfOperationMacrDManager detailManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInfoManager;

    private void processDetail(List<QfOperationMacrD> list, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)id);
        this.detailManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> detail.setMainId(id));
        this.detailManager.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationMacrD> list, String mainId) {
        QfOperationMacrM QfOperationMacrM2 = (QfOperationMacrM)((Object)((QfOperationMacrMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)QfOperationMacrM2), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(QfOperationMacrM2.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.detailManager.remove((Wrapper)queryWrapper);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        query.like((Object)"type_", (Object)"OP");
        List qfSubjectInternationalInfos = this.subjectInfoManager.getBaseMapper().selectList((Wrapper)query);
        Map<String, QfSubjectInternationalInfo> subjectMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(detail -> {
            detail.setMainId(mainId);
            QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(detail.getSubjectName())));
            if (null == subjectInternationalInfo) {
                return;
            }
            if ("%".equals(detail.getSubjectUnit())) {
                detail.setFillData(detail.getFillData().multiply(new BigDecimal(100)));
            }
            detail.setSubjectCode(subjectInternationalInfo.getCode());
            detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
            if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
            }
            detail.setFillDate(LocalDate.now());
        });
        boolean b = this.detailManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationMacrM t) {
        QfOperationMacrM QfOperationMacrM2 = (QfOperationMacrM)((Object)((QfOperationMacrMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfOperationMacrM2) {
            return false;
        }
        QfOperationMacrM2.setStatus(QfOperationMacrM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationMacrMDao)this.baseMapper).updateById((Object)QfOperationMacrM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationMacrM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfOperationMacrMS = ((QfOperationMacrMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfOperationMacrMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationMacrMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationMacrM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfOperationMacrMS = ((QfOperationMacrMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfOperationMacrMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationMacrMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    public List<FaTargetRespVo> data(ReportReqVo t) {
        if (null == t.getYear() || t.getYear() <= 0) {
            int year2 = LocalDate.now().getYear();
            t.setYear(year2);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 5);
        }
        List<QfOperationMacrD> list = ((QfOperationMacrMDao)this.baseMapper).data(t);
        Map<String, List<QfOperationMacrD>> subjectCodeList = list.stream().collect(Collectors.groupingBy(QfOperationMacrD::getSubjectCode));
        ArrayList data = Lists.newArrayList();
        ArrayList newList = Lists.newArrayList();
        subjectCodeList.forEach((k, detailList) -> {
            if ("OP161000".equals(k) || "OP160000".equals(k)) {
                newList.addAll(detailList);
                return;
            }
            FaTargetRespVo resultFa = new FaTargetRespVo();
            if (!CollectionUtils.isEmpty((Collection)detailList)) {
                resultFa.setTargetName(((QfOperationMacrD)((Object)((Object)detailList.get(0)))).getSubjectName());
                resultFa.setTargetNameEn(((QfOperationMacrD)((Object)((Object)detailList.get(0)))).getSubjectNameEn());
                resultFa.setTargetUnit(((QfOperationMacrD)((Object)((Object)detailList.get(0)))).getSubjectUnit());
                resultFa.setTargetId(((QfOperationMacrD)((Object)((Object)detailList.get(0)))).getSubjectCode());
                resultFa.setStaLat("1");
                resultFa.setType("1");
            }
            Map<Integer, List<QfOperationMacrD>> yearList = detailList.stream().collect(Collectors.groupingBy(QfOperationMacrD::getFillYear));
            ArrayList reportRespVos = Lists.newArrayList();
            yearList.forEach((year, v) -> {
                BigDecimal fillData = v.stream().map(QfOperationMacrD::getFillData).reduce(BigDecimal::add).get();
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setYear((Integer)year);
                faReportRespVo.setActual(fillData);
                reportRespVos.add(faReportRespVo);
                resultFa.setResultData(reportRespVos);
            });
            data.add(resultFa);
        });
        FaTargetRespVo resultFa = new FaTargetRespVo();
        resultFa.setTargetName("\u5168\u7403\u6c7d\u8f66\u751f\u4ea7\u9500\u552e\u6570\u636e");
        resultFa.setTargetNameEn("Global car production and sales data");
        resultFa.setTargetUnit("\u8f86");
        resultFa.setTargetId("OP160000");
        resultFa.setStaLat("15,16");
        resultFa.setType("1");
        ArrayList reportRespVos = Lists.newArrayList();
        Map<Integer, List<QfOperationMacrD>> yearList = newList.stream().collect(Collectors.groupingBy(QfOperationMacrD::getFillYear));
        yearList.forEach((year, v) -> {
            FaReportRespVo faReportRespVo = new FaReportRespVo();
            faReportRespVo.setYear((Integer)year);
            v.forEach(subjectInfo -> {
                String subjectCode = subjectInfo.getSubjectCode();
                if ("OP160000".equals(subjectCode)) {
                    faReportRespVo.setActual(subjectInfo.getFillData());
                }
                if ("OP161000".equals(subjectCode)) {
                    faReportRespVo.setBudget(subjectInfo.getFillData());
                }
            });
            reportRespVos.add(faReportRespVo);
            resultFa.setResultData(reportRespVos);
        });
        data.add(resultFa);
        return data;
    }

    @Override
    public List<FaTargetRespVo> fromUnderData(ReportReqVo t) {
        List<QfOperationMacrD> monthData;
        List<QfOperationMacrD> quarterData;
        List<QfOperationMacrD> yearData;
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInfoManager.getSubjectCodeMap("OP");
        QfSubjectInternationalInfo subjectInternationalInfo = subjectMap.get(t.getTargetId());
        if (null == subjectInternationalInfo) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        if (null == t.getYear() || t.getYear() <= 0) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        if (null == t.getStartMonth() || null == t.getEndMonth()) {
            t.setYear(t.getQuarterYear());
            t.setEndMonth(12);
            t.setStartMonth(1);
        }
        if (!CollectionUtils.isEmpty(yearData = ((QfOperationMacrMDao)this.baseMapper).yearData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargetName(subjectInternationalInfo.getSubjectName());
            resultFa.setTargetNameEn(subjectInternationalInfo.getNameEn());
            resultFa.setTargetUnit(subjectInternationalInfo.getUnit());
            resultFa.setTargetId(subjectInternationalInfo.getSubjectCode());
            resultFa.setStaLat("1");
            resultFa.setType("2");
            ArrayList reportRespVos = Lists.newArrayList();
            yearData.forEach(resp -> {
                BigDecimal fillData = resp.getFillData();
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setYear(resp.getFillYear());
                faReportRespVo.setActual(fillData);
                reportRespVos.add(faReportRespVo);
            });
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        if (!CollectionUtils.isEmpty(quarterData = ((QfOperationMacrMDao)this.baseMapper).quarterData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargetName(subjectInternationalInfo.getSubjectName());
            resultFa.setTargetNameEn(subjectInternationalInfo.getNameEn());
            resultFa.setTargetUnit(subjectInternationalInfo.getUnit());
            resultFa.setTargetId(subjectInternationalInfo.getSubjectCode());
            resultFa.setStaLat("1");
            resultFa.setType("3");
            ArrayList reportRespVos = Lists.newArrayList();
            quarterData.forEach(resp -> {
                BigDecimal fillData = resp.getFillData();
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setYear(t.getYear());
                faReportRespVo.setQuarter(resp.getFillQuarter());
                if ("%".equals(resultFa.getTargetUnit())) {
                    faReportRespVo.setActual(fillData.multiply(new BigDecimal(100)));
                } else {
                    faReportRespVo.setActual(fillData);
                }
                reportRespVos.add(faReportRespVo);
            });
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        if (!CollectionUtils.isEmpty(monthData = ((QfOperationMacrMDao)this.baseMapper).monthData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargetName(subjectInternationalInfo.getSubjectName());
            resultFa.setTargetNameEn(subjectInternationalInfo.getNameEn());
            resultFa.setTargetUnit(subjectInternationalInfo.getUnit());
            resultFa.setTargetId(subjectInternationalInfo.getSubjectCode());
            resultFa.setStaLat("1");
            resultFa.setType("4");
            ArrayList reportRespVos = Lists.newArrayList();
            monthData.forEach(resp -> {
                BigDecimal fillData = resp.getFillData();
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setYear(t.getYear());
                faReportRespVo.setMonth(resp.getFillMonth());
                if ("%".equals(resultFa.getTargetUnit())) {
                    faReportRespVo.setActual(fillData.multiply(new BigDecimal(100)));
                } else {
                    faReportRespVo.setActual(fillData);
                }
                reportRespVos.add(faReportRespVo);
            });
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        return resultList;
    }
}

