/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfReportAuthorityManager;
import com.artfess.cqlt.model.QfReportAuthority;
import com.artfess.cqlt.model.QfReportInfo;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u62a5\u8868\u6743\u9650"})
@RestController
@RequestMapping(value={"/qfReportAuthority/v1/"})
@ApiGroup(group={"group_biz"})
public class QfReportAuthorityController
extends BaseController<QfReportAuthorityManager, QfReportAuthority> {
    @Resource
    BaseContext baseContext;

    @PostMapping(value={"/insertInfo"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> insertInfo(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) List<QfReportAuthority> t) {
        if (!((QfReportAuthorityManager)this.baseService).saveOrUpdateBatch(t)) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/updateInfo"})
    @ApiOperation(value="\u4fee\u6539\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> updateInfo(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) List<QfReportAuthority> t) {
        if (!((QfReportAuthorityManager)this.baseService).updateBatchById(t)) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @GetMapping(value={"deleteById/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        if (!((QfReportAuthorityManager)this.baseService).removeById((Serializable)((Object)id))) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @DeleteMapping(value={"deleteByIds"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((QfReportAuthorityManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u6839\u636ereportId\u67e5\u8be2\u6388\u6743\u4fe1\u606f")
    public CommonResult<PageList<QfReportAuthority>> getList(@RequestParam(required=true) Integer pageNum, @RequestParam(required=true) Integer pageSize, @RequestParam(required=true) String reportId) {
        return ((QfReportAuthorityManager)this.baseService).selectList(pageNum, pageSize, reportId);
    }

    @PostMapping(value={"/myAuthList"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u6743\u9650")
    public CommonResult myAuthList(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody QfReportInfo t) {
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        Set roleCodes = AuthenticationUtil.getCurrentUserRolesAlias();
        List<QfReportInfo> list = ((QfReportAuthorityManager)this.baseService).myAuthList(currentAndChildOrgIds, currentUserId, roleCodes, t);
        return CommonResult.success(list, null);
    }
}

