/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CollectionUtils;
import com.artfess.base.util.PinyinUtil;
import com.artfess.cqlt.manager.BizOrgManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.PwdStrategy;
import com.artfess.uc.model.User;
import com.google.api.client.util.Lists;
import com.google.api.client.util.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import net.hasor.db.transaction.interceptor.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class BizOrgManagerImpl
implements BizOrgManager {
    private static final Logger log = LoggerFactory.getLogger(BizOrgManagerImpl.class);
    @Resource
    private OrgManager orgManager;
    @Resource
    private UserManager userManager;
    @Resource
    private OrgUserManager relateManager;
    @Resource
    private PwdStrategyManager pwdStrategyManager;
    @Resource
    private PasswordEncoder passwordEncoder;

    @Override
    @Transactional
    public Boolean sync() throws Exception {
        log.info("\u5f00\u59cb\u540c\u6b65\u6cdb\u5fae\u7ec4\u7ec7\u4eba\u5458\u4fe1\u606f");
        WebClient webClient = WebClient.builder().baseUrl("http://192.168.3.3:80").defaultHeader("User-Agent", new String[]{"Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko)"}).build();
        JSONArray obtainOrg = JSONArray.parseArray((String)((String)((WebClient.RequestBodySpec)webClient.post().uri("/getzzdw", new Object[0])).retrieve().bodyToMono(String.class).block()));
        JSONArray obtainDept = JSONArray.parseArray((String)((String)((WebClient.RequestBodySpec)webClient.post().uri("/getzzbm", new Object[0])).retrieve().bodyToMono(String.class).block()));
        JSONArray obtainUser = JSONArray.parseArray((String)((String)((WebClient.RequestBodySpec)webClient.post().uri("/getQFServlet", new Object[0])).retrieve().bodyToMono(String.class).block()));
        Assert.notNull((Object)obtainOrg, (String)"\u8bf7\u6c42\u7ec4\u7ec7\u6570\u636e\u5931\u8d25");
        Assert.notNull((Object)obtainDept, (String)"\u8bf7\u6c42\u90e8\u95e8\u6570\u636e\u5931\u8d25");
        Assert.notNull((Object)obtainUser, (String)"\u8bf7\u6c42\u7528\u6237\u6570\u636e\u5931\u8d25");
        log.info("\u6cdb\u5fae\u7ec4\u7ec7\u4fe1\u606f:{}", (Object)obtainOrg);
        log.info("\u6cdb\u5fae\u7ec4\u7ec7\u4fe1\u606fobtainDept:{}", (Object)obtainDept);
        log.info("\u6cdb\u5fae\u7ec4\u7ec7\u4fe1\u606fobtainUser:{}", (Object)obtainUser);
        List<Org> orgList = this.buildOrgList(obtainOrg, obtainDept);
        this.orgManager.saveOrUpdateBatch(orgList);
        ArrayList userList = Lists.newArrayList();
        ArrayList orgUserList = Lists.newArrayList();
        this.buildOrgUserList(obtainUser, userList, orgUserList);
        this.userManager.saveOrUpdateBatch((Collection)userList);
        this.relateManager.saveOrUpdateBatch((Collection)orgUserList);
        return true;
    }

    private void buildOrgUserList(JSONArray obtainUser, List<User> userList, List<OrgUser> orgUserList) {
        PwdStrategy pwdStrategy = this.pwdStrategyManager.getDefault();
        List list = this.relateManager.list();
        HashSet orgIdsAndUserIds = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(orgUser -> orgIdsAndUserIds.add(orgUser.getOrgId() + orgUser.getUserId()));
        }
        for (Object obj : obtainUser) {
            JSONObject orgUserJson = JSON.parseObject((String)obj.toString());
            User user = new User();
            user.setId(orgUserJson.getString("ryid"));
            user.setFullname(orgUserJson.getString("lastname"));
            user.setAccount(orgUserJson.getString("loginid"));
            if (StringUtils.isEmpty((Object)user.getAccount())) {
                user.setAccount(PinyinUtil.getPinyin((String)user.getFullname().substring(0, 1)) + PinyinUtil.getPinYinHeadChar((String)user.getFullname().substring(1)));
            }
            if ("admin".equals(user.getAccount()) || "cqlt".equals(user.getAccount())) continue;
            String defaultPswd = "123456";
            if (pwdStrategy != null) {
                defaultPswd = pwdStrategy.getInitPwd();
            }
            user.setPassword(this.passwordEncoder.encode((CharSequence)defaultPswd));
            user.setEmail(orgUserJson.getString("accounttype"));
            user.setMobile(orgUserJson.getString("mobile"));
            user.setPhoto(orgUserJson.getString("photo"));
            user.setStatus(orgUserJson.getInteger("status"));
            user.setFrom("restful");
            user.setGroupId(orgUserJson.getString("departmentid"));
            userList.add(user);
            OrgUser relate = new OrgUser();
            relate.setOrgId(orgUserJson.getString("departmentid"));
            relate.setUserId(orgUserJson.getString("ryid"));
            relate.setIsMaster(Integer.valueOf(0));
            if (orgIdsAndUserIds.contains(relate.getOrgId() + relate.getUserId())) continue;
            orgUserList.add(relate);
        }
    }

    private List<Org> buildOrgList(JSONArray obtainOrg, JSONArray obtainDept) throws Exception {
        HashMap<String, Org> orgMap = new HashMap<String, Org>(100);
        List allOrg = this.orgManager.list();
        String demId = null;
        for (Org org : allOrg) {
            if (!"1".equals(org.getId())) continue;
            demId = org.getDemId();
        }
        ArrayList orgList = Lists.newArrayList();
        for (Object obj : obtainOrg) {
            JSONObject orgJson = JSON.parseObject((String)obj.toString());
            Org org = new Org();
            org.setId(orgJson.getString("id"));
            org.setName(orgJson.getString("subcompanyname"));
            org.setParentId(orgJson.getString("supsubcomid"));
            org.setCode(PinyinUtil.getPinYinHeadChar((String)org.getName()));
            org.setOrgKind("OGN");
            org.setDemId(demId);
            if (BeanUtils.isNotEmpty(orgMap.get(org.getParentId()))) {
                org.setPath(((Org)orgMap.get(org.getParentId())).getPath() + org.getId() + ".");
                org.setPathName(((Org)orgMap.get(org.getParentId())).getPathName() + "/" + org.getName());
            } else {
                org.setPath(org.getId() + ".");
                org.setPathName("/" + org.getName());
            }
            orgMap.put(org.getId(), org);
            if (!"1".equals(org.getId())) continue;
        }
        for (Object deptObj : obtainDept) {
            JSONObject deptJson = JSON.parseObject((String)deptObj.toString());
            Org dept = new Org();
            dept.setId(deptJson.getString("bmid"));
            dept.setName(deptJson.getString("departmentname"));
            dept.setParentId(deptJson.getString("subcompanyid"));
            dept.setCode(PinyinUtil.getPinYinHeadChar((String)dept.getName()));
            dept.setDemId(demId);
            dept.setOrgKind("DEPT");
            if (BeanUtils.isNotEmpty(orgMap.get(dept.getParentId()))) {
                dept.setPath(((Org)orgMap.get(dept.getParentId())).getPath() + dept.getId() + ".");
                dept.setPathName(((Org)orgMap.get(dept.getParentId())).getPathName() + "/" + dept.getName());
            } else {
                dept.setPath(dept.getId() + ".");
                dept.setPathName("/" + dept.getName());
            }
            orgList.add(dept);
            orgMap.put(dept.getId(), dept);
        }
        return orgList;
    }
}

