/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.vo.EnterpriseInfoVo;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5883\u5916\u4f01\u4e1a\u4fe1\u606f "})
@RequestMapping(value={"/qfEnterpriseInfo/v1/"})
@ApiGroup(group={"group_biz"})
public class QfEnterpriseInfoController
extends BaseController<QfEnterpriseInfoManager, QfEnterpriseInfo> {
    private static final Logger log = LoggerFactory.getLogger(QfEnterpriseInfoController.class);

    @PostMapping(value={"/insertInfo"})
    @ApiOperation(value="\u65b0\u589e\u4f01\u4e1a\u4fe1\u606f")
    public CommonResult<String> insertInfo(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) QfEnterpriseInfo t) {
        String id = ((QfEnterpriseInfoManager)this.baseService).newInsertTree(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/updateById"})
    @ApiOperation(value="\u7f16\u8f91\u4f01\u4e1a\u4fe1\u606f")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) QfEnterpriseInfo t) {
        QfEnterpriseInfo byId = (QfEnterpriseInfo)((Object)((QfEnterpriseInfoManager)this.baseService).getById((Serializable)((Object)t.getId())));
        String id = ((QfEnterpriseInfoManager)this.baseService).newUpdateTree(t, byId.getName());
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(false, I18nUtil.getMessage((String)"update.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f\u6811\u5f62\u7ed3\u6784")
    public CommonResult<List<QfEnterpriseInfo>> getTree() {
        return ((QfEnterpriseInfoManager)this.baseService).getTree();
    }

    @GetMapping(value={"deleteById/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((QfEnterpriseInfoManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u4f01\u4e1a\u5206\u9875\u67e5\u8be2")
    public CommonResult<PageList<QfEnterpriseInfo>> getList(@RequestBody QueryFilter<QfEnterpriseInfo> queryFilter) {
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), (Object)super.query(queryFilter));
    }

    @PostMapping(value={"/move"})
    @ApiOperation(value="\u79fb\u52a8\u4f01\u4e1a\u7684\u4e0a\u4e0b\u7ea7")
    public CommonResult<String> move(@RequestBody QfEnterpriseInfo entity) {
        boolean result = ((QfEnterpriseInfoManager)this.baseService).move(entity);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        if (!params.isEmpty()) {
            ((QfEnterpriseInfoManager)this.baseService).updateSequence(params);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/getAreaTree"})
    @ApiOperation(value="\u83b7\u53d6\u6309\u6d32\u522b\u5212\u5206\u7684\u4f01\u4e1a\u6811")
    public CommonResult<List<EnterpriseInfoVo>> getAreaTree(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<QfEnterpriseInfo> queryFilter) {
        List<EnterpriseInfoVo> list = ((QfEnterpriseInfoManager)this.baseService).getAreaTree(queryFilter);
        return CommonResult.success(list, null);
    }

    @GetMapping(value={"findByCode/{code}"})
    @ApiOperation(value="\u6839\u636ecode\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f")
    public CommonResult<String> findByCode(@ApiParam(name="code", value="\u5b9e\u4f53id") @PathVariable String code) {
        QfEnterpriseInfo enterpriseInfo = ((QfEnterpriseInfoManager)this.baseService).findByCode(code);
        return CommonResult.success((Object)((Object)enterpriseInfo), null);
    }
}

