package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModelProperty.AccessMode;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 设备告警信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@TableName("DEVICE_WARN_INFO")
@ApiModel(value="DeviceWarnInfo对象", description="设备告警信息")
public class DeviceWarnInfo extends BaseModel<DeviceWarnInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请输入告警配置ID",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警配置ID")
    @TableField("conf_id_")
    private String confId;

    @NotBlank(message = "请输入告警设备标识",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警设备标识")
    @TableField("device_code_")
    private String deviceCode;

    @NotBlank(message = "请输入告警名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警名称")
    @TableField("warn_name_")
    private String warnName;

    @ApiModelProperty(value = "告警类型【字典】（1：设备故障报警，2：设备监测数据报警）")
    @TableField("warn_type_")
    private String warnType;

    @ApiModelProperty(value = "告警设备类型【字典】（1：标识牌，2：低洼积水，3：危险源，4：路障，5：摄像头，6：蓝牙信标，7：信息发布屏）")
    @TableField("device_type_")
    private String deviceType;

    @ApiModelProperty(value = "告警时间")
    @TableField("warn_time_")
    private LocalDateTime warnTime;

    @ApiModelProperty(value = "告警阈值")
    @TableField("warn_threshold_")
    private String warnThreshold;

    @NotBlank(message = "请输入告警缘由",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "告警缘由")
    @TableField("warn_reason_")
    private String warnReason;

    @ApiModelProperty(value = "告警数据")
    @TableField("warn_data_")
    private String warnData;

    @ApiModelProperty(value = "告警数据ID")
    @TableField("warn_data_id_")
    private String warnDataId;

    @ApiModelProperty(value = "处置事件_ID（事件中心系统产生的事件）")
    @TableField("handle_id_")
    private String handleId;

    @ApiModelProperty(value = "处理状态（0:待处理，1：待调度，2：正在处置，3：处置完成，4：已归档，5：已评估，9：已废弃")
    @TableField("handle_status_")
    private Integer handleStatus;

    @ApiModelProperty(value = "处理进程（百分比）")
    @TableField("handle_completion_")
    private Integer handleCompletion;

    @ApiModelProperty(value = "创建人")
    @TableField("handle_user_")
    private String handleUser;

    @ApiModelProperty(value = "处理结果")
    @TableField("handle_result_")
    private String handleResult;

    @ApiModelProperty(value = "处理时间")
    @TableField("handle_time_")
    private LocalDateTime handleTime;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode=AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_time_", fill= FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @ApiModelProperty("报警区域名称")
    @TableField(exist = false)
    private String areaName;

    @ApiModelProperty(value = "产品类型")
    @TableField(exist = false)
    private String productType;

    @ApiModelProperty(value = "设备名称")
    @TableField(exist = false)
    private String deviceName;
}
