package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 对备品件进行管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */

@Data
@FieldRepeat(fields = {"spareCode","spareName"},message = "备件名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="DeviceBaseSpare对象", description="对备品件进行管理")
public class DeviceBaseSpare extends AutoFillModel<DeviceBaseSpare> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定备件id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择备件库",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "备件库ID")
    @TableField("WAREHOUSE_ID_")
    private String warehouseId;

    @NotBlank(message = "请填写备件编码",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "备件编码")
    @TableField("SPARE_CODE_")
    private String spareCode;

    @NotBlank(message = "请填写备件名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "备件名称")
    @TableField("SPARE_NAME_")
    private String spareName;

    @ApiModelProperty(value = "备件规格")
    @TableField("SPARE_SPECS_")
    private String spareSpecs;

    @NotBlank(message = "请选择备件类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "备件类型")
    @TableField("SPARE_TYPE_")
    private String spareType;

    @ApiModelProperty(value = "备件数量")
    @TableField("SPARE_NUM_")
    private Integer spareNum;

    @ApiModelProperty(value = "备件数量单位")
    @TableField("SPARE_UNIT_")
    private String spareUnit;

    @ApiModelProperty(value = "备件供应商")
    @TableField("SUPPLIER_COMPANY_ID_")
    private String supplierCompanyId;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("SN_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;


    @ApiModelProperty(value = "供应商名称")
    @TableField(exist = false)
    private String companyName;

    @ApiModelProperty(value = "扩展信息填充内容")
    @TableField(exist = false)
    private List<DeviceBaseParamsValue> paramsValueList;

}
