package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 对单位（管理单位、运维单位、设备厂商、供应商）信息进行管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Data
@FieldRepeat(fields = {"companyCode","companyName"},message = "单位名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="DeviceBaseCompany对象", description="对单位（管理单位、运维单位、设备厂商、供应商）信息进行管理")
public class DeviceBaseCompany extends AutoFillModel<DeviceBaseCompany> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定单位id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位唯一编码")
    @TableField("COMPANY_CODE_")
    @NotBlank(message = "请输入单位编码",groups = {AddGroup.class,UpdateGroup.class})
    private String companyCode;

    @ApiModelProperty(value = "单位名称")
    @TableField("COMPANY_NAME_")
    @NotBlank(message = "请输入单位名称",groups = {AddGroup.class,UpdateGroup.class})
    private String companyName;

    @ApiModelProperty(value = "单位简称")
    @TableField("COMPANY_SHORT_NAME_")
    private String companyShortName;

    @ApiModelProperty(value = "单位类型(可多选 1:管理单位、2:建设单位、3:运维单位、4：供应商)")
    @TableField("COMPANY_TYPE_")
    @NotBlank(message = "请输入单位类型",groups = {AddGroup.class,UpdateGroup.class})
    private String companyType;

    @ApiModelProperty(value = "单位地址")
    @TableField("COMPANY_ADDRESS_")
    private String companyAddress;

    @ApiModelProperty(value = "联系人")
    @TableField("COMPANY_MAN_")
    private String companyMan;

    @ApiModelProperty(value = "联系电话")
    @TableField("COMPANY_TEL_")
    private String companyTel;

    @ApiModelProperty(value = "单位传真")
    @TableField("COMPANY_FAX_")
    private String companyFax;

    @ApiModelProperty(value = "单位邮箱")
    @TableField("COMPANY_MAIL_")
    private String companyMail;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("SN_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "扩展信息填充内容")
    @TableField(exist = false)
    private List<DeviceBaseParamsValue> paramsValueList;

}
