package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.model.DeviceBaseContract;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceRelationContract;
import com.artfess.device.base.vo.ContractDeviceVo;
import com.artfess.device.base.vo.ContractVo;
import com.artfess.device.base.vo.DeviceVo;
import org.apache.ibatis.annotations.Param;

import java.util.Map;

/**
 * 设备合同关联表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceRelationContractManager extends BaseManager<DeviceRelationContract> {

    /**
     * 获取合同关联设备信息
     * @param queryFilter
     * @return
     */
    PageList<DeviceVo> findByPage(QueryFilter<DeviceInfo> queryFilter);

    /**
     * 合同关联设备
     * @param t
     */
    void bindDevice(ContractVo t);

    /**
     * 获取合同已关联设备
     * @param queryFilter 分页参数
     * @return
     */
    PageList<ContractDeviceVo> getDeviceList(QueryFilter queryFilter);

    /**
     * 设备关联合同
     * @param t
     */
    void bindContract(DeviceVo t);

    /**
     * 获取设备已关联合同
     * @param t
     * @return
     */
    DeviceVo getContractList(DeviceVo t);

    PageList<DeviceBaseContract> findByContractPage(QueryFilter<DeviceBaseContract> queryFilter);
}
