package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.device.base.model.DeviceProductType;

import java.util.List;

/**
 * 设备产品类型信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceProductTypeManager extends BaseManager<DeviceProductType> {

    /**
     * 获取产品分裂下拉树
     * @param entity
     * @return
     */
    List<DeviceProductType> getTree(DeviceProductType entity);

    /**
     * 获取产品分类（包括摄像头）下拉树
     * @param entity
     * @return
     */
    List<DeviceProductType> getAllTree(DeviceProductType entity);

    /**
     * 修改产品分类接口
     * @param t
     * @return
     */
    String updateProductType(DeviceProductType t);
}
