/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.basedata.vo.TunnelCheckVo;
import com.artfess.yhxt.basedata.vo.TunnelRegularVo;
import com.artfess.yhxt.statistics.vo.Org4tunnelVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizTunnelInformation/v1/"})
@Api(tags={"\u96a7\u9053\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class TunnelInformationController
extends BaseController<TunnelInformationManager, TunnelInformation> {
    @RequestMapping(value={"getTunnelVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u96a7\u9053\u7edf\u8ba1", httpMethod="POST", notes="\u83b7\u53d6\u96a7\u9053\u7edf\u8ba1")
    public List<Org4tunnelVO> getTunnelVo() throws Exception {
        return ((TunnelInformationManager)this.baseService).getTunnelCount();
    }

    @RequestMapping(value={"/saveTunnel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u96a7\u9053\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveTunnel(@ApiParam(name="tunnelInformation", value="\u96a7\u9053\u5bf9\u8c61") @RequestBody TunnelInformation tunnelInformation) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtils.isEmpty((CharSequence)tunnelInformation.getId())) {
            tunnelInformation.setIsDele("0");
            tunnelInformation.setSn(((TunnelInformationManager)this.baseService).getSn());
            ((TunnelInformationManager)this.baseService).saveTunnel(tunnelInformation);
        } else {
            ((TunnelInformationManager)this.baseService).updateTunnel(tunnelInformation);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"/getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u96a7\u9053\u4fe1\u606f", httpMethod="POST")
    public PageList<TunnelInformation> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<TunnelInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<TunnelInformation> pageList = ((TunnelInformationManager)this.baseService).queryTunnelInformation(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"/updateBySn"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u6392\u5e8f\u53f7", httpMethod="POST")
    public CommonResult<String> updateBySn(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        ((TunnelInformationManager)this.baseService).updateSequence(params);
        return new CommonResult(true, "\u6392\u5e8f\u5b8c\u6210");
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u96a7\u9053\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u96a7\u9053\u4fe1\u606f")
    public TunnelInformation get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return ((TunnelInformationManager)this.baseService).getTunnelById(id);
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u96a7\u9053\u4fe1\u606f", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u96a7\u9053\u4fe1\u606f")
    public CommonResult<String> removes(String ... ids) throws Exception {
        ((TunnelInformationManager)this.baseService).removeByIds(Arrays.asList(ids));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/updateBridge"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u96a7\u9053\u4fe1\u606f", httpMethod="POST", notes="\u903b\u8f91\u5220\u9664\u96a7\u9053\u4fe1\u606f")
    public CommonResult<String> updateBridge(@ApiParam(name="ids", value="\u53ef\u89c6\u5316\u5206\u7c7bID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            ((TunnelInformationManager)this.baseService).update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getJsonVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5\u4fe1\u606f", httpMethod="POST")
    public PageList<TunnelCheckVo> getJsonVo(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<TunnelInformation> queryFilter) throws Exception {
        PageList<TunnelCheckVo> pageList = ((TunnelInformationManager)this.baseService).queryTunnel(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"/getJsonRegularVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u96a7\u9053\u5b9a\u671f\u68c0\u67e5\u4fe1\u606f", httpMethod="POST")
    public PageList<TunnelRegularVo> getJsonRegularVo(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<TunnelInformation> queryFilter) throws Exception {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<TunnelRegularVo> pageList = ((TunnelInformationManager)this.baseService).queryTunnelRegular(queryFilter);
        return pageList;
    }
}

