/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.disease.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.disease.manager.DiseaseManager;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.disease.vo.DiseaseReportVO;
import com.artfess.yhxt.push.service.PushTaskService;
import com.artfess.yhxt.statistics.vo.Org4DiseaseVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/disease/v1/"})
@Api(tags={"\u75c5\u5bb3\u7ba1\u7406\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
public class DiseaseController
extends BaseController<DiseaseManager, Disease> {
    @Resource
    private BaseContext baseContext;
    @Resource
    private RoadManager roadManager;
    @Resource
    private PermissionUtils permissionUtils;
    @Resource
    private PushTaskService pushTaskService;

    @RequestMapping(value={"diseaseReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u75c5\u5bb3\u62a5\u8868", httpMethod="GET", notes="\u83b7\u53d6\u75c5\u5bb3\u62a5\u8868")
    public List<DiseaseReportVO> diseaseReport(String year, String orgId) throws Exception {
        return ((DiseaseManager)this.baseService).diseaseReport(year, orgId);
    }

    @RequestMapping(value={"getDiseaseCountVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u75c5\u5bb3\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u75c5\u5bb3\u6570\u91cf")
    public List<Org4DiseaseVO> getDiseaseCountVo(String year) throws Exception {
        return ((DiseaseManager)this.baseService).getDiseaseCount(year);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u75c5\u5bb3\u4fe1\u606f", httpMethod="POST")
    public PageList<Disease> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Disease> queryFilter) {
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        return ((DiseaseManager)this.baseService).queryDisease(queryFilter);
    }

    @RequestMapping(value={"/saveDisease"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u75c5\u5bb3\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveDisease(@ApiParam(name="disease", value="\u75c5\u5bb3\u5bf9\u8c61") @RequestBody Disease disease) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtils.isEmpty((CharSequence)disease.getId())) {
            disease.setDeadline(((DiseaseManager)this.baseService).calculateDeadline(LocalDateTime.now()));
            disease.setHandlingSituation(0);
            disease.setCreateAccount(this.baseContext.getCurrentUserAccout());
            ((DiseaseManager)this.baseService).create((Model)disease);
        } else {
            ((DiseaseManager)this.baseService).update((Model)disease);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(true, msg, (Object)disease.getId());
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u75c5\u5bb3\u3001\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> save(@ApiParam(name="disease", value="\u75c5\u5bb3\u5bf9\u8c61") @RequestBody Disease disease) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtils.isEmpty((CharSequence)disease.getId())) {
            if (disease.getCheckDate() == null) {
                disease.setCheckDate(LocalDateTime.now());
            }
            disease.setHandlingSituation(0);
            disease.setDeadline(((DiseaseManager)this.baseService).calculateDeadline(LocalDateTime.now()));
            disease.setCreateAccount(this.baseContext.getCurrentUserAccout());
            if (disease.getCompanyId() == null) {
                Road road = (Road)((Object)this.roadManager.getById((Serializable)((Object)disease.getRoadId())));
                disease.setCompanyId(road.getCompanyId());
                disease.setCompanyName(road.getCompanyName());
            }
            ((DiseaseManager)this.baseService).saveDiseaseVo(disease);
        } else {
            ((DiseaseManager)this.baseService).updateDiseaseVo(disease);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(true, msg, (Object)disease.getId());
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u75c5\u5bb3\u4fe1\u606f", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u75c5\u5bb3\u4fe1\u606f")
    public CommonResult<String> removes(@ApiParam(name="ids", value="\u591a\u4e2a\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        ((DiseaseManager)this.baseService).removeByIds(Arrays.asList(ids));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u75c5\u5bb3\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u75c5\u5bb3\u4fe1\u606f")
    public Disease get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return ((DiseaseManager)this.baseService).getByIdDisease(id);
    }

    @RequestMapping(value={"getJsonBridgeDiseaseCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u75c5\u5bb3,\u6865\u6881\u5b9a\u671f\u7ecf\u5e38\u4fe1\u606f", httpMethod="POST")
    public PageList<Disease> getJsonBridgeDiseaseCheck(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Disease> queryFilter) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        return ((DiseaseManager)this.baseService).getJsonBridgeDiseaseCheck(queryFilter);
    }

    @RequestMapping(value={"getJsonCulvertDiseaseCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u75c5\u5bb3,\u6db5\u6d1e\u5b9a\u671f\u7ecf\u5e38\u4fe1\u606f", httpMethod="POST")
    public PageList<Disease> getJsonCulvertDiseaseCheck(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Disease> queryFilter) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        return ((DiseaseManager)this.baseService).getJsonCulvertDiseaseCheck(queryFilter);
    }

    @RequestMapping(value={"getJsonTunnelDiseaseCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u75c5\u5bb3,\u96a7\u9053\u5b9a\u671f\u7ecf\u5e38\u4fe1\u606f", httpMethod="POST")
    public PageList<Disease> getJsonTunnelDiseaseCheck(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Disease> queryFilter) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        return ((DiseaseManager)this.baseService).getJsonTunnelDiseaseCheck(queryFilter);
    }

    @RequestMapping(value={"getJsonSideDiseaseCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u75c5\u5bb3,\u8fb9\u5761\u5b9a\u671f\u7ecf\u5e38\u4fe1\u606f", httpMethod="POST")
    public PageList<Disease> getJsonSideDiseaseCheck(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Disease> queryFilter) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        return ((DiseaseManager)this.baseService).getJsonSideDiseaseCheck(queryFilter);
    }

    @PostMapping(value={"/minioDrawingUpload"})
    @ApiOperation(value="\u75c5\u5bb3\u56fe\u7247\u4e0a\u4f20\u63a5\u53e3")
    public Accessory minioDiseaseUpload(MultipartFile file, @ApiParam(name="sourceId", value="\u8d44\u6e90id", required=true) String sourceId) {
        Accessory accessory = ((DiseaseManager)this.baseService).minioDiseaseUpload(file, sourceId);
        return accessory;
    }

    @DeleteMapping(value={"/removesDisease"})
    @ApiOperation(value="\u5220\u9664\u75c5\u5bb3\u56fe\u7247", httpMethod="DELETE", notes="\u5220\u9664\u75c5\u5bb3\u56fe\u7247")
    public CommonResult<String> minioDiseaseDel(@ApiParam(name="ids", value="\u591a\u4e2a\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        ((DiseaseManager)this.baseService).minioDiseaseDel(Arrays.asList(ids));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/downloadDiseaseUpload"})
    @ApiOperation(value="\u75c5\u5bb3\u56fe\u7247\u4e0b\u8f7d\u63a5\u53e3", httpMethod="POST", notes="\u75c5\u5bb3\u56fe\u7247\u4e0b\u8f7d\u63a5\u53e3")
    public void downloadContractUpload(@ApiParam(name="ids", value="\u9644\u4ef6ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00") @RequestParam(value="ids", required=true) String ids, HttpServletResponse response) throws Exception {
        ((DiseaseManager)this.baseService).minIoDiseaseDownFile(ids, response);
    }

    @GetMapping(value={"diseaseCount"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u75c5\u5bb3\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u75c5\u5bb3\u4fe1\u606f")
    public void diseaseCount() throws Exception {
        this.pushTaskService.diseaseCount();
    }
}

