package com.artfess.form.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.form.model.ComponentValidEntity;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;


import java.util.List;

/**
 * @program: cqgs
 * @Date: 2020/9/26 17:05
 * @Author: ZQF
 * @Description: 元件管理-数据有效性校验配置
 */
public interface ComponentValidManager extends BaseManager<ComponentValidEntity> {

    /**
    * @Description: 新增数据有效性校验配置信息
    * @param componentValidEntity
    * @Return: java.lang.String
    * @Author: ZQF
    * @Date: 2020/9/26 17:09
    */
    String insertComponentValid(ComponentValidEntity componentValidEntity);

    /**
    * @Description: 修改数据有效性校验配置信息
    * @param componentValidEntity
    * @Return: java.lang.String
    * @Author: ZQF
    * @Date: 2020/9/26 17:10
    */
    String updateComponentValid(ComponentValidEntity componentValidEntity);

    /**
    * @Description: 根据ID查询数据有效性校验配置信息
    * @param id
    * @Return: com.sysplat.sys.modeling.components.entity.ComponentFunctionEntity
    * @Author: ZQF
    * @Date: 2020/9/26 17:11
    */
    ComponentValidEntity loadComponentValid(String id);

    /**
    * @Description: 根据ID批量删除数据有效性校验配置信息
    * @param ids
    * @Return: java.lang.Integer
    * @Author: ZQF
    * @Date: 2020/9/26 17:11
    */
    Integer deleteComponentValid(String ids);

    /**
    * @Description: 查询数据有效性校验配置信息（不分页）
    * @param componentValidEntity
    * @Return: java.util.List<com.sysplat.sys.modeling.components.entity.ComponentValidEntity>
    * @Author: ZQF
    * @Date: 2020/9/26 17:11
    */
    List<ComponentValidEntity> queryComponentValid(ComponentValidEntity componentValidEntity);

    /**
    * @Description: 分页查询数据有效性校验配置信息
    * @param pageRequest
    * @Return: com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.sysplat.sys.modeling.components.entity.ComponentValidEntity>
    * @Author: ZQF
    * @Date: 2020/9/26 17:11
    */
    //Page<ComponentValidEntity> slicedQueryComponentValid(BasePage<ComponentValidEntity> pageRequest);

    /**
    * @Description: 批量修改状态
    * @param ids
    * @param status
    * @Return: void
    * @Author: ZQF
    * @Date: 2020/10/15 16:03
    */
    void updateComponentValidStatus(String ids, Integer status);
}
