/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.completionAcceptance.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.cqxy.completionAcceptance.dao.CompletionAcceptanceDao;
import com.artfess.cqxy.completionAcceptance.manager.CompletionAcceptanceManager;
import com.artfess.cqxy.completionAcceptance.model.CompletionAcceptance;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CompletionAcceptanceManagerImpl
extends BaseManagerImpl<CompletionAcceptanceDao, CompletionAcceptance>
implements CompletionAcceptanceManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private ProjectManagementManager pm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(CompletionAcceptance entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.twelve.getCode());
            ele.setGroup("CompletionAcceptance");
            ele.setNode(ProjectStatusEnum.twelve.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.twelve.getCode()));
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pm.getById((Serializable)((Object)entity.getProjectId())));
        if (null != projectManagement && null != entity.getCompletionAcceptanceDate()) {
            projectManagement.setCompletionAcceptanceTime(entity.getCompletionAcceptanceDate());
            this.pm.updateById((Object)projectManagement);
        }
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, CompletionAcceptance entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.thirtyFour.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.thirtyFour.getName());
        globalRetrieval.setBizTableName(FunctionEnum.thirtyFour.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.thirtyFour.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.thirtyFour.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.thirtyFour.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.thirtyFour.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.thirtyFour.getFunctionPath());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getCompletionAcceptanceOpinions() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public CompletionAcceptance getById(String id) {
        CompletionAcceptance result = ((CompletionAcceptanceDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<CompletionAcceptance> queryAllByPage(QueryFilter<CompletionAcceptance> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bca", false);
        IPage<CompletionAcceptance> result = ((CompletionAcceptanceDao)this.baseMapper).queryAllByPage((IPage<CompletionAcceptance>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<CompletionAcceptance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (CompletionAcceptance ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, CompletionAcceptance.class, (ImportParams)new ImportParams());
            for (CompletionAcceptance ele : data) {
                ele.setProjectId(projectId);
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<CompletionAcceptance> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u7ae3\u5de5\u9a8c\u6536-\u7ae3\u5de5\u9a8c\u6536-\u5bfc\u51fa\u7ed3\u679c";
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        ArrayList<String> heards = new ArrayList<String>();
        heards.addAll(Arrays.asList("\u9879\u76ee\u540d\u79f0", "\u7ae3\u5de5\u9a8c\u6536\u540d\u79f0", "\u7ae3\u5de5\u9a8c\u6536\u65e5\u671f", "\u5de5\u7a0b\u9a8c\u6536\u8303\u56f4", "\u4e13\u95e8\u60c5\u51b5\u8bf4\u660e", "\u7ae3\u5de5\u9a8c\u6536\u610f\u89c1", "\u5907\u6ce8"));
        HSSFRow titleRow1 = sheet.createRow(0);
        for (int i = 0; i < heards.size(); ++i) {
            BizUtils.handelCell(workbook, fileName, titleRow1.createCell(i), (String)heards.get(i), new boolean[0]);
        }
        int row = 1;
        BizUtils.handleFilter(queryFilter, "bca", false);
        List data = ((CompletionAcceptanceDao)this.baseMapper).queryAllByPage((IPage<CompletionAcceptance>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<CompletionAcceptance>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (int i = 0; i < data.size(); ++i) {
            HSSFRow listRow = sheet.createRow(row);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(0), ((CompletionAcceptance)((Object)data.get(i))).getProjectInfo().getProjectName(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(1), ((CompletionAcceptance)((Object)data.get(i))).getName(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(2), DateUtils.date2Str((Date)((CompletionAcceptance)((Object)data.get(i))).getCompletionAcceptanceDate(), (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd")), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(3), ((CompletionAcceptance)((Object)data.get(i))).getProjectAcceptanceScope(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(4), ((CompletionAcceptance)((Object)data.get(i))).getSpecialInformation(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(5), ((CompletionAcceptance)((Object)data.get(i))).getCompletionAcceptanceOpinions(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(6), ((CompletionAcceptance)((Object)data.get(i))).getRemarks(), new boolean[0]);
            ++row;
        }
        sheet.setColumnWidth(0, 7000);
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }
}

