/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectApproval.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectApproval.dao.DecisionAnnualPlanDao;
import com.artfess.cqxy.projectApproval.manager.DecisionAnnualPlanManager;
import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;
import com.artfess.cqxy.projectApproval.vo.DecisionAnnualPlanVo;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DecisionAnnualPlanManagerImpl
extends BaseManagerImpl<DecisionAnnualPlanDao, DecisionAnnualPlan>
implements DecisionAnnualPlanManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    ProjectManagementManager pmm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(DecisionAnnualPlan entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.one.getCode());
            Integer year = entity.getYear();
            ele.setGroup("DecisionAnnualPlan" + year);
            ele.setNode(ProjectStatusEnum.one.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, DecisionAnnualPlan entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        if (null != projectManagement) {
            globalRetrieval.setProjectName(projectManagement.getProjectName());
            globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        }
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.two.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.two.getName());
        globalRetrieval.setBizTableName(FunctionEnum.two.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.two.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.two.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.two.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.two.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.two.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getResponsibleUnit() + "_" + entity.getConstructionAddress() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public DecisionAnnualPlan getById(String id) {
        DecisionAnnualPlan result = ((DecisionAnnualPlanDao)this.baseMapper).getById(id);
        Integer year = result.getYear();
        String group = "DecisionAnnualPlan" + year;
        result.setAccessoryInfo(this.accessoryManager.getAccessoryByGroup(group));
        return result;
    }

    @Override
    public PageList<DecisionAnnualPlan> queryAllByPage(QueryFilter<DecisionAnnualPlan> queryFilter) {
        queryFilter.addFilter("bdap.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<DecisionAnnualPlan> result = ((DecisionAnnualPlanDao)this.baseMapper).queryAllByPage((IPage<DecisionAnnualPlan>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<DecisionAnnualPlan>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (DecisionAnnualPlan ele : records) {
            Integer year = ele.getYear();
            String group = "DecisionAnnualPlan" + year;
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryByGroup(group));
        }
        return new PageList(result);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<Map<String, String>> queryInvestment(StatisticsVo statisticsVo) {
        return ((DecisionAnnualPlanDao)this.baseMapper).queryInvestment(statisticsVo);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        List projectType = this.sdm.queryDictListItemsByCode("xmgl-xmlx");
        List buildType = this.sdm.queryDictListItemsByCode("ndjh-jslx");
        try {
            InputStream inputStream = file.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheetAt = workbook.getSheetAt(0);
            for (Row row : sheetAt) {
                if (row.getRowNum() == 0) continue;
                DecisionAnnualPlan data = new DecisionAnnualPlan();
                if (null == row.getCell(1) || StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(1)))) continue;
                data.setYear(null == row.getCell(0) ? LocalDate.now().getYear() : Integer.valueOf(BizUtils.getCellValue(row.getCell(0))).intValue());
                data.setProjectName(null == row.getCell(1) ? "" : BizUtils.getCellValue(row.getCell(1)));
                data.setProjectType(null == row.getCell(2) ? "" : BizUtils.getDicCodeByValue_String(buildType, BizUtils.getCellValue(row.getCell(2))));
                data.setProjectCode(null == row.getCell(3) ? null : BizUtils.getDicCodeByValue_Int(projectType, BizUtils.getCellValue(row.getCell(3))));
                data.setResponsibleUnit(null == row.getCell(4) ? "" : BizUtils.getCellValue(row.getCell(4)));
                data.setConstructionAddress(null == row.getCell(5) ? "" : BizUtils.getCellValue(row.getCell(5)));
                data.setConstructionScaleContent(null == row.getCell(6) ? "" : BizUtils.getCellValue(row.getCell(6)));
                data.setTotalInvestment(null == row.getCell(7) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(7))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(7)))));
                try {
                    data.setCommencementTime(null == row.getCell(8) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(8))) ? null : new SimpleDateFormat("yyyy-MM-dd").parse(BizUtils.getCellValue(row.getCell(8)))));
                }
                catch (ParseException e) {
                    data.setCompletionTime(null == row.getCell(8) ? null : row.getCell(8).getDateCellValue());
                    e.printStackTrace();
                }
                try {
                    data.setCompletionTime(null == row.getCell(9) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(9))) ? null : new SimpleDateFormat("yyyy-MM-dd").parse(BizUtils.getCellValue(row.getCell(9)))));
                }
                catch (ParseException e) {
                    data.setCompletionTime(null == row.getCell(9) ? null : row.getCell(9).getDateCellValue());
                    e.printStackTrace();
                }
                data.setTotalAnnualInvestment(null == row.getCell(10) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(10))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(10)))));
                data.setAnnualTasks(null == row.getCell(11) ? null : BizUtils.getCellValue(row.getCell(11)));
                data.setInvestment1(null == row.getCell(12) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(12))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(12)))));
                data.setInvestment2(null == row.getCell(13) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(13))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(13)))));
                data.setInvestment3(null == row.getCell(14) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(14))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(14)))));
                data.setInvestment4(null == row.getCell(15) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(15))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(15)))));
                data.setInvestment5(null == row.getCell(16) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(16))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(16)))));
                data.setInvestment6(null == row.getCell(17) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(17))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(17)))));
                data.setInvestment7(null == row.getCell(18) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(18))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(18)))));
                data.setInvestment8(null == row.getCell(19) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(19))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(19)))));
                data.setInvestment9(null == row.getCell(20) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(20))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(20)))));
                data.setInvestment10(null == row.getCell(21) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(21))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(21)))));
                data.setInvestment11(null == row.getCell(22) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(22))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(22)))));
                data.setInvestment12(null == row.getCell(23) ? null : (StringUtils.isBlank((CharSequence)BizUtils.getCellValue(row.getCell(23))) ? null : new BigDecimal(BizUtils.getCellValue(row.getCell(23)))));
                data.setRemarks(null == row.getCell(24) ? "" : BizUtils.getCellValue(row.getCell(24)));
                ((DecisionAnnualPlanDao)this.baseMapper).insert((Object)data);
                this.handleRetrieval(new GlobalRetrieval(), data);
            }
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<DecisionAnnualPlan> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u5e74\u5ea6\u8ba1\u5212-\u5bfc\u51fa\u7ed3\u679c";
        List buildType = this.sdm.queryDictListItemsByCode("ndjh-jslx");
        List projectType = this.sdm.queryDictListItemsByCode("xmgl-xmlx");
        queryFilter.addFilter("bdap.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        PageBean queryFilterPageBean = queryFilter.getPageBean();
        queryFilterPageBean.setPageSize(-1);
        List data = this.queryAllByPage(queryFilter).getRows();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ArrayList<DecisionAnnualPlanVo> voList = new ArrayList<DecisionAnnualPlanVo>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            DecisionAnnualPlan ele = (DecisionAnnualPlan)((Object)data.get(i));
            ele.setProjectType(BizUtils.getDicValueByCode((List<DictModel>)buildType, ele.getProjectType()));
            DecisionAnnualPlanVo decisionAnnualPlanVo = new DecisionAnnualPlanVo();
            org.springframework.beans.BeanUtils.copyProperties((Object)((Object)ele), (Object)((Object)decisionAnnualPlanVo));
            decisionAnnualPlanVo.setProjectCode(BizUtils.getDicValueByCode((List<DictModel>)projectType, ele.getProjectCode()));
            voList.add(decisionAnnualPlanVo);
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, DecisionAnnualPlanVo.class, voList);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }
}

