/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.documentLibrary.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cqxy.documentLibrary.dao.FileLibraryTypeDao;
import com.artfess.cqxy.documentLibrary.manager.FileLibraryTypeManager;
import com.artfess.cqxy.documentLibrary.model.FileLibraryType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class FileLibraryTypeManagerImpl
extends BaseManagerImpl<FileLibraryTypeDao, FileLibraryType>
implements FileLibraryTypeManager {
    @Override
    public void changeHasChildNode(String typeID, boolean flag) {
        int num = flag ? ((FileLibraryTypeDao)this.baseMapper).updateChildNodeStatus(typeID, "0") : ((FileLibraryTypeDao)this.baseMapper).updateChildNodeStatus(typeID, "1");
    }

    @Override
    public List<FileLibraryType> getByParentCode(String pCode) {
        return this.traversalTree(((FileLibraryTypeDao)this.baseMapper).getByParentCode(pCode));
    }

    private List<FileLibraryType> traversalTree(List<FileLibraryType> list) {
        ArrayList<FileLibraryType> trees = new ArrayList<FileLibraryType>();
        if (!list.isEmpty()) {
            for (FileLibraryType tree : list) {
                List<FileLibraryType> children = this.traversalTree(((FileLibraryTypeDao)this.baseMapper).getByParentCode(tree.getCode()));
                tree.setChildren(children);
                trees.add(tree);
            }
        }
        return trees;
    }

    @Override
    public boolean isKeyExist(String id, String code) {
        Integer integer;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"CODE_", (Object)code);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)id)) {
            wrapper.ne((Object)"ID_", (Object)id);
        }
        return (integer = ((FileLibraryTypeDao)this.baseMapper).selectCount((Wrapper)wrapper)) > 0;
    }

    @Override
    public PageList<FileLibraryType> queryChildNodeByPage(QueryFilter<FileLibraryType> queryFilter) {
        String pCode = null;
        List test = queryFilter.getQuerys();
        for (QueryField ele : test) {
            if (!"bflt.PCODE_".equals(ele.getProperty())) continue;
            pCode = String.valueOf(ele.getValue());
            break;
        }
        Assert.notNull(pCode, (String)"\u7236\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        queryFilter.addFilter("bflt.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<FileLibraryType> result = ((FileLibraryTypeDao)this.baseMapper).queryChildNodeByPage((IPage<FileLibraryType>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FileLibraryType>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        List data = ((FileLibraryTypeDao)this.baseMapper).selectBatchIds(idList);
        boolean flag = super.removeByIds(idList);
        for (FileLibraryType ele : data) {
            if (this.getByParentCode(ele.getPcode()).size() != 0) continue;
            this.changeHasChildNode(ele.getId(), false);
        }
        return flag;
    }

    @Override
    public boolean checkHasChild(String id) {
        Integer flag = ((FileLibraryType)((Object)((FileLibraryTypeDao)this.baseMapper).selectById((Serializable)((Object)id)))).getHasChildren();
        return 0 == flag;
    }

    public boolean saveOrUpdateBatch(Collection<FileLibraryType> entityList) {
        boolean result = false;
        if (null == entityList || entityList.size() == 0) {
            return false;
        }
        for (FileLibraryType ele : entityList) {
            FileLibraryType flag = (FileLibraryType)((Object)((FileLibraryTypeDao)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"CODE_", (Object)ele.getCode())));
            if (null != flag && !StringUtils.isEmpty((Object)flag.getCode())) {
                throw new RuntimeException("\u8282\u70b9\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            result = this.save((Object)ele);
            this.changeHasChildNode(ele.getId(), true);
        }
        return result;
    }
}

