/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.job.persistence.manager.SchedulerService;
import com.artfess.rescue.patrol.dao.BizInspectionVideoConfDao;
import com.artfess.rescue.patrol.manager.BizInspectionVideoConfManager;
import com.artfess.rescue.patrol.manager.BizTaskConfVideoManager;
import com.artfess.rescue.patrol.model.BizInspectionVideoConf;
import com.artfess.rescue.patrol.model.BizTaskConfVideo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizInspectionVideoConfManagerImpl
extends BaseManagerImpl<BizInspectionVideoConfDao, BizInspectionVideoConf>
implements BizInspectionVideoConfManager {
    @Resource
    Scheduler scheduler;
    @Resource
    BaseContext baseContext;
    @Resource
    SchedulerService schedulerService;
    @Resource
    private BizTaskConfVideoManager taskConfVideoManager;
    private final String JOBCLASS = "com.artfess.rescue.patrol.job.BizInspectionVideoTaskJob";

    @Override
    @Transactional
    public CommonResult<String> saveOrUpdateInfo(BizInspectionVideoConf trainTaskConf) throws SchedulerException {
        if (StringUtil.isEmpty((String)trainTaskConf.getId())) {
            trainTaskConf.setId(UniqueIdUtil.getSuid());
        } else {
            String jobName = trainTaskConf.getId() + ":" + this.scheduler.getSchedulerName();
            TriggerKey key = new TriggerKey(jobName, this.baseContext.getCurrentTenantId());
            Trigger.TriggerState state = this.scheduler.getTriggerState(key);
            if (state == Trigger.TriggerState.NORMAL) {
                throw new BaseException("\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\uff0c\u8bf7\u6682\u505c\u540e\u8fdb\u884c\u7f16\u8f91\uff01");
            }
        }
        trainTaskConf.setConfType(2);
        trainTaskConf.setPlanType(1);
        boolean result = this.saveOrUpdate((Object)trainTaskConf);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u64cd\u4f5c\u5931\u8d25!");
        }
        List<BizTaskConfVideo> list = trainTaskConf.getTaskConfVideo();
        if (CollectionUtils.isEmpty(list)) {
            throw new BaseException("\u89c6\u9891\u70b9\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        queryWrapper.eq(BizTaskConfVideo::getTaskConfId, (Object)trainTaskConf.getId());
        this.taskConfVideoManager.remove((Wrapper)queryWrapper);
        list.forEach(trainTaskConfVideo -> trainTaskConfVideo.setTaskConfId(trainTaskConf.getId()));
        this.taskConfVideoManager.saveBatch(list);
        String jobName = trainTaskConf.getId() + ":" + this.scheduler.getSchedulerName();
        boolean jobExists = this.schedulerService.isJobExists(jobName);
        if (!jobExists) {
            HashMap parameter = Maps.newHashMap();
            parameter.put("confId", trainTaskConf.getId());
            CommonResult jobResult = this.schedulerService.addJob(jobName, "com.artfess.rescue.patrol.job.BizInspectionVideoTaskJob", (Map)parameter, null);
            boolean isSuccess = jobResult.getState();
            if (!isSuccess) {
                throw new BaseException("\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u5931\u8d25");
            }
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)trainTaskConf.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean toggleTriggerRun(String id) throws Exception {
        if (null == this.scheduler) {
            return false;
        }
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u57f9\u8bad\u914d\u7f6e");
        BizInspectionVideoConf videoConf = (BizInspectionVideoConf)((Object)((BizInspectionVideoConfDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)videoConf), (String)"\u57f9\u8bad\u914d\u7f6e\u4e0d\u5b58\u5728");
        String jobName = videoConf.getId() + ":" + this.scheduler.getSchedulerName();
        TriggerKey key = new TriggerKey(jobName, this.baseContext.getCurrentTenantId());
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        boolean rtn = this.schedulerService.isTriggerExists(jobName);
        if (!rtn) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)videoConf.getPlanType());
            jsonObject.put("timeInterval", (Object)videoConf.getPlanInterval());
            this.schedulerService.addTrigger(jobName, jobName, JSON.toJSONString((Object)jsonObject));
        } else if (state == Trigger.TriggerState.PAUSED) {
            this.scheduler.resumeTrigger(key);
        } else if (state == Trigger.TriggerState.NORMAL) {
            this.scheduler.pauseTrigger(key);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean executeJob(String id) throws SchedulerException {
        if (null == this.scheduler) {
            return false;
        }
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u914d\u7f6e");
        BizInspectionVideoConf videoConf = (BizInspectionVideoConf)((Object)((BizInspectionVideoConfDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (videoConf == null) {
            return false;
        }
        String jobName = videoConf.getId() + ":" + this.scheduler.getSchedulerName();
        JobKey key = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        this.scheduler.triggerJob(key);
        videoConf.setPushStatus(1);
        this.updateById((Object)videoConf);
        return true;
    }

    @Override
    public BizInspectionVideoConf getInfoById(String id) {
        BizInspectionVideoConf inspectionVideoConf = (BizInspectionVideoConf)((Object)this.getById((Serializable)((Object)id)));
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        queryWrapper.eq(BizTaskConfVideo::getTaskConfId, (Object)inspectionVideoConf.getId());
        List list = this.taskConfVideoManager.list((Wrapper)queryWrapper);
        inspectionVideoConf.setTaskConfVideo(list);
        return inspectionVideoConf;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PageList<BizInspectionVideoConf> queryInfo(QueryFilter<BizInspectionVideoConf> queryFilter) {
        return this.query(queryFilter);
    }
}

