import req from "@/request.js";
const portal = window.context.portal;
export default {
    // 分页
    queryChargeData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizCharge/v1/query`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 保存
    saveChargeData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizCharge/v1/save`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    getDataById(id) {
        return new Promise((resolve, reject) => {
            req.get(portal + `/bizCharge/v1/` + id).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    batchDeleteConfig(deleteIds) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/bizCharge/v1/?ids=' + deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    }


}