package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 *  水库水源地
 */
@Getter
public enum MonitorLevelEnum {
    /**
     * 删除
     */
    ONE("1", "国控级"),

    TWO("2", "省控级"),

    THREE("3", "地市级"),

    FOUR("4", "区县级"),

    OTHER("5", "其他"),


    ;

    MonitorLevelEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String level){
        if(StringUtils.isEmpty(level)){
            return null;
        }
        MonitorLevelEnum[] values = values();
        for (MonitorLevelEnum state : values) {
            if (state.getType().equals(level)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getLevel(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        MonitorLevelEnum[] values = values();
        for (MonitorLevelEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
