package com.artfess.ljzc.stock.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.ljzc.stock.model.AssetStockInfo;
import com.artfess.ljzc.stock.vo.AssetStockInfoVo;

import java.util.List;
import java.util.Map;

/**
 * 股权资产信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-11-27
 */
public interface AssetStockInfoManager extends BaseManager<AssetStockInfo> {

    /**
     * 保存股权资产信息
     * @param stockInfoVo
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    String insertStockInfo(AssetStockInfoVo stockInfoVo) throws Exception;

    /**
     * 修改股权资产信息
     * @param stockInfoVo
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean updateStockInfo(AssetStockInfoVo stockInfoVo) throws Exception;

    /**
     * 删除股权资产信息
     * @param id
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean deleteStockInfo(String id);

    /**
     * 删除股权资产信息
     * @param ids 股权id集合
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean deleteBachStockInfo(List<String> ids);

    /**
     * 根据ID查询股权资产信息
     * @param id
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    AssetStockInfoVo findStockInfoVo(String id);

    /**
     * 审核股权资产信息入库
     * @param status 入库审核状态（0：未审核，1：已审核）
     * @param idList 资产ID集合
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean auditStock(String status,String msg, List<String> idList);

    /**
     * 查询股权结构图谱信息
     * @param orgId 股权所属单位的ＩＤ
     * @param orgName 股权所属单位的名称
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Map<String,Object> queryStockStructures(String orgId, String orgName);

    List<JSONObject> stockStatistics(String fullId);
}
